/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.T2CCallableStatement;
import oracle.jdbc.driver.T2CConnection;
import oracle.jdbc.driver.T2CPreparedStatement;
import oracle.jdbc.driver.T2CStatement;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.logging.annotations.DefaultLevel;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Logging;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.OCI_INTERNAL})
class T2CInputStream
extends OracleInputStream {
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;

    native int t2cGetBytes(long var1, int var3, byte[] var4, int var5, Accessor[] var6, Object[] var7, Object[] var8, long var9);

    T2CInputStream(OracleStatement stmt, int index, Accessor a2) {
        super(stmt, index, a2);
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, T2CInputStream.class, $$$methodRef$$$3, null, stmt, index, a2);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, T2CInputStream.class, $$$methodRef$$$3, null);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T2CInputStream.class, $$$methodRef$$$3, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T2CInputStream.class, $$$methodRef$$$3, null, throwable2);
            }
            throw throwable;
        }
    }

    private int getRowNumber() {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, T2CInputStream.class, $$$methodRef$$$0, this, new Object[0]);
            }
            int row = 0;
            if (this.statement.isFetchStreams) {
                if (this.statement instanceof T2CStatement) {
                    if (((T2CStatement)this.statement).needToRetainRows) {
                        row = this.statement.storedRowCount;
                    }
                } else if (this.statement instanceof T2CPreparedStatement) {
                    if (((T2CPreparedStatement)this.statement).needToRetainRows) {
                        row = this.statement.storedRowCount;
                    }
                } else if (((T2CCallableStatement)this.statement).needToRetainRows) {
                    row = this.statement.storedRowCount;
                }
            }
            int n2 = row;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, T2CInputStream.class, $$$methodRef$$$0, this, n2);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T2CInputStream.class, $$$methodRef$$$0, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T2CInputStream.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @DefaultLevel(value=Logging.FINEST)
    public int getBytes(int n2) throws IOException {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            int n3;
            block31: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, T2CInputStream.class, $$$methodRef$$$1, this, n2);
                }
                Monitor.CloseableLock lock = this.statement.connection.acquireCloseableLock();
                try {
                    void howMany;
                    if (howMany > this.currentBufferSize) {
                        this.currentBufferSize = Math.max((int)howMany, this.initialBufferSize);
                        this.resizableBuffer = new byte[this.currentBufferSize];
                    }
                    long flags = this.statement.connection.useNio ? 1 : 0;
                    if (this.statement.connection.useNio) {
                        if (this.statement.nioBuffers[3] == null || this.statement.nioBuffers[3].capacity() < this.resizableBuffer.length) {
                            this.statement.nioBuffers[3] = ByteBuffer.allocateDirect(this.resizableBuffer.length);
                        } else {
                            this.statement.nioBuffers[3].rewind();
                        }
                    }
                    int dataSize = 0;
                    dataSize = this.t2cGetBytes(this.statement.c_state, this.columnIndex, this.resizableBuffer, this.currentBufferSize, this.statement.accessors, this.statement.nioBuffers, this.statement.lobPrefetchMetaData, flags);
                    boolean needToUpdateNioBuffers = false;
                    try {
                        int row = this.getRowNumber();
                        if (dataSize == -1) {
                            ((T2CConnection)this.statement.connection).checkError(dataSize, this.statement.sqlWarning);
                        } else if (dataSize == -2) {
                            needToUpdateNioBuffers = true;
                            this.accessor.setNull(row, true);
                            dataSize = 0;
                        } else if (dataSize >= 0) {
                            this.accessor.setNull(row, false);
                        }
                    }
                    catch (SQLException e2) {
                        IOException iOException = new IOException(e2.getMessage());
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, T2CInputStream.class, $$$methodRef$$$1, this, iOException);
                        }
                        throw iOException;
                    }
                    if (dataSize <= 0) {
                        dataSize = -1;
                        needToUpdateNioBuffers = true;
                    }
                    if (this.statement.connection.useNio) {
                        ByteBuffer b2 = this.statement.nioBuffers[3];
                        if (b2 != null && dataSize > 0) {
                            b2.get(this.resizableBuffer, 0, dataSize);
                        }
                        if (needToUpdateNioBuffers) {
                            try {
                                this.statement.extractNioDefineBuffers(this.columnIndex);
                            }
                            catch (SQLException e3) {
                                IOException iOException = new IOException(e3.getMessage());
                                if (bl) {
                                    ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, T2CInputStream.class, $$$methodRef$$$1, this, iOException);
                                }
                                throw iOException;
                            }
                        }
                    }
                    if (needToUpdateNioBuffers && this.statement.lobPrefetchMetaData != null) {
                        this.statement.processLobPrefetchMetaData(this.statement.lobPrefetchMetaData);
                    }
                    int n4 = dataSize;
                    if (lock != null) {
                        lock.close();
                    }
                    n3 = n4;
                    if (!bl) break block31;
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    Throwable throwable3 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, T2CInputStream.class, $$$methodRef$$$1, this, throwable3);
                    }
                    throw throwable3;
                }
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, T2CInputStream.class, $$$methodRef$$$1, this, n3);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T2CInputStream.class, $$$methodRef$$$1, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T2CInputStream.class, $$$methodRef$$$1, this, throwable4);
            }
            throw throwable;
        }
    }

    @Override
    public boolean isNull() throws IOException {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, T2CInputStream.class, $$$methodRef$$$2, this, new Object[0]);
            }
            if (!this.statement.isFetchStreams) {
                this.needBytes();
                boolean bl2 = super.isNull();
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, T2CInputStream.class, $$$methodRef$$$2, this, bl2);
                    ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T2CInputStream.class, $$$methodRef$$$2, this, null);
                }
                return bl2;
            }
            boolean bl3 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, T2CInputStream.class, $$$methodRef$$$2, this, bl3);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T2CInputStream.class, $$$methodRef$$$2, this, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T2CInputStream.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$3 = T2CInputStream.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Accessor.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = T2CInputStream.class.getDeclaredMethod("isNull", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = T2CInputStream.class.getDeclaredMethod("getBytes", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = T2CInputStream.class.getDeclaredMethod("getRowNumber", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

