/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.AutoKeyInfo;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.ForwardOnlyResultSet;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class OracleReturnResultSet
extends ForwardOnlyResultSet {
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;

    OracleReturnResultSet(PhysicalConnection conn, OracleStatement stmt) throws SQLException {
        super(conn, stmt);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, OracleReturnResultSet.class, $$$methodRef$$$3, null, conn, stmt);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleReturnResultSet.class, $$$methodRef$$$3, null);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleReturnResultSet.class, $$$methodRef$$$3, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleReturnResultSet.class, $$$methodRef$$$3, null, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void close() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, OracleReturnResultSet.class, $$$methodRef$$$0, this, new Object[0]);
            }
            Monitor.CloseableLock lock = this.statement.connection.acquireCloseableLock();
            try {
                super.close();
                this.statement.currentResultSet = null;
                this.statement.returnParamsFetched = false;
                this.statement.rowsDmlReturned = 0;
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, OracleReturnResultSet.class, $$$methodRef$$$0, this, throwable3);
                }
                throw throwable3;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleReturnResultSet.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleReturnResultSet.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleReturnResultSet.class, $$$methodRef$$$0, this, throwable4);
            }
            throw throwable;
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            AutoKeyInfo autoKeyInfo;
            block17: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, OracleReturnResultSet.class, $$$methodRef$$$1, this, new Object[0]);
                }
                Monitor.CloseableLock lock = this.statement.connection.acquireCloseableLock();
                try {
                    if (!this.statement.isAutoGeneratedKey) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, OracleReturnResultSet.class, $$$methodRef$$$1, this, sQLException);
                        }
                        throw sQLException;
                    }
                    if (this.closed) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, OracleReturnResultSet.class, $$$methodRef$$$1, this, sQLException);
                        }
                        throw sQLException;
                    }
                    if (this.statement.closed) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, OracleReturnResultSet.class, $$$methodRef$$$1, this, sQLException);
                        }
                        throw sQLException;
                    }
                    AutoKeyInfo info = this.statement.autoKeyInfo;
                    info.statement = this.statement;
                    info.connection = this.connection;
                    info.initMetaData(this);
                    AutoKeyInfo autoKeyInfo2 = info;
                    if (lock != null) {
                        lock.close();
                    }
                    autoKeyInfo = autoKeyInfo2;
                    if (!bl) break block17;
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    Throwable throwable3 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, OracleReturnResultSet.class, $$$methodRef$$$1, this, throwable3);
                    }
                    throw throwable3;
                }
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, OracleReturnResultSet.class, $$$methodRef$$$1, this, autoKeyInfo);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleReturnResultSet.class, $$$methodRef$$$1, this, null);
            }
            return autoKeyInfo;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleReturnResultSet.class, $$$methodRef$$$1, this, throwable4);
            }
            throw throwable;
        }
    }

    @Override
    public int findColumn(String string) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, OracleReturnResultSet.class, $$$methodRef$$$2, this, string);
            }
            Monitor.CloseableLock lock = this.statement.connection.acquireCloseableLock();
            try {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, OracleReturnResultSet.class, $$$methodRef$$$2, this, sQLException);
                }
                throw sQLException;
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, OracleReturnResultSet.class, $$$methodRef$$$2, this, throwable3);
                }
                throw throwable3;
            }
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleReturnResultSet.class, $$$methodRef$$$2, this, throwable4);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$3 = OracleReturnResultSet.class.getDeclaredConstructor(PhysicalConnection.class, OracleStatement.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleReturnResultSet.class.getDeclaredMethod("findColumn", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleReturnResultSet.class.getDeclaredMethod("getMetaData", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleReturnResultSet.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

