/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLevel;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Logging;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.TDSReader;
import oracle.sql.CHAR;
import oracle.sql.CharacterSet;
import oracle.sql.Datum;
import oracle.sql.converter.CharacterSetMetaData;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.OBJECT_TYPES})
@DefaultLevel(value=Logging.FINEST)
public class OracleTypeCHAR
extends OracleType
implements Serializable {
    static final long serialVersionUID = -6899444518695804629L;
    int form;
    int charset;
    int length;
    int characterSemantic;
    private transient OracleConnection connection;
    private short pickleCharaterSetId;
    private transient CharacterSet pickleCharacterSet;
    private short pickleNcharCharacterSet;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;

    protected OracleTypeCHAR() {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$14, null, new Object[0]);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$14, null);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$14, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$14, null, throwable2);
            }
            throw throwable;
        }
    }

    public OracleTypeCHAR(OracleConnection conn) {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$15, null, conn);
            }
            this.form = 0;
            this.charset = 0;
            this.length = 0;
            this.connection = conn;
            this.pickleCharaterSetId = 0;
            this.pickleNcharCharacterSet = 0;
            this.pickleCharacterSet = null;
            try {
                this.pickleCharaterSetId = this.connection.getStructAttrCsId();
            }
            catch (SQLException ex) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                ex.printStackTrace(pw);
                String z2 = sw.toString();
                if (bl) {
                    this.debug($$$loggerRef$$$15, Level.FINEST, $$$methodRef$$$15, z2);
                }
                this.pickleCharaterSetId = (short)-1;
            }
            this.pickleCharacterSet = CharacterSet.make(this.pickleCharaterSetId);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$15, null);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$15, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$15, null, throwable2);
            }
            throw throwable;
        }
    }

    protected OracleTypeCHAR(OracleConnection conn, int typecode) {
        super(typecode);
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$16, null, conn, typecode);
            }
            this.form = 0;
            this.charset = 0;
            this.length = 0;
            this.connection = conn;
            this.pickleCharaterSetId = 0;
            this.pickleNcharCharacterSet = 0;
            this.pickleCharacterSet = null;
            try {
                this.pickleCharaterSetId = this.connection.getStructAttrCsId();
            }
            catch (SQLException ex) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                ex.printStackTrace(pw);
                String z2 = sw.toString();
                if (bl) {
                    this.debug($$$loggerRef$$$16, Level.FINEST, $$$methodRef$$$16, z2);
                }
                this.pickleCharaterSetId = (short)-1;
            }
            this.pickleCharacterSet = CharacterSet.make(this.pickleCharaterSetId);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$16, null);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$16, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$16, null, throwable2);
            }
            throw throwable;
        }
    }

    private int getLengthInCharacter() {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            short characterSet;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$0, this, new Object[0]);
            }
            int ratio = 0;
            short s2 = characterSet = this.form == 2 ? this.pickleNcharCharacterSet : this.pickleCharaterSetId;
            if (characterSet != 0) {
                ratio = CharacterSetMetaData.getRatio(characterSet, 1);
                int n2 = this.length / ratio;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$0, this, n2);
                    ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$0, this, null);
                }
                return n2;
            }
            int n3 = this.length;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$0, this, n3);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$0, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            CHAR datum;
            String value;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$1, this, object, oracleConnection);
            }
            if (value == null) {
                Datum datum2 = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$1, this, datum2);
                    ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$1, this, null);
                }
                return null;
            }
            if (value instanceof CHAR) {
                datum = (CHAR)((Object)value);
            } else if (this.typeCode == 1 && value instanceof String) {
                if (this.characterSemantic != 0) {
                    int ratio = CharacterSetMetaData.getRatio(this.pickleCharaterSetId, 1);
                    Object s2 = value;
                    for (int i2 = ((String)s2).length(); i2 < this.length / ratio; ++i2) {
                        s2 = (String)s2 + " ";
                    }
                    value = s2;
                    datum = new CHAR((Object)value, this.pickleCharacterSet);
                } else {
                    datum = new CHAR(value, this.pickleCharacterSet, this.length);
                }
            } else {
                datum = new CHAR((Object)value, this.pickleCharacterSet);
            }
            if (this.typeCode == 12 || this.typeCode == -9) {
                datum.setVariableLength(true);
            }
            CHAR cHAR = datum;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$1, this, cHAR);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$1, this, null);
            }
            return cHAR;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Datum[] toDatumArray(Object object, OracleConnection oracleConnection, long l2, int n2) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void obj;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$2, this, object, oracleConnection, l2, n2);
            }
            Datum[] datumArray = null;
            if (obj != null) {
                void count;
                void beginIdx;
                void conn;
                if (obj instanceof Object[] && !(obj instanceof char[][])) {
                    Datum[] datumArray2 = super.toDatumArray(obj, (OracleConnection)conn, (long)beginIdx, (int)count);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$2, this, datumArray2);
                        ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$2, this, null);
                    }
                    return datumArray2;
                }
                datumArray = this.cArrayToDatumArray(obj, (OracleConnection)conn, (long)beginIdx, (int)count);
            }
            Datum[] datumArray3 = datumArray;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$2, this, datumArray3);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$2, this, null);
            }
            return datumArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void parseTDSrec(TDSReader tDSReader) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void tdsReader;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$3, this, tDSReader);
            }
            super.parseTDSrec((TDSReader)tdsReader);
            try {
                this.length = tdsReader.readUB2();
                this.form = tdsReader.readByte();
                this.characterSemantic = this.form & 0x80;
                this.form &= 0x7F;
                this.charset = tdsReader.readUB2();
                if (this.form == 2) {
                    switch (this.typeCode) {
                        case 12: {
                            this.typeCode = -9;
                            break;
                        }
                        case 1: {
                            this.typeCode = -15;
                        }
                    }
                }
            }
            catch (SQLException ex) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 47, "parseTDS").fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$3, this, sQLException);
                }
                throw sQLException;
            }
            if (this.form != 2 || this.pickleNcharCharacterSet != 0) {
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$3, this);
                    ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$3, this, null);
                }
                return;
            }
            try {
                this.pickleNcharCharacterSet = this.connection.getStructAttrNCsId();
            }
            catch (SQLException ex) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                ex.printStackTrace(pw);
                String z2 = sw.toString();
                if (bl) {
                    this.debug($$$loggerRef$$$3, Level.FINEST, $$$methodRef$$$3, z2);
                }
                this.pickleNcharCharacterSet = (short)2000;
            }
            this.pickleCharaterSetId = this.pickleNcharCharacterSet;
            this.pickleCharacterSet = CharacterSet.make(this.pickleCharaterSetId);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$3, this);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$3, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int pickle81(PickleContext pickleContext, Datum datum) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void context;
            void data;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$4, this, pickleContext, datum);
            }
            CHAR dbchar = this.getDbCHAR((Datum)data);
            if (this.characterSemantic != 0 && this.form != 2) {
                if (dbchar.getStringWithReplacement().length() > this.length) {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 72, "\"" + dbchar.getStringWithReplacement() + "\"").fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$4, this, sQLException);
                    }
                    throw sQLException;
                }
            } else if (dbchar.getLength() > (long)this.length) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 72, "\"" + dbchar.getStringWithReplacement() + "\"").fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$4, this, sQLException);
                }
                throw sQLException;
            }
            int n2 = super.pickle81((PickleContext)context, dbchar);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$4, this, n2);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$4, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Object toObject(byte[] byArray, int n2, Map map) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void type;
            void bytes;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$5, this, byArray, n2, map);
            }
            if (bytes == null || ((void)bytes).length == 0) {
                Object var6_5 = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$5, this, var6_5);
                    ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$5, this, null);
                }
                return null;
            }
            CHAR result = null;
            switch (this.form) {
                case 1: 
                case 2: {
                    result = new CHAR((byte[])bytes, this.pickleCharacterSet);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    result = new CHAR((byte[])bytes, null);
                }
            }
            if ((this.typeCode == 12 || this.typeCode == -9) && result != null) {
                result.setVariableLength(true);
            }
            if (type == true) {
                CHAR cHAR = result;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$5, this, cHAR);
                    ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$5, this, null);
                }
                return cHAR;
            }
            if (type == 2) {
                Object object;
                Object object2 = object = result != null ? result.stringValue() : result;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$5, this, object);
                    ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$5, this, null);
                }
                return object2;
            }
            if (type == 3) {
                void var6_8 = bytes;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$5, this, var6_8);
                    ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$5, this, null);
                }
                return var6_8;
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59, bytes).fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$5, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private CHAR getDbCHAR(Datum datum) {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void data;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$6, this, datum);
            }
            CHAR in_char_obj = (CHAR)data;
            CHAR db_char_obj = null;
            if (in_char_obj.getCharacterSet().getOracleId() == this.pickleCharaterSetId) {
                db_char_obj = in_char_obj;
            } else {
                try {
                    db_char_obj = new CHAR(in_char_obj.toString(), this.pickleCharacterSet);
                }
                catch (SQLException ex) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    ex.printStackTrace(pw);
                    String z2 = sw.toString();
                    if (bl) {
                        this.debug($$$loggerRef$$$6, Level.FINEST, $$$methodRef$$$6, z2);
                    }
                    db_char_obj = in_char_obj;
                }
            }
            CHAR cHAR = db_char_obj;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$6, this, cHAR);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$6, this, null);
            }
            return cHAR;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Datum[] cArrayToDatumArray(Object object, OracleConnection oracleConnection, long l2, int n2) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void obj;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$7, this, object, oracleConnection, l2, n2);
            }
            Datum[] datumArray = null;
            if (obj != null) {
                void beginIdx;
                void count;
                if (obj instanceof char[][]) {
                    char[][] parray = (char[][])obj;
                    int len = (int)(count == -1 ? (long)parray.length : Math.min((long)parray.length - beginIdx + 1L, (long)count));
                    datumArray = new Datum[len];
                    for (int i2 = 0; i2 < len; ++i2) {
                        datumArray[i2] = new CHAR(new String(parray[(int)beginIdx + i2 - 1]), this.pickleCharacterSet);
                    }
                } else if (obj instanceof boolean[]) {
                    boolean[] parray = (boolean[])obj;
                    int len = (int)(count == -1 ? (long)parray.length : Math.min((long)parray.length - beginIdx + 1L, (long)count));
                    datumArray = new Datum[len];
                    for (int i3 = 0; i3 < len; ++i3) {
                        datumArray[i3] = new CHAR(parray[(int)beginIdx + i3 - 1], this.pickleCharacterSet);
                    }
                } else if (obj instanceof short[]) {
                    short[] parray = (short[])obj;
                    int len = (int)(count == -1 ? (long)parray.length : Math.min((long)parray.length - beginIdx + 1L, (long)count));
                    datumArray = new Datum[len];
                    for (int i4 = 0; i4 < len; ++i4) {
                        datumArray[i4] = new CHAR(parray[(int)beginIdx + i4 - 1], this.pickleCharacterSet);
                    }
                } else if (obj instanceof int[]) {
                    int[] parray = (int[])obj;
                    int len = (int)(count == -1 ? (long)parray.length : Math.min((long)parray.length - beginIdx + 1L, (long)count));
                    datumArray = new Datum[len];
                    for (int i5 = 0; i5 < len; ++i5) {
                        datumArray[i5] = new CHAR(parray[(int)beginIdx + i5 - 1], this.pickleCharacterSet);
                    }
                } else if (obj instanceof long[]) {
                    long[] parray = (long[])obj;
                    int len = (int)(count == -1 ? (long)parray.length : Math.min((long)parray.length - beginIdx + 1L, (long)count));
                    datumArray = new Datum[len];
                    for (int i6 = 0; i6 < len; ++i6) {
                        datumArray[i6] = new CHAR(new Long(parray[(int)beginIdx + i6 - 1]), this.pickleCharacterSet);
                    }
                } else if (obj instanceof float[]) {
                    float[] parray = (float[])obj;
                    int len = (int)(count == -1 ? (long)parray.length : Math.min((long)parray.length - beginIdx + 1L, (long)count));
                    datumArray = new Datum[len];
                    for (int i7 = 0; i7 < len; ++i7) {
                        datumArray[i7] = new CHAR(new Float(parray[(int)beginIdx + i7 - 1]), this.pickleCharacterSet);
                    }
                } else if (obj instanceof double[]) {
                    double[] parray = (double[])obj;
                    int len = (int)(count == -1 ? (long)parray.length : Math.min((long)parray.length - beginIdx + 1L, (long)count));
                    datumArray = new Datum[len];
                    for (int i8 = 0; i8 < len; ++i8) {
                        datumArray[i8] = new CHAR(new Double(parray[(int)beginIdx + i8 - 1]), this.pickleCharacterSet);
                    }
                } else {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59, obj).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$7, this, sQLException);
                    }
                    throw sQLException;
                }
            }
            Datum[] datumArray2 = datumArray;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$7, this, datumArray2);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$7, this, null);
            }
            return datumArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    public int getLength() {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$8, this, new Object[0]);
            }
            if (this.characterSemantic != 0) {
                int n2 = this.getLengthInCharacter();
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$8, this, n2);
                    ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$8, this, null);
                }
                return n2;
            }
            int n3 = this.length;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$8, this, n3);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$8, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void out;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$9, this, objectOutputStream);
            }
            out.writeInt(this.form);
            out.writeInt(this.charset);
            out.writeInt(this.length);
            out.writeInt(this.characterSemantic);
            out.writeShort(this.pickleCharaterSetId);
            out.writeShort(this.pickleNcharCharacterSet);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$9, this);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$9, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void in;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$10, this, objectInputStream);
            }
            this.form = in.readInt();
            this.charset = in.readInt();
            this.length = in.readInt();
            this.characterSemantic = in.readInt();
            this.pickleCharaterSetId = in.readShort();
            this.pickleNcharCharacterSet = in.readShort();
            this.pickleCharacterSet = this.pickleNcharCharacterSet != 0 ? CharacterSet.make(this.pickleNcharCharacterSet) : CharacterSet.make(this.pickleCharaterSetId);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$10, this);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$10, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setConnection(OracleConnection oracleConnection) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void conn;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$11, this, oracleConnection);
            }
            this.connection = conn;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$11, this);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$11, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean isNCHAR() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$12, this, new Object[0]);
            }
            boolean bl3 = bl2 = this.form == 2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$12, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$12, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$13, this, new Object[0]);
            }
            OracleConnection oracleConnection = this.connection;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$13, this, oracleConnection);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$13, this, null);
            }
            return oracleConnection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, OracleTypeCHAR.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    @Log
    protected void debug(Logger logger, Level level, Executable method, String msg) {
        ClioSupport.log(logger, level, this.getClass(), method, msg);
    }

    static {
        try {
            $$$methodRef$$$16 = OracleTypeCHAR.class.getDeclaredConstructor(OracleConnection.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = OracleTypeCHAR.class.getDeclaredConstructor(OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = OracleTypeCHAR.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = OracleTypeCHAR.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OracleTypeCHAR.class.getDeclaredMethod("isNCHAR", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OracleTypeCHAR.class.getDeclaredMethod("setConnection", OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleTypeCHAR.class.getDeclaredMethod("readObject", ObjectInputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleTypeCHAR.class.getDeclaredMethod("writeObject", ObjectOutputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleTypeCHAR.class.getDeclaredMethod("getLength", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleTypeCHAR.class.getDeclaredMethod("cArrayToDatumArray", Object.class, OracleConnection.class, Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleTypeCHAR.class.getDeclaredMethod("getDbCHAR", Datum.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleTypeCHAR.class.getDeclaredMethod("toObject", byte[].class, Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleTypeCHAR.class.getDeclaredMethod("pickle81", PickleContext.class, Datum.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleTypeCHAR.class.getDeclaredMethod("parseTDSrec", TDSReader.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleTypeCHAR.class.getDeclaredMethod("toDatumArray", Object.class, OracleConnection.class, Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleTypeCHAR.class.getDeclaredMethod("toDatum", Object.class, OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleTypeCHAR.class.getDeclaredMethod("getLengthInCharacter", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

