/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.sql.CharacterSet;

@DefaultLogger(value="oracle.sql")
@Supports(value={Feature.CHARACTER_PROCESSING})
abstract class CharacterSetFactory {
    public static final short DEFAULT_CHARSET = -1;
    public static final short ASCII_CHARSET = 1;
    public static final short ISO_LATIN_1_CHARSET = 31;
    public static final short UNICODE_1_CHARSET = 870;
    public static final short UNICODE_2_CHARSET = 871;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;

    CharacterSetFactory() {
        boolean bl = (0x8000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, CharacterSetFactory.class, $$$methodRef$$$1, null, new Object[0]);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, CharacterSetFactory.class, $$$methodRef$$$1, null);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, CharacterSetFactory.class, $$$methodRef$$$1, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, CharacterSetFactory.class, $$$methodRef$$$1, null, throwable2);
            }
            throw throwable;
        }
    }

    public abstract CharacterSet make(int var1);

    public static void main(String[] stringArray) {
        boolean bl = (0x8000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, CharacterSetFactory.class, $$$methodRef$$$0, null, new Object[]{stringArray});
            }
            CharacterSet unicode = CharacterSet.make(871);
            int[] charSets = new int[]{1, 31, 870, 871};
            for (int idX = 0; idX < charSets.length; ++idX) {
                CharacterSet cs = CharacterSet.make(charSets[idX]);
                Object longString = "longlonglonglong";
                longString = (String)longString + (String)longString + (String)longString + (String)longString;
                longString = (String)longString + (String)longString + (String)longString + (String)longString;
                longString = (String)longString + (String)longString + (String)longString + (String)longString;
                longString = (String)longString + (String)longString + (String)longString + (String)longString;
                String[] testStrings = new String[]{"abc", "ab?c", "XYZ", longString};
                for (int idS = 0; idS < testStrings.length; ++idS) {
                    boolean ok;
                    block17: {
                        String testString = testStrings[idS];
                        Object shortString = testString;
                        if (testString.length() > 16) {
                            shortString = ((String)shortString).substring(0, 16) + "...";
                        }
                        System.out.println("testing " + cs + " against <" + (String)shortString + ">");
                        ok = true;
                        try {
                            byte[] utf;
                            byte[] rawWithoutReplacement;
                            String withoutReplacement;
                            byte[] raw = cs.convertWithReplacement(testString);
                            String withReplacement = cs.toStringWithReplacement(raw, 0, raw.length);
                            raw = cs.convert(withReplacement);
                            String roundTrip = cs.toString(raw, 0, raw.length);
                            if (!withReplacement.equals(roundTrip)) {
                                System.out.println("    FAILED roundTrip " + roundTrip);
                                ok = false;
                            }
                            if (cs.isLossyFrom(unicode)) {
                                try {
                                    byte[] bad = cs.convert(testString);
                                    String badString = cs.toString(bad, 0, bad.length);
                                    if (!badString.equals(roundTrip)) {
                                        System.out.println("    FAILED roundtrip, no throw");
                                    }
                                    break block17;
                                }
                                catch (SQLException bad) {}
                                break block17;
                            }
                            if (!roundTrip.equals(testString)) {
                                System.out.println("    FAILED roundTrip " + roundTrip);
                                ok = false;
                            }
                            if (!(withoutReplacement = cs.toString(rawWithoutReplacement = cs.convert(unicode, utf = unicode.convert(testString), 0, utf.length), 0, rawWithoutReplacement.length)).equals(testString)) {
                                System.out.println("    FAILED withoutReplacement " + withoutReplacement);
                                ok = false;
                            }
                        }
                        catch (Exception ex) {
                            System.out.println("    FAILED with Exception " + ex);
                        }
                    }
                    if (!ok) continue;
                    System.out.println("    PASSED " + (cs.isLossyFrom(unicode) ? "LOSSY" : ""));
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, CharacterSetFactory.class, $$$methodRef$$$0, null);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, CharacterSetFactory.class, $$$methodRef$$$0, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, CharacterSetFactory.class, $$$methodRef$$$0, null, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$1 = CharacterSetFactory.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$0 = CharacterSetFactory.class.getDeclaredMethod("main", String[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
    }
}

