/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import oracle.AQ.AQDriverManager;
import oracle.AQ.AQException;
import oracle.AQ.AQOracleAdmin;
import oracle.AQ.AQOracleAgent;
import oracle.AQ.AQOracleQueue;
import oracle.AQ.AQOracleQueueTable;
import oracle.AQ.AQOracleSession;
import oracle.AQ.AQQueueProperty;
import oracle.AQ.AQQueueTable;
import oracle.AQ.AQQueueTableProperty;
import oracle.jdbc.OracleBlob;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleClob;
import oracle.jdbc.OracleData;
import oracle.jdbc.internal.JMSNotificationRegistration;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.util.RepConversion;
import oracle.jms.AQjmsAdtMessage;
import oracle.jms.AQjmsAgent;
import oracle.jms.AQjmsBytesMessage;
import oracle.jms.AQjmsCliSubMapEntry;
import oracle.jms.AQjmsClientSubscriberMap;
import oracle.jms.AQjmsConnection;
import oracle.jms.AQjmsConstants;
import oracle.jms.AQjmsConsumer;
import oracle.jms.AQjmsConsumerExceptionListener;
import oracle.jms.AQjmsDestination;
import oracle.jms.AQjmsDestinationProperty;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsGeneralDBConnection;
import oracle.jms.AQjmsInterOp;
import oracle.jms.AQjmsMapMessage;
import oracle.jms.AQjmsMessage;
import oracle.jms.AQjmsNtfRegistration;
import oracle.jms.AQjmsObject;
import oracle.jms.AQjmsObjectMessage;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsProducer;
import oracle.jms.AQjmsQueueBrowser;
import oracle.jms.AQjmsQueueSenderImpl;
import oracle.jms.AQjmsSelector;
import oracle.jms.AQjmsStreamMessage;
import oracle.jms.AQjmsTextMessage;
import oracle.jms.AQjmsTopicBrowser;
import oracle.jms.AQjmsTopicPublisherImpl;
import oracle.jms.AQjmsTopicReceiver;
import oracle.jms.AQjmsUtil;
import oracle.jms.AdtMessage;
import oracle.jms.EmulatedXAHandler;
import oracle.jms.TopicBrowser;
import oracle.sql.CustomDatum;
import oracle.sql.ORAData;
import oracle.sql.converter.CharacterSetMetaData;

public class AQjmsSession
extends AQjmsObject
implements QueueSession,
TopicSession {
    int cl_check_interval = AQjmsConstants.getCloseCheckInterval();
    AQjmsConnection jms_conn;
    int ack_mode;
    boolean transacted;
    int sess_type;
    private CallableStatement rems_stmt;
    private CallableStatement alts_stmt;
    private CallableStatement bind_stmt;
    private CallableStatement ubnd_stmt;
    private CallableStatement chks_stmt;
    private Hashtable cons_list;
    private QueueBrowser queue_browser;
    private MessageListener privileged_listener;
    long[] oci_handles = new long[3];
    long oci_aq_cntxt = 0L;
    short dbversion;
    OracleCallableStatement st_text = null;
    OracleCallableStatement st_bytes = null;
    OracleCallableStatement st_map = null;
    OracleCallableStatement st_stream = null;
    OracleCallableStatement st_object = null;
    OracleCallableStatement st_adt = null;
    OracleCallableStatement st_adt_rep = null;
    OracleCallableStatement deq_stmt = null;
    OracleCallableStatement st_array_enqueue = null;
    OracleCallableStatement st_array_text_enqueue = null;
    OracleCallableStatement st_array_bytes_enqueue = null;
    OracleCallableStatement st_array_stream_enqueue = null;
    OracleCallableStatement st_array_map_enqueue = null;
    OracleCallableStatement st_array_object_enqueue = null;
    OracleCallableStatement st_array_dequeue = null;
    OracleCallableStatement st_array_text_dequeue = null;
    OracleCallableStatement st_array_bytes_dequeue = null;
    OracleCallableStatement st_array_stream_dequeue = null;
    OracleCallableStatement st_array_map_dequeue = null;
    OracleCallableStatement st_array_object_dequeue = null;
    Connection db_conn = null;
    boolean cache_deq_stmt = false;
    static boolean loaded_library = false;
    private String clientSessionGUID = null;
    private static final Map<String, Map<String, Map<String, Topic>>> s_subt = new HashMap<String, Map<String, Map<String, Topic>>>();
    private final Object m_consync = new Object();
    private boolean compliant = AQjmsConstants.IS_COMPLIANT;
    private Thread closingThread = null;
    AQjmsGeneralDBConnection genConn = null;
    private String prevSubName = null;
    private EmulatedXAHandler xaHandler;
    private int db_max_bytes;
    private boolean sendConsistent = true;
    boolean wlsXaTopicNextDisabled;
    OracleBlob cachedTempBlob = null;
    OracleClob cachedTempClob = null;
    volatile boolean usedJMSRegistration;
    ExceptionListener excpLsnr = null;
    ArrayList<AQjmsConsumerExceptionListener> consExcpListenerList = new ArrayList();
    private Object m_lsync = new Object();
    private boolean m_inlis = false;
    private static final int MAX_SUBSCRIBER_LEN = 30;
    private static final int MAX_SUBSCRIBER_LEN_122_COMPATIBLE = 128;
    private static final int MAX_QUEUE_NAME_LEN = 24;
    private static final int MAX_QUEUETABLE_NAME_LEN = 24;

    AQjmsSession(AQjmsConnection aQjmsConnection, int n, boolean bl, int n2, AQjmsGeneralDBConnection aQjmsGeneralDBConnection) throws JMSException {
        super("Session", aQjmsConnection);
        this.jms_conn = aQjmsConnection;
        this.ack_mode = n;
        this.transacted = bl;
        this.compliant = aQjmsConnection.getCompliant();
        this.genConn = aQjmsGeneralDBConnection;
        this.db_conn = aQjmsGeneralDBConnection.getDBConnection();
        this.dbversion = aQjmsConnection.getDBVersion();
        AQjmsOracleDebug.trace(5, "AQjmsSession.constructor", "dbversion=" + this.dbversion);
        this.setDBRatio();
        this.rems_stmt = null;
        this.alts_stmt = null;
        this.bind_stmt = null;
        this.ubnd_stmt = null;
        this.chks_stmt = null;
        if (n2 == 10 || n2 == 20 || n2 == 30) {
            this.sess_type = n2;
        } else {
            AQjmsOracleDebug.trace(1, "AQjmsSession.constructor1", "Invalid type - not a Queue or Topic");
            AQjmsError.throwEx(122, "invalid type");
        }
        this.xaHandler = AQjmsConstants.useEmulatedXA() ? new EmulatedXAHandler(this.db_conn, this) : null;
        if (!this.isInTransactionRechecked() && n != 1 && n != 2 && n != 3) {
            AQjmsOracleDebug.trace(1, "AQjmsSession.constructor1", "Wrong ACKOWLEDGE MODE: ack_mode, setting it to AUTO_ACKNOWLEDGE");
            n = 1;
        }
        this.cons_list = new Hashtable();
        this.queue_browser = null;
        this.privileged_listener = null;
        this.cache_deq_stmt = false;
        AQjmsOracleDebug.trace(3, "AQjmsSession.constructor1", "oci enabled = " + AQDriverManager.isOciAQEnabled());
        this.getOCIHandles();
        if (this.hasOciAQContext() || this.getDriver().equalsIgnoreCase("thin") && AQjmsConstants.useJdbcAQ()) {
            this.setMultiRetry();
        }
        if (AQjmsConstants.ORDER_WITH_SELECTOR) {
            this.enableEventForMsgOrder();
        }
        if (!((oracle.jdbc.OracleConnection)this.db_conn).getUsingXAFlag()) {
            try {
                this.db_conn.setAutoCommit(false);
            }
            catch (SQLException sQLException) {
                AQjmsError.throwEx("can not set autocommit for the db connection", (Throwable)sQLException);
            }
        }
        aQjmsConnection.attach(this);
    }

    boolean isKprb() {
        String string = ((OracleConnection)this.db_conn).getProtocolType();
        AQjmsOracleDebug.trace(3, "AQjmsSession.isKbrp", "protocol:" + string);
        return "kprb".equals(string);
    }

    private boolean isKnownSingleCharset(int n) {
        return n == 1 || n == 2 || n == 31;
    }

    private int getClientRatio() throws JMSException {
        AQjmsOracleDebug.trace(5, "AQjmsSession.getClientRatio", "enter");
        short s = 0;
        try {
            s = ((OracleConnection)this.db_conn).getJdbcCsId();
        }
        catch (SQLException sQLException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.getClientRatio get the csid from jdbc", sQLException);
            AQjmsError.throwEx("Failed to obtain the Client CSID from JDBC connection", (Throwable)sQLException);
        }
        AQjmsOracleDebug.trace(5, "AQjmsSession.getClientRatio", "The Client csid = " + s);
        int n = 0;
        if (this.isKnownSingleCharset(s)) {
            n = 1;
        } else {
            int n2 = CharacterSetMetaData.getRatio((int)s, (int)2002);
            if (n2 == 0) {
                AQjmsError.throwEx("The Client CSID obtained from JDBC is bad", null);
            } else {
                n = n2 * 2;
            }
        }
        AQjmsOracleDebug.trace(5, "AQjmsSession.getClientRatio", "exit");
        return n;
    }

    private void setDBRatio() throws JMSException {
        AQjmsOracleDebug.trace(5, "AQjmsSession.setDBRatio", "enter");
        short s = 0;
        try {
            s = ((OracleConnection)this.db_conn).getDbCsId();
        }
        catch (SQLException sQLException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.setRatio get the csid from db", sQLException);
            AQjmsError.throwEx("Failed to obtain the DB CSID from JDBC connection", (Throwable)sQLException);
        }
        AQjmsOracleDebug.trace(5, "AQjmsSession.setRatio", "The DB csid = " + s);
        if (this.isKnownSingleCharset(s)) {
            this.db_max_bytes = 1;
        } else {
            int n = CharacterSetMetaData.getRatio((int)s, (int)2002);
            if (n == 0) {
                AQjmsError.throwEx("The DB CSID obtained from JDBC is bad", null);
            } else {
                this.db_max_bytes = n * 2;
            }
        }
        AQjmsOracleDebug.trace(5, "AQjmsSession.setRatio", "exit");
    }

    int maxBytes(int n) {
        return this.db_max_bytes * n;
    }

    boolean getCompliant() {
        AQjmsOracleDebug.trace(4, "AQjmsSession.getCompliant", "Session <compliant>:" + this.compliant);
        return this.compliant;
    }

    private native long ociinit(long[] var1, int var2, int var3, boolean var4, short var5, int var6, int var7) throws Exception;

    private native void ocifrctx(long[] var1, long var2, int var4) throws Exception;

    private native void ocibreak(long var1, long var3, long var5) throws Exception;

    public BytesMessage createBytesMessage() throws JMSException {
        AQjmsBytesMessage aQjmsBytesMessage = null;
        this.checkSessionStarted();
        aQjmsBytesMessage = new AQjmsBytesMessage(this);
        AQjmsOracleDebug.trace(5, "AQjmsSession.createBytesMesage", "returning bytes message");
        return aQjmsBytesMessage;
    }

    public synchronized MapMessage createMapMessage() throws JMSException {
        AQjmsMapMessage aQjmsMapMessage = null;
        this.checkSessionStarted();
        aQjmsMapMessage = new AQjmsMapMessage(this);
        AQjmsOracleDebug.trace(5, "AQjmsSession.createMapMessage", "returning map message");
        return aQjmsMapMessage;
    }

    public synchronized Message createMessage() throws JMSException {
        AQjmsMessage aQjmsMessage = null;
        this.checkSessionStarted();
        aQjmsMessage = new AQjmsMessage(this, true);
        aQjmsMessage.setHeaderOnly();
        AQjmsOracleDebug.trace(5, "AQjmsSession.createMessage", "return message");
        return aQjmsMessage;
    }

    public synchronized ObjectMessage createObjectMessage() throws JMSException {
        AQjmsObjectMessage aQjmsObjectMessage = null;
        this.checkSessionStarted();
        aQjmsObjectMessage = new AQjmsObjectMessage(this);
        AQjmsOracleDebug.trace(5, "AQjmsSession.createObjectMessage", "return object message");
        return aQjmsObjectMessage;
    }

    public synchronized ObjectMessage createObjectMessage(Serializable serializable) throws JMSException {
        AQjmsObjectMessage aQjmsObjectMessage = null;
        this.checkSessionStarted();
        aQjmsObjectMessage = new AQjmsObjectMessage(this);
        aQjmsObjectMessage.setObject(serializable);
        AQjmsOracleDebug.trace(5, "AQjmsSession.createObjectMessage", "return initialized object message");
        return aQjmsObjectMessage;
    }

    public synchronized AdtMessage createAdtMessage() throws JMSException {
        AQjmsAdtMessage aQjmsAdtMessage = null;
        aQjmsAdtMessage = this.createAdtMessage(null);
        return aQjmsAdtMessage;
    }

    public synchronized AQjmsAdtMessage createAdtMessage(CustomDatum customDatum) throws JMSException {
        AQjmsAdtMessage aQjmsAdtMessage = null;
        this.checkSessionStarted();
        aQjmsAdtMessage = new AQjmsAdtMessage(this, customDatum);
        AQjmsOracleDebug.trace(5, "AQjmsSession.createAdtMessage", "return adt message");
        return aQjmsAdtMessage;
    }

    public synchronized AdtMessage createORAMessage() throws JMSException {
        AQjmsAdtMessage aQjmsAdtMessage = null;
        ORAData oRAData = null;
        aQjmsAdtMessage = this.createORAMessage(oRAData);
        return aQjmsAdtMessage;
    }

    public synchronized AQjmsAdtMessage createORAMessage(OracleData oracleData) throws JMSException {
        AQjmsAdtMessage aQjmsAdtMessage = null;
        this.checkSessionStarted();
        aQjmsAdtMessage = new AQjmsAdtMessage(this, oracleData);
        AQjmsOracleDebug.trace(5, "AQjmsSession.createAdtMessage", "return adt message");
        return aQjmsAdtMessage;
    }

    public synchronized AQjmsAdtMessage createORAMessage(ORAData oRAData) throws JMSException {
        AQjmsAdtMessage aQjmsAdtMessage = null;
        this.checkSessionStarted();
        aQjmsAdtMessage = new AQjmsAdtMessage(this, oRAData);
        AQjmsOracleDebug.trace(5, "AQjmsSession.createAdtMessage", "return adt message");
        return aQjmsAdtMessage;
    }

    public synchronized StreamMessage createStreamMessage() throws JMSException {
        AQjmsStreamMessage aQjmsStreamMessage = null;
        this.checkSessionStarted();
        aQjmsStreamMessage = new AQjmsStreamMessage(this);
        AQjmsOracleDebug.trace(5, "AQjmsSession.createStreamMessage", "return stream message");
        return aQjmsStreamMessage;
    }

    public synchronized TextMessage createTextMessage() throws JMSException {
        AQjmsTextMessage aQjmsTextMessage = null;
        this.checkSessionStarted();
        aQjmsTextMessage = new AQjmsTextMessage(this);
        AQjmsOracleDebug.trace(5, "AQjmsSession.createTextMessage", "return text message");
        return aQjmsTextMessage;
    }

    public synchronized TextMessage createTextMessage(StringBuffer stringBuffer) throws JMSException {
        AQjmsTextMessage aQjmsTextMessage = null;
        this.checkSessionStarted();
        aQjmsTextMessage = new AQjmsTextMessage(this);
        aQjmsTextMessage.setText(stringBuffer.toString());
        AQjmsOracleDebug.trace(5, "AQjmsSession.createTextMessage", "return initialized text message");
        return aQjmsTextMessage;
    }

    public synchronized TextMessage createTextMessage(String string) throws JMSException {
        AQjmsTextMessage aQjmsTextMessage = null;
        this.checkSessionStarted();
        aQjmsTextMessage = new AQjmsTextMessage(this);
        aQjmsTextMessage.setText(string);
        AQjmsOracleDebug.trace(5, "AQjmsSession.createTextMessage", "return initialized text message");
        return aQjmsTextMessage;
    }

    public synchronized boolean getTransacted() throws JMSException {
        this.checkSessionStarted();
        return this.transacted;
    }

    public synchronized int getAckMode() throws JMSException {
        this.checkSessionStarted();
        return this.ack_mode;
    }

    void checkConsistency() throws JMSException {
        if (!this.sendConsistent) {
            JMSException jMSException = new JMSException("Cannot not commit in an inconsistent state, must rollback");
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.checkConsistency", jMSException);
            throw jMSException;
        }
    }

    void setConsistency(boolean bl) {
        this.sendConsistent = bl;
        if (!bl && this.xaHandler != null) {
            this.xaHandler.setRollbackOnlyIfInGlobalTxn();
        }
    }

    public void commit() throws JMSException {
        this.checkSessionStarted();
        if (!this.transacted) {
            AQjmsError.throwIllegalStateEx(227, null);
        }
        if (this.usedJMSRegistration) {
            this.ackJmsNtfsAndCommit();
            return;
        }
        if (!this.lock("commit", -1L)) {
            AQjmsError.throwEx(122);
        }
        try {
            this.commitNoCheck();
        }
        finally {
            this.unlock("commit");
        }
    }

    void ackJmsNtfsAndCommit() throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsSession.ackJmsNtfsAndCommit", "entry");
        if (!this.lock("ackJmsNtfsAndCommit", -1L)) {
            AQjmsError.throwEx(122);
        }
        try {
            this.ackMultiJmsNtfs(JMSNotificationRegistration.Directive.COMMIT);
            AQjmsOracleDebug.trace(5, "AQjmsSession.ackJmsNtfsAndCommit", "ready to commit");
            this.commitNoCheck();
        }
        finally {
            this.unlock("ackJmsNtfsAndCommit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ackMultiJmsNtfs(JMSNotificationRegistration.Directive directive) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsSession.ackMultiJmsNtfs", "entry Operation= " + (directive == JMSNotificationRegistration.Directive.COMMIT ? "Commit" : "Rollback"));
        try {
            AQjmsNtfRegistration aQjmsNtfRegistration;
            ArrayList<AQjmsNtfRegistration> arrayList = new ArrayList<AQjmsNtfRegistration>();
            Object object = this.cons_list.elements();
            while (object.hasMoreElements()) {
                AQjmsConsumer aQjmsConsumer = (AQjmsConsumer)object.nextElement();
                aQjmsNtfRegistration = aQjmsConsumer.getNtfReg();
                if (aQjmsNtfRegistration == null || aQjmsNtfRegistration.getLastMessageId() == null) continue;
                arrayList.add(aQjmsNtfRegistration);
            }
            if (arrayList.size() == 0) {
                AQjmsOracleDebug.trace(4, "AQjmsSession.ackMultiJmsNtfs", "All messages are Acknowledged, No Ack to be sent.");
                return;
            }
            object = new byte[arrayList.size()][];
            ArrayList<JMSNotificationRegistration> arrayList2 = new ArrayList<JMSNotificationRegistration>(arrayList.size());
            Iterator iterator = arrayList.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                aQjmsNtfRegistration = (AQjmsNtfRegistration)iterator.next();
                object[n++] = aQjmsNtfRegistration.getLastMessageId();
                arrayList2.add(aQjmsNtfRegistration.getJDBCRegistration());
                AQjmsOracleDebug.trace(4, "AQjmsSession.ackMultiJmsNtfs", "Ack for registration= " + aQjmsNtfRegistration + " lastMessageID=" + RepConversion.bArray2String((byte[])aQjmsNtfRegistration.getLastMessageId()));
            }
            AQjmsSession aQjmsSession = this;
            synchronized (aQjmsSession) {
                OracleConnection oracleConnection = (OracleConnection)this.getDBConnection();
                oracleConnection.ackJMSNotification(arrayList2, (byte[][])object, directive);
            }
            AQjmsOracleDebug.trace(4, "AQjmsSession.ackMultiJmsNtfs", "after called db conn.ackJMSNotification");
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                ((AQjmsNtfRegistration)iterator.next()).setLastMessageId(null);
            }
        }
        catch (SQLException sQLException) {
            AQjmsError.throwEx("failed to ack last notified message", (Throwable)sQLException);
        }
    }

    @Override
    void startJMSNotification() throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsSession.startJMSNotification", "entry");
        if (this.usedJMSRegistration) {
            if (!this.lock("startJMSNotification", -1L)) {
                AQjmsError.throwEx(122);
            }
            try {
                Enumeration enumeration = this.cons_list.elements();
                while (enumeration.hasMoreElements()) {
                    this.checkSessionStarted();
                    AQjmsConsumer aQjmsConsumer = (AQjmsConsumer)enumeration.nextElement();
                    aQjmsConsumer.startJMSNotification();
                }
            }
            finally {
                this.unlock("startJMSNotification");
            }
        }
        AQjmsOracleDebug.trace(4, "AQjmsSession.startJMSNotification", "exit");
    }

    @Override
    void stopJMSNotification() throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsSession.stopJMSNotification", "entry");
        if (this.usedJMSRegistration) {
            if (!this.lock("stopJMSNotification", -1L)) {
                AQjmsError.throwEx(122);
            }
            try {
                Enumeration enumeration = this.cons_list.elements();
                while (enumeration.hasMoreElements()) {
                    this.checkSessionStarted();
                    AQjmsConsumer aQjmsConsumer = (AQjmsConsumer)enumeration.nextElement();
                    aQjmsConsumer.stopJMSNotification();
                }
            }
            finally {
                this.unlock("stopJMSNotification");
            }
        }
        AQjmsOracleDebug.trace(4, "AQjmsSession.stopJMSNotification", "exit");
    }

    @Override
    void handleJMSNotification() throws JMSException, TimeoutException {
        AQjmsOracleDebug.trace(4, "AQjmsSession.handleJMSNotification", "entry");
        if (this.usedJMSRegistration) {
            long l;
            long l2 = AQjmsConstants.getJmsNotificationTimeout();
            if (l2 < (l = 1000L)) {
                l = l2;
            }
            AQjmsOracleDebug.trace(5, "AQjmsSession.handleJMSNotification", "timeoutInMillis " + l2);
            AQjmsOracleDebug.trace(5, "AQjmsSession.handleJMSNotification", "check the state of the registration");
            boolean bl = true;
            long l3 = System.currentTimeMillis() + l2;
            Enumeration enumeration = this.cons_list.elements();
            while (enumeration.hasMoreElements()) {
                AQjmsConsumer aQjmsConsumer = (AQjmsConsumer)enumeration.nextElement();
                while (!(bl = System.currentTimeMillis() > l3)) {
                    this.checkSessionStarted();
                    if (aQjmsConsumer.isRegistrationDisabled()) break;
                    try {
                        AQjmsOracleDebug.trace(5, "AQjmsSession.handleJMSNotification", "state of the registration is not DISABLED");
                        Thread.sleep(l);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (l >= 30000L || l == l2) continue;
                    l += 1000L;
                }
                if (!bl) continue;
                throw new TimeoutException("The timeout value specified, " + l2 + " ms exceeded, stop() on Connection timed out !");
            }
        }
        AQjmsOracleDebug.trace(4, "AQjmsSession.handleJMSNotification", "exit");
    }

    void forceCommit() throws JMSException {
        if (!this.lock("forceCommit", -1L)) {
            AQjmsError.throwEx(122);
        }
        try {
            this.commitNoCheck();
        }
        finally {
            this.unlock("forceCommit");
        }
    }

    synchronized void commitNoCheck() throws JMSException {
        this.checkConsistency();
        Connection connection = null;
        connection = this.getDBConnection();
        try {
            connection.commit();
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
        if (!AQjmsConstants.ignorePriority()) {
            this.restartConsumers();
        }
    }

    public synchronized void rollback() throws JMSException {
        this.checkSessionStarted();
        if (!this.transacted) {
            AQjmsError.throwIllegalStateEx(228, null);
        }
        if (this.usedJMSRegistration) {
            this.ackJmsNtfsAndRollback();
            return;
        }
        this.forceRollback();
    }

    private void ackJmsNtfsAndRollback() throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsSession.ackJmsNtfsAndRollback", "entry");
        if (!this.lock("ackJmsNtfsAndRollback", -1L)) {
            AQjmsError.throwEx(122);
        }
        try {
            this.ackMultiJmsNtfs(JMSNotificationRegistration.Directive.ROLLBACK);
            AQjmsOracleDebug.trace(5, "AQjmsSession.ackJmsNtfsAndRollback", "ready to rollback");
            this.forceRollback();
        }
        finally {
            this.unlock("ackJmsNtfsAndRollback");
        }
    }

    synchronized void forceRollback() throws JMSException {
        Connection connection = null;
        connection = this.getDBConnection();
        try {
            connection.rollback();
            this.setConsistency(true);
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
        this.restartConsumers();
    }

    @Override
    void markClosed() {
        super.markClosed();
        if (this.lockedByReceive()) {
            this.cancelBlockingReceive();
        }
    }

    void cancelBlockingReceive() {
        try {
            if (this.oci_aq_cntxt != 0L) {
                String string = AQjmsUtil.getSystemProperty("os.name");
                if (string == null || !string.toUpperCase().startsWith("WINDOWS")) {
                    AQjmsOracleDebug.trace(5, "AQjmsSession.cancelBlockingReceive", System.currentTimeMillis() + ": Calling OCIBreak");
                    this.ocibreak(this.getOCIServiceHandle(), this.getOCIErrorHandle(), this.oci_aq_cntxt);
                }
            } else {
                AQjmsOracleDebug.trace(5, "AQjmsSession.cancelBlockingReceive", System.currentTimeMillis() + ": Calling OracleConnection.cancel");
                if (this.db_conn != null) {
                    ((oracle.jdbc.OracleConnection)this.db_conn).cancel();
                }
            }
        }
        catch (Throwable throwable) {
            AQjmsOracleDebug.trace(4, "AQjmsSession.cancelBlockingReceive", "Got exception: " + throwable);
        }
    }

    @Override
    protected synchronized void preClose() throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsSession.preClose", "ENTRY");
        Connection connection = this.getOurDBConnection();
        try {
            if (connection != null && !connection.isClosed()) {
                if (!this.isInGlobalTransactionRechecked() && !this.genConn.isExternal()) {
                    AQjmsOracleDebug.trace(4, "AQjmsSession.preClose", "abort txn");
                    connection.rollback();
                } else {
                    AQjmsOracleDebug.trace(4, "AQjmsSession.preClose", "not aborting txn");
                }
            }
        }
        catch (SQLException sQLException) {
            AQjmsOracleDebug.traceEx(1, "AQjmsSession.preClose: failed to rollback the transaction before close", sQLException);
            throw new AQjmsException(sQLException);
        }
        AQjmsOracleDebug.trace(4, "AQjmsSession.preClose", "EXIT");
    }

    @Override
    public void close() throws JMSException {
        try {
            this.closingThread = Thread.currentThread();
            super.close();
        }
        finally {
            this.closingThread = null;
        }
    }

    @Override
    protected synchronized void localClose() throws JMSException {
        Connection connection = null;
        AQjmsOracleDebug.trace(3, "AQjmsSession.localClose", "entry ...");
        if (this.clientSessionGUID != null) {
            try {
                this.removeAQNondurableSubscribers(this.clientSessionGUID);
            }
            catch (Throwable throwable) {
                AQjmsOracleDebug.traceEx(5, "AQjmsSession.localClose: removeAQNondurableSubscribers(" + this.clientSessionGUID + ")", throwable);
            }
        }
        if (this.cachedTempBlob != null) {
            try {
                AQjmsOracleDebug.trace(5, "AQjmsSession.localClose", "to free cached temporary Blob");
                this.cachedTempBlob.free();
            }
            catch (Throwable throwable) {
                AQjmsOracleDebug.traceEx(5, "AQjmsSession.localClose: free cached temporary Blob", throwable);
            }
            this.cachedTempBlob = null;
        }
        if (this.cachedTempClob != null) {
            try {
                AQjmsOracleDebug.trace(5, "AQjmsSession.localClose", "to free cached temporary Clob");
                this.cachedTempClob.free();
            }
            catch (Throwable throwable) {
                AQjmsOracleDebug.traceEx(5, "AQjmsSession.localClose: free cached temporary Clob", throwable);
            }
            this.cachedTempClob = null;
        }
        connection = this.getOurDBConnection();
        try {
            if (this.oci_aq_cntxt != 0L && !connection.isClosed()) {
                this.freeOCIHandles();
            }
        }
        catch (Throwable throwable) {
            AQjmsOracleDebug.traceEx(5, "AQjmsSession.localClose: freeing oci handles", throwable);
        }
        try {
            if (this.rems_stmt != null) {
                this.rems_stmt.close();
                this.rems_stmt = null;
            }
            if (this.alts_stmt != null) {
                this.alts_stmt.close();
                this.alts_stmt = null;
            }
            if (this.bind_stmt != null) {
                this.bind_stmt.close();
                this.bind_stmt = null;
            }
            if (this.ubnd_stmt != null) {
                this.ubnd_stmt.close();
                this.ubnd_stmt = null;
            }
            if (this.chks_stmt != null) {
                this.chks_stmt.close();
                this.chks_stmt = null;
            }
        }
        catch (Throwable throwable) {
            AQjmsOracleDebug.traceEx(2, "AQjmsSession.localClose: close cached statements", throwable);
        }
        this.destroyStmt(this.st_text);
        this.destroyStmt(this.st_bytes);
        this.destroyStmt(this.st_map);
        this.destroyStmt(this.st_object);
        this.destroyStmt(this.st_stream);
        this.destroyStmt(this.st_adt);
        this.destroyStmt(this.st_adt_rep);
        this.destroyStmt(this.deq_stmt);
        this.destroyStmt(this.st_array_enqueue);
        this.destroyStmt(this.st_array_text_enqueue);
        this.destroyStmt(this.st_array_bytes_enqueue);
        this.destroyStmt(this.st_array_stream_enqueue);
        this.destroyStmt(this.st_array_map_enqueue);
        this.destroyStmt(this.st_array_object_enqueue);
        this.destroyStmt(this.st_array_dequeue);
        this.destroyStmt(this.st_array_text_dequeue);
        this.destroyStmt(this.st_array_bytes_dequeue);
        this.destroyStmt(this.st_array_stream_dequeue);
        this.destroyStmt(this.st_array_map_dequeue);
        this.destroyStmt(this.st_array_object_dequeue);
        try {
            AQjmsOracleDebug.trace(4, "AQjmsSession.localClose", "Closing general Connection");
            this.genConn.close();
        }
        catch (Throwable throwable) {
            AQjmsOracleDebug.traceEx(2, "AQjmsSession.localClose: close db connection", throwable);
        }
        this.jms_conn = null;
        this.db_conn = null;
        this.genConn = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startListener() {
        Object object = this.m_lsync;
        synchronized (object) {
            this.m_inlis = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopListener() {
        Object object = this.m_lsync;
        synchronized (object) {
            this.m_inlis = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean inListener() {
        boolean bl = false;
        Object object = this.m_lsync;
        synchronized (object) {
            bl = this.m_inlis;
        }
        return bl;
    }

    public synchronized void recover() throws JMSException {
        this.checkSessionStarted();
        int n = this.getAcknowledgeMode();
        if (n == 0) {
            AQjmsError.throwIllegalStateEx(238, null);
        }
        Connection connection = null;
        if (n == 2 || this.inListener()) {
            if (this.usedJMSRegistration) {
                AQjmsOracleDebug.trace(5, "AQjmsSession.recover", "before calling session.ackJmsNtfsAndRollback");
                this.ackJmsNtfsAndRollback();
                return;
            }
            try {
                connection = this.getDBConnection();
                connection.rollback();
            }
            catch (SQLException sQLException) {
                throw new AQjmsException(sQLException);
            }
            this.restartConsumers();
        }
    }

    public synchronized MessageListener getMessageListener() throws JMSException {
        return this.privileged_listener;
    }

    public synchronized void setMessageListener(MessageListener messageListener) throws JMSException {
        this.privileged_listener = messageListener;
        Enumeration enumeration = this.cons_list.elements();
        while (enumeration.hasMoreElements()) {
            AQjmsConsumer aQjmsConsumer = (AQjmsConsumer)enumeration.nextElement();
            aQjmsConsumer.setPrivilegedMessageListener(messageListener);
        }
    }

    public synchronized void setExceptionListener(ExceptionListener exceptionListener) {
        this.excpLsnr = exceptionListener;
    }

    public synchronized ExceptionListener getExceptionListener() {
        return this.excpLsnr;
    }

    synchronized ArrayList<AQjmsConsumerExceptionListener> getConsumerExcpLsnrList() {
        return this.consExcpListenerList;
    }

    synchronized void addConsumerExcpLsnr(AQjmsConsumerExceptionListener aQjmsConsumerExceptionListener) {
        this.consExcpListenerList.add(aQjmsConsumerExceptionListener);
    }

    synchronized void removeConsumerExcpLsnr(AQjmsConsumerExceptionListener aQjmsConsumerExceptionListener) {
        this.consExcpListenerList.remove(aQjmsConsumerExceptionListener);
    }

    public synchronized Queue createQueue(String string) throws JMSException {
        AQjmsOracleDebug.trace(3, "AQjmsSession.createQueue IN", "queuename: " + string);
        this.checkClosed("createQueue");
        if (this.sess_type == 20) {
            AQjmsError.throwIllegalStateEx(234, null);
        }
        String string2 = this.getAQOwner(string);
        String string3 = this.getAQName(string);
        Queue queue = null;
        try {
            queue = this.getQueue(string2, string3);
        }
        catch (Exception exception) {
            AQjmsOracleDebug.traceEx(5, "AQjmsSession.createQueue: getQueue failed: ", exception);
            AQjmsError.throwEx(190, string, exception);
        }
        AQjmsOracleDebug.trace(3, "AQjmsSession.createQueue EXIT ", "");
        return queue;
    }

    public synchronized QueueReceiver createReceiver(Queue queue) throws JMSException {
        AQjmsConsumer aQjmsConsumer = null;
        this.checkSessionStarted();
        if (queue == null) {
            throw new InvalidDestinationException(AQjmsError.getMessage(143));
        }
        if (!(queue instanceof AQjmsDestination) || !((AQjmsDestination)queue).isQueue()) {
            AQjmsError.throwInvalidDestEx(125);
        }
        if (this.getMessageListener() != null) {
            AQjmsError.throwEx(107, "createReceiver after MessageListener of Session is set");
        }
        aQjmsConsumer = new AQjmsConsumer(this, (Destination)queue, 10, 3, null, null);
        this.cons_list.put(aQjmsConsumer, aQjmsConsumer);
        return aQjmsConsumer;
    }

    public synchronized QueueReceiver createReceiver(Queue queue, Object object) throws JMSException {
        AQjmsConsumer aQjmsConsumer = null;
        this.checkSessionStarted();
        if (queue == null) {
            throw new InvalidDestinationException(AQjmsError.getMessage(143));
        }
        if (!(queue instanceof AQjmsDestination) || !((AQjmsDestination)queue).isQueue()) {
            AQjmsError.throwInvalidDestEx(125);
        }
        if (this.getMessageListener() != null) {
            AQjmsError.throwEx(107, "createReceiver after MessageListener of Session is set");
        }
        aQjmsConsumer = new AQjmsConsumer(this, (Destination)queue, 10, 3, null, object);
        this.cons_list.put(aQjmsConsumer, aQjmsConsumer);
        return aQjmsConsumer;
    }

    public QueueReceiver createReceiver(Queue queue, String string) throws JMSException {
        return this.createReceiver(queue, string, null);
    }

    public synchronized QueueReceiver createReceiver(Queue queue, String string, Object object) throws JMSException {
        AQjmsConsumer aQjmsConsumer = null;
        AQjmsSelector aQjmsSelector = null;
        String string2 = null;
        this.checkSessionStarted();
        if (queue == null) {
            throw new InvalidDestinationException(AQjmsError.getMessage(143));
        }
        if (!(queue instanceof AQjmsDestination) || !((AQjmsDestination)queue).isQueue()) {
            AQjmsError.throwInvalidDestEx(125);
        }
        if (this.getMessageListener() != null) {
            AQjmsError.throwEx(107, "createReceiver after MessageListener of Session is set");
        }
        if (string != null && !string.equals("")) {
            AQjmsDestination aQjmsDestination = (AQjmsDestination)queue;
            aQjmsSelector = aQjmsDestination.isSharded() ? new AQjmsSelector(string, 10, 4, this.dbversion, aQjmsDestination) : (object != null ? new AQjmsSelector(string, 10, 2, this.dbversion, this.getCompliant()) : ((string2 = ((AQjmsDestination)queue).getAdtType()).equalsIgnoreCase("SYS.ANYDATA") ? new AQjmsSelector(string, 10, 3, this.dbversion, this.getCompliant()) : new AQjmsSelector(string, 10, 1, this.dbversion, this.getCompliant())));
        }
        AQjmsOracleDebug.trace(5, "AQjmsSession.createReceiver", "Selector: " + aQjmsSelector);
        aQjmsConsumer = new AQjmsConsumer(this, (Destination)queue, 10, 3, null, object, aQjmsSelector, null);
        this.cons_list.put(aQjmsConsumer, aQjmsConsumer);
        return aQjmsConsumer;
    }

    public synchronized QueueSender createSender(Queue queue) throws JMSException {
        AQjmsQueueSenderImpl aQjmsQueueSenderImpl = null;
        this.checkSessionStarted();
        if (!(queue == null || queue instanceof AQjmsDestination && ((AQjmsDestination)queue).isQueue())) {
            AQjmsError.throwInvalidDestEx(125);
        }
        aQjmsQueueSenderImpl = new AQjmsQueueSenderImpl(this, (AQjmsDestination)queue);
        return aQjmsQueueSenderImpl;
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        return this.createBrowser(queue, null, null, false);
    }

    public QueueBrowser createBrowser(Queue queue, Object object) throws JMSException {
        return this.createBrowser(queue, null, object, false);
    }

    public QueueBrowser createBrowser(Queue queue, String string) throws JMSException {
        return this.createBrowser(queue, string, null, false);
    }

    public QueueBrowser createBrowser(Queue queue, String string, boolean bl) throws JMSException {
        return this.createBrowser(queue, string, null, bl);
    }

    public QueueBrowser createBrowser(Queue queue, String string, Object object) throws JMSException {
        return this.createBrowser(queue, string, object, false);
    }

    public synchronized QueueBrowser createBrowser(Queue queue, String string, Object object, boolean bl) throws JMSException {
        AQjmsQueueBrowser aQjmsQueueBrowser = null;
        int n = 1;
        AQjmsSelector aQjmsSelector = null;
        String string2 = null;
        String string3 = null;
        this.checkSessionStarted();
        if (queue == null) {
            throw new InvalidDestinationException(AQjmsError.getMessage(143));
        }
        if (this.sess_type == 20) {
            AQjmsError.throwIllegalStateEx(234, null);
        }
        if (!(queue instanceof AQjmsDestination) || !((AQjmsDestination)queue).isQueue()) {
            AQjmsError.throwInvalidDestEx(125);
        }
        string2 = ((AQjmsDestination)queue).getCompleteName();
        if (bl) {
            n = 2;
        }
        if (string != null && !string.equals("")) {
            AQjmsDestination aQjmsDestination = (AQjmsDestination)queue;
            aQjmsSelector = aQjmsDestination.isSharded() ? new AQjmsSelector(string, 10, 4, this.dbversion, aQjmsDestination) : (object != null ? new AQjmsSelector(string, 10, 2, this.dbversion, this.getCompliant()) : ((string3 = ((AQjmsDestination)queue).getAdtType()).equalsIgnoreCase("SYS.ANYDATA") ? new AQjmsSelector(string, 10, 3, this.dbversion, this.getCompliant()) : new AQjmsSelector(string, 10, 1, this.dbversion, this.getCompliant())));
        }
        aQjmsQueueBrowser = new AQjmsQueueBrowser((Session)this, (Destination)queue, 10, n, null, aQjmsSelector, object);
        return aQjmsQueueBrowser;
    }

    public TopicBrowser createBrowser(Topic topic, String string) throws JMSException {
        return this.createBrowser(topic, string, null, null, false);
    }

    public TopicBrowser createBrowser(Topic topic, String string, boolean bl) throws JMSException {
        return this.createBrowser(topic, string, null, null, bl);
    }

    public TopicBrowser createBrowser(Topic topic, String string, Object object) throws JMSException {
        return this.createBrowser(topic, string, null, object, false);
    }

    public TopicBrowser createBrowser(Topic topic, String string, Object object, boolean bl) throws JMSException {
        return this.createBrowser(topic, string, null, object, bl);
    }

    public TopicBrowser createBrowser(Topic topic, String string, String string2) throws JMSException {
        return this.createBrowser(topic, string, string2, null, false);
    }

    public TopicBrowser createBrowser(Topic topic, String string, String string2, boolean bl) throws JMSException {
        return this.createBrowser(topic, string, string2, null, bl);
    }

    public TopicBrowser createBrowser(Topic topic, String string, String string2, Object object) throws JMSException {
        return this.createBrowser(topic, string, string2, object, false);
    }

    public synchronized TopicBrowser createBrowser(Topic topic, String string, String string2, Object object, boolean bl) throws JMSException {
        AQjmsTopicBrowser aQjmsTopicBrowser = null;
        int n = 1;
        AQjmsSelector aQjmsSelector = null;
        String string3 = null;
        String string4 = null;
        this.checkSessionStarted();
        if (this.dbversion < 9000) {
            AQjmsError.throwEx(102);
        }
        if (topic == null) {
            AQjmsError.throwEx(166);
        }
        if (!(topic instanceof AQjmsDestination) || !((AQjmsDestination)topic).isTopic()) {
            AQjmsError.throwInvalidDestEx(126);
        }
        string3 = ((AQjmsDestination)topic).getCompleteName();
        if (bl) {
            n = 2;
        }
        if (string2 != null && !string2.equals("")) {
            AQjmsDestination aQjmsDestination = (AQjmsDestination)topic;
            aQjmsSelector = aQjmsDestination.isSharded() ? new AQjmsSelector(string2, 20, 4, this.dbversion, aQjmsDestination) : (object != null ? new AQjmsSelector(string2, 20, 2, this.dbversion, this.getCompliant()) : ((string4 = ((AQjmsDestination)topic).getAdtType()).equalsIgnoreCase("SYS.ANYDATA") ? new AQjmsSelector(string2, 20, 3, this.dbversion, this.getCompliant()) : new AQjmsSelector(string2, 20, 1, this.dbversion, this.getCompliant())));
        }
        aQjmsTopicBrowser = new AQjmsTopicBrowser((Session)this, (Destination)topic, 20, n, string, aQjmsSelector, object);
        return aQjmsTopicBrowser;
    }

    public synchronized TemporaryQueue createTemporaryQueue() throws JMSException {
        this.checkSessionStarted();
        if (this.sess_type == 20) {
            AQjmsError.throwIllegalStateEx(234, null);
        }
        return this.makeTemporaryQueue(false);
    }

    public synchronized Destination createJMSShardedQueue(String string, boolean bl) throws JMSException {
        return this.createJMSShardedQueue(string, bl, null, 0, null);
    }

    public synchronized Destination createJMSShardedQueue(String string, boolean bl, String string2, int n, String string3) throws JMSException {
        AQjmsDestination aQjmsDestination = null;
        Connection connection = null;
        CallableStatement callableStatement = null;
        if (string == null || string.trim().equals("")) {
            AQjmsError.throwEx(134);
        }
        String string4 = this.getAQOwner(string);
        String string5 = this.getAQName(string);
        AQjmsOracleDebug.trace(5, "AQjmsSession.createJMSShardedQueue", "Queue Owner: " + string4 + " and Queue Name: " + string5);
        String string6 = "begin dbms_aqadm.create_sharded_queue(queue_name => ?, storage_clause => ?, max_retries => ?, comment => ?, ";
        string6 = bl ? string6 + "multiple_consumers => true); end;" : string6 + "multiple_consumers => false); end;";
        try {
            connection = this.getDBConnection();
            callableStatement = connection.prepareCall(string6);
            callableStatement.setString(1, string);
            callableStatement.setString(2, string2);
            if (n != 0) {
                ((OracleCallableStatement)callableStatement).setObject(3, (Object)n, 4);
            } else {
                ((OracleCallableStatement)callableStatement).setNull(3, 4);
            }
            callableStatement.setString(4, string3);
            callableStatement.execute();
        }
        catch (SQLException sQLException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.createJMSShardedQueue", sQLException);
            throw new AQjmsException(sQLException);
        }
        finally {
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (SQLException sQLException) {}
            callableStatement = null;
        }
        AQQueueProperty aQQueueProperty = new AQQueueProperty();
        aQQueueProperty.setSharded(true);
        aQQueueProperty.setComment(string3);
        aQQueueProperty.setMaxRetries(n);
        try (AQOracleQueue aQOracleQueue = null;){
            aQOracleQueue = new AQOracleQueue(this, string4, string5, null, aQQueueProperty, 3, null, false);
            AQjmsDestinationProperty aQjmsDestinationProperty = new AQjmsDestinationProperty(aQOracleQueue.getProperty(true));
            aQjmsDestination = bl ? new AQjmsDestination(string4, string5, 20, aQOracleQueue.getPayloadType(), aQOracleQueue.getObjectPayloadType(), aQjmsDestinationProperty, null, false) : new AQjmsDestination(string4, string5, 10, aQOracleQueue.getPayloadType(), aQOracleQueue.getObjectPayloadType(), aQjmsDestinationProperty, null, false);
        }
        return aQjmsDestination;
    }

    public synchronized Topic createTopic(String string) throws JMSException {
        this.checkClosed("createQueue");
        if (this.sess_type == 10) {
            AQjmsError.throwIllegalStateEx(234, null);
        }
        String string2 = this.getAQOwner(string);
        String string3 = this.getAQName(string);
        Topic topic = null;
        try {
            topic = this.getTopic(string2, string3);
        }
        catch (Exception exception) {
            AQjmsOracleDebug.traceEx(5, "AQjmsSession.createTopic: getTopic failed: ", exception);
            AQjmsError.throwEx(243, string, exception);
        }
        return topic;
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        this.checkSessionStarted();
        TopicSubscriber topicSubscriber = this.createNondurableSub(topic, null, false, null, null);
        return topicSubscriber;
    }

    public TopicSubscriber createSubscriber(Topic topic, String string, boolean bl) throws JMSException {
        this.checkSessionStarted();
        TopicSubscriber topicSubscriber = this.createNondurableSub(topic, string, bl, null, null);
        return topicSubscriber;
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String string) throws JMSException {
        return this.createDurableSubscriber(topic, string, null, false, null, null);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String string, Object object) throws JMSException {
        return this.createDurableSubscriber(topic, string, null, false, object, null);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String string, String string2, boolean bl) throws JMSException {
        return this.createDurableSubscriber(topic, string, string2, bl, null, null);
    }

    public synchronized TopicSubscriber createDurableSubscriber(Topic topic, String string, String string2, boolean bl, Object object) throws JMSException {
        return this.createDurableSubscriber(topic, string, string2, bl, object, null);
    }

    public synchronized TopicSubscriber createDurableSubscriber(Topic topic, String string, String string2, boolean bl, Object object, String string3) throws JMSException {
        return this.createDurableSubscriber(topic, string, string2, bl, object, string3, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized TopicSubscriber createDurableSubscriber(Topic topic, String string, String string2, boolean bl, Object object, String string3, boolean bl2, boolean bl3) throws JMSException {
        AQjmsAgent aQjmsAgent = null;
        TopicSubscriber topicSubscriber = null;
        AQjmsSelector aQjmsSelector = null;
        Connection connection = null;
        this.checkSessionStarted();
        if (this.sess_type == 10) {
            AQjmsError.throwIllegalStateEx(234, null);
        }
        connection = this.getDBConnection();
        if (string == null) {
            AQjmsError.throwEx(116);
        }
        String string4 = AQjmsSession.chopit(string, this.getMaxSubscriberNameLen());
        if (topic == null) {
            throw new InvalidDestinationException(AQjmsError.getMessage(166));
        }
        if (!(topic instanceof AQjmsDestination) || !((AQjmsDestination)topic).isTopic()) {
            AQjmsError.throwInvalidDestEx(126);
        }
        if (this.getMessageListener() != null) {
            AQjmsError.throwEx(107, "createDurableSubscriber after MessageListener of Session is set");
        }
        try {
            aQjmsAgent = new AQjmsAgent();
            aQjmsAgent.setName(string4);
        }
        catch (SQLException sQLException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.createDurableSubscriber - error createing agent", sQLException);
            throw new AQjmsException(sQLException);
        }
        aQjmsSelector = this.getAQJmsSelector((AQjmsDestination)topic, string2, bl, object);
        topicSubscriber = !bl2 && this.getCompliant() ? this.createSubInCompliantMode(topic, string4, string2, aQjmsSelector, bl, object, string3, aQjmsAgent) : this.createSubInOldMode(topic, string4, aQjmsSelector, bl, object, string3, aQjmsAgent);
        this.cons_list.put(topicSubscriber, topicSubscriber);
        AQjmsConsumer aQjmsConsumer = (AQjmsConsumer)topicSubscriber;
        aQjmsConsumer.setDurable(!bl3);
        if (aQjmsConsumer.isDurable()) {
            String string5 = this.jms_conn.getClientIDForce();
            Map<String, Map<String, Map<String, Topic>>> map = s_subt;
            synchronized (map) {
                Map<String, Topic> map2;
                Map<String, Map<String, Topic>> map3 = s_subt.get(this.genConn.providerKey);
                if (map3 == null) {
                    map3 = new HashMap<String, Map<String, Topic>>();
                    s_subt.put(this.genConn.providerKey, map3);
                }
                if ((map2 = map3.get(string5)) == null) {
                    map2 = new HashMap<String, Topic>();
                    map3.put(string5, map2);
                }
                map2.put(string, topic);
            }
        }
        return topicSubscriber;
    }

    private AQjmsSelector getAQJmsSelector(AQjmsDestination aQjmsDestination, String string, boolean bl, Object object) throws JMSException {
        String string2 = null;
        AQjmsSelector aQjmsSelector = null;
        boolean bl2 = aQjmsDestination.isSharded();
        boolean bl3 = false;
        if (!bl2) {
            string2 = aQjmsDestination.getAdtType();
            bl3 = string2.equalsIgnoreCase("SYS.AQ$_JMS_MESSAGE") || string2.equalsIgnoreCase("SYS.AQ$_JMS_TEXT_MESSAGE") || string2.equalsIgnoreCase("SYS.AQ$_JMS_BYTES_MESSAGE") || string2.equalsIgnoreCase("SYS.AQ$_JMS_MAP_MESSAGE") || string2.equalsIgnoreCase("SYS.AQ$_JMS_OBJECT_MESSAGE") || string2.equalsIgnoreCase("SYS.AQ$_JMS_STREAM_MESSAGE");
        }
        String string3 = string;
        if (bl && (bl2 || bl3)) {
            string3 = string == null || string.trim().equals("") ? "JMS_OracleConnectionID <> '" + this.jms_conn.getConnectionID() + "'" : "(" + string + ") and (JMS_OracleConnectionID <> '" + this.jms_conn.getConnectionID() + "')";
            AQjmsOracleDebug.trace(5, "AQjmsSession.getAQJmsSelector", "The fixed selector for noLocal option is: " + string3);
        }
        if (string3 != null && !string3.equals("")) {
            if (bl2) {
                aQjmsSelector = new AQjmsSelector(string3, 20, 4, this.dbversion, aQjmsDestination);
            } else if (bl3) {
                aQjmsSelector = new AQjmsSelector(string3, 20, 1, this.dbversion, this.getCompliant());
            } else if (string2.equalsIgnoreCase("SYS.ANYDATA")) {
                aQjmsSelector = new AQjmsSelector(string3, 20, 3, this.dbversion, this.getCompliant());
            } else {
                if (object == null) {
                    AQjmsError.throwEx(137);
                }
                aQjmsSelector = new AQjmsSelector(string3, 20, 2, this.dbversion, this.getCompliant());
            }
        }
        return aQjmsSelector;
    }

    private TopicSubscriber createSubInCompliantMode(Topic topic, String string, String string2, AQjmsSelector aQjmsSelector, boolean bl, Object object, String string3, AQjmsAgent aQjmsAgent) throws JMSException {
        TopicSubscriber topicSubscriber = null;
        String string4 = this.jms_conn.getClientIDForce();
        AQjmsCliSubMapEntry aQjmsCliSubMapEntry = AQjmsClientSubscriberMap.createClientSubscriber(string4, string, topic, string2, bl, this.jms_conn.getConnectionID(), string3);
        if (aQjmsCliSubMapEntry == null) {
            AQjmsOracleDebug.trace(5, "AQjmsSession.createSubInCompliantMode", "The subscriber " + string + " is NOT in subscriber map.");
        } else {
            AQjmsOracleDebug.trace(5, "AQjmsSession.createSubInCompliantMode", "The subscriber " + string + " is in subscriber map.");
        }
        if (this.checkSubscriberExists(topic, aQjmsAgent)) {
            AQjmsOracleDebug.trace(5, "AQjmsSession.createSubInCompliantMode", "The subscriber " + string + " is in database.");
            if (aQjmsCliSubMapEntry == null) {
                AQjmsOracleDebug.trace(5, "AQjmsSession.createSubInCompliantMode", "The subscriber " + string + " is not in subscribers map in memory.");
                try {
                    topicSubscriber = this.alterDurableSubscriber(topic, aQjmsAgent, aQjmsSelector, bl, object, false, string3);
                    AQjmsOracleDebug.trace(5, "AQjmsSession.createSubInCompliantMode", "alterDurableSubscriber is called.");
                }
                catch (AQjmsException aQjmsException) {
                    AQjmsOracleDebug.trace(3, "AQjmsSession.createSubInCompliantMode - aq_ex", "error number: " + aQjmsException.getErrorNumber());
                    if (aQjmsException.getErrorNumber() == 1031 && ((AQjmsDestination)topic).isSecure()) {
                        AQjmsOracleDebug.trace(5, "AQjmsSession.createSubInCompliantMode", "secure queue - agent exists");
                        topicSubscriber = new AQjmsConsumer(this, (Destination)topic, 20, 3, string, object, aQjmsSelector, string3);
                    }
                    AQjmsClientSubscriberMap.removeClientSubscriber(string4, string);
                    throw aQjmsException;
                }
            } else {
                AQjmsOracleDebug.trace(5, "AQjmsSession.createSubInCompliantMode", "The subscriber " + string + " is in subscribers map in memory.");
                boolean bl2 = false;
                try {
                    bl2 = AQjmsUtil.topicEquals((AQjmsDestination)topic, (AQjmsDestination)aQjmsCliSubMapEntry.m_topic) && AQjmsUtil.selectorEquals(string2, aQjmsCliSubMapEntry.m_selector);
                }
                catch (JMSException jMSException) {
                    AQjmsClientSubscriberMap.recoverClientSubscriber(string4, string, aQjmsCliSubMapEntry);
                    throw jMSException;
                }
                if (bl2) {
                    AQjmsOracleDebug.trace(5, "AQjmsSession.createSubInCompliantMode", "the topic and selector are the same for old and new subscribers");
                    AQjmsOracleDebug.trace(5, "AQjmsSession.createSubInCompliantMode", "Always alter the subscriber.");
                    try {
                        topicSubscriber = this.alterDurableSubscriber(topic, aQjmsAgent, aQjmsSelector, bl, object, false, string3);
                    }
                    catch (AQjmsException aQjmsException) {
                        AQjmsOracleDebug.trace(3, "AQjmsSession.createSubInCompliantMode-2 - aq_ex", "error number: " + aQjmsException.getErrorNumber());
                        if (aQjmsException.getErrorNumber() == 1031 && ((AQjmsDestination)topic).isSecure()) {
                            AQjmsOracleDebug.trace(5, "AQjmsSession.createSubInCompliantMode", "secure queue - agent exists");
                            topicSubscriber = new AQjmsConsumer(this, (Destination)topic, 20, 3, string, object, aQjmsSelector, string3);
                        }
                        AQjmsClientSubscriberMap.recoverClientSubscriber(string4, string, aQjmsCliSubMapEntry);
                        throw aQjmsException;
                    }
                } else {
                    AQjmsOracleDebug.trace(5, "AQjmsSession.createSubInCompliantMode", "the topic and selector are different for old and new subscribers");
                    try {
                        this.removeSubscriber(aQjmsCliSubMapEntry.m_topic, aQjmsAgent);
                        topicSubscriber = this.addDurableSubscriber(topic, aQjmsAgent, aQjmsSelector, bl, object, false, string3, false);
                        AQjmsOracleDebug.trace(5, "AQjmsSession.createSubInCompliantMode", "The subscriber is removed and then recreated.");
                    }
                    catch (AQjmsException aQjmsException) {
                        AQjmsOracleDebug.trace(3, "AQjmsSession.createSubInCompliantMode - aq_ex", "error number: " + aQjmsException.getErrorNumber());
                        AQjmsClientSubscriberMap.removeClientSubscriber(string4, string);
                        throw aQjmsException;
                    }
                }
            }
        } else {
            AQjmsOracleDebug.trace(5, "AQjmsSession.createSubInCompliantMode", "The subscriber " + string + " is not in database.");
            try {
                if (aQjmsCliSubMapEntry != null && !AQjmsUtil.topicEquals((AQjmsDestination)topic, (AQjmsDestination)aQjmsCliSubMapEntry.m_topic)) {
                    AQjmsOracleDebug.trace(5, "AQjmsSession.createSubInCompliantMode", "Recreate the subscriber with same name but different topic.");
                    try {
                        this.removeSubscriber(aQjmsCliSubMapEntry.m_topic, aQjmsAgent);
                    }
                    catch (AQjmsException aQjmsException) {
                        if (aQjmsException.getErrorNumber() == 24035) {
                            AQjmsOracleDebug.trace(3, "AQjmsSession.createSubInCompliantMode - aq_jex", "error number: " + aQjmsException.getErrorNumber());
                        }
                        throw aQjmsException;
                    }
                    AQjmsOracleDebug.trace(5, "AQjmsSession.createSubInCompliantMode", "The subscriber is removed and then recreated.");
                }
                topicSubscriber = this.addDurableSubscriber(topic, aQjmsAgent, aQjmsSelector, bl, object, false, string3, false);
            }
            catch (AQjmsException aQjmsException) {
                AQjmsOracleDebug.trace(3, "AQjmsSession.createSubInCompliantMode - aq_ex", "error number: " + aQjmsException.getErrorNumber());
                AQjmsClientSubscriberMap.removeClientSubscriber(string4, string);
                throw aQjmsException;
            }
        }
        return topicSubscriber;
    }

    private TopicSubscriber createSubInOldMode(Topic topic, String string, AQjmsSelector aQjmsSelector, boolean bl, Object object, String string2, AQjmsAgent aQjmsAgent) throws JMSException {
        TopicSubscriber topicSubscriber = null;
        try {
            topicSubscriber = this.addDurableSubscriber(topic, aQjmsAgent, aQjmsSelector, bl, object, false, string2, false);
        }
        catch (AQjmsException aQjmsException) {
            AQjmsOracleDebug.trace(3, "AQjmsSession.createSubInOldMode - aq_ex", "error number: " + aQjmsException.getErrorNumber());
            if (aQjmsException.getErrorNumber() == 1031 && ((AQjmsDestination)topic).isSecure()) {
                AQjmsOracleDebug.trace(5, "AQjmsSession.createSubInOldMode", "secure queue - check if agent exists");
                if (this.checkSubscriberExists(topic, aQjmsAgent)) {
                    topicSubscriber = new AQjmsConsumer(this, (Destination)topic, 20, 3, string, object, aQjmsSelector, string2);
                }
                throw aQjmsException;
            }
            if (aQjmsException.getErrorNumber() == 24034) {
                topicSubscriber = this.alterDurableSubscriber(topic, aQjmsAgent, aQjmsSelector, bl, object, false, string2);
            }
            throw aQjmsException;
        }
        return topicSubscriber;
    }

    public TopicSubscriber forceCreateOldSubscriber(Topic topic, String string) throws JMSException {
        return this.createDurableSubscriber(topic, string, null, false, null, null, true, false);
    }

    public TopicSubscriber forceCreateOldSubscriber(Topic topic, String string, Object object) throws JMSException {
        return this.createDurableSubscriber(topic, string, null, false, object, null, true, false);
    }

    public TopicSubscriber forceCreateOldSubscriber(Topic topic, String string, String string2, Object object) throws JMSException {
        return this.createDurableSubscriber(topic, string, string2, false, object, null, true, false);
    }

    public TopicSubscriber forceCreateOldSubscriber(Topic topic, String string, String string2, boolean bl) throws JMSException {
        return this.createDurableSubscriber(topic, string, string2, bl, null, null, true, false);
    }

    public TopicSubscriber forceCreateOldSubscriber(Topic topic, String string, String string2, boolean bl, Object object, String string3) throws JMSException {
        return this.createDurableSubscriber(topic, string, string2, bl, object, string3, true, false);
    }

    public TopicSubscriber getDurableSubscriber(Topic topic, String string) throws JMSException, InvalidDestinationException {
        return this.getDurableSubscriber(topic, string, null);
    }

    public synchronized TopicSubscriber getDurableSubscriber(Topic topic, String string, Object object) throws JMSException, InvalidDestinationException {
        AQjmsOracleDebug.trace(5, "AQjmsSession.getDurableSubscriber", "entry");
        AQjmsConsumer aQjmsConsumer = null;
        this.checkSessionStarted();
        if (string == null) {
            AQjmsError.throwEx(116);
        }
        if (topic == null) {
            throw new InvalidDestinationException(AQjmsError.getMessage(166));
        }
        if (!(topic instanceof AQjmsDestination) || !((AQjmsDestination)topic).isTopic()) {
            AQjmsError.throwInvalidDestEx(126);
        }
        if (this.getMessageListener() != null) {
            AQjmsError.throwEx(107, "getDurableSubscriber after MessageListener of Session is set");
        }
        string = AQjmsSession.chopit(string, this.getMaxSubscriberNameLen());
        AQjmsAgent aQjmsAgent = null;
        try {
            aQjmsAgent = new AQjmsAgent();
            aQjmsAgent.setName(string);
        }
        catch (SQLException sQLException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.getDurableSubscriber - error createing agent", sQLException);
            throw new AQjmsException(sQLException);
        }
        if (!this.checkSubscriberExists(topic, aQjmsAgent)) {
            AQjmsOracleDebug.trace(3, "AQjmsSession.getDurableSubscriber", "subscriber is not in database, return null!!!");
            return null;
        }
        AQjmsOracleDebug.trace(3, "AQjmsSession.getDurableSubscriber", "found the subscriber in the database");
        String string2 = this.jms_conn.getClientIDForce();
        AQjmsCliSubMapEntry aQjmsCliSubMapEntry = AQjmsClientSubscriberMap.addClientSubscriber(string2, string, topic);
        if (aQjmsCliSubMapEntry != null) {
            AQjmsOracleDebug.trace(3, "AQjmsSession.getDurableSubscriber", "found the subscriber in the map");
            AQjmsSelector aQjmsSelector = this.getAQJmsSelector((AQjmsDestination)topic, aQjmsCliSubMapEntry.m_selector, aQjmsCliSubMapEntry.m_noLocal, object);
            aQjmsConsumer = new AQjmsConsumer(this, (Destination)topic, 20, 3, string, object, aQjmsSelector, aQjmsCliSubMapEntry.m_transformation, aQjmsCliSubMapEntry.m_noLocal, true);
        } else {
            AQjmsOracleDebug.trace(3, "AQjmsSession.getDurableSubscriber", "Did not found the subscriber in the map");
            aQjmsConsumer = new AQjmsConsumer(this, (Destination)topic, 20, 3, string, object, null, null, false, false);
        }
        this.cons_list.put(aQjmsConsumer, aQjmsConsumer);
        AQjmsOracleDebug.trace(5, "AQjmsSession.getDurableSubscriber", "exit");
        return aQjmsConsumer;
    }

    public synchronized void createRemoteSubscriber(Topic topic, AQjmsAgent aQjmsAgent, String string) throws JMSException {
        this.createRemoteSubscriber(topic, aQjmsAgent, string, null, null, false);
    }

    public synchronized void createRemoteSubscriber(Topic topic, AQjmsAgent aQjmsAgent, String string, Object object) throws JMSException {
        this.createRemoteSubscriber(topic, aQjmsAgent, string, object, null, false);
    }

    public synchronized void createRemoteSubscriber(Topic topic, AQjmsAgent aQjmsAgent, String string, Object object, String string2) throws JMSException {
        this.createRemoteSubscriber(topic, aQjmsAgent, string, object, string2, false);
    }

    public synchronized void createRemoteSubscriber(Topic topic, AQjmsAgent aQjmsAgent, String string, Object object, String string2, boolean bl) throws JMSException {
        AQjmsSelector aQjmsSelector = null;
        Connection connection = null;
        String string3 = null;
        String string4 = null;
        connection = this.getDBConnection();
        if (aQjmsAgent == null) {
            AQjmsError.throwEx(105);
        }
        try {
            string4 = aQjmsAgent.getAddress();
        }
        catch (SQLException sQLException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.createRemoteSubscriber1 - get address of remote subscriber", sQLException);
            throw new AQjmsException(sQLException);
        }
        if (string4 == null || string4.equals("")) {
            AQjmsError.throwEx(197);
        }
        if (topic == null) {
            AQjmsError.throwEx(166);
        }
        if (!(topic instanceof AQjmsDestination) || !((AQjmsDestination)topic).isTopic()) {
            AQjmsError.throwInvalidDestEx(126);
        }
        if (string != null && !string.equals("")) {
            string3 = ((AQjmsDestination)topic).getAdtType();
            AQjmsDestination aQjmsDestination = (AQjmsDestination)topic;
            if (aQjmsDestination.isSharded()) {
                aQjmsSelector = new AQjmsSelector(string, 20, 4, this.dbversion, aQjmsDestination);
            } else if (string3.equalsIgnoreCase("SYS.AQ$_JMS_MESSAGE") || string3.equalsIgnoreCase("SYS.AQ$_JMS_TEXT_MESSAGE") || string3.equalsIgnoreCase("SYS.AQ$_JMS_BYTES_MESSAGE") || string3.equalsIgnoreCase("SYS.AQ$_JMS_MAP_MESSAGE") || string3.equalsIgnoreCase("SYS.AQ$_JMS_OBJECT_MESSAGE") || string3.equalsIgnoreCase("SYS.AQ$_JMS_STREAM_MESSAGE")) {
                aQjmsSelector = new AQjmsSelector(string, 20, 1, this.dbversion, this.getCompliant());
            } else if (string3.equalsIgnoreCase("SYS.ANYDATA")) {
                aQjmsSelector = new AQjmsSelector(string, 20, 3, this.dbversion, this.getCompliant());
            } else {
                if (object == null) {
                    AQjmsError.throwEx(137);
                }
                aQjmsSelector = new AQjmsSelector(string, 20, 2, this.dbversion, this.getCompliant());
            }
        }
        try {
            this.addDurableSubscriber(topic, aQjmsAgent, aQjmsSelector, false, null, true, string2, bl);
        }
        catch (AQjmsException aQjmsException) {
            AQjmsOracleDebug.trace(3, "AQjmsSession.createRemoteSubscriber - aq_ex", "error number: " + aQjmsException.getErrorNumber());
            if (aQjmsException.getErrorNumber() == 24034) {
                this.alterDurableSubscriber(topic, aQjmsAgent, aQjmsSelector, false, null, true, string2);
            }
            throw aQjmsException;
        }
    }

    synchronized void removeRemoteSubscriber(Topic topic, AQjmsAgent aQjmsAgent) throws JMSException {
        String string = null;
        Connection connection = null;
        connection = this.getDBConnection();
        if (aQjmsAgent == null) {
            AQjmsError.throwEx(105);
        }
        try {
            string = aQjmsAgent.getAddress();
        }
        catch (SQLException sQLException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.removeRemoteSubscriber2 - get address of remote subscriber", sQLException);
            throw new AQjmsException(sQLException);
        }
        if (string == null || string.equals("")) {
            AQjmsError.throwEx(197);
        }
        if (topic == null) {
            AQjmsError.throwEx(166);
        }
        if (!(topic instanceof AQjmsDestination) || !((AQjmsDestination)topic).isTopic()) {
            AQjmsError.throwInvalidDestEx(126);
        }
        this.removeSubscriber(topic, aQjmsAgent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean checkSubscriberExists(Topic topic, AQjmsAgent aQjmsAgent) {
        String string = "";
        String string2 = "";
        AQOracleAgent aQOracleAgent = null;
        Map<String, Class<?>> map = null;
        String string3 = null;
        int n = 0;
        Connection connection = null;
        int n2 = 0;
        AQjmsOracleDebug.trace(5, "AQjmsSession.checkSubscriberExists", "entry");
        try {
            if (aQjmsAgent == null) {
                AQjmsError.throwEx(105);
            }
            connection = this.getDBConnection();
            string2 = aQjmsAgent.getName();
            string3 = aQjmsAgent.getAddress();
            n = aQjmsAgent.getProtocol();
            string = ((AQjmsDestination)topic).getCompleteName();
            try {
                map = connection.getTypeMap();
            }
            catch (Exception exception) {
                AQjmsError.throwEx(112, (Throwable)exception);
            }
            try {
                map.put("SYS.AQ$_AGENT", Class.forName("oracle.AQ.AQOracleAgent"));
            }
            catch (Exception exception) {
                AQjmsError.throwEx(146, (Throwable)exception);
            }
            aQOracleAgent = new AQOracleAgent(string2, string3, n);
            AQjmsOracleDebug.trace(5, "AQjmsSession.checkSubscriberExists", "subs_name: " + string2 + " subs_addr: " + string3 + " subs_prot: " + n);
            if (this.chks_stmt != null) {
                this.chks_stmt.clearParameters();
            } else {
                AQjmsOracleDebug.trace(5, "AQjmsSession.checkSubscriberExists", "before subs_exists t_name: " + string);
                String string4 = AQjmsInterOp.getCheckStmtByVersion(this.dbversion);
                AQjmsOracleDebug.trace(5, "AQjmsSession.checkSubscriberExists", "subscriber_exists statement: " + string4);
                this.chks_stmt = connection.prepareCall(string4);
            }
            this.chks_stmt.setString(1, string);
            this.chks_stmt.setObject(2, (Object)aQOracleAgent, 2002);
            this.chks_stmt.setObject(3, (Object)1);
            this.chks_stmt.registerOutParameter(4, 2);
            this.chks_stmt.registerOutParameter(5, 12);
            this.chks_stmt.registerOutParameter(6, 12);
            this.chks_stmt.registerOutParameter(7, 12);
            if (this.is10compatible()) {
                this.chks_stmt.registerOutParameter(8, 12);
                this.chks_stmt.registerOutParameter(9, 2);
                this.chks_stmt.execute();
                n2 = this.chks_stmt.getInt(9);
            } else {
                this.chks_stmt.registerOutParameter(8, 2);
                this.chks_stmt.execute();
                n2 = this.chks_stmt.getInt(8);
            }
        }
        catch (SQLException sQLException) {
            try {
                this.chks_stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.chks_stmt = null;
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.checkSubscriberExists-sqlex", sQLException);
            n2 = 0;
        }
        catch (Exception exception) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.checkSubscriberExists-ex", exception);
            n2 = 0;
        }
        finally {
            AQjmsOracleDebug.trace(3, "AQjmsSession.checkSubscriberExists", "always close the check stmt");
            if (this.chks_stmt != null) {
                try {
                    this.chks_stmt.close();
                }
                catch (Exception exception) {}
                this.chks_stmt = null;
            }
        }
        AQjmsOracleDebug.trace(5, "AQjmsSession.checkSubscriberExists", "exit s_exists=" + n2);
        return n2 == 1;
    }

    public synchronized AQjmsTopicReceiver createTopicReceiver(Topic topic, String string, String string2) throws JMSException {
        return this.createTopicReceiver(topic, string, string2, null);
    }

    public synchronized AQjmsTopicReceiver createTopicReceiver(Topic topic, String string, String string2, Object object) throws JMSException {
        AQjmsConsumer aQjmsConsumer = null;
        AQjmsSelector aQjmsSelector = null;
        String string3 = null;
        this.checkSessionStarted();
        if (topic == null) {
            AQjmsError.throwEx(166);
        }
        if (!(topic instanceof AQjmsDestination) || !((AQjmsDestination)topic).isTopic()) {
            AQjmsError.throwInvalidDestEx(126);
        }
        if (this.getMessageListener() != null) {
            AQjmsError.throwEx(107, "createTopicReceiver after MessageListener is set");
        }
        if (string2 != null && !string2.equals("")) {
            AQjmsDestination aQjmsDestination = (AQjmsDestination)topic;
            aQjmsSelector = aQjmsDestination.isSharded() ? new AQjmsSelector(string2, 20, 4, this.dbversion, aQjmsDestination) : (object != null ? new AQjmsSelector(string2, 10, 2, this.dbversion, this.getCompliant()) : ((string3 = ((AQjmsDestination)topic).getAdtType()).equalsIgnoreCase("SYS.ANYDATA") ? new AQjmsSelector(string2, 10, 3, this.dbversion, this.getCompliant()) : new AQjmsSelector(string2, 10, 1, this.dbversion, this.getCompliant())));
        }
        aQjmsConsumer = new AQjmsConsumer(this, (Destination)topic, 20, 3, string, object, aQjmsSelector, null);
        this.cons_list.put(aQjmsConsumer, aQjmsConsumer);
        return aQjmsConsumer;
    }

    private synchronized TopicSubscriber addDurableSubscriber(Topic topic, AQjmsAgent aQjmsAgent, AQjmsSelector aQjmsSelector, boolean bl, Object object, boolean bl2, String string, boolean bl3) throws JMSException {
        String string2 = "";
        String string3 = "";
        AQOracleAgent aQOracleAgent = null;
        Map<String, Class<?>> map = null;
        String string4 = null;
        int n = 0;
        String string5 = null;
        AQjmsConsumer aQjmsConsumer = null;
        Connection connection = null;
        connection = this.getDBConnection();
        if (topic == null) {
            AQjmsError.throwInvalidDestEx(166);
        }
        if (!(topic instanceof AQjmsDestination) || !((AQjmsDestination)topic).isTopic()) {
            AQjmsError.throwInvalidDestEx(126);
        }
        if (aQjmsAgent == null) {
            AQjmsError.throwEx(105);
        }
        Statement statement = null;
        try {
            string3 = aQjmsAgent.getName();
            string4 = aQjmsAgent.getAddress();
            n = aQjmsAgent.getProtocol();
            string2 = ((AQjmsDestination)topic).getCompleteName();
            try {
                map = connection.getTypeMap();
            }
            catch (Exception exception) {
                AQjmsError.throwEx(112, (Throwable)exception);
            }
            try {
                map.put("SYS.AQ$_AGENT", Class.forName("oracle.AQ.AQOracleAgent"));
            }
            catch (Exception exception) {
                AQjmsError.throwEx(146, (Throwable)exception);
            }
            aQOracleAgent = new AQOracleAgent(string3, string4, n);
            if (aQjmsSelector != null) {
                if (aQjmsSelector.getSelectorType() == 10) {
                    string5 = aQjmsSelector.getRule();
                    AQjmsOracleDebug.trace(5, "AQjmsSession.addDurableSubscriber", "Rule: " + string5);
                } else if (aQjmsSelector.getSelectorType() == 40) {
                    string5 = aQjmsSelector.getAdtRule();
                }
            }
            String string6 = AQjmsInterOp.getAddSubStmtByVersion(this.dbversion, bl3);
            AQjmsOracleDebug.trace(5, "AQjmsSession.addDurableSubscriber", "add_subscriber statement:" + string6);
            statement = connection.prepareCall(string6);
            statement.setString(1, string2);
            statement.setObject(2, aQOracleAgent, 2002);
            statement.setString(3, string5);
            if (this.is82compatible()) {
                statement.setString(4, string);
                if (this.is92compatible()) {
                    if (((AQjmsDestination)topic).isSecure()) {
                        statement.setInt(5, 1);
                    } else {
                        statement.setInt(5, 0);
                    }
                }
            }
            statement.execute();
        }
        catch (SQLException sQLException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.addDurableSubscriber", sQLException);
            throw new AQjmsException(sQLException);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
        }
        if (!bl2) {
            aQjmsConsumer = new AQjmsConsumer(this, (Destination)topic, 20, 3, string3, object, aQjmsSelector, string, bl);
            this.cons_list.put(aQjmsConsumer, aQjmsConsumer);
            return aQjmsConsumer;
        }
        return null;
    }

    private synchronized TopicSubscriber addAQNondurableSubscriber(Topic topic, String string, boolean bl, Object object, String string2) throws JMSException {
        Connection connection = this.getDBConnection();
        if (this.sess_type == 10) {
            AQjmsError.throwIllegalStateEx(234, null);
        }
        if (topic == null) {
            throw new InvalidDestinationException(AQjmsError.getMessage(166));
        }
        if (!(topic instanceof AQjmsDestination) || !((AQjmsDestination)topic).isTopic()) {
            AQjmsError.throwInvalidDestEx(126);
        }
        if (this.getMessageListener() != null) {
            AQjmsError.throwEx(107, "create subscriber after MessageListener of Session is set");
        }
        AQjmsSelector aQjmsSelector = this.getAQJmsSelector((AQjmsDestination)topic, string, bl, object);
        String string3 = AQjmsInterOp.getAddAQNondurableSubStmtByVersion(this.dbversion);
        AQjmsOracleDebug.trace(5, "AQjmsSession.addAQNondurableSubscriber", "add nondurable subscriber statement: " + string3);
        String string4 = ((AQjmsDestination)topic).getCompleteName();
        String string5 = null;
        if (aQjmsSelector != null) {
            if (aQjmsSelector.getSelectorType() == 10) {
                string5 = aQjmsSelector.getRule();
            } else if (aQjmsSelector.getSelectorType() == 40) {
                string5 = aQjmsSelector.getAdtRule();
            }
        }
        CallableStatement callableStatement = null;
        String string6 = null;
        try {
            callableStatement = connection.prepareCall(string3);
            callableStatement.setString(1, string4);
            callableStatement.setString(2, string5);
            callableStatement.setString(3, string2);
            if (this.clientSessionGUID == null) {
                callableStatement.setString(4, null);
                callableStatement.registerOutParameter(4, 12);
            } else {
                callableStatement.setString(4, this.clientSessionGUID);
            }
            callableStatement.registerOutParameter(5, 12);
            callableStatement.execute();
            string6 = callableStatement.getString(5);
            AQjmsOracleDebug.trace(5, "AQjmsSession.addAQNondurableSubscriber", "subscriber name: " + string6);
            if (this.clientSessionGUID == null) {
                this.clientSessionGUID = callableStatement.getString(4);
                AQjmsOracleDebug.trace(5, "AQjmsSession.addAQNondurableSubscriber", "session GUID: " + this.clientSessionGUID);
            }
        }
        catch (SQLException sQLException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.addAQNondurableSubscriber", sQLException);
            throw new AQjmsException(sQLException);
        }
        finally {
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (Exception exception) {}
        }
        AQjmsConsumer aQjmsConsumer = new AQjmsConsumer(this, (Destination)topic, 20, 3, string6, object, aQjmsSelector, string2, bl);
        aQjmsConsumer.setDurable(false);
        this.cons_list.put(aQjmsConsumer, aQjmsConsumer);
        return aQjmsConsumer;
    }

    private TopicSubscriber addAQNondurableSubscriberSQ(Topic topic, String string, boolean bl, Object object, String string2) throws JMSException {
        Connection connection = this.getDBConnection();
        if (this.sess_type == 10) {
            AQjmsError.throwIllegalStateEx(234, null);
        }
        if (topic == null) {
            throw new InvalidDestinationException(AQjmsError.getMessage(166));
        }
        if (!(topic instanceof AQjmsDestination) || !((AQjmsDestination)topic).isTopic()) {
            AQjmsError.throwInvalidDestEx(126);
        }
        if (this.getMessageListener() != null) {
            AQjmsError.throwEx(107, "create subscriber after MessageListener of Session is set");
        }
        AQjmsSelector aQjmsSelector = this.getAQJmsSelector((AQjmsDestination)topic, string, bl, object);
        String string3 = AQjmsInterOp.getAddAQNondurableSubSQStmtByVersion(this.dbversion);
        AQjmsOracleDebug.trace(5, "AQjmsSession.addAQNondurableSubscriberSQ", "add nondurable subscribe sql statement: " + string3);
        String string4 = ((AQjmsDestination)topic).getCompleteName();
        String string5 = null;
        if (aQjmsSelector != null) {
            if (aQjmsSelector.getSelectorType() == 10) {
                string5 = aQjmsSelector.getRule();
            } else if (aQjmsSelector.getSelectorType() == 40) {
                string5 = aQjmsSelector.getAdtRule();
            }
        }
        CallableStatement callableStatement = null;
        String string6 = null;
        try {
            callableStatement = connection.prepareCall(string3);
            callableStatement.setString(1, string4);
            callableStatement.setString(2, string5);
            callableStatement.setString(3, string2);
            callableStatement.registerOutParameter(4, 12);
            callableStatement.execute();
            string6 = callableStatement.getString(4);
            AQjmsOracleDebug.trace(5, "AQjmsSession.addAQNondurableSubscriberSQ", "nondurable subscriber is added: topic=" + string4 + ", subscriber name=" + string6);
        }
        catch (SQLException sQLException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.addAQNondurableSubscriberSQ", sQLException);
            throw new AQjmsException(sQLException);
        }
        finally {
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (Exception exception) {}
        }
        AQjmsConsumer aQjmsConsumer = new AQjmsConsumer(this, (Destination)topic, 20, 3, string6, object, aQjmsSelector, string2, bl);
        aQjmsConsumer.setDurable(false);
        this.cons_list.put(aQjmsConsumer, aQjmsConsumer);
        return aQjmsConsumer;
    }

    private void removeAQNondurableSubscriberSQ(AQjmsDestination aQjmsDestination, String string) throws JMSException {
        Connection connection = this.getOurDBConnection();
        if (!aQjmsDestination.isTopic()) {
            AQjmsError.throwInvalidDestEx(126);
        }
        String string2 = AQjmsInterOp.getRemoveAQNondurableSubSQStmtByVersion(this.dbversion);
        String string3 = aQjmsDestination.getCompleteName();
        CallableStatement callableStatement = null;
        try {
            callableStatement = connection.prepareCall(string2);
            callableStatement.setString(1, string3);
            callableStatement.setString(2, string);
            callableStatement.execute();
            AQjmsOracleDebug.trace(5, "AQjmsSession.removeAQNondurableSubscriberSQ", "nondurable subscriber is removed: topic=" + string3 + ", subscriber name=" + string);
        }
        catch (SQLException sQLException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.removeAQNondurableSubscriberSQ", sQLException);
            throw new AQjmsException(sQLException);
        }
        finally {
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private void removeAQNondurableSubscribers(String string) throws JMSException {
        Connection connection = this.getOurDBConnection();
        String string2 = AQjmsInterOp.getRemoveAQNondurableSubsStmtByVersion(this.dbversion);
        AQjmsOracleDebug.trace(5, "AQjmsSession.removeAQNondurableSubscribers", "remove nondurable subscribers by session GUID statement: " + string2);
        CallableStatement callableStatement = null;
        try {
            callableStatement = connection.prepareCall(string2);
            AQjmsOracleDebug.trace(5, "AQjmsSession.removeAQNondurableSubscribers", "session GUID : " + string);
            callableStatement.setString(1, string);
            callableStatement.execute();
        }
        catch (SQLException sQLException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.removeAQNondurableSubscribers", sQLException);
            throw new AQjmsException(sQLException);
        }
        finally {
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private synchronized TopicSubscriber alterDurableSubscriber(Topic topic, AQjmsAgent aQjmsAgent, AQjmsSelector aQjmsSelector, boolean bl, Object object, boolean bl2, String string) throws JMSException {
        String string2 = "";
        String string3 = "";
        AQOracleAgent aQOracleAgent = null;
        Map<String, Class<?>> map = null;
        String string4 = null;
        int n = 0;
        String string5 = null;
        AQjmsConsumer aQjmsConsumer = null;
        Connection connection = null;
        connection = this.getDBConnection();
        if (topic == null) {
            AQjmsError.throwInvalidDestEx(166);
        }
        if (!(topic instanceof AQjmsDestination) || !((AQjmsDestination)topic).isTopic()) {
            AQjmsError.throwInvalidDestEx(126);
        }
        if (aQjmsAgent == null) {
            AQjmsError.throwEx(105);
        }
        try {
            string3 = aQjmsAgent.getName();
            string4 = aQjmsAgent.getAddress();
            n = aQjmsAgent.getProtocol();
            string2 = ((AQjmsDestination)topic).getCompleteName();
            try {
                map = connection.getTypeMap();
            }
            catch (Exception exception) {
                AQjmsError.throwEx(112, (Throwable)exception);
            }
            try {
                map.put("SYS.AQ$_AGENT", Class.forName("oracle.AQ.AQOracleAgent"));
            }
            catch (Exception exception) {
                AQjmsError.throwEx(146);
            }
            aQOracleAgent = new AQOracleAgent(string3, string4, n);
            if (aQjmsSelector != null) {
                if (aQjmsSelector.getSelectorType() == 10) {
                    string5 = aQjmsSelector.getRule();
                    AQjmsOracleDebug.trace(5, "AQjmsSession.alterDurableSubscriber", "Rule: " + string5);
                } else if (aQjmsSelector.getSelectorType() == 40) {
                    string5 = aQjmsSelector.getAdtRule();
                    AQjmsOracleDebug.trace(5, "AQjmsSession.alterDurableSubscriber", "Alter Rule: " + string5);
                }
            }
            if (this.alts_stmt != null) {
                this.alts_stmt.clearParameters();
            } else {
                String string6 = AQjmsInterOp.getAlterSubStmtByVersion(this.dbversion);
                AQjmsOracleDebug.trace(5, "AQjmsSession.alterDurableSubscriber", "alter_subscriber statement : " + string6);
                this.alts_stmt = connection.prepareCall(string6);
            }
            this.alts_stmt.setString(1, string2);
            this.alts_stmt.setObject(2, (Object)aQOracleAgent, 2002);
            this.alts_stmt.setString(3, string5);
            if (this.is82compatible()) {
                this.alts_stmt.setString(4, string);
                if (this.is92compatible()) {
                    if (((AQjmsDestination)topic).isSecure()) {
                        this.alts_stmt.setInt(5, 1);
                    } else {
                        this.alts_stmt.setInt(5, 0);
                    }
                }
            }
            this.alts_stmt.execute();
            AQjmsOracleDebug.trace(5, "AQjmsSession.alterDurableSubscriber", "Alter Subscriber");
        }
        catch (SQLException sQLException) {
            try {
                this.alts_stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.alts_stmt = null;
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.alterDurableSubscriber", sQLException);
            throw new AQjmsException(sQLException);
        }
        if (!bl2) {
            aQjmsConsumer = new AQjmsConsumer(this, (Destination)topic, 20, 3, string3, object, aQjmsSelector, string, bl);
            this.cons_list.put(aQjmsConsumer, aQjmsConsumer);
            return aQjmsConsumer;
        }
        return null;
    }

    boolean diffSubName(String string) {
        if (this.prevSubName == null || !this.prevSubName.equalsIgnoreCase(string)) {
            this.prevSubName = string;
            return true;
        }
        return false;
    }

    public synchronized TopicPublisher createPublisher(Topic topic) throws JMSException {
        AQjmsTopicPublisherImpl aQjmsTopicPublisherImpl = null;
        this.checkSessionStarted();
        if (!(topic == null || topic instanceof AQjmsDestination && ((AQjmsDestination)topic).isTopic())) {
            AQjmsError.throwInvalidDestEx(126);
        }
        aQjmsTopicPublisherImpl = new AQjmsTopicPublisherImpl(this, (AQjmsDestination)topic);
        return aQjmsTopicPublisherImpl;
    }

    public synchronized TemporaryTopic createTemporaryTopic() throws JMSException {
        this.checkSessionStarted();
        if (this.sess_type == 10) {
            AQjmsError.throwIllegalStateEx(234, null);
        }
        return this.makeTemporaryQueue(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unsubscribe(String string) throws JMSException {
        this.checkSessionStarted();
        if (this.sess_type == 10) {
            AQjmsError.throwIllegalStateEx(234, null);
        }
        if (string == null) {
            throw new InvalidDestinationException(AQjmsError.getMessage(235));
        }
        String string2 = this.jms_conn.getClientIDForce();
        Map<String, Map<String, Map<String, Topic>>> map = s_subt;
        synchronized (map) {
            Map<String, Map<String, Topic>> map2 = s_subt.get(this.genConn.providerKey);
            if (map2 == null) {
                throw new InvalidDestinationException(AQjmsError.getMessage(235));
            }
            Map<String, Topic> map3 = map2.get(string2);
            if (map3 == null) {
                throw new InvalidDestinationException(AQjmsError.getMessage(235));
            }
            Topic topic = map3.get(string);
            if (topic == null) {
                throw new InvalidDestinationException(AQjmsError.getMessage(235));
            }
            this.unsubscribe(topic, string);
            map3.remove(string);
            if (map3.isEmpty()) {
                map2.remove(string2);
            }
            if (map2.isEmpty()) {
                s_subt.remove(this.genConn.providerKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unsubscribe(Topic topic, String string) throws JMSException {
        AQjmsAgent aQjmsAgent = null;
        Connection connection = null;
        AQjmsOracleDebug.trace(3, "AQjmsSession.unsubscribe", "entry");
        this.checkSessionStarted();
        connection = this.getDBConnection();
        if (string == null) {
            AQjmsError.throwEx(116);
        }
        if (topic == null) {
            AQjmsError.throwEx(166);
        }
        string = AQjmsSession.chopit(string, this.getMaxSubscriberNameLen());
        if (!(topic instanceof AQjmsDestination) || !((AQjmsDestination)topic).isTopic()) {
            AQjmsError.throwInvalidDestEx(126);
        }
        AQjmsOracleDebug.trace(3, "AQjmsSession.unsubscribe", "subs name:" + string + ", topic name:" + ((AQjmsDestination)topic).getTopicName());
        if (this.getCompliant()) {
            Object object;
            AQjmsOracleDebug.trace(3, "AQjmsSession.unsubscribe", "unsubscribe in compliant mode, consult in memeory map before remove AQ subscriber.");
            Object object2 = object = AQjmsClientSubscriberMap.getMapLock();
            synchronized (object2) {
                AQjmsClientSubscriberMap.unsubscribeClientSubscriber(this.jms_conn.getClientIDForce(), string);
                try {
                    aQjmsAgent = new AQjmsAgent();
                    aQjmsAgent.setName(string);
                    this.removeSubscriber(topic, aQjmsAgent);
                }
                catch (SQLException sQLException) {
                    throw new AQjmsException(sQLException);
                }
            }
        }
        AQjmsOracleDebug.trace(3, "AQjmsSession.unsubscribe", "unsubscribe in old mode, just remove the AQ subscriber.");
        try {
            aQjmsAgent = new AQjmsAgent();
            aQjmsAgent.setName(string);
            this.removeSubscriber(topic, aQjmsAgent);
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
        AQjmsOracleDebug.trace(3, "AQjmsSession.unsubscribe", "exit");
    }

    public synchronized void unsubscribe(Topic topic, AQjmsAgent aQjmsAgent) throws JMSException {
        this.checkSessionStarted();
        this.removeRemoteSubscriber(topic, aQjmsAgent);
    }

    private synchronized void removeSubscriber(Topic topic, AQjmsAgent aQjmsAgent) throws JMSException {
        String string = "";
        String string2 = "";
        AQOracleAgent aQOracleAgent = null;
        Map<String, Class<?>> map = null;
        String string3 = null;
        int n = 0;
        Connection connection = null;
        AQjmsOracleDebug.trace(3, "AQjmsSession.removeSubscriber", "enter");
        connection = this.getDBConnection();
        if (topic == null) {
            AQjmsError.throwInvalidDestEx(166);
        }
        if (!(topic instanceof AQjmsDestination) || !((AQjmsDestination)topic).isTopic()) {
            AQjmsError.throwInvalidDestEx(126);
        }
        if (aQjmsAgent == null) {
            AQjmsError.throwEx(105);
        }
        try {
            Object object;
            string = ((AQjmsDestination)topic).getCompleteName();
            string2 = aQjmsAgent.getName();
            string3 = aQjmsAgent.getAddress();
            n = aQjmsAgent.getProtocol();
            try {
                map = connection.getTypeMap();
            }
            catch (Exception exception) {
                AQjmsError.throwEx(112, (Throwable)exception);
            }
            try {
                map.put("SYS.AQ$_AGENT", Class.forName("oracle.AQ.AQOracleAgent"));
            }
            catch (Exception exception) {
                AQjmsError.throwEx(146);
            }
            aQOracleAgent = new AQOracleAgent(string2, string3, n);
            if (this.rems_stmt != null) {
                this.rems_stmt.clearParameters();
            } else {
                object = AQjmsInterOp.getRemoveSubStmtByVersion(this.dbversion);
                AQjmsOracleDebug.trace(5, "AQjmsSession.removeSubscriber", "remove_subscriber statement: " + (String)object);
                this.rems_stmt = connection.prepareCall((String)object);
            }
            this.rems_stmt.setString(1, string);
            this.rems_stmt.setObject(2, (Object)aQOracleAgent, 2002);
            if (this.is92compatible()) {
                if (((AQjmsDestination)topic).isSecure()) {
                    this.rems_stmt.setInt(3, 1);
                } else {
                    this.rems_stmt.setInt(3, 0);
                }
            }
            this.rems_stmt.execute();
            try {
                object = this.cons_list.elements();
                while (object.hasMoreElements()) {
                    AQjmsConsumer aQjmsConsumer = (AQjmsConsumer)object.nextElement();
                    if (aQjmsConsumer.cons_name == null || !aQjmsConsumer.cons_name.equals(string2) || !aQjmsConsumer.cons_dest.getCompleteName().equals(string)) continue;
                    aQjmsConsumer.disableConsumerExceptionListener();
                }
            }
            catch (Exception exception) {
                AQjmsOracleDebug.traceEx(3, "AQjmsSession.removeSubscriber", exception);
            }
        }
        catch (SQLException sQLException) {
            try {
                this.rems_stmt.close();
                this.rems_stmt = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.removeSubscriber", sQLException);
            throw new AQjmsException(sQLException);
        }
        AQjmsOracleDebug.trace(3, "AQjmsSession.removeSubscriber", "exit");
    }

    synchronized Map<String, JMSNotificationRegistration> registerJMSNotification(String[] stringArray, Map<String, Properties> map, String string) throws SQLException, JMSException {
        OracleConnection oracleConnection = (OracleConnection)this.getDBConnection();
        return oracleConnection.registerJMSNotification(stringArray, map, string);
    }

    synchronized void unregisterJMSNotification(JMSNotificationRegistration jMSNotificationRegistration) throws JMSException, SQLException {
        OracleConnection oracleConnection = (OracleConnection)this.getDBConnection();
        oracleConnection.unregisterJMSNotification(jMSNotificationRegistration);
    }

    synchronized void startJMSNotification(JMSNotificationRegistration jMSNotificationRegistration) throws JMSException, SQLException {
        OracleConnection oracleConnection = (OracleConnection)this.getDBConnection();
        oracleConnection.startJMSNotification(jMSNotificationRegistration);
    }

    synchronized void ackJMSNotification(JMSNotificationRegistration jMSNotificationRegistration, byte[] byArray, JMSNotificationRegistration.Directive directive) throws SQLException, JMSException {
        OracleConnection oracleConnection = (OracleConnection)this.getDBConnection();
        oracleConnection.ackJMSNotification(jMSNotificationRegistration, byArray, directive);
    }

    public void run() {
    }

    public Connection getDBConnection() throws JMSException {
        this.checkSessionStarted();
        return this.db_conn;
    }

    private Connection getOurDBConnection() {
        return this.db_conn;
    }

    public Map getTypeMap() throws JMSException {
        Map map = null;
        oracle.jdbc.OracleConnection oracleConnection = null;
        try {
            oracleConnection = (oracle.jdbc.OracleConnection)this.getDBConnection();
            map = oracleConnection.getTypeMap();
            if (map != null) {
                AQjmsOracleDebug.trace(5, "AQjmsSession.getTypeMap", "typemap found");
            } else {
                AQjmsOracleDebug.trace(5, "AQjmsSession.getTypeMap", "typemap NULL");
            }
        }
        catch (SQLException sQLException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.getTypeMap", sQLException);
            throw new AQjmsException(sQLException);
        }
        return map;
    }

    private void checkSessionStarted() throws JMSException {
        if (this.isSessionClosed() && Thread.currentThread() != this.closingThread) {
            AQjmsError.throwIllegalStateEx(131, null);
        }
    }

    public AQjmsConnection getJmsConnection() throws JMSException {
        return this.jms_conn;
    }

    public AQQueueTable createQueueTable(String string, String string2, AQQueueTableProperty aQQueueTableProperty) throws JMSException {
        return this.createQueueTable(string, string2, aQQueueTableProperty, false);
    }

    public synchronized AQQueueTable createQueueTable(String string, String string2, AQQueueTableProperty aQQueueTableProperty, boolean bl) throws JMSException {
        AQOracleSession aQOracleSession = null;
        AQQueueTable aQQueueTable = null;
        Connection connection = null;
        connection = this.getDBConnection();
        try {
            aQOracleSession = new AQOracleSession(connection);
            aQQueueTable = aQOracleSession.createQueueTable(string, string2, aQQueueTableProperty, bl);
        }
        catch (AQException aQException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.createQueueTable", aQException);
            throw new AQjmsException(aQException);
        }
        return aQQueueTable;
    }

    public synchronized AQQueueTable getQueueTable(String string, String string2) throws JMSException {
        AQOracleSession aQOracleSession = null;
        AQQueueTable aQQueueTable = null;
        Connection connection = null;
        connection = this.getDBConnection();
        try {
            aQOracleSession = new AQOracleSession(connection);
            aQQueueTable = aQOracleSession.getQueueTable(string, string2);
        }
        catch (AQException aQException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.getQueueTable", aQException);
            throw new AQjmsException(aQException);
        }
        return aQQueueTable;
    }

    public synchronized Queue createQueue(AQQueueTable aQQueueTable, String string, AQjmsDestinationProperty aQjmsDestinationProperty) throws JMSException {
        return this.createQueue(aQQueueTable, string, aQjmsDestinationProperty, false);
    }

    public synchronized Queue createQueue(AQQueueTable aQQueueTable, String string, AQjmsDestinationProperty aQjmsDestinationProperty, boolean bl) throws JMSException {
        AQOracleSession aQOracleSession = null;
        AQOracleQueue aQOracleQueue = null;
        AQjmsDestination aQjmsDestination = null;
        Connection connection = null;
        AQjmsDestinationProperty aQjmsDestinationProperty2 = null;
        connection = this.getDBConnection();
        if (aQjmsDestinationProperty == null) {
            AQjmsError.throwEx(121);
        }
        if (aQQueueTable == null) {
            AQjmsError.throwEx(187);
        }
        try {
            if (((AQOracleQueueTable)aQQueueTable).isMulticonsumerEnabled()) {
                AQjmsError.throwEx(144);
            }
            aQOracleSession = new AQOracleSession(connection);
            aQOracleQueue = (AQOracleQueue)aQOracleSession.createQueue(aQQueueTable, string, aQjmsDestinationProperty, bl);
            aQjmsDestinationProperty2 = new AQjmsDestinationProperty(aQOracleQueue.getProperty(true));
            aQjmsDestination = new AQjmsDestination(aQOracleQueue.getOwner(), aQOracleQueue.getName(), 10, aQOracleQueue.getPayloadType(), aQOracleQueue.getObjectPayloadType(), aQjmsDestinationProperty2, aQOracleQueue.getQueueTableName(), aQQueueTable.isSecure());
        }
        catch (AQException aQException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.createQueue", aQException);
            throw new AQjmsException(aQException);
        }
        finally {
            try {
                if (aQOracleQueue != null) {
                    aQOracleQueue.close();
                }
            }
            catch (Throwable throwable) {}
            try {
                if (aQOracleSession != null) {
                    aQOracleSession.close();
                }
            }
            catch (Throwable throwable) {}
        }
        return aQjmsDestination;
    }

    public Topic createTopic(AQQueueTable aQQueueTable, String string, AQjmsDestinationProperty aQjmsDestinationProperty) throws JMSException {
        return this.createTopic(aQQueueTable, string, aQjmsDestinationProperty, false);
    }

    public synchronized Topic createTopic(AQQueueTable aQQueueTable, String string, AQjmsDestinationProperty aQjmsDestinationProperty, boolean bl) throws JMSException {
        AQOracleSession aQOracleSession = null;
        AQOracleQueue aQOracleQueue = null;
        AQjmsDestination aQjmsDestination = null;
        Connection connection = null;
        AQjmsDestinationProperty aQjmsDestinationProperty2 = null;
        connection = this.getDBConnection();
        if (aQQueueTable == null) {
            AQjmsError.throwEx(187);
        }
        if (aQjmsDestinationProperty == null) {
            AQjmsError.throwEx(121);
        }
        try {
            if (aQjmsDestinationProperty.getQueueType() == 1) {
                AQjmsError.throwEx(151);
            }
            if (!((AQOracleQueueTable)aQQueueTable).isMulticonsumerEnabled()) {
                AQjmsError.throwEx(142);
            }
            aQOracleSession = new AQOracleSession(connection);
            aQOracleQueue = (AQOracleQueue)aQOracleSession.createQueue(aQQueueTable, string, aQjmsDestinationProperty, bl);
            AQjmsOracleDebug.trace(5, "AQjmsSession.createTopic", "Queue table: " + aQOracleQueue.getQueueTableName());
            aQjmsDestinationProperty2 = new AQjmsDestinationProperty(aQOracleQueue.getProperty(true));
            aQjmsDestination = new AQjmsDestination(aQOracleQueue.getOwner(), aQOracleQueue.getName(), 20, aQOracleQueue.getPayloadType(), aQOracleQueue.getObjectPayloadType(), aQjmsDestinationProperty2, aQOracleQueue.getQueueTableName(), aQQueueTable.isSecure());
        }
        catch (AQException aQException) {
            AQjmsOracleDebug.traceEx(5, "AQjmsSession.createTopic", aQException);
            throw new AQjmsException(aQException);
        }
        finally {
            try {
                if (aQOracleQueue != null) {
                    aQOracleQueue.close();
                }
            }
            catch (Throwable throwable) {}
            try {
                if (aQOracleSession != null) {
                    aQOracleSession.close();
                }
            }
            catch (Throwable throwable) {}
        }
        return aQjmsDestination;
    }

    public synchronized Queue getQueue(String string, String string2) throws JMSException {
        AQjmsOracleDebug.trace(3, "AQjmsSession.getQueue IN", " owner: " + string + ", name: " + string2);
        AQOracleSession aQOracleSession = null;
        AQOracleQueue aQOracleQueue = null;
        AQjmsDestination aQjmsDestination = null;
        AQjmsDestinationProperty aQjmsDestinationProperty = null;
        Connection connection = null;
        AQOracleQueueTable aQOracleQueueTable = null;
        connection = this.getDBConnection();
        try {
            aQOracleSession = new AQOracleSession(connection);
            AQjmsOracleDebug.trace(5, "AQjmsSession.getQueue", "created AQOracleSession");
            aQOracleQueue = (AQOracleQueue)aQOracleSession.getQueue(string, string2);
            AQjmsOracleDebug.trace(5, "AQjmsSession.getQueue", "finish AQOracleSession.getQueue()");
            aQjmsDestinationProperty = new AQjmsDestinationProperty(aQOracleQueue.getProperty(true));
            aQjmsDestination = new AQjmsDestination(aQOracleQueue.getOwner(), aQOracleQueue.getName(), 10, aQOracleQueue.getPayloadType(), aQOracleQueue.getObjectPayloadType(), aQjmsDestinationProperty, aQOracleQueue.getQueueTableName(), aQOracleQueue.isSecure());
            aQOracleQueueTable = (AQOracleQueueTable)this.getQueueTable(aQOracleQueue.getOwner(), aQOracleQueue.getQueueTableName());
            if (aQOracleQueueTable.isMulticonsumerEnabled() && aQjmsDestinationProperty.getQueueType() != 1) {
                AQjmsError.throwEx(130);
            }
        }
        catch (AQException aQException) {
            AQjmsOracleDebug.traceEx(5, "AQjmsSession.getQueue", aQException);
            throw new AQjmsException(aQException);
        }
        finally {
            try {
                if (aQOracleQueue != null) {
                    aQOracleQueue.close();
                }
            }
            catch (Throwable throwable) {}
            try {
                if (aQOracleSession != null) {
                    aQOracleSession.close();
                }
            }
            catch (Throwable throwable) {}
            try {
                if (aQOracleQueueTable != null) {
                    aQOracleQueueTable.getAQSession().close();
                }
            }
            catch (Throwable throwable) {}
        }
        AQjmsOracleDebug.trace(3, "AQjmsSession.getQueue EXIT", "");
        return aQjmsDestination;
    }

    public Destination getJmsDestination(AQOracleQueue aQOracleQueue) throws JMSException {
        AQjmsDestination aQjmsDestination = null;
        AQjmsDestinationProperty aQjmsDestinationProperty = null;
        Connection connection = null;
        String string = null;
        connection = this.getDBConnection();
        try {
            string = aQOracleQueue.getObjectPayloadType();
            if (string.equalsIgnoreCase("SYS.AQ$_JMS_MESSAGE") || string.equalsIgnoreCase("SYS.AQ$_JMS_TEXT_MESSAGE") || string.equalsIgnoreCase("SYS.AQ$_JMS_BYTES_MESSAGE") || string.equalsIgnoreCase("SYS.AQ$_JMS_MAP_MESSAGE") || string.equalsIgnoreCase("SYS.AQ$_JMS_OBJECT_MESSAGE") || string.equalsIgnoreCase("SYS.AQ$_JMS_STREAM_MESSAGE")) {
                AQjmsOracleDebug.trace(5, "AQjmsSession.getJmsDestination", "before newAQjmsDestProp");
                aQjmsDestinationProperty = new AQjmsDestinationProperty(aQOracleQueue.getProperty(true));
                aQjmsDestination = !aQOracleQueue.isMultiConsumer() || aQjmsDestinationProperty.getQueueType() == 1 ? new AQjmsDestination(aQOracleQueue.getOwner(), aQOracleQueue.getName(), 10, aQOracleQueue.getPayloadType(), aQOracleQueue.getObjectPayloadType(), aQjmsDestinationProperty, aQOracleQueue.getQueueTableName(), aQOracleQueue.isSecure()) : new AQjmsDestination(aQOracleQueue.getOwner(), aQOracleQueue.getName(), 20, aQOracleQueue.getPayloadType(), aQOracleQueue.getObjectPayloadType(), aQjmsDestinationProperty, aQOracleQueue.getQueueTableName(), aQOracleQueue.isSecure());
            } else {
                aQjmsDestination = null;
            }
        }
        catch (AQException aQException) {
            AQjmsOracleDebug.traceEx(5, "AQjmsSession.geJmsDestination", aQException);
            throw new AQjmsException(aQException);
        }
        return aQjmsDestination;
    }

    public synchronized Topic getTopic(String string, String string2) throws JMSException {
        AQOracleSession aQOracleSession = null;
        AQOracleQueue aQOracleQueue = null;
        AQjmsDestination aQjmsDestination = null;
        AQjmsDestinationProperty aQjmsDestinationProperty = null;
        Connection connection = null;
        AQOracleQueueTable aQOracleQueueTable = null;
        connection = this.getDBConnection();
        try {
            aQOracleSession = new AQOracleSession(connection);
            aQOracleQueue = (AQOracleQueue)aQOracleSession.getQueue(string, string2);
            aQjmsDestinationProperty = new AQjmsDestinationProperty(aQOracleQueue.getProperty(true));
            aQjmsDestination = new AQjmsDestination(aQOracleQueue.getOwner(), aQOracleQueue.getName(), 20, aQOracleQueue.getPayloadType(), aQOracleQueue.getObjectPayloadType(), aQjmsDestinationProperty, aQOracleQueue.getQueueTableName(), aQOracleQueue.isSecure());
            aQOracleQueueTable = (AQOracleQueueTable)this.getQueueTable(aQOracleQueue.getOwner(), aQOracleQueue.getQueueTableName());
            if (!aQOracleQueueTable.isMulticonsumerEnabled()) {
                AQjmsError.throwEx(142);
            }
        }
        catch (AQException aQException) {
            AQjmsOracleDebug.traceEx(5, "AQjmsSession.getTopic", aQException);
            throw new AQjmsException(aQException);
        }
        finally {
            try {
                if (aQOracleQueue != null) {
                    aQOracleQueue.close();
                }
            }
            catch (Throwable throwable) {}
            try {
                if (aQOracleSession != null) {
                    aQOracleSession.close();
                }
            }
            catch (Throwable throwable) {}
            try {
                if (aQOracleQueueTable != null) {
                    aQOracleQueueTable.getAQSession().close();
                }
            }
            catch (Throwable throwable) {}
        }
        return aQjmsDestination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isSessionClosed() throws JMSException {
        boolean bl = false;
        if (this.isClosed()) {
            return true;
        }
        Object object = this.m_consync;
        synchronized (object) {
            if (this.jms_conn == null) {
                bl = true;
            } else {
                block12: {
                    if (this.db_conn != null) {
                        try {
                            if (!this.db_conn.isClosed()) {
                                bl = false;
                                break block12;
                            }
                            bl = true;
                        }
                        catch (Exception exception) {
                            bl = true;
                        }
                    } else {
                        bl = false;
                    }
                }
                if (bl) {
                    this.jms_conn = null;
                }
            }
        }
        return bl;
    }

    int getCloseCheckInterval() {
        return this.cl_check_interval;
    }

    public synchronized void setCloseCheckInterval(int n) throws JMSException {
        if (n >= 1) {
            this.cl_check_interval = n;
        } else {
            AQjmsError.throwEx(123, Integer.toString(1));
        }
    }

    public void grantSystemPrivilege(String string, String string2, boolean bl) throws JMSException {
        AQOracleSession aQOracleSession = null;
        Connection connection = null;
        connection = this.getDBConnection();
        try {
            aQOracleSession = new AQOracleSession(connection);
            AQOracleAdmin.grantSystemPrivilege(aQOracleSession, string, string2, bl);
            aQOracleSession.close();
        }
        catch (AQException aQException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.grantSystemPrivilege", aQException);
            throw new AQjmsException(aQException);
        }
    }

    public void revokeSystemPrivilege(String string, String string2) throws JMSException {
        AQOracleSession aQOracleSession = null;
        Connection connection = null;
        connection = this.getDBConnection();
        try {
            aQOracleSession = new AQOracleSession(connection);
            AQOracleAdmin.revokeSystemPrivilege(aQOracleSession, string, string2);
            aQOracleSession.close();
        }
        catch (AQException aQException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.revokeSystemPrivilege", aQException);
            throw new AQjmsException(aQException);
        }
    }

    public void createAQAgent(String string) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsSession.createAQAgent-1", "entry");
        this.createAQAgent(string, false, false, null);
        AQjmsOracleDebug.trace(4, "AQjmsSession.createAQAgent-1", "exit");
    }

    public void createAQAgent(String string, boolean bl, boolean bl2, String string2) throws JMSException {
        Statement statement = null;
        Connection connection = null;
        String string3 = "false";
        String string4 = "false";
        AQjmsOracleDebug.trace(4, "AQjmsSession.createAQAgent-2", "entry");
        if (string == null) {
            AQjmsError.throwEx(229, "agentName");
        }
        if (bl) {
            string3 = "true";
        }
        if (bl2) {
            string4 = "true";
        }
        try {
            connection = this.getDBConnection();
            statement = connection.prepareCall("begin dbms_aqadm.create_aq_agent(agent_name=> ?, certificate_location => ?, enable_http => " + string3 + ", enable_smtp => " + string4 + "); end;");
            statement.setString(1, string);
            statement.setString(2, string2);
            statement.execute();
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new AQjmsException(sQLException);
        }
        AQjmsOracleDebug.trace(4, "AQjmsSession.createAQAgent-2", "exit");
    }

    public void alterAQAgent(String string, boolean bl, boolean bl2, String string2) throws JMSException {
        Statement statement = null;
        Connection connection = null;
        String string3 = "false";
        String string4 = "false";
        AQjmsOracleDebug.trace(4, "AQjmsSession.alterAQAgent", "entry");
        if (string == null) {
            AQjmsError.throwEx(229, "agentName");
        }
        if (bl) {
            string3 = "true";
        }
        if (bl2) {
            string4 = "true";
        }
        try {
            connection = this.getDBConnection();
            statement = connection.prepareCall("begin dbms_aqadm.alter_aq_agent(agent_name=> ?, certificate_location => ?, enable_http => " + string3 + ", enable_smtp => " + string4 + "); end;");
            statement.setString(1, string);
            statement.setString(2, string2);
            statement.execute();
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new AQjmsException(sQLException);
        }
        AQjmsOracleDebug.trace(4, "AQjmsSession.alterAQAgent", "exit");
    }

    public void dropAQAgent(String string) throws JMSException {
        Statement statement = null;
        Connection connection = null;
        AQjmsOracleDebug.trace(4, "AQjmsSession.dropAQAgent", "entry");
        if (string == null) {
            AQjmsError.throwEx(229, "agentName");
        }
        try {
            connection = this.getDBConnection();
            statement = connection.prepareCall("begin dbms_aqadm.drop_aq_agent(agent_name=> ? ); end;");
            statement.setString(1, string);
            statement.execute();
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new AQjmsException(sQLException);
        }
        AQjmsOracleDebug.trace(4, "AQjmsSession.dropAQAgent", "exit");
    }

    public void enableDBAccess(String string, String string2) throws JMSException {
        Statement statement = null;
        Connection connection = null;
        AQjmsOracleDebug.trace(4, "AQjmsSession.enableDBAccess", "entry");
        if (string == null) {
            AQjmsError.throwEx(229, "agentName");
        }
        if (string2 == null) {
            AQjmsError.throwEx(229, "dbUserName");
        }
        try {
            connection = this.getDBConnection();
            statement = connection.prepareCall("begin dbms_aqadm.enable_db_access(agent_name=> ?, db_username => ? ); end;");
            statement.setString(1, string);
            statement.setString(2, string2);
            statement.execute();
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new AQjmsException(sQLException);
        }
        AQjmsOracleDebug.trace(4, "AQjmsSession.enableDBAccess", "exit");
    }

    public void disableDBAccess(String string, String string2) throws JMSException {
        Statement statement = null;
        Connection connection = null;
        AQjmsOracleDebug.trace(4, "AQjmsSession.disableDBAccess", "entry");
        if (string == null) {
            AQjmsError.throwEx(229, "agentName");
        }
        if (string2 == null) {
            AQjmsError.throwEx(229, "dbUserName");
        }
        try {
            connection = this.getDBConnection();
            statement = connection.prepareCall("begin dbms_aqadm.disable_db_access(agent_name=> ?, db_username => ? ); end;");
            statement.setString(1, string);
            statement.setString(2, string2);
            statement.execute();
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new AQjmsException(sQLException);
        }
        AQjmsOracleDebug.trace(4, "AQjmsSession.disableDBAccess", "exit");
    }

    public boolean isDeqStmtCachingEnabled() {
        return this.cache_deq_stmt;
    }

    public void setDeqStmtCachingFlag(boolean bl) {
        this.cache_deq_stmt = bl;
    }

    public void bindAgent(AQjmsAgent aQjmsAgent, String string) throws JMSException {
        Connection connection = null;
        String string2 = "";
        AQOracleAgent aQOracleAgent = null;
        Map<String, Class<?>> map = null;
        String string3 = null;
        int n = 0;
        connection = this.getDBConnection();
        if (aQjmsAgent == null) {
            AQjmsError.throwEx(105);
        }
        try {
            string2 = aQjmsAgent.getName();
            string3 = aQjmsAgent.getAddress();
            n = aQjmsAgent.getProtocol();
            try {
                map = connection.getTypeMap();
            }
            catch (Exception exception) {
                AQjmsError.throwEx(112, (Throwable)exception);
            }
            try {
                map.put("SYS.AQ$_AGENT", Class.forName("oracle.AQ.AQOracleAgent"));
            }
            catch (Exception exception) {
                AQjmsError.throwEx(146, (Throwable)exception);
            }
            aQOracleAgent = new AQOracleAgent(string2, string3, n);
            if (this.bind_stmt != null) {
                this.bind_stmt.clearParameters();
            } else {
                this.bind_stmt = connection.prepareCall("begin dbms_aq.bind_agent(agent=>?, certificate_location=>?); end;");
            }
            this.bind_stmt.setObject(1, (Object)aQOracleAgent, 2002);
            this.bind_stmt.setString(2, string);
            this.bind_stmt.execute();
        }
        catch (SQLException sQLException) {
            try {
                this.bind_stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.bind_stmt = null;
            throw new AQjmsException(sQLException);
        }
    }

    public void unbindAgent(AQjmsAgent aQjmsAgent) throws JMSException {
        Connection connection = null;
        String string = "";
        AQOracleAgent aQOracleAgent = null;
        Map<String, Class<?>> map = null;
        String string2 = null;
        int n = 0;
        connection = this.getDBConnection();
        if (aQjmsAgent == null) {
            AQjmsError.throwEx(105);
        }
        try {
            string = aQjmsAgent.getName();
            string2 = aQjmsAgent.getAddress();
            n = aQjmsAgent.getProtocol();
            try {
                map = connection.getTypeMap();
            }
            catch (Exception exception) {
                AQjmsError.throwEx(112, (Throwable)exception);
            }
            try {
                map.put("SYS.AQ$_AGENT", Class.forName("oracle.AQ.AQOracleAgent"));
            }
            catch (Exception exception) {
                AQjmsError.throwEx(146, (Throwable)exception);
            }
            aQOracleAgent = new AQOracleAgent(string, string2, n);
            if (this.ubnd_stmt != null) {
                this.ubnd_stmt.clearParameters();
            } else {
                this.ubnd_stmt = connection.prepareCall("begin dbms_aq.unbind_agent(agent=>?); end;");
            }
            this.ubnd_stmt.setObject(1, (Object)aQOracleAgent, 2002);
            this.ubnd_stmt.execute();
        }
        catch (SQLException sQLException) {
            try {
                this.ubnd_stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.ubnd_stmt = null;
            throw new AQjmsException(sQLException);
        }
    }

    OracleCallableStatement getTextStmt() throws SQLException {
        if (this.st_text == null) {
            String string = AQjmsInterOp.getEnquTextMsgStmtByVersion(this.dbversion);
            AQjmsOracleDebug.trace(5, "AQjmsSession.getTextStmt", "enqueue_text statement: " + string);
            this.st_text = (OracleCallableStatement)this.db_conn.prepareCall(string);
        } else {
            this.st_text.clearParameters();
        }
        return this.st_text;
    }

    OracleCallableStatement getMapStmt() throws SQLException {
        if (this.st_map == null) {
            String string = AQjmsInterOp.getEnquMapMsgStmtByVersion(this.dbversion);
            AQjmsOracleDebug.trace(5, "AQjmsSession.getMapStmt", "enqueue_map statement: " + string);
            this.st_map = (OracleCallableStatement)this.db_conn.prepareCall(string);
        } else {
            this.st_map.clearParameters();
        }
        return this.st_map;
    }

    OracleCallableStatement getStreamStmt() throws SQLException {
        if (this.st_stream == null) {
            String string = AQjmsInterOp.getEnquStreamMsgStmtByVersion(this.dbversion);
            AQjmsOracleDebug.trace(5, "AQjmsSession.getStreamStmt", "enqueue_stream statement: " + string);
            this.st_stream = (OracleCallableStatement)this.db_conn.prepareCall(string);
        } else {
            this.st_stream.clearParameters();
        }
        return this.st_stream;
    }

    OracleCallableStatement getBytesStmt() throws SQLException {
        if (this.st_bytes == null) {
            String string = AQjmsInterOp.getEnquBytesMsgStmtByVersion(this.dbversion);
            AQjmsOracleDebug.trace(5, "AQjmsSession.getBytesStmt", "enqueue_bytes statement: " + string);
            this.st_bytes = (OracleCallableStatement)this.db_conn.prepareCall(string);
        } else {
            this.st_bytes.clearParameters();
        }
        return this.st_bytes;
    }

    OracleCallableStatement getObjectStmt() throws SQLException {
        if (this.st_object == null) {
            String string = AQjmsInterOp.getEnquObjectMsgStmtByVersion(this.dbversion);
            AQjmsOracleDebug.trace(5, "AQjmsSession.getObjectStmt", "enqueue_object statement: " + string);
            this.st_object = (OracleCallableStatement)this.db_conn.prepareCall(string);
        } else {
            this.st_object.clearParameters();
        }
        return this.st_object;
    }

    OracleCallableStatement getAdtStmt() throws SQLException {
        if (this.st_adt == null) {
            String string = AQjmsInterOp.getEnquAdtStmtByVersion(this.dbversion);
            AQjmsOracleDebug.trace(5, "AQjmsSession.getAdtStmt", "enqueue_adt statement: " + string);
            this.st_adt = (OracleCallableStatement)this.db_conn.prepareCall(string);
        } else {
            this.st_adt.clearParameters();
        }
        return this.st_adt;
    }

    OracleCallableStatement getAdtNoRecplStmt() throws SQLException {
        if (this.st_adt_rep == null) {
            String string = AQjmsInterOp.getEnquAdtNoRecplStmtByVersion(this.dbversion);
            AQjmsOracleDebug.trace(5, "AQjmsSession.getAdtNoRecplStmt", "enqueue_adt_norecpl statement: " + string);
            this.st_adt_rep = (OracleCallableStatement)this.db_conn.prepareCall(string);
        } else {
            this.st_adt_rep.clearParameters();
        }
        return this.st_adt_rep;
    }

    OracleCallableStatement getEnqueueStmt(Message message) throws SQLException {
        if (message instanceof AQjmsTextMessage) {
            return this.getTextStmt();
        }
        if (message instanceof AQjmsBytesMessage) {
            return this.getBytesStmt();
        }
        if (message instanceof AQjmsStreamMessage) {
            return this.getStreamStmt();
        }
        if (message instanceof AQjmsMapMessage) {
            return this.getMapStmt();
        }
        if (message instanceof AQjmsObjectMessage) {
            return this.getObjectStmt();
        }
        return null;
    }

    OracleCallableStatement getDequeueStmt() throws SQLException {
        if (this.deq_stmt == null) {
            String string = AQjmsInterOp.getDequeueStmtByVersion(this.dbversion);
            AQjmsOracleDebug.trace(5, "AQjmsSession.getDequeueStmt", "dequeue statement: " + string);
            this.deq_stmt = (OracleCallableStatement)this.db_conn.prepareCall(string);
        } else {
            this.deq_stmt.clearParameters();
        }
        return this.deq_stmt;
    }

    OracleCallableStatement getArrayEnqueueStmt(String string) throws SQLException {
        String string2 = this.is19compatible() ? "dbms_aqjms." : "dbms_aqjms_internal.";
        AQjmsOracleDebug.trace(5, "AQjmsSession.getArrayEnqueueStmt: pkgName: ", string2);
        if (string.equalsIgnoreCase("SYS.AQ$_JMS_MESSAGE")) {
            if (this.st_array_enqueue == null) {
                this.st_array_enqueue = (OracleCallableStatement)this.db_conn.prepareCall("begin " + string2 + "aq$_jms_enqueue_messages( queue_name => ?, messages => ?, num_messages => ?, message_props => ?, visibility => ?, relative_msgid => ?, sequence_deviation => ?, transformation => ?, msgids => ?, errors => ?, num_enqueued => ? ); end; ");
            } else {
                this.st_array_enqueue.clearParameters();
            }
            return this.st_array_enqueue;
        }
        if (string.equalsIgnoreCase("SYS.AQ$_JMS_TEXT_MESSAGE")) {
            if (this.st_array_text_enqueue == null) {
                this.st_array_text_enqueue = (OracleCallableStatement)this.db_conn.prepareCall("begin " + string2 + "aq$_jms_enqueue_text_messages( queue_name => ?, messages => ?, num_messages => ?, message_props => ?, visibility => ?, relative_msgid => ?, sequence_deviation => ?, transformation => ?, msgids => ?, errors => ?, num_enqueued => ? ); end; ");
            } else {
                this.st_array_text_enqueue.clearParameters();
            }
            return this.st_array_text_enqueue;
        }
        if (string.equalsIgnoreCase("SYS.AQ$_JMS_BYTES_MESSAGE")) {
            if (this.st_array_bytes_enqueue == null) {
                this.st_array_bytes_enqueue = (OracleCallableStatement)this.db_conn.prepareCall("begin " + string2 + "aq$_jms_enqueue_bytes_messages( queue_name => ?, messages => ?, num_messages => ?, message_props => ?, visibility => ?, relative_msgid => ?, sequence_deviation => ?, transformation => ?, msgids => ?, errors => ?, num_enqueued => ? ); end; ");
            } else {
                this.st_array_bytes_enqueue.clearParameters();
            }
            return this.st_array_bytes_enqueue;
        }
        if (string.equalsIgnoreCase("SYS.AQ$_JMS_STREAM_MESSAGE")) {
            if (this.st_array_stream_enqueue == null) {
                this.st_array_stream_enqueue = (OracleCallableStatement)this.db_conn.prepareCall("begin " + string2 + "aq$_jms_enqueue_str_messages( queue_name => ?, messages => ?, num_messages => ?, message_props => ?, visibility => ?, relative_msgid => ?, sequence_deviation => ?, transformation => ?, msgids => ?, errors => ?, num_enqueued => ? ); end; ");
            } else {
                this.st_array_stream_enqueue.clearParameters();
            }
            return this.st_array_stream_enqueue;
        }
        if (string.equalsIgnoreCase("SYS.AQ$_JMS_MAP_MESSAGE")) {
            if (this.st_array_map_enqueue == null) {
                this.st_array_map_enqueue = (OracleCallableStatement)this.db_conn.prepareCall("begin " + string2 + "aq$_jms_enqueue_map_messages( queue_name => ?, messages => ?, num_messages => ?, message_props => ?, visibility => ?, relative_msgid => ?, sequence_deviation => ?, transformation => ?, msgids => ?, errors => ?, num_enqueued => ? ); end; ");
            } else {
                this.st_array_map_enqueue.clearParameters();
            }
            return this.st_array_map_enqueue;
        }
        if (string.equalsIgnoreCase("SYS.AQ$_JMS_OBJECT_MESSAGE")) {
            if (this.st_array_object_enqueue == null) {
                this.st_array_object_enqueue = (OracleCallableStatement)this.db_conn.prepareCall("begin " + string2 + "aq$_jms_enqueue_obj_messages( queue_name => ?, messages => ?, num_messages => ?, message_props => ?, visibility => ?, relative_msgid => ?, sequence_deviation => ?, transformation => ?, msgids => ?, errors => ?, num_enqueued => ? ); end; ");
            } else {
                this.st_array_object_enqueue.clearParameters();
            }
            return this.st_array_object_enqueue;
        }
        return null;
    }

    OracleCallableStatement getArrayDequeueStmt(String string) throws SQLException {
        String string2 = this.is19compatible() ? "dbms_aqjms." : "dbms_aqjms_internal.";
        AQjmsOracleDebug.trace(5, "AQjmsSession.getArrayDequeueStmt: pkgName: ", string2);
        if (string.equalsIgnoreCase("SYS.AQ$_JMS_MESSAGE")) {
            if (this.st_array_dequeue == null) {
                this.st_array_dequeue = (OracleCallableStatement)this.db_conn.prepareCall("begin " + string2 + "aq$_jms_dequeue_messages( queue_name => ?, num_messages => ?, consumer_name => ?, dequeue_mode => ?, navigation => ?, visibility => ?, wait => ?, correlation => ?, deq_condition => ?, signature => ?, transformation => ?, message_props => ?, messages => ?, msgids => ?, num_dequeued => ? ); end; ");
            } else {
                this.st_array_dequeue.clearParameters();
            }
            return this.st_array_dequeue;
        }
        if (string.equalsIgnoreCase("SYS.AQ$_JMS_TEXT_MESSAGE")) {
            if (this.st_array_text_dequeue == null) {
                this.st_array_text_dequeue = (OracleCallableStatement)this.db_conn.prepareCall("begin " + string2 + "aq$_jms_dequeue_text_messages( queue_name => ?, num_messages => ?, consumer_name => ?, dequeue_mode => ?, navigation => ?, visibility => ?, wait => ?, correlation => ?, deq_condition => ?, signature => ?, transformation => ?, message_props => ?, messages => ?, msgids => ?, num_dequeued => ? ); end; ");
            } else {
                this.st_array_text_dequeue.clearParameters();
            }
            return this.st_array_text_dequeue;
        }
        if (string.equalsIgnoreCase("SYS.AQ$_JMS_BYTES_MESSAGE")) {
            if (this.st_array_bytes_dequeue == null) {
                this.st_array_bytes_dequeue = (OracleCallableStatement)this.db_conn.prepareCall("begin " + string2 + "aq$_jms_dequeue_bytes_messages( queue_name => ?, num_messages => ?, consumer_name => ?, dequeue_mode => ?, navigation => ?, visibility => ?, wait => ?, correlation => ?, deq_condition => ?, signature => ?, transformation => ?, message_props => ?, messages => ?, msgids => ?, num_dequeued => ? ); end; ");
            } else {
                this.st_array_bytes_dequeue.clearParameters();
            }
            return this.st_array_bytes_dequeue;
        }
        if (string.equalsIgnoreCase("SYS.AQ$_JMS_STREAM_MESSAGE")) {
            if (this.st_array_stream_dequeue == null) {
                this.st_array_stream_dequeue = (OracleCallableStatement)this.db_conn.prepareCall("begin " + string2 + "aq$_jms_dequeue_stream_messages( queue_name => ?, num_messages => ?, consumer_name => ?, dequeue_mode => ?, navigation => ?, visibility => ?, wait => ?, correlation => ?, deq_condition => ?, signature => ?, transformation => ?, message_props => ?, messages => ?, msgids => ?, num_dequeued => ? ); end; ");
            } else {
                this.st_array_stream_dequeue.clearParameters();
            }
            return this.st_array_stream_dequeue;
        }
        if (string.equalsIgnoreCase("SYS.AQ$_JMS_MAP_MESSAGE")) {
            if (this.st_array_map_dequeue == null) {
                this.st_array_map_dequeue = (OracleCallableStatement)this.db_conn.prepareCall("begin " + string2 + "aq$_jms_dequeue_map_messages( queue_name => ?, num_messages => ?, consumer_name => ?, dequeue_mode => ?, navigation => ?, visibility => ?, wait => ?, correlation => ?, deq_condition => ?, signature => ?, transformation => ?, message_props => ?, messages => ?, msgids => ?, num_dequeued => ? ); end; ");
            } else {
                this.st_array_map_dequeue.clearParameters();
            }
            return this.st_array_map_dequeue;
        }
        if (string.equalsIgnoreCase("SYS.AQ$_JMS_OBJECT_MESSAGE")) {
            if (this.st_array_object_dequeue == null) {
                this.st_array_object_dequeue = (OracleCallableStatement)this.db_conn.prepareCall("begin " + string2 + "aq$_jms_dequeue_object_messages( queue_name => ?, num_messages => ?, consumer_name => ?, dequeue_mode => ?, navigation => ?, visibility => ?, wait => ?, correlation => ?, deq_condition => ?, signature => ?, transformation => ?, message_props => ?, messages => ?, msgids => ?, num_dequeued => ? ); end; ");
            } else {
                this.st_array_object_dequeue.clearParameters();
            }
            return this.st_array_object_dequeue;
        }
        return null;
    }

    void destroyStmt(OracleCallableStatement oracleCallableStatement) {
        if (oracleCallableStatement == null) {
            return;
        }
        boolean bl = false;
        if (oracleCallableStatement == this.st_text) {
            this.st_text = null;
            bl = true;
        } else if (oracleCallableStatement == this.st_map) {
            this.st_map = null;
            bl = true;
        } else if (oracleCallableStatement == this.st_bytes) {
            this.st_bytes = null;
            bl = true;
        } else if (oracleCallableStatement == this.st_stream) {
            this.st_stream = null;
            bl = true;
        } else if (oracleCallableStatement == this.st_object) {
            this.st_object = null;
            bl = true;
        } else if (oracleCallableStatement == this.st_adt) {
            this.st_adt = null;
            bl = true;
        } else if (oracleCallableStatement == this.st_adt_rep) {
            this.st_adt_rep = null;
            bl = true;
        } else if (oracleCallableStatement == this.deq_stmt) {
            this.deq_stmt = null;
            bl = true;
        } else if (oracleCallableStatement == this.st_array_enqueue) {
            this.st_array_enqueue = null;
            bl = true;
        } else if (oracleCallableStatement == this.st_array_text_enqueue) {
            this.st_array_text_enqueue = null;
            bl = true;
        } else if (oracleCallableStatement == this.st_array_bytes_enqueue) {
            this.st_array_bytes_enqueue = null;
            bl = true;
        } else if (oracleCallableStatement == this.st_array_stream_enqueue) {
            this.st_array_stream_enqueue = null;
            bl = true;
        } else if (oracleCallableStatement == this.st_array_map_enqueue) {
            this.st_array_map_enqueue = null;
            bl = true;
        } else if (oracleCallableStatement == this.st_array_object_enqueue) {
            this.st_array_object_enqueue = null;
            bl = true;
        } else if (oracleCallableStatement == this.st_array_dequeue) {
            this.st_array_dequeue = null;
            bl = true;
        } else if (oracleCallableStatement == this.st_array_text_dequeue) {
            this.st_array_text_dequeue = null;
            bl = true;
        } else if (oracleCallableStatement == this.st_array_bytes_dequeue) {
            this.st_array_bytes_dequeue = null;
            bl = true;
        } else if (oracleCallableStatement == this.st_array_stream_dequeue) {
            this.st_array_stream_dequeue = null;
            bl = true;
        } else if (oracleCallableStatement == this.st_array_map_dequeue) {
            this.st_array_map_dequeue = null;
            bl = true;
        } else if (oracleCallableStatement == this.st_array_object_dequeue) {
            this.st_array_object_dequeue = null;
            bl = true;
        }
        if (bl) {
            try {
                oracleCallableStatement.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected long[] getOCIHandles() throws JMSException {
        String string = this.getDriver();
        if ((string.equalsIgnoreCase("oci8") || string.equalsIgnoreCase("oci")) && AQDriverManager.isOciAQEnabled() && AQjmsConstants.OCI_NATIVE_PATH) {
            Properties properties = new Properties();
            Connection connection = this.getOurDBConnection();
            try {
                if (!loaded_library) {
                    String string2 = AQjmsUtil.getSystemProperty("os.name");
                    String string3 = null;
                    if (string2.toUpperCase().startsWith("WINDOWS")) {
                        string3 = "oci";
                    } else if (string2.equalsIgnoreCase("OpenVMS")) {
                        string3 = "libclntsh";
                    } else if (string2.toUpperCase().startsWith("MAC OS")) {
                        string3 = "clntsh";
                    }
                    if (string3 != null) {
                        final String string4 = string3;
                        AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                System.loadLibrary(string4);
                                return null;
                            }
                        });
                        loaded_library = true;
                    }
                }
            }
            catch (Exception exception) {
                AQjmsOracleDebug.traceEx(3, "AQjmsSession.loadLibrary excp:", exception);
            }
            catch (Error error) {
                AQjmsOracleDebug.traceErr(3, "AQjmsSession.loadLibrary error:", error);
            }
            try {
                properties = ((OracleConnection)connection).getOCIHandles();
            }
            catch (Exception exception) {
                AQjmsError.throwEx(122, "Properties Not Found", exception);
            }
            AQjmsOracleDebug.trace(5, "AQjmsSession.getOCIHandles():", "Got DBAccess properties ");
            long l = Long.parseLong(properties.getProperty("OCIEnvHandle"));
            long l2 = Long.parseLong(properties.getProperty("OCIErrHandle"));
            long l3 = Long.parseLong(properties.getProperty("OCISvcCtxHandle"));
            if (l == this.oci_handles[0] && l2 == this.oci_handles[1] && l3 == this.oci_handles[2]) {
                return this.oci_handles;
            }
            this.freeOCIHandles();
            this.oci_handles[0] = l;
            this.oci_handles[1] = l2;
            this.oci_handles[2] = l3;
            AQjmsOracleDebug.trace(3, "AQjmsSession.getOCIHandles():", "(Re)got oci handles ");
            String string5 = Thread.currentThread().getName();
            int n = 0;
            try {
                AQjmsOracleDebug.println("Tname.substring:" + string5.substring(7) + "::");
                n = Integer.parseInt(string5.substring(7));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.oci_aq_cntxt = this.ociinit(this.oci_handles, AQjmsOracleDebug.getTraceLevel(), n, this.toUseTempLobs(), this.dbversion, this.db_max_bytes, this.getClientRatio());
            }
            catch (Exception exception) {
                AQjmsError.throwEx(122, "OCI Init failed!", exception);
            }
            AQjmsOracleDebug.trace(3, "AQjmsSession.getOCIHandles():", "(Re)initialized AQ context");
            return this.oci_handles;
        }
        return null;
    }

    private void setMultiRetry() throws JMSException {
        if ((this.sess_type == 20 || this.sess_type == 30) && this.hasGenMsgSupport()) {
            CallableStatement callableStatement = null;
            try {
                String string = "{call dbms_aqin.set_multi_retry(TRUE)}";
                callableStatement = this.db_conn.prepareCall(string);
                callableStatement.execute(string);
                AQjmsOracleDebug.trace(3, "AQjmsSession.setMultiRetry", "setting the multi_retry flag to true");
            }
            catch (SQLException sQLException) {
                AQjmsOracleDebug.traceEx(3, "AQjmsSession.setMultiRetry", sQLException);
                throw new AQjmsException(sQLException);
            }
            finally {
                try {
                    if (callableStatement != null) {
                        callableStatement.close();
                    }
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private void enableEventForMsgOrder() throws JMSException {
        if (this.is11compatible()) {
            CallableStatement callableStatement = null;
            try {
                String string = "{call dbms_aqin.set_deq_sort(TRUE)}";
                callableStatement = this.db_conn.prepareCall(string);
                callableStatement.execute(string);
                AQjmsOracleDebug.trace(3, "AQjmsSession.enableEventForMsgOrder", "setting the multi_retry flag to true");
            }
            catch (SQLException sQLException) {
                AQjmsOracleDebug.traceEx(3, "AQjmsSession.enableEventForMsgOrder", sQLException);
                throw new AQjmsException(sQLException);
            }
            finally {
                try {
                    if (callableStatement != null) {
                        callableStatement.close();
                    }
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private long getOCIServiceHandle() {
        return this.oci_handles[2];
    }

    private long getOCIErrorHandle() {
        return this.oci_handles[1];
    }

    void freeOCIHandles() throws JMSException {
        if (this.oci_aq_cntxt != 0L) {
            Properties properties = null;
            try {
                Connection connection = this.getOurDBConnection();
                if (connection.isClosed()) {
                    return;
                }
                properties = ((OracleConnection)connection).getDBAccessProperties();
            }
            catch (Exception exception) {
                AQjmsError.throwEx(122, "Properties Not Found", exception);
            }
            if (properties != null) {
                try {
                    this.ocifrctx(this.oci_handles, this.oci_aq_cntxt, AQjmsOracleDebug.getTraceLevel());
                }
                catch (Exception exception) {
                    AQjmsOracleDebug.traceEx(3, "freeOCIHandles excp:", exception);
                    AQjmsError.throwEx(122, "Freeing OCI handles", exception);
                }
                AQjmsOracleDebug.trace(3, "AQjmsSession.freeOCIHandles():", "Freed AQ context");
            }
        }
        this.oci_aq_cntxt = 0L;
    }

    boolean is82compatible() {
        return AQjmsInterOp.is82compatible(this.dbversion);
    }

    boolean is92compatible() {
        return AQjmsInterOp.is92compatible(this.dbversion);
    }

    boolean is10compatible() {
        return AQjmsInterOp.is10compatible(this.dbversion);
    }

    boolean is102compatible() {
        return AQjmsInterOp.is102compatible(this.dbversion);
    }

    boolean is11compatible() {
        return AQjmsInterOp.is11compatible(this.dbversion);
    }

    boolean is112compatible() {
        return AQjmsInterOp.is112compatible(this.dbversion);
    }

    boolean is121compatible() {
        return AQjmsInterOp.is121compatible(this.dbversion);
    }

    boolean is122compatible() {
        return AQjmsInterOp.is122compatible(this.dbversion);
    }

    boolean is19compatible() {
        return AQjmsInterOp.is19compatible(this.dbversion);
    }

    boolean toUseTempLobs() {
        return this.is10compatible() && this.jms_conn.isUseTempLobs();
    }

    short getDBVersion() {
        return this.dbversion;
    }

    boolean hasGenMsgSupport() {
        return AQjmsInterOp.hasGenMsgSupport(this.dbversion);
    }

    public boolean hasOciAQContext() {
        return this.oci_aq_cntxt != 0L;
    }

    String getDriver() {
        return this.jms_conn.getDriver();
    }

    public synchronized void removeConsumer(AQjmsConsumer aQjmsConsumer) {
        if (aQjmsConsumer.dest_type == 20 && !aQjmsConsumer.isDurable()) {
            try {
                AQjmsOracleDebug.trace(3, "AQjmsSession.removeConsumer", "Before removing nondurable subscriber " + aQjmsConsumer.cons_name);
                if (AQjmsConstants.useAQNondurableSubscriber()) {
                    if (aQjmsConsumer.cons_dest.isSharded()) {
                        this.removeAQNondurableSubscriberSQ(aQjmsConsumer.cons_dest, aQjmsConsumer.cons_name);
                    } else if (this.clientSessionGUID != null && this.isClosing()) {
                        AQjmsOracleDebug.trace(3, "AQjmsSession.removeConsumer", "Delay removing nondurable subscriber " + aQjmsConsumer.cons_name + " on server ");
                    }
                } else {
                    AQjmsAgent aQjmsAgent = new AQjmsAgent();
                    aQjmsAgent.setName(aQjmsConsumer.cons_name);
                    this.removeSubscriber(aQjmsConsumer.cons_dest, aQjmsAgent);
                }
                AQjmsOracleDebug.trace(3, "AQjmsSession.removeConsumer", "End removing nondurable subscriber " + aQjmsConsumer.cons_name);
            }
            catch (Exception exception) {
                AQjmsOracleDebug.traceEx(3, "AQjmsSession.removeConsumer", exception);
            }
        }
        aQjmsConsumer.disableConsumerExceptionListener();
        this.cons_list.remove(aQjmsConsumer);
    }

    void disableConsumerExceptionListenerForQ(String string) {
        Enumeration enumeration = this.cons_list.elements();
        while (enumeration.hasMoreElements()) {
            AQjmsConsumer aQjmsConsumer = (AQjmsConsumer)enumeration.nextElement();
            if (!aQjmsConsumer.cons_dest.getCompleteName().equals(string)) continue;
            aQjmsConsumer.disableConsumerExceptionListener();
        }
    }

    @Override
    public void finalize() {
        AQjmsOracleDebug.println("AQjmsSession.finalize");
    }

    private String getAQOwner(String string) throws JMSException {
        if (string.indexOf(46) == -1) {
            try {
                return this.getDBConnection().getMetaData().getUserName();
            }
            catch (SQLException sQLException) {
                throw new AQjmsException(sQLException);
            }
        }
        return string.substring(0, string.indexOf(46));
    }

    private String getAQName(String string) {
        if (string.indexOf(46) == -1) {
            return string;
        }
        return string.substring(1 + string.indexOf(46));
    }

    private int getMaxSubscriberNameLen() {
        return this.is122compatible() ? 128 : 30;
    }

    private String getTempName() throws JMSException {
        String string = this.jms_conn.getConnectionID();
        int n = this.jms_conn.getTempCount();
        return "TMPQ_" + n + "_" + string;
    }

    private String getSubsName() throws JMSException {
        String string = this.jms_conn.getConnectionID();
        int n = this.jms_conn.getTempCount();
        String string2 = AQjmsSession.chopit("TSUB_" + n + "_" + string, 30);
        return string2;
    }

    private static String chopit(String string, int n) {
        if (string != null && string.length() > n) {
            AQjmsOracleDebug.trace(5, "AQjmsSession.chopit", string + " -> " + string.substring(0, n));
            string = string.substring(0, n);
        }
        return string;
    }

    private AQjmsDestination makeTemporaryQueue(boolean bl) throws JMSException {
        String string = this.getAQOwner("");
        String string2 = AQjmsSession.chopit(this.getTempName(), 24);
        String string3 = AQjmsSession.chopit(string2, 24);
        AQjmsDestination aQjmsDestination = null;
        if (!this.is121compatible() || AQjmsConstants.usePre12TempDestination()) {
            AQQueueTableProperty aQQueueTableProperty = null;
            try {
                aQQueueTableProperty = new AQQueueTableProperty("SYS.AQ$_JMS_MESSAGE");
                aQQueueTableProperty.setSortOrder("priority,enq_time");
                aQQueueTableProperty.setMultiConsumer(bl);
            }
            catch (AQException aQException) {
                throw new AQjmsException(aQException);
            }
            AQQueueTable aQQueueTable = this.createQueueTable(string, string3, aQQueueTableProperty, true);
            aQjmsDestination = bl ? (AQjmsDestination)this.createTopic(aQQueueTable, string2, new AQjmsDestinationProperty(), true) : (AQjmsDestination)this.createQueue(aQQueueTable, string2, new AQjmsDestinationProperty(), true);
        } else {
            aQjmsDestination = (AQjmsDestination)this.createJMSShardedQueue(string2, bl);
        }
        aQjmsDestination.start((Session)this, true, true, true);
        this.jms_conn.registerTemp(aQjmsDestination);
        return aQjmsDestination;
    }

    private TopicSubscriber createNondurableSub(Topic topic, String string, boolean bl, Object object, String string2) throws JMSException {
        TopicSubscriber topicSubscriber = null;
        if (topic == null) {
            throw new InvalidDestinationException(AQjmsError.getMessage(166));
        }
        if (!AQjmsConstants.useAQNondurableSubscriber() || !this.is112compatible()) {
            String string3 = this.getSubsName();
            topicSubscriber = this.createDurableSubscriber(topic, string3, string, bl, object, string2, true, true);
            AQjmsOracleDebug.trace(3, "AQjmsSession.createNondurableSub", "Created nondurable subscriber using durable subscriber: " + string3);
            return topicSubscriber;
        }
        if (this.is121compatible() && ((AQjmsDestination)topic).isSharded()) {
            topicSubscriber = this.addAQNondurableSubscriberSQ(topic, string, bl, object, string2);
            AQjmsOracleDebug.trace(3, "AQjmsSession.createNondurableSub", "Created nondurable subscriber using 12g APIs");
            return topicSubscriber;
        }
        topicSubscriber = this.addAQNondurableSubscriber(topic, string, bl, object, string2);
        AQjmsOracleDebug.trace(3, "AQjmsSession.createNondurableSub", "Created nondurable subscriber using 11.2 APIs");
        return topicSubscriber;
    }

    public synchronized void restartConsumers() {
        AQjmsOracleDebug.trace(5, "AQjmsSession.restartConsumers", "entry");
        Enumeration enumeration = this.cons_list.elements();
        while (enumeration.hasMoreElements()) {
            AQjmsConsumer aQjmsConsumer = (AQjmsConsumer)enumeration.nextElement();
            aQjmsConsumer.restart();
        }
    }

    void checkForGlobalTxn() throws JMSException {
        AQjmsOracleDebug.trace(3, "AQjmsSession.checkForGlobalTxn", "entry");
        if (this.xaHandler == null) {
            AQjmsOracleDebug.trace(3, "AQjmsSession.checkForGlobalTxn", "oracle.jms.useEmulatedXA is off");
        } else {
            AQjmsOracleDebug.trace(3, "AQjmsSession.checkForGlobalTxn", "oracle.jms.useEmulatedXA is on");
            this.xaHandler.checkForGlobalTxn();
        }
        AQjmsOracleDebug.trace(3, "AQjmsSession.checkForGlobalTxn", "exit");
    }

    boolean isInGlobalTransactionRechecked() throws JMSException {
        boolean bl = false;
        AQjmsOracleDebug.trace(3, "AQjmsSession.inGlobalTransRechecked", "entry");
        if (this.xaHandler == null) {
            AQjmsOracleDebug.trace(3, "AQjmsSession.inGlobalTransRechecked", "oracle.jms.useEmulatedXA is off");
        } else {
            AQjmsOracleDebug.trace(3, "AQjmsSession.inGlobalTransRechecked", "oracle.jms.useEmulatedXA is on");
            bl = this.xaHandler.inGlobalTrans(true);
        }
        AQjmsOracleDebug.trace(3, "AQjmsSession.inGlobalTransRechecked", "exit");
        return bl;
    }

    boolean isInGlobalTransaction() {
        boolean bl = false;
        AQjmsOracleDebug.trace(3, "AQjmsSession.isInGlobalTransaction", "entry");
        if (this.xaHandler == null) {
            AQjmsOracleDebug.trace(3, "AQjmsSession.isInGlobalTransaction", "oracle.jms.useEmulatedXA is off");
        } else {
            AQjmsOracleDebug.trace(3, "AQjmsSession.isInGlobalTransaction", "oracle.jms.useEmulatedXA is on");
            bl = this.xaHandler.globalTxnFlag;
        }
        AQjmsOracleDebug.trace(3, "AQjmsSession.isInGlobalTransaction", "exit");
        return bl;
    }

    boolean isInTransactionRechecked() throws JMSException {
        return this.transacted || this.isInGlobalTransactionRechecked();
    }

    public int getAcknowledgeMode() throws JMSException {
        this.checkSessionStarted();
        if (this.isInTransactionRechecked()) {
            return 0;
        }
        return this.ack_mode;
    }

    public synchronized MessageProducer createProducer(Destination destination) throws JMSException {
        AQjmsProducer aQjmsProducer = null;
        this.checkSessionStarted();
        if (destination != null && !(destination instanceof AQjmsDestination)) {
            AQjmsError.throwInvalidDestEx(127);
        }
        aQjmsProducer = new AQjmsProducer(this, (AQjmsDestination)destination, 30);
        return aQjmsProducer;
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        return this.createConsumer(destination, null, null, null, false);
    }

    public MessageConsumer createConsumer(Destination destination, String string) throws JMSException {
        return this.createConsumer(destination, string, null, null, false);
    }

    public MessageConsumer createConsumer(Destination destination, String string, boolean bl) throws JMSException {
        return this.createConsumer(destination, string, null, null, bl);
    }

    public synchronized MessageConsumer createConsumer(Destination destination, String string, Object object, String string2, boolean bl) throws JMSException {
        int n;
        TopicSubscriber topicSubscriber = null;
        this.checkSessionStarted();
        if (destination == null) {
            throw new InvalidDestinationException(AQjmsError.getMessage(200));
        }
        if (!(destination instanceof AQjmsDestination)) {
            AQjmsError.throwInvalidDestEx(127);
        }
        if (this.getMessageListener() != null) {
            AQjmsError.throwEx(107, "createConsumer after MessageListener of Session is set");
        }
        if ((n = ((AQjmsDestination)destination).isQueue() ? 10 : 20) == 10) {
            AQjmsSelector aQjmsSelector = null;
            String string3 = null;
            if (string != null && !string.equals("")) {
                AQjmsDestination aQjmsDestination = (AQjmsDestination)destination;
                aQjmsSelector = aQjmsDestination.isSharded() ? new AQjmsSelector(string, n, 4, this.dbversion, aQjmsDestination) : (object != null ? new AQjmsSelector(string, n, 2, this.dbversion, this.getCompliant()) : ((string3 = ((AQjmsDestination)destination).getAdtType()).equalsIgnoreCase("SYS.ANYDATA") ? new AQjmsSelector(string, n, 3, this.dbversion, this.getCompliant()) : new AQjmsSelector(string, n, 1, this.dbversion, this.getCompliant())));
            }
            AQjmsOracleDebug.trace(5, "AQjmsSession.createConsumer", "Selector for Queue: " + aQjmsSelector);
            topicSubscriber = new AQjmsConsumer(this, destination, n, 3, null, object, aQjmsSelector, string2);
        } else {
            topicSubscriber = this.createNondurableSub((Topic)destination, string, bl, object, string2);
        }
        this.cons_list.put(topicSubscriber, topicSubscriber);
        return topicSubscriber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isConnectionClosed() {
        boolean bl = false;
        Object object = this.m_consync;
        synchronized (object) {
            if (this.jms_conn == null) {
                bl = true;
            }
        }
        return bl;
    }

    void checkConnectionClosed() throws JMSException {
        if (this.isConnectionClosed()) {
            AQjmsError.throwIllegalStateEx(131, null);
        }
    }

    boolean isNetworkTimeoutRequired() {
        return AQjmsConstants.SET_NETWORK_TIMEOUT;
    }
}

