/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import oracle.jdbc.OracleData;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsGenMessage_C;
import oracle.jms.AQjmsMapMessage_C;
import oracle.jms.AQjmsMessage;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsSession;
import oracle.jms.AQjmsUtil;

public class AQjmsMapMessage
extends AQjmsMessage
implements MapMessage {
    private byte[] m_bytesData = new byte[0];
    private HashMap m_map;
    private boolean m_dirty = false;

    public AQjmsMapMessage() {
        super(true);
        this.m_map = new HashMap();
        this.m_dirty = true;
        this.access_mode = 2;
    }

    AQjmsMapMessage(AQjmsSession aQjmsSession) {
        super(aQjmsSession, true);
        this.m_map = new HashMap();
        this.m_dirty = true;
        this.access_mode = 2;
    }

    AQjmsMapMessage(AQjmsMessage aQjmsMessage) {
        super(aQjmsMessage);
        this.m_map = new HashMap();
        this.m_dirty = true;
    }

    AQjmsMapMessage(AQjmsSession aQjmsSession, AQjmsMapMessage_C aQjmsMapMessage_C) throws JMSException {
        super(aQjmsSession, true);
        try {
            this.header_ext = aQjmsMapMessage_C.getHeader();
            this.readMapMessageContainer(aQjmsMapMessage_C);
            this.m_dirty = false;
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
        this.access_mode = 0;
    }

    AQjmsMapMessage(AQjmsSession aQjmsSession, AQjmsGenMessage_C aQjmsGenMessage_C) throws JMSException {
        super(aQjmsSession, true);
        try {
            this.header_ext = aQjmsGenMessage_C.getHeader();
            this.readGenMessageContainer(aQjmsGenMessage_C);
            this.m_dirty = false;
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
        this.access_mode = 0;
    }

    AQjmsMapMessage(AQjmsSession aQjmsSession, byte[] byArray) throws JMSException {
        super(aQjmsSession, true);
        if (byArray != null) {
            this.m_bytesData = byArray;
        }
        this.m_dirty = false;
        this.access_mode = 0;
    }

    byte[] getHashTable() throws JMSException {
        this.updateBytesDataFromMap();
        return this.m_bytesData;
    }

    public void setBoolean(String string, boolean bl) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkMapName(string);
        this.getMap().put(string, new Boolean(bl));
        this.m_dirty = true;
    }

    public void setByte(String string, byte by) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkMapName(string);
        this.getMap().put(string, new Byte(by));
        this.m_dirty = true;
    }

    public void setShort(String string, short s) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkMapName(string);
        this.getMap().put(string, new Short(s));
        this.m_dirty = true;
    }

    public void setChar(String string, char c) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkMapName(string);
        this.getMap().put(string, new Character(c));
        this.m_dirty = true;
    }

    public void setDouble(String string, double d) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkMapName(string);
        this.getMap().put(string, new Double(d));
        this.m_dirty = true;
    }

    public void setFloat(String string, float f) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkMapName(string);
        this.getMap().put(string, new Float(f));
        this.m_dirty = true;
    }

    public void setInt(String string, int n) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkMapName(string);
        this.getMap().put(string, new Integer(n));
        this.m_dirty = true;
    }

    public void setLong(String string, long l) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkMapName(string);
        this.getMap().put(string, new Long(l));
        this.m_dirty = true;
    }

    public void setString(String string, String string2) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkMapName(string);
        this.getMap().put(string, string2);
        this.m_dirty = true;
    }

    public void setObject(String string, Object object) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkMapName(string);
        if (object == null || object instanceof Integer || object instanceof Character || object instanceof Long || object instanceof Float || object instanceof Short || object instanceof Byte || object instanceof Double || object instanceof String || object instanceof byte[] || object instanceof Boolean) {
            this.getMap().put(string, object);
        } else {
            AQjmsError.throwMsgFormatEx(161, null);
        }
        this.m_dirty = true;
    }

    public void setBytes(String string, byte[] byArray) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkMapName(string);
        byte[] byArray2 = null;
        if (byArray != null) {
            byArray2 = new byte[byArray.length];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        }
        this.getMap().put(string, byArray2);
        this.m_dirty = true;
    }

    public void setBytes(String string, byte[] byArray, int n, int n2) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkMapName(string);
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        this.getMap().put(string, byArray2);
        this.m_dirty = true;
    }

    private void checkMapName(String string) {
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException("Illegal attempt to set null or empty name in MapMessage.");
        }
    }

    public boolean getBoolean(String string) throws JMSException {
        Object v = this.getMap().get(string);
        boolean bl = false;
        if (v instanceof Boolean) {
            bl = (Boolean)v;
        } else if (v == null || v instanceof String) {
            bl = Boolean.valueOf((String)v);
        } else {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        return bl;
    }

    public byte getByte(String string) throws JMSException {
        Object v = this.getMap().get(string);
        byte by = 0;
        if (v instanceof Byte) {
            by = (Byte)v;
        } else if (v == null || v instanceof String) {
            by = Byte.valueOf((String)v);
        } else {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        return by;
    }

    public byte[] getBytes(String string) throws JMSException {
        Object v = this.getMap().get(string);
        byte[] byArray = null;
        if (v == null) {
            byArray = null;
        } else if (v instanceof byte[]) {
            byte[] byArray2 = (byte[])v;
            byArray = new byte[byArray2.length];
            System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
        } else {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        return byArray;
    }

    public char getChar(String string) throws JMSException {
        Object v = this.getMap().get(string);
        char c = '\u0000';
        if (v instanceof Character) {
            c = ((Character)v).charValue();
        } else {
            if (v == null) {
                throw new NullPointerException("read a null value as a char");
            }
            AQjmsError.throwMsgFormatEx(117, null);
        }
        return c;
    }

    public double getDouble(String string) throws JMSException {
        Object v = this.getMap().get(string);
        double d = 0.0;
        if (v instanceof Float) {
            d = ((Float)v).floatValue();
        } else if (v instanceof Double) {
            d = (Double)v;
        } else if (v == null || v instanceof String) {
            d = Double.valueOf((String)v);
        } else {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        return d;
    }

    public float getFloat(String string) throws JMSException {
        Object v = this.getMap().get(string);
        float f = 0.0f;
        if (v instanceof Float) {
            f = ((Float)v).floatValue();
        } else if (v == null || v instanceof String) {
            f = Float.valueOf((String)v).floatValue();
        } else {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        return f;
    }

    public int getInt(String string) throws JMSException {
        Object v = this.getMap().get(string);
        int n = 0;
        if (v instanceof Byte) {
            n = ((Byte)v).byteValue();
        } else if (v instanceof Short) {
            n = ((Short)v).shortValue();
        } else if (v instanceof Integer) {
            n = (Integer)v;
        } else if (v == null || v instanceof String) {
            n = Integer.valueOf((String)v);
        } else {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        return n;
    }

    public long getLong(String string) throws JMSException {
        Object v = this.getMap().get(string);
        long l = 0L;
        if (v instanceof Byte) {
            l = ((Byte)v).byteValue();
        } else if (v instanceof Short) {
            l = ((Short)v).shortValue();
        } else if (v instanceof Integer) {
            l = ((Integer)v).intValue();
        } else if (v instanceof Long) {
            l = (Long)v;
        } else if (v == null || v instanceof String) {
            l = Long.valueOf((String)v);
        } else {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        return l;
    }

    public Enumeration getMapNames() throws JMSException {
        return Collections.enumeration(this.getMap().keySet());
    }

    public Object getObject(String string) throws JMSException {
        Object v = this.getMap().get(string);
        if (v == null || v instanceof Boolean || v instanceof Byte || v instanceof Character || v instanceof Double || v instanceof Float || v instanceof Integer || v instanceof Long || v instanceof Short || v instanceof String || v instanceof byte[]) {
            return v;
        }
        AQjmsError.throwEx(122, "Corrupted message");
        return v;
    }

    public short getShort(String string) throws JMSException {
        Object v = this.getMap().get(string);
        short s = 0;
        if (v instanceof Byte) {
            s = ((Byte)v).byteValue();
        } else if (v instanceof Short) {
            s = (Short)v;
        } else if (v == null || v instanceof String) {
            s = Short.valueOf((String)v);
        } else {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        return s;
    }

    public String getString(String string) throws JMSException {
        Object v = this.getMap().get(string);
        String string2 = null;
        if (v instanceof Integer || v instanceof Character || v instanceof Long || v instanceof Float || v instanceof Short || v instanceof Byte || v instanceof Double || v instanceof String || v instanceof Boolean) {
            string2 = v.toString();
        } else if (v == null || v instanceof String) {
            string2 = (String)v;
        } else {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        return string2;
    }

    public boolean itemExists(String string) throws JMSException {
        return this.getMap().containsKey(string);
    }

    @Override
    public void clearBody() throws JMSException {
        if (this.m_map == null) {
            this.m_map = new HashMap();
        } else {
            this.m_map.clear();
        }
        this.m_dirty = true;
        this.setAccessMode(2);
    }

    @Override
    OracleData getMessageCont(AQjmsSession aQjmsSession, boolean bl, boolean bl2) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsMapMessage.getMessageCont", "entry");
        this.updateBytesDataFromMap();
        AQjmsMapMessage_C aQjmsMapMessage_C = new AQjmsMapMessage_C();
        boolean[] blArray = new boolean[1];
        this.m_tempLob = AQjmsUtil.populateBytesContainer(aQjmsMapMessage_C, 3, this.header_ext, this.m_bytesData, aQjmsSession, bl, blArray, bl2);
        this.setWriteLobLater(blArray[0]);
        AQjmsOracleDebug.trace(4, "AQjmsMapMessage.getMessageCont", "exit");
        return aQjmsMapMessage_C;
    }

    @Override
    AQjmsGenMessage_C getGenMessageCont(AQjmsSession aQjmsSession, boolean bl, boolean bl2) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsMapMessage.getGenMessageCont", "entry");
        this.updateBytesDataFromMap();
        AQjmsGenMessage_C aQjmsGenMessage_C = new AQjmsGenMessage_C();
        boolean[] blArray = new boolean[1];
        this.m_tempLob = AQjmsUtil.populateBytesContainer(aQjmsGenMessage_C, 3, this.header_ext, this.m_bytesData, aQjmsSession, bl, blArray, bl2);
        this.setWriteLobLater(blArray[0]);
        AQjmsOracleDebug.trace(4, "AQjmsMapMessage.getGenMessageCont", "exit");
        return aQjmsGenMessage_C;
    }

    @Override
    void writeLob(AQjmsSession aQjmsSession, String string, byte[] byArray, boolean bl) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsMapmessage.writeLob", "entry");
        if (this.m_writeLobLater) {
            AQjmsUtil.writeBlob(this.m_bytesData, aQjmsSession, string, byArray, bl);
        }
        AQjmsOracleDebug.trace(4, "AQjmsMapmessage.writeLob", "exit");
    }

    private void readMapMessageContainer(AQjmsMapMessage_C aQjmsMapMessage_C) throws JMSException {
        try {
            this.m_bytesData = AQjmsUtil.getBytesData(aQjmsMapMessage_C.getBytesLen(), aQjmsMapMessage_C.getBytesLob(), aQjmsMapMessage_C.getBytesRaw());
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
        if (this.m_bytesData == null) {
            this.m_bytesData = new byte[0];
        }
    }

    private void readGenMessageContainer(AQjmsGenMessage_C aQjmsGenMessage_C) throws JMSException {
        try {
            this.m_bytesData = AQjmsUtil.getBytesData(aQjmsGenMessage_C.getBytesLen(), aQjmsGenMessage_C.getBytesLob(), aQjmsGenMessage_C.getBytesRaw());
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
        if (this.m_bytesData == null) {
            this.m_bytesData = new byte[0];
        }
    }

    private void updateBytesDataFromMap() throws JMSException {
        if (this.m_dirty) {
            this.m_bytesData = AQjmsMapMessage.convertHashMapToByteArray(this.m_map);
            this.m_dirty = false;
        }
    }

    private Map getMap() throws JMSException {
        if (this.m_map == null) {
            this.m_map = AQjmsMapMessage.convertByteArrayToHashMap(this.m_bytesData);
        }
        return this.m_map;
    }

    private static byte[] convertHashMapToByteArray(HashMap hashMap) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsMapMessage.convertHashMapToByteArray", "entry");
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(hashMap);
            AQjmsOracleDebug.trace(4, "AQjmsMapMessage.convertHashMapToByteArray", "exit");
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsMapMessage.convertHashMapToByteArray IO", iOException);
            AQjmsError.throwEx(157, (Throwable)iOException);
            return null;
        }
    }

    private static HashMap convertByteArrayToHashMap(byte[] byArray) throws JMSException {
        HashMap hashMap = null;
        AQjmsOracleDebug.trace(4, "AQjmsMapMessage.convertByteArrayToHashMap", "entry");
        if (byArray == null) {
            byArray = new byte[]{};
        }
        try {
            ByteArrayInputStream byteArrayInputStream;
            ObjectInputStream objectInputStream;
            Object object;
            hashMap = byArray.length == 0 ? new HashMap() : ((object = (objectInputStream = new ObjectInputStream(byteArrayInputStream = new ByteArrayInputStream(byArray))).readObject()) instanceof Hashtable ? new HashMap((Map)object) : (HashMap)object);
        }
        catch (ClassNotFoundException classNotFoundException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsMapMessage.convertByteArrayToHashMap CNF", classNotFoundException);
            AQjmsError.throwEx(109, (Throwable)classNotFoundException);
            return null;
        }
        catch (InvalidClassException invalidClassException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsMapMessage.convertByteArrayToHashMap ICE", invalidClassException);
            AQjmsError.throwEx(156, (Throwable)invalidClassException);
        }
        catch (IOException iOException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsMapMessage.convertByteArrayToHashMap IO", iOException);
            AQjmsError.throwEx(157, (Throwable)iOException);
        }
        AQjmsOracleDebug.trace(4, "AQjmsMapMessage.convertByteArrayToHashMap", "exit");
        return hashMap;
    }

    @Override
    byte[] getBytesCont() throws JMSException {
        this.updateBytesDataFromMap();
        return this.m_bytesData;
    }
}

