/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.AQ.xml;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.jakarta.AQ.xml.AQxmlClientRequest;
import oracle.jakarta.AQ.xml.AQxmlCommitRequest;
import oracle.jakarta.AQ.xml.AQxmlCommitResponse;
import oracle.jakarta.AQ.xml.AQxmlDebug;
import oracle.jakarta.AQ.xml.AQxmlDocument;
import oracle.jakarta.AQ.xml.AQxmlError;
import oracle.jakarta.AQ.xml.AQxmlException;
import oracle.jakarta.AQ.xml.AQxmlFault;
import oracle.jakarta.AQ.xml.AQxmlIdapRespConverter;
import oracle.jakarta.AQ.xml.AQxmlPushResponse;
import oracle.jakarta.AQ.xml.AQxmlRespConverter;
import oracle.jakarta.AQ.xml.AQxmlRollbackRequest;
import oracle.jakarta.AQ.xml.AQxmlRollbackResponse;
import oracle.jakarta.AQ.xml.AQxmlSequenceNumRequest;
import oracle.jakarta.AQ.xml.AQxmlSequenceNumResponse;
import oracle.jakarta.AQ.xml.AQxmlTypeInfoRequest;
import oracle.jakarta.AQ.xml.AQxmlTypeInfoResponse;
import oracle.jdbc.OracleDriver;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLParseException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class AQxmlUtil {
    static int ORA_ERROR = 1;
    static int QUEUE_TYPE_MISMATCH = 2;
    static int AQXML_ERROR = 3;
    static int AQJMS_ERROR = 4;
    static int XML_PARSE_ERROR = 5;
    static int HTTP_FAIL = 6;
    static int IO_ERROR = 7;
    static String cookie = null;
    static HttpURLConnection urlConn = null;
    static DOMParser domP = null;
    static AQxmlIdapRespConverter idapAdap = null;
    static FileOutputStream mylogstrm = null;

    public static void commitRequest(String[] req) {
        AQxmlCommitRequest com_req = null;
        XMLDocument xml_doc = new XMLDocument();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        Object fhdl = null;
        try {
            AQxmlDebug.println("commitRequest:Enter");
            com_req = new AQxmlCommitRequest();
            AQxmlUtil.generateDOMDocument((Document)xml_doc, com_req);
            xml_doc.print(pw);
            req[0] = sw.toString();
            AQxmlDebug.println("commitRequest:Exit");
        }
        catch (AQxmlException aQxmlException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void rollbackRequest(String[] req) {
        AQxmlRollbackRequest roll_req = null;
        XMLDocument xml_doc = new XMLDocument();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        Object fhdl = null;
        try {
            AQxmlDebug.println("rollbackRequest:Enter");
            roll_req = new AQxmlRollbackRequest();
            AQxmlUtil.generateDOMDocument((Document)xml_doc, roll_req);
            xml_doc.print(pw);
            req[0] = sw.toString();
            AQxmlDebug.println("rollbackRequest:Exit");
        }
        catch (AQxmlException aQxmlException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void seqNumRequest(String dblink, String queue, int qid, String[] req) {
        AQxmlSequenceNumRequest seq_req = null;
        XMLDocument xml_doc = new XMLDocument();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        Object fhdl = null;
        try {
            AQxmlDebug.println("seqNumRequest:Enter");
            seq_req = new AQxmlSequenceNumRequest(dblink, queue, String.valueOf(qid));
            seq_req.setAutoCommit(true);
            AQxmlUtil.generateDOMDocument((Document)xml_doc, seq_req);
            xml_doc.print(pw);
            req[0] = sw.toString();
            AQxmlDebug.println("seqNumRequest:Exit");
        }
        catch (AQxmlException aQxmlException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void getTypeInfo(String remqueue, String[] req) {
        AQxmlTypeInfoRequest typ_req = null;
        XMLDocument xml_doc = new XMLDocument();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        Object fhdl = null;
        try {
            AQxmlDebug.println("getTypeInfo:Enter");
            typ_req = new AQxmlTypeInfoRequest(remqueue);
            typ_req.setAutoCommit(true);
            AQxmlUtil.generateDOMDocument((Document)xml_doc, typ_req);
            xml_doc.print(pw);
            req[0] = sw.toString();
            AQxmlDebug.println("getTypeInfo:Exit");
        }
        catch (AQxmlException aQxmlException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void decodeCommitResp(String response, int[] status, int[] err_typ, int[] err_code, String[] err_msg) {
        AQxmlDocument[] resps = null;
        AQxmlFault fault_resp = null;
        AQxmlCommitResponse com_resp = null;
        try {
            AQxmlDebug.println("decodeCommitResp:Enter");
            resps = AQxmlUtil.decode(response);
            for (int i = 0; i < resps.length && resps[i] != null; ++i) {
                if (resps[i] instanceof AQxmlFault) {
                    fault_resp = (AQxmlFault)resps[i];
                    status[0] = fault_resp.getStatusResponse().getStatusCode();
                } else {
                    if (!(resps[i] instanceof AQxmlCommitResponse)) continue;
                    com_resp = (AQxmlCommitResponse)resps[i];
                    status[0] = com_resp.getStatusResponse().getStatusCode();
                }
                if (status[0] != 0) {
                    err_code[0] = fault_resp.getStatusResponse().getErrorCode();
                    err_msg[0] = fault_resp.getStatusResponse().getErrorMessage();
                } else {
                    err_code[0] = 0;
                    err_msg[0] = null;
                }
                break;
            }
        }
        catch (AQxmlException aQxmlException) {
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        AQxmlDebug.println("decodeCommitResp:Exit");
    }

    public static void decodeRollbackResp(String response, int[] status, int[] err_typ, int[] err_code, String[] err_msg) {
        AQxmlDocument[] resps = null;
        AQxmlRollbackResponse roll_resp = null;
        AQxmlFault fault_resp = null;
        try {
            AQxmlDebug.println("decodeRollbackResp:Enter");
            resps = AQxmlUtil.decode(response);
            for (int i = 0; i < resps.length && resps[i] != null; ++i) {
                if (resps[i] instanceof AQxmlFault) {
                    fault_resp = (AQxmlFault)resps[i];
                    status[0] = fault_resp.getStatusResponse().getStatusCode();
                } else {
                    if (!(resps[i] instanceof AQxmlRollbackResponse)) continue;
                    roll_resp = (AQxmlRollbackResponse)resps[i];
                    status[0] = roll_resp.getStatusResponse().getStatusCode();
                }
                if (status[0] != 0) {
                    err_code[0] = fault_resp.getStatusResponse().getErrorCode();
                    err_msg[0] = fault_resp.getStatusResponse().getErrorMessage();
                } else {
                    err_code[0] = 0;
                    err_msg[0] = null;
                }
                break;
            }
        }
        catch (AQxmlException aQxmlException) {
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        AQxmlDebug.println("decodeRollbackResp:Exit");
    }

    public static void decodePushResp(String response, ARRAY[] mids, int[] status, int[] err_typ, int[] err_code, String[] err_msg) {
        OracleDriver ora_drv = null;
        Connection db_conn = null;
        AQxmlDocument[] resps = null;
        AQxmlPushResponse push_resp = null;
        AQxmlFault fault_resp = null;
        String[] mid_arr = null;
        String[][] mid_arrs = null;
        ArrayDescriptor ads = null;
        int cnt = 0;
        AQxmlDebug.println("decodePushResp:Enter");
        try {
            ora_drv = new OracleDriver();
            db_conn = ora_drv.defaultConnection();
            ads = ArrayDescriptor.createDescriptor((String)"SYS.AQ$_MIDARRAY", (Connection)db_conn);
        }
        catch (SQLException ex) {
            AQxmlDebug.traceEx(3, "AQxmlUtil.decodePushResp", ex);
        }
        try {
            resps = AQxmlUtil.decode(response);
            mid_arrs = new String[resps.length][];
            for (int j = 0; j < resps.length && resps[j] != null; ++j) {
                if (resps[j] instanceof AQxmlFault) {
                    fault_resp = (AQxmlFault)resps[j];
                    status[0] = fault_resp.getStatusResponse().getStatusCode();
                } else {
                    if (!(resps[j] instanceof AQxmlPushResponse)) continue;
                    push_resp = (AQxmlPushResponse)resps[j];
                    status[0] = push_resp.getStatusResponse().getStatusCode();
                }
                if (status[0] != 0) {
                    AQxmlDebug.println("decodePushResp:Error");
                    err_typ[0] = AQXML_ERROR;
                    err_code[0] = fault_resp.getStatusResponse().getErrorCode();
                    err_msg[0] = fault_resp.getStatusResponse().getErrorMessage();
                    mids[0] = new ARRAY(ads, db_conn, (Object)mid_arr);
                    break;
                }
                AQxmlDebug.println("decodePushResp:Success");
                err_code[0] = 0;
                err_typ[0] = 0;
                err_msg[0] = "NO ERROR";
                mid_arr = new String[push_resp.getMsgidCount()];
                mid_arrs[j] = mid_arr;
                for (int i = 0; i < push_resp.getMsgidCount(); ++i) {
                    mid_arr[i] = push_resp.getMessageId(i);
                    ++cnt;
                }
            }
            mid_arr = new String[cnt];
            int k = 0;
            for (int i = 0; i < mid_arrs.length && mid_arrs[i] != null; ++i) {
                for (int j = 0; j < mid_arrs[i].length && mid_arrs[i][j] != null; ++j) {
                    mid_arr[k++] = mid_arrs[i][j];
                }
            }
            mids[0] = new ARRAY(ads, db_conn, (Object)mid_arr);
        }
        catch (AQxmlException ex) {
            AQxmlDebug.println("decodePushResp:Exp1");
            err_typ[0] = AQXML_ERROR;
        }
        catch (XMLParseException pe) {
            err_typ[0] = XML_PARSE_ERROR;
        }
        catch (SAXException sae) {
            err_typ[0] = XML_PARSE_ERROR;
        }
        catch (IOException ioe) {
            err_typ[0] = IO_ERROR;
        }
        catch (SQLException sx) {
            err_typ[0] = ORA_ERROR;
        }
        AQxmlDebug.println("decodePushResp:Exit");
    }

    public static void decodeQtypeResp(String response, byte[][] toid, int[] version, byte[][] tds, int[] rc, int[] status, int[] err_typ, int[] err_code, String[] err_msg) {
        AQxmlDocument[] resps = null;
        AQxmlTypeInfoResponse qtyp_resp = null;
        AQxmlFault fault_resp = null;
        try {
            AQxmlDebug.println("decodeRollbackResp:Enter");
            resps = AQxmlUtil.decode(response);
            for (int i = 0; i < resps.length && resps[i] != null; ++i) {
                if (resps[i] instanceof AQxmlFault) {
                    fault_resp = (AQxmlFault)resps[i];
                    status[0] = fault_resp.getStatusResponse().getStatusCode();
                } else {
                    if (!(resps[i] instanceof AQxmlTypeInfoResponse)) continue;
                    qtyp_resp = (AQxmlTypeInfoResponse)resps[i];
                    status[0] = qtyp_resp.getStatusResponse().getStatusCode();
                }
                if (status[0] != 0) {
                    err_typ[0] = AQXML_ERROR;
                    err_code[0] = fault_resp.getStatusResponse().getErrorCode();
                    err_msg[0] = fault_resp.getStatusResponse().getErrorMessage();
                } else {
                    err_code[0] = 0;
                    err_msg[0] = null;
                    Integer int_obj = new Integer(qtyp_resp.getReturnCode());
                    rc[0] = int_obj;
                    toid[0] = AQxmlRespConverter.convertHexStringToByte(qtyp_resp.getTypeId());
                    int_obj = new Integer(qtyp_resp.getVersion());
                    version[0] = int_obj;
                    tds[0] = AQxmlRespConverter.convertHexStringToByte(qtyp_resp.getTypeDescriptor());
                }
                break;
            }
        }
        catch (AQxmlException aQxmlException) {
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        AQxmlDebug.println("decodeQueueTypeResp:Exit");
    }

    public static void decodeSeqnumResp(String response, long[] seqnum, int[] status, int[] err_typ, int[] err_code, String[] err_msg) {
        AQxmlSequenceNumResponse seq_resp = null;
        AQxmlDocument[] resps = null;
        AQxmlFault fault_resp = null;
        try {
            AQxmlDebug.println("decodeSeqnumResp:Enter");
            resps = AQxmlUtil.decode(response);
            for (int i = 0; i < resps.length && resps[i] != null; ++i) {
                if (resps[i] instanceof AQxmlFault) {
                    fault_resp = (AQxmlFault)resps[i];
                    status[0] = fault_resp.getStatusResponse().getStatusCode();
                } else {
                    if (!(resps[i] instanceof AQxmlSequenceNumResponse)) continue;
                    seq_resp = (AQxmlSequenceNumResponse)resps[i];
                    status[0] = seq_resp.getStatusResponse().getStatusCode();
                }
                if (status[0] != 0) {
                    err_typ[0] = AQXML_ERROR;
                    err_code[0] = fault_resp.getStatusResponse().getErrorCode();
                    err_msg[0] = fault_resp.getStatusResponse().getErrorMessage();
                } else {
                    err_code[0] = 0;
                    err_msg[0] = null;
                    Long long_obj = new Long(seq_resp.getSequenceNumber());
                    seqnum[0] = long_obj;
                }
                break;
            }
        }
        catch (AQxmlException aQxmlException) {
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        AQxmlDebug.println("decodeSequenceNumResp:Exit");
    }

    static AQxmlDocument[] decode(String response) throws XMLParseException, IOException, SAXException, AQxmlException {
        AQxmlDocument[] retDoc = null;
        AQxmlDebug.println("decodeSequenceNumResp:Exit");
        StringReader data_stream = new StringReader(response);
        domP.parse((Reader)data_stream);
        XMLDocument doc = domP.getDocument();
        idapAdap.setDocument((Document)doc);
        retDoc = idapAdap.generateAQxmlDocument();
        return retDoc;
    }

    public static void generateDOMDocument(Document response_doc, AQxmlDocument aqxml_doc) throws AQxmlException {
        Element root_elem = null;
        Element body_node = null;
        Element root_node = null;
        AQxmlDebug.trace(4, "AQxmlUtil.generateDOMDocument", "Entry");
        ((XMLDocument)response_doc).setVersion("1.0");
        root_elem = ((XMLDocument)response_doc).createElementNS("http://ns.oracle.com/AQ/schemas/envelope", "Envelope");
        ((XMLElement)root_elem).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://ns.oracle.com/AQ/schemas/envelope");
        response_doc.appendChild(root_elem);
        root_node = response_doc.getDocumentElement();
        body_node = ((XMLDocument)response_doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "Body");
        root_node.appendChild(body_node);
        if (aqxml_doc instanceof AQxmlCommitRequest) {
            AQxmlUtil.genCommitRequestXml(response_doc, (AQxmlCommitRequest)aqxml_doc, body_node);
        } else if (aqxml_doc instanceof AQxmlRollbackRequest) {
            AQxmlUtil.genRollbackRequestXml(response_doc, (AQxmlRollbackRequest)aqxml_doc, body_node);
        } else if (aqxml_doc instanceof AQxmlSequenceNumRequest) {
            AQxmlUtil.genSequenceNumRequestXml(response_doc, (AQxmlSequenceNumRequest)aqxml_doc, body_node);
        } else if (aqxml_doc instanceof AQxmlTypeInfoRequest) {
            AQxmlUtil.genTypeInfoRequestXml(response_doc, (AQxmlTypeInfoRequest)aqxml_doc, body_node);
        } else {
            AQxmlDebug.trace(3, "AQxmlUtil.generateDOMDocument", "Invalid class: " + aqxml_doc.getClass().getName());
        }
    }

    static void genCommitRequestXml(Document doc, AQxmlCommitRequest aqxml_doc, Node idap_body_node) throws AQxmlException {
        AQxmlDebug.trace(4, "AQxmlUtil.genCommitRequestXml", "entry");
        aqxml_doc.setTagName("AQXmlCommit");
        AQxmlUtil.genClientRequestXml(doc, aqxml_doc, idap_body_node);
        AQxmlDebug.trace(4, "AQxmlUtil.genCommitRequestXml", "exit");
    }

    static void genRollbackRequestXml(Document doc, AQxmlRollbackRequest aqxml_doc, Node idap_body_node) throws AQxmlException {
        AQxmlDebug.trace(4, "AQxmlUtil.genRollbackRequestXml", "entry");
        aqxml_doc.setTagName("AQXmlRollback");
        AQxmlUtil.genClientRequestXml(doc, aqxml_doc, idap_body_node);
        AQxmlDebug.trace(4, "AQxmlUtil.genRollbackRequestXml", "exit");
    }

    static void genSequenceNumRequestXml(Document doc, AQxmlSequenceNumRequest aqxml_doc, Node idap_body_node) throws AQxmlException {
        Object com_elem = null;
        AQxmlDebug.trace(4, "AQxmlUtil.genSequenceNumRequestXml", "entry");
        aqxml_doc.setTagName("AQXmlSequenceNumber");
        AQxmlUtil.genClientRequestXml(doc, aqxml_doc, idap_body_node);
        Node seqNumNode = idap_body_node.getFirstChild();
        Element queueNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "destination");
        seqNumNode.appendChild(queueNode);
        Text queueTextNode = doc.createTextNode(aqxml_doc.getDestination());
        queueNode.appendChild(queueTextNode);
        Element dbNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "database_link");
        seqNumNode.appendChild(dbNode);
        Text dbTextNode = doc.createTextNode(aqxml_doc.getDatabaseLink());
        dbNode.appendChild(dbTextNode);
        Element qidNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "source_qid");
        seqNumNode.appendChild(qidNode);
        String qid = aqxml_doc.getQid();
        Text qidTextNode = doc.createTextNode(String.valueOf(qid));
        qidNode.appendChild(qidTextNode);
        if (aqxml_doc.getAutoCommit()) {
            AQxmlUtil.genAutoCommitXml(doc, seqNumNode);
        }
        AQxmlDebug.trace(4, "AQxmlUtil.genSequenceNumRequestXml", "exit");
    }

    static void genTypeInfoRequestXml(Document doc, AQxmlTypeInfoRequest aqxml_doc, Node idap_body_node) throws AQxmlException {
        Object com_elem = null;
        AQxmlDebug.trace(4, "AQxmlUtil.genTypeInfoRequestXml", "entry");
        aqxml_doc.setTagName("AQXmlQueueTypeInfo");
        AQxmlUtil.genClientRequestXml(doc, aqxml_doc, idap_body_node);
        Node queueTypeReqNode = idap_body_node.getFirstChild();
        Element destinationNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "destination");
        queueTypeReqNode.appendChild(destinationNode);
        Text destTextNode = doc.createTextNode(aqxml_doc.getQueue());
        destinationNode.appendChild(destTextNode);
        if (aqxml_doc.getAutoCommit()) {
            AQxmlUtil.genAutoCommitXml(doc, queueTypeReqNode);
        }
        AQxmlDebug.trace(4, "AQxmlUtil.genTypeInfoRequestXml", "exit");
    }

    static void genClientRequestXml(Document doc, AQxmlClientRequest aqxml_doc, Node idap_body_node) throws AQxmlException {
        XMLElement elem = null;
        AQxmlDebug.trace(4, "AQxmlUtil.genClientRequestXml", "entry");
        if (aqxml_doc.tag_name == null) {
            AQxmlError.throwAQEx(401, "Tag name: null");
        }
        elem = new XMLElement(aqxml_doc.tag_name, "", "http://ns.oracle.com/AQ/schemas/access");
        elem.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://ns.oracle.com/AQ/schemas/access");
        if (idap_body_node == null) {
            AQxmlError.throwAQEx(401, "Idap Body Node: Null");
        }
        idap_body_node.appendChild((Node)elem);
        AQxmlDebug.trace(4, "AQxmlUtil.genClientRequestXml", "exit");
    }

    static void genAutoCommitXml(Document doc, Node node) {
        Element com_node = null;
        com_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "AQXmlCommit");
        node.appendChild(com_node);
    }

    static {
        domP = new DOMParser();
        domP.setPreserveWhitespace(false);
        idapAdap = new AQxmlIdapRespConverter();
        try {
            mylogstrm = new FileOutputStream("/tmp/servletout.log");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

