/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.AQ.xml;

import java.net.InetAddress;
import java.rmi.server.UID;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Random;
import javax.transaction.xa.Xid;
import oracle.jakarta.AQ.xml.AQxmlDebug;
import oracle.jakarta.AQ.xml.AQxmlError;
import oracle.jakarta.AQ.xml.AQxmlException;
import oracle.jdbc.xa.OracleXid;

class AQxmlXid {
    static final int UID_VERSION = 224;
    static final int FORMAT_ID = 1221;
    static final int AQXID_TYPE = 12;

    AQxmlXid() {
    }

    static void main(String[] args) throws AQxmlException {
        String suid = null;
        int iter = 1;
        Integer type = new Integer(12);
        AQxmlXid xid = new AQxmlXid();
        if (args.length > 0) {
            iter = Integer.parseInt(args[0]);
        }
        for (int j = 0; j < iter; ++j) {
            Xid my_uid = AQxmlXid.createXid(type.byteValue(), 1);
            suid = AQxmlXid.ByteArraytoString(my_uid.getGlobalTransactionId());
            AQxmlDebug.trace(3, "AQxmlXid UUID: ", suid);
        }
    }

    static Xid createXid() throws AQxmlException {
        return AQxmlXid.createXid((byte)12, 1);
    }

    static Xid createXid(byte type, int br_id) throws AQxmlException {
        String host = null;
        String str = null;
        int last_idx = 0;
        int idx = 0;
        InetAddress iaddr = null;
        OracleXid ret_xid = null;
        byte[] uid = new byte[16];
        Date dt = new Date();
        Timestamp tv = new Timestamp(dt.getTime());
        long tv_sec = tv.getTime();
        long tv_usec = tv.getNanos() / 1000;
        long x = (tv_sec & 0xFFFFL) * 16960L;
        long l = x & 0xFFFFL;
        x = (tv_sec & 0xFFFFL) * 15L + (x >> 16);
        long h = x >> 16;
        x = (tv_sec >> 16) * 16960L + (x & 0xFFFFL);
        h += (tv_sec >> 16) * 15L + (x >> 16);
        if (tv_usec >= ((l += (x & 0xFFFFL) << 16) ^ 0xFFFFFFFFFFFFFFFFL)) {
            ++h;
        }
        l += tv_usec;
        try {
            iaddr = InetAddress.getLocalHost();
        }
        catch (Exception ex) {
            AQxmlDebug.traceEx(3, "AQxmlXid.createXid", ex);
            AQxmlError.throwAQEx(401, ex);
        }
        Long lt = new Long(h >> 8);
        uid[0] = lt.byteValue();
        lt = new Long(h);
        uid[1] = lt.byteValue();
        lt = new Long(l >> 24);
        uid[2] = lt.byteValue();
        lt = new Long(l >> 16);
        uid[3] = lt.byteValue();
        lt = new Long(l >> 8);
        uid[4] = lt.byteValue();
        lt = new Long(l);
        uid[5] = lt.byteValue();
        Random rand = new Random();
        int r = rand.nextInt();
        lt = new Long(r >> 8);
        uid[6] = lt.byteValue();
        lt = new Long(r);
        uid[7] = lt.byteValue();
        lt = new Long(0xE0 | type);
        uid[8] = lt.byteValue();
        lt = new Long(iaddr.hashCode());
        uid[9] = lt.byteValue();
        host = iaddr.getHostAddress();
        idx = host.indexOf(46);
        last_idx = 0;
        for (int j = 0; j < 4; ++j) {
            str = idx > 0 ? host.substring(last_idx, idx) : host.substring(last_idx);
            Integer val = Integer.valueOf(str);
            if (str != null) {
                uid[10 + j] = val.byteValue();
            }
            last_idx = idx + 1;
            idx = host.indexOf(46, idx + 1);
        }
        UID muid = new UID();
        h = muid.hashCode();
        lt = new Long(h >> 8);
        uid[14] = lt.byteValue();
        lt = new Long(h);
        uid[15] = lt.byteValue();
        byte[] gtrid = new byte[64];
        byte[] bid = new byte[64];
        bid[0] = (byte)br_id;
        System.arraycopy(uid, 0, gtrid, 0, 16);
        try {
            ret_xid = new OracleXid(1221, gtrid, bid);
        }
        catch (Exception ex) {
            AQxmlDebug.traceEx(3, "AQxmlProcessor.createXid", ex);
            AQxmlError.throwAQEx(401, "OracleXid exception", ex);
        }
        return ret_xid;
    }

    void initUid(byte[] uid) {
        if (uid[5] == 255) {
            if (uid[4] == 255) {
                if (uid[3] == 255) {
                    if (uid[2] == 255) {
                        if (uid[1] == 255) {
                            uid[0] = uid[0] == 255 ? (byte)0 : (byte)(uid[0] + 1);
                            uid[1] = 0;
                        } else {
                            uid[1] = (byte)(uid[1] + 1);
                        }
                        uid[2] = 0;
                    } else {
                        uid[2] = (byte)(uid[2] + 1);
                    }
                    uid[3] = 0;
                } else {
                    uid[3] = (byte)(uid[3] + 1);
                }
                uid[4] = 0;
            } else {
                uid[4] = (byte)(uid[4] + 1);
            }
            uid[5] = 0;
        } else {
            uid[5] = (byte)(uid[5] + 1);
        }
    }

    static String ByteArraytoString(byte[] b) {
        StringBuffer buf = new StringBuffer();
        if (b == null) {
            buf.append("<Null byte array!>");
        } else {
            int n = b.length;
            for (int i = 0; i < n; ++i) {
                int v = b[i] & 0xFF;
                if (v < 16) {
                    buf.append("0" + Integer.toHexString(v));
                    continue;
                }
                buf.append(Integer.toHexString(v));
            }
        }
        return buf.toString();
    }
}

