/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.jms;

import jakarta.jms.JMSException;
import jakarta.jms.JMSRuntimeException;
import jakarta.jms.XAConnection;
import jakarta.jms.XAJMSContext;
import jakarta.jms.XATopicConnection;
import jakarta.jms.XATopicConnectionFactory;
import java.util.Properties;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import oracle.jakarta.jms.AQjmsOracleDebug;
import oracle.jakarta.jms.AQjmsTopicConnectionFactory;
import oracle.jakarta.jms.AQjmsUtil;
import oracle.jakarta.jms.AQjmsXAConnection;
import oracle.jakarta.jms.AQjmsXAResourceFactory;
import oracle.jakarta.jms.WebLogicHelper;

public class AQjmsXATopicConnectionFactory
extends AQjmsTopicConnectionFactory
implements XATopicConnectionFactory {
    private XADataSource m_xaDS = null;
    private AQjmsXAResourceFactory m_xaresFactory = null;

    AQjmsXATopicConnectionFactory(String hostname, String oracle_sid, int portno, String driver) throws JMSException {
        super(hostname, oracle_sid, portno, driver);
    }

    AQjmsXATopicConnectionFactory(String jdbc_connect_str, Properties jdbc_props) throws JMSException {
        super(jdbc_connect_str, jdbc_props);
    }

    AQjmsXATopicConnectionFactory(DataSource dsobj, AQjmsXAResourceFactory xaresFactory) throws JMSException {
        super(dsobj);
        this.m_xaresFactory = xaresFactory;
    }

    AQjmsXATopicConnectionFactory(DataSource dsobj, String jdbc_connect_str, Properties jdbc_props) throws JMSException {
        super(dsobj, jdbc_connect_str, jdbc_props);
    }

    AQjmsXATopicConnectionFactory(String dsname, AQjmsXAResourceFactory xaresFactory) throws JMSException {
        super(dsname);
        this.m_xaresFactory = xaresFactory;
    }

    AQjmsXATopicConnectionFactory(XADataSource xaDS) throws JMSException {
        this.m_xaDS = xaDS;
    }

    AQjmsXATopicConnectionFactory(String xaDSName) throws JMSException {
        this.m_xaDS = (XADataSource)AQjmsUtil.lookupObject(xaDSName, XADataSource.class);
        AQjmsOracleDebug.trace(5, "AQjmsXATopicConnectionFactory - constructor", "XADataSource name: " + xaDSName);
    }

    public AQjmsXATopicConnectionFactory() {
    }

    public XATopicConnection createXATopicConnection() throws JMSException {
        AQjmsXAConnection tconn = null;
        AQjmsOracleDebug.trace(5, "AQjmsXATopicConnectionFactory.createXATopicConnection", "enter");
        tconn = this.createAllXAConnection(20);
        AQjmsOracleDebug.trace(5, "AQjmsXATopicConnectionFactory.createXATopicConnection", "XATopicConnection created successfully");
        return tconn;
    }

    public XATopicConnection createXATopicConnection(String username, String password) throws JMSException {
        AQjmsXAConnection tconn = null;
        Object new_info = null;
        AQjmsOracleDebug.trace(5, "AQjmsXATopicConnectionFactory.createXATopicConnection w/username/password", "enter");
        tconn = this.createAllXAConnection(20, username, password);
        AQjmsOracleDebug.trace(5, "AQjmsXATopicConnectionFactory.createXATopicConnection w/username/password", "XATopicConnection created successfully");
        return tconn;
    }

    public XAConnection createXAConnection() throws JMSException {
        AQjmsXAConnection conn = null;
        AQjmsOracleDebug.trace(5, "AQjmsXATopicConnectionFactory.createXAConnection", "enter");
        conn = this.createAllXAConnection(30);
        AQjmsOracleDebug.trace(5, "AQjmsXATopicConnectionFactory.createXAConnection", "XAConnection created successfully");
        return conn;
    }

    public XAConnection createXAConnection(String username, String password) throws JMSException {
        AQjmsXAConnection conn = null;
        Object new_info = null;
        AQjmsOracleDebug.trace(5, "AQjmsXATopicConnectionFactory.createXAConnection w/username/password", "enter");
        conn = this.createAllXAConnection(30, username, password);
        AQjmsOracleDebug.trace(5, "AQjmsXATopicConnectionFactory.createXAConnection w/username/password", "XAConnection created successfully");
        return conn;
    }

    private AQjmsXAConnection createAllXAConnection(int connType) throws JMSException {
        AQjmsXAConnection conn = null;
        if (WebLogicHelper.runningInWLServer()) {
            if (this.data_source == null) {
                throw new UnsupportedOperationException("WebLogic server side components must use AQ JMS datasource configuration");
            }
            conn = new AQjmsXAConnection(this.data_source, this.m_xaresFactory, null, null, connType);
        } else {
            conn = this.jdbc_conn_str != null ? new AQjmsXAConnection(this.jdbc_conn_str, this.jdbc_info, connType) : (this.m_xaDS != null ? new AQjmsXAConnection(this.m_xaDS, null, null, connType) : (this.data_source != null ? new AQjmsXAConnection(this.data_source, this.m_xaresFactory, null, null, connType) : new AQjmsXAConnection(this.hostname, this.oracle_sid, this.portno, null, null, this.jdbc_driver, connType)));
        }
        conn.setCompliant(this.compliant);
        return conn;
    }

    private AQjmsXAConnection createAllXAConnection(int connType, String username, String password) throws JMSException {
        AQjmsXAConnection conn = null;
        if (WebLogicHelper.runningInWLServer()) {
            if (this.data_source == null) {
                throw new UnsupportedOperationException("WebLogic server side components must use AQ JMS datasource configuration");
            }
            conn = new AQjmsXAConnection(this.data_source, this.m_xaresFactory, username, password, connType);
        } else {
            Properties new_info = null;
            if (this.jdbc_conn_str != null) {
                if (this.jdbc_info != null) {
                    if (username != null || password != null) {
                        new_info = (Properties)this.jdbc_info.clone();
                        new_info.put("user", username);
                        new_info.put("password", password);
                    } else {
                        new_info = this.jdbc_info;
                    }
                    conn = new AQjmsXAConnection(this.jdbc_conn_str, new_info, connType);
                } else {
                    conn = new AQjmsXAConnection(this.jdbc_conn_str, username, password, connType);
                }
            } else {
                conn = this.m_xaDS != null ? new AQjmsXAConnection(this.m_xaDS, username, password, connType) : (this.data_source != null ? new AQjmsXAConnection(this.data_source, this.m_xaresFactory, username, password, connType) : new AQjmsXAConnection(this.hostname, this.oracle_sid, this.portno, username, password, this.jdbc_driver, connType));
            }
        }
        conn.setCompliant(this.compliant);
        return conn;
    }

    public XAJMSContext createXAContext() {
        throw new JMSRuntimeException("createXAContext() is not supported");
    }

    public XAJMSContext createXAContext(String arg0, String arg1) {
        throw new JMSRuntimeException("createXAContext(String, String) is not supported");
    }
}

