/*
 * Decompiled with CFR 0.152.
 */
package oracle.r2dbc.impl;

import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.ConnectionFactoryMetadata;
import io.r2dbc.spi.ConnectionFactoryOptions;
import java.sql.Connection;
import javax.sql.DataSource;
import oracle.r2dbc.impl.OracleConnectionImpl;
import oracle.r2dbc.impl.OracleR2dbcExceptions;
import oracle.r2dbc.impl.ReactiveJdbcAdapter;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

final class OracleConnectionFactoryImpl
implements ConnectionFactory {
    private final ReactiveJdbcAdapter adapter;
    private final DataSource dataSource;

    OracleConnectionFactoryImpl(ConnectionFactoryOptions options) {
        OracleR2dbcExceptions.requireNonNull(options, "options is null.");
        this.adapter = ReactiveJdbcAdapter.getOracleAdapter();
        this.dataSource = this.adapter.createDataSource(options);
    }

    public Publisher<io.r2dbc.spi.Connection> create() {
        return Mono.fromDirect(this.adapter.publishConnection(this.dataSource)).map(conn -> new OracleConnectionImpl(this.adapter, (Connection)conn));
    }

    public ConnectionFactoryMetadata getMetadata() {
        return () -> "Oracle Database";
    }
}

