/*
 * Decompiled with CFR 0.152.
 */
package oracle.r2dbc.impl;

import io.r2dbc.spi.ConnectionFactoryOptions;
import io.r2dbc.spi.Option;
import io.r2dbc.spi.R2dbcException;
import io.r2dbc.spi.R2dbcTimeoutException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.nio.ByteBuffer;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.util.Calendar;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import javax.sql.DataSource;
import oracle.jdbc.OracleBlob;
import oracle.jdbc.OracleClob;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.OracleRow;
import oracle.jdbc.datasource.OracleDataSource;
import oracle.r2dbc.impl.OracleR2dbcExceptions;
import oracle.r2dbc.impl.ReactiveJdbcAdapter;
import oracle.sql.json.OracleJsonObject;
import org.reactivestreams.FlowAdapters;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.publisher.DirectProcessor;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class OracleReactiveJdbcAdapter
implements ReactiveJdbcAdapter {
    private static final OracleReactiveJdbcAdapter INSTANCE = new OracleReactiveJdbcAdapter();
    private static final Set<Option<CharSequence>> SUPPORTED_CONNECTION_PROPERTY_OPTIONS = Set.of(Option.valueOf((String)"oracle.net.tns_admin"), Option.valueOf((String)"oracle.net.wallet_location"), Option.sensitiveValueOf((String)"oracle.net.wallet_password"), Option.valueOf((String)"javax.net.ssl.keyStore"), Option.valueOf((String)"javax.net.ssl.keyStoreType"), Option.sensitiveValueOf((String)"javax.net.ssl.keyStorePassword"), Option.valueOf((String)"javax.net.ssl.trustStore"), Option.valueOf((String)"javax.net.ssl.trustStoreType"), Option.sensitiveValueOf((String)"javax.net.ssl.trustStorePassword"), Option.valueOf((String)"oracle.net.authentication_services"), Option.valueOf((String)"oracle.net.ssl_certificate_alias"), Option.valueOf((String)"oracle.net.ssl_server_dn_match"), Option.valueOf((String)"oracle.net.ssl_server_cert_dn"), Option.valueOf((String)"oracle.net.ssl_version"), Option.valueOf((String)"oracle.net.ssl_cipher_suites"), Option.valueOf((String)"ssl.keyManagerFactory.algorithm"), Option.valueOf((String)"ssl.trustManagerFactory.algorithm"), Option.valueOf((String)"oracle.net.ssl_context_protocol"), Option.valueOf((String)"oracle.jdbc.fanEnabled"), Option.valueOf((String)"oracle.jdbc.implicitStatementCacheSize"));
    private static final Set<Class<?>> SUPPORTED_BIND_TYPES = Set.of(String.class, Boolean.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, BigDecimal.class, byte[].class, BigInteger.class, Date.class, Time.class, Timestamp.class, Clob.class, Blob.class, Array.class, Struct.class, Ref.class, URL.class, RowId.class, NClob.class, SQLXML.class, Calendar.class, java.util.Date.class, LocalDate.class, LocalTime.class, LocalDateTime.class, OffsetTime.class, OffsetDateTime.class, Period.class, Duration.class, OracleJsonObject.class);

    private OracleReactiveJdbcAdapter() {
    }

    static OracleReactiveJdbcAdapter getInstance() {
        return INSTANCE;
    }

    @Override
    public DataSource createDataSource(ConnectionFactoryOptions options) {
        OracleDataSource oracleDataSource = (OracleDataSource)OracleR2dbcExceptions.getOrHandleSQLException(oracle.jdbc.pool.OracleDataSource::new);
        OracleR2dbcExceptions.runOrHandleSQLException(() -> oracleDataSource.setURL(OracleReactiveJdbcAdapter.composeJdbcUrl(options)));
        OracleReactiveJdbcAdapter.configureStandardOptions(oracleDataSource, options);
        OracleReactiveJdbcAdapter.configureExtendedOptions(oracleDataSource, options);
        OracleReactiveJdbcAdapter.configureJdbcDefaults(oracleDataSource);
        return oracleDataSource;
    }

    private static String composeJdbcUrl(ConnectionFactoryOptions options) {
        String host = (String)options.getRequiredValue(ConnectionFactoryOptions.HOST);
        Integer port = (Integer)options.getValue(ConnectionFactoryOptions.PORT);
        String serviceName = (String)options.getValue(ConnectionFactoryOptions.DATABASE);
        Boolean isTcps = OracleReactiveJdbcAdapter.parseOptionValue(ConnectionFactoryOptions.SSL, options, Boolean.class, Boolean::valueOf);
        return String.format("jdbc:oracle:thin:@%s%s%s%s", Boolean.TRUE.equals(isTcps) ? "tcps:" : "", host, port != null ? ":" + port : "", serviceName != null ? "/" + serviceName : "");
    }

    private static void configureStandardOptions(OracleDataSource oracleDataSource, ConnectionFactoryOptions options) {
        Duration timeout;
        CharSequence password;
        String user = (String)options.getValue(ConnectionFactoryOptions.USER);
        if (user != null) {
            OracleR2dbcExceptions.runOrHandleSQLException(() -> oracleDataSource.setUser(user));
        }
        if ((password = (CharSequence)options.getValue(ConnectionFactoryOptions.PASSWORD)) != null) {
            OracleR2dbcExceptions.runOrHandleSQLException(() -> oracleDataSource.setPassword(password.toString()));
        }
        if ((timeout = OracleReactiveJdbcAdapter.parseOptionValue(ConnectionFactoryOptions.CONNECT_TIMEOUT, options, Duration.class, Duration::parse)) != null) {
            OracleR2dbcExceptions.runOrHandleSQLException(() -> oracleDataSource.setLoginTimeout(Math.toIntExact(timeout.getSeconds()) + timeout.getNano() == 0 ? 0 : 1));
        }
    }

    private static void configureExtendedOptions(OracleDataSource oracleDataSource, ConnectionFactoryOptions options) {
        String tnsAdmin = (String)options.getValue(Option.valueOf((String)"TNS_ADMIN"));
        if (tnsAdmin != null) {
            OracleR2dbcExceptions.runOrHandleSQLException(() -> oracleDataSource.setConnectionProperty("oracle.net.tns_admin", tnsAdmin));
        }
        for (Option<CharSequence> option : SUPPORTED_CONNECTION_PROPERTY_OPTIONS) {
            CharSequence value = (CharSequence)options.getValue(option);
            if (value == null) continue;
            OracleR2dbcExceptions.runOrHandleSQLException(() -> oracleDataSource.setConnectionProperty(option.name(), value.toString()));
        }
    }

    private static <T> T parseOptionValue(Option<T> option, ConnectionFactoryOptions options, Class<T> type, Function<String, T> parser) {
        Object value = options.getValue(option);
        if (value == null) {
            return null;
        }
        if (type.isInstance(value)) {
            return (T)value;
        }
        if (value instanceof String) {
            try {
                return parser.apply((String)value);
            }
            catch (Throwable parseFailure) {
                throw new IllegalArgumentException("Failed to parse the value of Option: " + option.name(), parseFailure);
            }
        }
        throw new IllegalArgumentException(String.format("Value of Option %s has an unexpected type: %s. Expected Type is: %s.", option.name(), value.getClass(), type));
    }

    private static void configureJdbcDefaults(OracleDataSource oracleDataSource) {
        String enableJdbcSpecCompliance = "oracle.jdbc.J2EE13Compliant";
        OracleR2dbcExceptions.runOrHandleSQLException(() -> oracleDataSource.setConnectionProperty(enableJdbcSpecCompliance, "true"));
        OracleR2dbcExceptions.runOrHandleSQLException(() -> {
            String userValue = oracleDataSource.getConnectionProperty("oracle.jdbc.implicitStatementCacheSize");
            if (userValue == null) {
                oracleDataSource.setConnectionProperty("oracle.jdbc.implicitStatementCacheSize", "25");
            }
        });
    }

    @Override
    public Publisher<? extends Connection> publishConnection(DataSource dataSource) {
        OracleDataSource oracleDataSource = this.unwrapOracleDataSource(dataSource);
        return Mono.from(this.adaptFlowPublisher(() -> oracleDataSource.createConnectionBuilder().buildConnectionPublisherOracle())).onErrorMap(R2dbcException.class, error -> error.getErrorCode() == 18714 ? new R2dbcTimeoutException(error.getMessage(), error.getSqlState(), error.getErrorCode(), error.getCause()) : error);
    }

    @Override
    public Publisher<Boolean> publishSQLExecution(PreparedStatement sqlStatement) {
        OraclePreparedStatement oraclePreparedStatement = this.unwrapOraclePreparedStatement(sqlStatement);
        return this.adaptFlowPublisher(() -> ((OraclePreparedStatement)oraclePreparedStatement).executeAsyncOracle());
    }

    @Override
    public Publisher<Long> publishBatchUpdate(PreparedStatement batchUpdateStatement) {
        OraclePreparedStatement oraclePreparedStatement = this.unwrapOraclePreparedStatement(batchUpdateStatement);
        return this.adaptFlowPublisher(() -> ((OraclePreparedStatement)oraclePreparedStatement).executeBatchAsyncOracle());
    }

    @Override
    public <T> Publisher<T> publishRows(ResultSet resultSet, Function<ReactiveJdbcAdapter.JdbcRow, T> rowMappingFunction) {
        OracleResultSet oracleResultSet = this.unwrapOracleResultSet(resultSet);
        return this.adaptFlowPublisher(() -> oracleResultSet.publisherOracle(oracleRow -> rowMappingFunction.apply(new OracleJdbcRow((OracleRow)oracleRow))));
    }

    @Override
    public Publisher<Void> publishCommit(Connection connection) {
        OracleConnection oracleConnection = this.unwrapOracleConnection(connection);
        return this.adaptFlowPublisher(() -> {
            if (oracleConnection.getAutoCommit()) {
                return FlowAdapters.toFlowPublisher((Publisher)Mono.empty());
            }
            return oracleConnection.commitAsyncOracle();
        });
    }

    @Override
    public Publisher<Void> publishRollback(Connection connection) {
        OracleConnection oracleConnection = this.unwrapOracleConnection(connection);
        return this.adaptFlowPublisher(() -> {
            if (oracleConnection.getAutoCommit()) {
                return FlowAdapters.toFlowPublisher((Publisher)Mono.empty());
            }
            return oracleConnection.rollbackAsyncOracle();
        });
    }

    @Override
    public Publisher<Void> publishClose(Connection connection) {
        return this.adaptFlowPublisher(() -> ((OracleConnection)this.unwrapOracleConnection(connection)).closeAsyncOracle());
    }

    @Override
    public Publisher<ByteBuffer> publishBlobRead(Blob blob) throws R2dbcException {
        OracleBlob oracleBlob = this.castAsType(blob, OracleBlob.class);
        return Flux.from(this.adaptFlowPublisher(() -> oracleBlob.publisherOracle(1L))).map(ByteBuffer::wrap);
    }

    public Publisher<String> publishClobRead(Clob clob) throws R2dbcException {
        OracleClob oracleClob = this.castAsType(clob, OracleClob.class);
        return this.adaptFlowPublisher(() -> oracleClob.publisherOracle(1L));
    }

    @Override
    public Publisher<Void> publishBlobWrite(Publisher<ByteBuffer> contentPublisher, Blob blob) {
        OracleBlob oracleBlob = this.castAsType(blob, OracleBlob.class);
        DirectProcessor writeOutcomeProcessor = DirectProcessor.create();
        Flow.Subscriber blobSubscriber = OracleR2dbcExceptions.getOrHandleSQLException(() -> oracleBlob.subscriberOracle(1L, FlowAdapters.toFlowSubscriber((Subscriber)writeOutcomeProcessor)));
        return this.adaptFlowPublisher(() -> {
            Flux.from((Publisher)contentPublisher).map(byteBuffer -> {
                ByteBuffer slice = byteBuffer.slice();
                byte[] byteArray = new byte[slice.remaining()];
                slice.get(byteArray);
                return byteArray;
            }).subscribe(new SerializedLobSubscriber(blobSubscriber));
            return FlowAdapters.toFlowPublisher((Publisher)writeOutcomeProcessor.then());
        });
    }

    @Override
    public Publisher<Void> publishClobWrite(Publisher<? extends CharSequence> contentPublisher, Clob clob) {
        OracleClob oracleClob = this.castAsType(clob, OracleClob.class);
        DirectProcessor writeOutcomeProcessor = DirectProcessor.create();
        Flow.Subscriber clobSubscriber = OracleR2dbcExceptions.getOrHandleSQLException(() -> oracleClob.subscriberOracle(1L, FlowAdapters.toFlowSubscriber((Subscriber)writeOutcomeProcessor)));
        return this.adaptFlowPublisher(() -> {
            Flux.from((Publisher)contentPublisher).map(CharSequence::toString).subscribe(new SerializedLobSubscriber(clobSubscriber));
            return FlowAdapters.toFlowPublisher((Publisher)writeOutcomeProcessor.then());
        });
    }

    @Override
    public Publisher<Void> publishBlobFree(Blob blob) throws R2dbcException {
        OracleBlob oracleBlob = this.castAsType(blob, OracleBlob.class);
        return this.adaptFlowPublisher(() -> ((OracleBlob)oracleBlob).freeAsyncOracle());
    }

    @Override
    public Publisher<Void> publishClobFree(Clob clob) throws R2dbcException {
        OracleClob oracleClob = this.castAsType(clob, OracleClob.class);
        return this.adaptFlowPublisher(() -> ((OracleClob)oracleClob).freeAsyncOracle());
    }

    @Override
    public boolean isSupportedBindType(Class<?> javaType) {
        return SUPPORTED_BIND_TYPES.contains(javaType) || SUPPORTED_BIND_TYPES.stream().anyMatch(supportedType -> supportedType.isAssignableFrom(javaType));
    }

    @Override
    public Publisher<PreparedStatement> publishPreparedStatement(String sql, String[] generatedColumns, Connection connection) {
        OracleConnection oracleConnection = this.unwrapOracleConnection(connection);
        try {
            PreparedStatement preparedStatement = generatedColumns == null ? oracleConnection.prepareStatement(sql) : (generatedColumns.length == 0 ? oracleConnection.prepareStatement(sql, 1) : oracleConnection.prepareStatement(sql, generatedColumns));
            return Mono.just((Object)preparedStatement);
        }
        catch (SQLException sqlException) {
            return Mono.error((Throwable)OracleR2dbcExceptions.toR2dbcException(sqlException));
        }
    }

    private <T> Publisher<T> adaptFlowPublisher(OracleR2dbcExceptions.ThrowingSupplier<Flow.Publisher<? extends T>> publisherSupplier) {
        return Flux.from(OracleReactiveJdbcAdapter.deferOnce(publisherSupplier)).onErrorMap(SQLException.class, OracleR2dbcExceptions::toR2dbcException);
    }

    private static <T> Publisher<T> deferOnce(OracleR2dbcExceptions.ThrowingSupplier<Flow.Publisher<? extends T>> publisherSupplier) {
        AtomicBoolean isSubscribed = new AtomicBoolean(false);
        CompletableFuture publisherFuture = new CompletableFuture();
        return subscriber -> {
            Objects.requireNonNull(subscriber, "Subscriber is null");
            if (isSubscribed.compareAndSet(false, true)) {
                Publisher publisher2;
                try {
                    publisher2 = FlowAdapters.toPublisher((Flow.Publisher)((Flow.Publisher)OracleR2dbcExceptions.getOrHandleSQLException(publisherSupplier)));
                }
                catch (R2dbcException r2dbcException) {
                    publisher2 = Mono.error((Throwable)r2dbcException);
                }
                publisher2.subscribe(subscriber);
                publisherFuture.complete(publisher2);
            } else {
                publisherFuture.thenAccept(publisher -> publisher.subscribe(subscriber));
            }
        };
    }

    private OracleDataSource unwrapOracleDataSource(DataSource dataSource) {
        return OracleR2dbcExceptions.getOrHandleSQLException(() -> dataSource.unwrap(OracleDataSource.class));
    }

    private OracleConnection unwrapOracleConnection(Connection connection) {
        return OracleR2dbcExceptions.getOrHandleSQLException(() -> connection.unwrap(OracleConnection.class));
    }

    private OraclePreparedStatement unwrapOraclePreparedStatement(PreparedStatement preparedStatement) {
        return OracleR2dbcExceptions.getOrHandleSQLException(() -> preparedStatement.unwrap(OraclePreparedStatement.class));
    }

    private OracleResultSet unwrapOracleResultSet(ResultSet resultSet) {
        return OracleR2dbcExceptions.getOrHandleSQLException(() -> resultSet.unwrap(OracleResultSet.class));
    }

    private <T> T castAsType(Object object, Class<T> type) {
        if (type.isInstance(object)) {
            return type.cast(object);
        }
        throw OracleR2dbcExceptions.newNonTransientException(object.getClass() + " is not an instance of " + type, null);
    }

    private static class SerializedLobSubscriber<T>
    implements Subscriber<T>,
    Flow.Subscription {
        final Flow.Subscriber<T> lobSubscriber;
        final ReentrantLock signalLock = new ReentrantLock();
        Subscription contentSubscription;

        SerializedLobSubscriber(Flow.Subscriber<T> lobSubscriber) {
            this.lobSubscriber = lobSubscriber;
        }

        public void onSubscribe(Subscription subscription) {
            this.contentSubscription = subscription;
            this.lobSubscriber.onSubscribe(this);
        }

        @Override
        public void request(long n) {
            this.signalLock.lock();
            try {
                this.contentSubscription.request(n);
            }
            finally {
                this.signalLock.unlock();
            }
        }

        @Override
        public void cancel() {
            this.signalLock.lock();
            try {
                this.contentSubscription.cancel();
            }
            finally {
                this.signalLock.unlock();
            }
        }

        public void onNext(T item) {
            this.lobSubscriber.onNext(item);
        }

        public void onError(Throwable throwable) {
            this.lobSubscriber.onError(throwable);
        }

        public void onComplete() {
            this.lobSubscriber.onComplete();
        }
    }

    private static final class OracleJdbcRow
    implements ReactiveJdbcAdapter.JdbcRow {
        private final OracleRow oracleRow;

        private OracleJdbcRow(OracleRow oracleRow) {
            this.oracleRow = oracleRow;
        }

        public <U> U getObject(int index, Class<U> type) {
            try {
                return (U)this.oracleRow.getObject(index + 1, type);
            }
            catch (SQLException sqlException) {
                if (sqlException.getErrorCode() == 18711) {
                    throw new IllegalStateException(sqlException);
                }
                if (sqlException.getErrorCode() == 17004) {
                    throw new IllegalArgumentException(sqlException);
                }
                throw OracleR2dbcExceptions.toR2dbcException(sqlException);
            }
        }

        @Override
        public ReactiveJdbcAdapter.JdbcRow copy() {
            return new OracleJdbcRow(this.oracleRow.clone());
        }
    }
}

