/*
 * Decompiled with CFR 0.152.
 */
package oracle.r2dbc.impl;

import io.r2dbc.spi.Result;
import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import java.sql.ResultSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import oracle.r2dbc.impl.OracleR2dbcExceptions;
import oracle.r2dbc.impl.OracleRowImpl;
import oracle.r2dbc.impl.OracleRowMetadataImpl;
import oracle.r2dbc.impl.ReactiveJdbcAdapter;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

abstract class OracleResultImpl
implements Result {
    private boolean isConsumed = false;

    private OracleResultImpl() {
    }

    public static Result createUpdateCountResult(final int updateCount) {
        return new OracleResultImpl(){

            @Override
            Publisher<Integer> publishUpdateCount() {
                return updateCount < 1 ? Mono.empty() : Mono.just((Object)updateCount);
            }

            @Override
            <T> Publisher<T> publishRows(BiFunction<Row, RowMetadata, ? extends T> mappingFunction) {
                return Mono.empty();
            }
        };
    }

    public static Result createQueryResult(final ReactiveJdbcAdapter adapter, final ResultSet resultSet) {
        return new OracleResultImpl(){

            @Override
            Publisher<Integer> publishUpdateCount() {
                return Mono.empty();
            }

            @Override
            <T> Publisher<T> publishRows(BiFunction<Row, RowMetadata, ? extends T> mappingFunction) {
                OracleRowMetadataImpl metadata = new OracleRowMetadataImpl(OracleR2dbcExceptions.getOrHandleSQLException(resultSet::getMetaData));
                return Flux.from(adapter.publishRows(resultSet, jdbcRow -> mappingFunction.apply(new OracleRowImpl((ReactiveJdbcAdapter.JdbcRow)jdbcRow, metadata, adapter), metadata)));
            }
        };
    }

    public static Publisher<Result> createGeneratedValuesResult(ReactiveJdbcAdapter adapter, final int updateCount, ResultSet values) {
        if (!OracleR2dbcExceptions.getOrHandleSQLException(values::isBeforeFirst).booleanValue()) {
            return Mono.just((Object)OracleResultImpl.createUpdateCountResult(updateCount));
        }
        OracleRowMetadataImpl metadata = new OracleRowMetadataImpl(OracleR2dbcExceptions.getOrHandleSQLException(values::getMetaData));
        return Flux.from(adapter.publishRows(values, ReactiveJdbcAdapter.JdbcRow::copy)).collectList().map(cachedRows -> new OracleResultImpl((List)cachedRows, metadata, adapter){
            final /* synthetic */ List val$cachedRows;
            final /* synthetic */ OracleRowMetadataImpl val$metadata;
            final /* synthetic */ ReactiveJdbcAdapter val$adapter;
            {
                this.val$cachedRows = list;
                this.val$metadata = oracleRowMetadataImpl;
                this.val$adapter = reactiveJdbcAdapter;
            }

            @Override
            Publisher<Integer> publishUpdateCount() {
                return Mono.just((Object)updateCount);
            }

            @Override
            <T> Publisher<T> publishRows(BiFunction<Row, RowMetadata, ? extends T> mappingFunction) {
                return Flux.fromIterable((Iterable)this.val$cachedRows).map(jdbcRow -> mappingFunction.apply(new OracleRowImpl((ReactiveJdbcAdapter.JdbcRow)jdbcRow, this.val$metadata, this.val$adapter), this.val$metadata));
            }
        });
    }

    public final Publisher<Integer> getRowsUpdated() {
        this.setConsumed();
        return this.publishUpdateCount();
    }

    public final <T> Publisher<T> map(BiFunction<Row, RowMetadata, ? extends T> mappingFunction) {
        OracleR2dbcExceptions.requireNonNull(mappingFunction, " Mapping function is null");
        this.setConsumed();
        Publisher rowPublisher = this.publishRows(mappingFunction);
        AtomicBoolean isSubscribed = new AtomicBoolean(false);
        return Flux.defer(() -> isSubscribed.compareAndSet(false, true) ? rowPublisher : Mono.error((Throwable)new IllegalStateException("Multiple subscribers are not supported by the Oracle R2DBC  Result.map(BiFunction) publisher")));
    }

    private void setConsumed() {
        if (this.isConsumed) {
            throw new IllegalStateException("A result can not be consumed more than once");
        }
        this.isConsumed = true;
    }

    abstract <T> Publisher<T> publishRows(BiFunction<Row, RowMetadata, ? extends T> var1);

    abstract Publisher<Integer> publishUpdateCount();
}

