/*
 * Decompiled with CFR 0.152.
 */
package oracle.r2dbc.impl;

import io.r2dbc.spi.ConnectionFactoryOptions;
import io.r2dbc.spi.R2dbcException;
import io.r2dbc.spi.R2dbcNonTransientResourceException;
import java.nio.ByteBuffer;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.function.Function;
import javax.sql.DataSource;
import oracle.r2dbc.impl.OracleR2dbcExceptions;
import oracle.r2dbc.impl.OracleReactiveJdbcAdapter;
import org.reactivestreams.Publisher;

interface ReactiveJdbcAdapter {
    public static ReactiveJdbcAdapter getOracleAdapter() throws R2dbcException {
        try {
            int oracleDriverVersion = DriverManager.getDriver("jdbc:oracle:thin:").getMajorVersion();
            if (oracleDriverVersion < 21) {
                throw new R2dbcNonTransientResourceException("Unsupported Oracle JDBC Driver version: " + oracleDriverVersion);
            }
        }
        catch (SQLException getDriverException) {
            throw OracleR2dbcExceptions.newNonTransientException("Failed to locate the Oracle JDBC Driver", getDriverException);
        }
        return OracleReactiveJdbcAdapter.getInstance();
    }

    public DataSource createDataSource(ConnectionFactoryOptions var1);

    public Publisher<? extends Connection> publishConnection(DataSource var1) throws R2dbcException;

    public Publisher<Boolean> publishSQLExecution(PreparedStatement var1) throws R2dbcException;

    public Publisher<Long> publishBatchUpdate(PreparedStatement var1) throws R2dbcException;

    public <T> Publisher<T> publishRows(ResultSet var1, Function<JdbcRow, T> var2) throws R2dbcException;

    public Publisher<Void> publishCommit(Connection var1) throws R2dbcException;

    public Publisher<Void> publishRollback(Connection var1) throws R2dbcException;

    public Publisher<Void> publishClose(Connection var1) throws R2dbcException;

    public Publisher<ByteBuffer> publishBlobRead(Blob var1) throws R2dbcException;

    public Publisher<? extends CharSequence> publishClobRead(Clob var1) throws R2dbcException;

    public Publisher<Void> publishBlobWrite(Publisher<ByteBuffer> var1, Blob var2) throws R2dbcException;

    public Publisher<Void> publishClobWrite(Publisher<? extends CharSequence> var1, Clob var2) throws R2dbcException;

    public Publisher<Void> publishBlobFree(Blob var1) throws R2dbcException;

    public Publisher<Void> publishClobFree(Clob var1) throws R2dbcException;

    public boolean isSupportedBindType(Class<?> var1);

    public Publisher<PreparedStatement> publishPreparedStatement(String var1, String[] var2, Connection var3);

    public static interface JdbcRow {
        public <T> T getObject(int var1, Class<T> var2);

        public JdbcRow copy();
    }
}

