/*
 * Decompiled with CFR 0.152.
 */
package oracle.r2dbc.impl;

import io.r2dbc.spi.Clob;
import io.r2dbc.spi.OutParameterMetadata;
import io.r2dbc.spi.Parameter;
import io.r2dbc.spi.R2dbcException;
import io.r2dbc.spi.R2dbcType;
import io.r2dbc.spi.Readable;
import io.r2dbc.spi.ReadableMetadata;
import io.r2dbc.spi.Statement;
import io.r2dbc.spi.Type;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.Struct;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleStruct;
import oracle.r2dbc.OracleR2dbcObject;
import oracle.r2dbc.OracleR2dbcObjectMetadata;
import oracle.r2dbc.OracleR2dbcTypes;
import oracle.r2dbc.impl.DependentCounter;
import oracle.r2dbc.impl.OracleR2dbcExceptions;
import oracle.r2dbc.impl.OracleReadableImpl;
import oracle.r2dbc.impl.OracleReadableMetadataImpl;
import oracle.r2dbc.impl.OracleResultImpl;
import oracle.r2dbc.impl.ReactiveJdbcAdapter;
import oracle.r2dbc.impl.ReadablesMetadata;
import oracle.r2dbc.impl.SqlParameterParser;
import oracle.r2dbc.impl.SqlTypeMap;
import oracle.sql.DATE;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.TIMESTAMP;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class OracleStatementImpl
implements Statement {
    private static final Object NULL_BIND = new Object();
    private final Connection jdbcConnection;
    private final ReactiveJdbcAdapter adapter;
    private final String sql;
    private final int timeout;
    private final List<String> parameterNames;
    private final Object[] bindValues;
    private Queue<Object[]> batch = new LinkedList<Object[]>();
    private int fetchSize = 0;
    private String[] generatedColumns = null;

    OracleStatementImpl(String sql, Duration timeout, Connection jdbcConnection, ReactiveJdbcAdapter adapter) {
        this.sql = sql;
        this.jdbcConnection = jdbcConnection;
        this.adapter = adapter;
        this.parameterNames = SqlParameterParser.parse(sql);
        this.bindValues = new Object[this.parameterNames.size()];
        this.timeout = (int)Math.min(Integer.MAX_VALUE, timeout.toSeconds() + (long)(timeout.getNano() == 0 ? 0 : 1));
    }

    public Statement bind(int index, Object value) {
        OracleR2dbcExceptions.requireOpenConnection(this.jdbcConnection);
        OracleR2dbcExceptions.requireNonNull(value, "value is null");
        this.requireValidIndex(index);
        this.bindObject(index, value);
        return this;
    }

    public Statement bind(String identifier, Object value) {
        OracleR2dbcExceptions.requireOpenConnection(this.jdbcConnection);
        OracleR2dbcExceptions.requireNonNull(identifier, "identifier is null");
        OracleR2dbcExceptions.requireNonNull(value, "value is null");
        this.bindNamedParameter(identifier, value);
        return this;
    }

    public Statement bindNull(int index, Class<?> type) {
        OracleR2dbcExceptions.requireOpenConnection(this.jdbcConnection);
        OracleStatementImpl.requireSupportedNullClass(type);
        this.requireValidIndex(index);
        this.bindObject(index, null);
        return this;
    }

    public Statement bindNull(String identifier, Class<?> type) {
        OracleR2dbcExceptions.requireOpenConnection(this.jdbcConnection);
        OracleR2dbcExceptions.requireNonNull(identifier, "identifier is null");
        OracleStatementImpl.requireSupportedNullClass(type);
        this.bindNamedParameter(identifier, null);
        return this;
    }

    public Statement add() {
        OracleR2dbcExceptions.requireOpenConnection(this.jdbcConnection);
        this.addBatchValues();
        return this;
    }

    public Statement returnGeneratedValues(String ... columns) {
        OracleR2dbcExceptions.requireOpenConnection(this.jdbcConnection);
        OracleR2dbcExceptions.requireNonNull(columns, "Column names are null");
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i] != null) continue;
            throw new IllegalArgumentException("Null column name at index: " + i);
        }
        if (this.isOutParameterPresent()) {
            throw OracleStatementImpl.outParameterWithGeneratedValues();
        }
        if (!this.batch.isEmpty()) {
            throw OracleStatementImpl.generatedValuesWithBatch();
        }
        this.generatedColumns = (String[])columns.clone();
        return this;
    }

    public Statement fetchSize(int rows) {
        OracleR2dbcExceptions.requireOpenConnection(this.jdbcConnection);
        if (rows < 0) {
            throw new IllegalArgumentException("Fetch size is less than zero: " + rows);
        }
        this.fetchSize = rows;
        return this;
    }

    public Publisher<OracleResultImpl> execute() {
        OracleR2dbcExceptions.requireOpenConnection(this.jdbcConnection);
        Publisher<JdbcStatement> statementPublisher = !this.batch.isEmpty() ? this.createJdbcBatch() : (this.isOutParameterPresent() ? this.createJdbcCall() : (this.generatedColumns != null ? this.createJdbcReturningGenerated() : this.createJdbcStatement()));
        AtomicBoolean isSubscribed = new AtomicBoolean(false);
        return Flux.defer(() -> {
            if (isSubscribed.compareAndSet(false, true)) {
                return Mono.from((Publisher)statementPublisher).flatMapMany(JdbcStatement::execute);
            }
            return Mono.error((Throwable)new IllegalStateException("Multiple subscribers are not supported by the Oracle R2DBC Statement.execute() publisher"));
        });
    }

    private Publisher<JdbcStatement> createJdbcStatement() {
        int currentFetchSize = this.fetchSize;
        Object[] currentBinds = this.transferBinds();
        return this.adapter.getLock().get(() -> {
            PreparedStatement preparedStatement = this.jdbcConnection.prepareStatement(this.sql);
            preparedStatement.setFetchSize(currentFetchSize);
            preparedStatement.setQueryTimeout(this.timeout);
            return new JdbcStatement(preparedStatement, currentBinds);
        });
    }

    private Publisher<JdbcStatement> createJdbcBatch() {
        IllegalStateException invalidBinds;
        try {
            this.add();
            invalidBinds = null;
        }
        catch (IllegalStateException illegalStateException) {
            invalidBinds = illegalStateException;
        }
        IllegalStateException finalInvalidBinds = invalidBinds;
        int currentFetchSize = this.fetchSize;
        Queue<Object[]> currentBatch = this.batch;
        this.batch = new LinkedList<Object[]>();
        return this.adapter.getLock().get(() -> {
            PreparedStatement preparedStatement = this.jdbcConnection.prepareStatement(this.sql);
            preparedStatement.setFetchSize(currentFetchSize);
            preparedStatement.setQueryTimeout(this.timeout);
            return finalInvalidBinds == null ? new JdbcBatch(preparedStatement, currentBatch) : new JdbcBatchInvalidBinds(preparedStatement, currentBatch, finalInvalidBinds);
        });
    }

    private Publisher<JdbcStatement> createJdbcCall() {
        int currentFetchSize = this.fetchSize;
        Object[] currentBinds = this.transferBinds();
        return this.adapter.getLock().get(() -> {
            CallableStatement callableStatement = this.jdbcConnection.prepareCall(this.sql);
            callableStatement.setFetchSize(currentFetchSize);
            callableStatement.setQueryTimeout(this.timeout);
            return new JdbcCall(callableStatement, currentBinds, this.parameterNames);
        });
    }

    private Publisher<JdbcStatement> createJdbcReturningGenerated() {
        int currentFetchSize = this.fetchSize;
        Object[] currentBinds = this.transferBinds();
        String[] currentGeneratedColumns = (String[])this.generatedColumns.clone();
        return this.adapter.getLock().get(() -> {
            PreparedStatement preparedStatement = currentGeneratedColumns.length == 0 ? this.jdbcConnection.prepareStatement(this.sql, 1) : this.jdbcConnection.prepareStatement(this.sql, currentGeneratedColumns);
            preparedStatement.setFetchSize(currentFetchSize);
            preparedStatement.setQueryTimeout(this.timeout);
            return new JdbcReturningGenerated(preparedStatement, currentBinds);
        });
    }

    private void bindNamedParameter(String name, Object value) {
        boolean isMatched = false;
        for (int i = 0; i < this.parameterNames.size(); ++i) {
            if (!name.equals(this.parameterNames.get(i))) continue;
            isMatched = true;
            this.bindObject(i, value);
        }
        if (!isMatched) {
            throw new NoSuchElementException("Unrecognized parameter identifier: " + name);
        }
    }

    private void bindObject(int index, Object object) {
        if (object == null) {
            this.bindValues[index] = NULL_BIND;
        } else if (object instanceof Parameter) {
            this.bindParameter(index, (Parameter)object);
        } else {
            if (object instanceof Parameter.In || object instanceof Parameter.Out) {
                throw new IllegalArgumentException("Parameter.In and Parameter.Out bind values must implement Parameter");
            }
            OracleStatementImpl.requireSupportedJavaType(object);
            this.bindValues[index] = object;
        }
    }

    private void bindParameter(int index, Parameter parameter) {
        if (parameter instanceof Parameter.Out) {
            if (!this.batch.isEmpty()) {
                throw OracleStatementImpl.outParameterWithBatch();
            }
            if (this.generatedColumns != null) {
                throw OracleStatementImpl.outParameterWithGeneratedValues();
            }
        }
        OracleStatementImpl.requireSupportedSqlType(OracleR2dbcExceptions.requireNonNull(parameter.getType(), "Parameter type is null"));
        OracleStatementImpl.requireSupportedJavaType(parameter.getValue());
        this.bindValues[index] = parameter;
    }

    private void requireValidIndex(int index) {
        if (this.parameterNames.isEmpty()) {
            throw new IndexOutOfBoundsException("Statement has no parameter markers");
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException("Parameter index is non-positive: " + index);
        }
        if (index >= this.parameterNames.size()) {
            throw new IndexOutOfBoundsException("Parameter index is out of range: " + index + ". Largest index is: " + (this.parameterNames.size() - 1));
        }
    }

    private void addBatchValues() {
        if (this.generatedColumns != null) {
            throw OracleStatementImpl.generatedValuesWithBatch();
        }
        for (Object parameter : this.bindValues) {
            if (parameter == null) {
                throw OracleStatementImpl.parameterNotSet();
            }
            if (!(parameter instanceof Parameter.Out)) continue;
            throw OracleStatementImpl.outParameterWithBatch();
        }
        this.batch.add((Object[])this.bindValues.clone());
        Arrays.fill(this.bindValues, null);
    }

    private boolean isOutParameterPresent() {
        for (Object value : this.bindValues) {
            if (!(value instanceof Parameter.Out)) continue;
            return true;
        }
        return false;
    }

    private Object[] transferBinds() {
        this.requireAllParametersSet();
        Object[] currentBinds = (Object[])this.bindValues.clone();
        Arrays.fill(this.bindValues, null);
        return currentBinds;
    }

    private void requireAllParametersSet() {
        for (Object parameter : this.bindValues) {
            if (parameter != null) continue;
            throw OracleStatementImpl.parameterNotSet();
        }
    }

    private static IllegalStateException parameterNotSet() {
        return new IllegalStateException("One or more parameters are not set");
    }

    private static void requireSupportedJavaType(Object object) {
        if (object != null && SqlTypeMap.toJdbcType(object.getClass()) == null) {
            throw new IllegalArgumentException("Unsupported Java type:" + object.getClass());
        }
    }

    private static void requireSupportedSqlType(Type r2dbcType) {
        SQLType jdbcType = SqlTypeMap.toJdbcType(r2dbcType);
        if (jdbcType == null) {
            throw new IllegalArgumentException("Unsupported SQL type: " + r2dbcType);
        }
    }

    private static void requireSupportedNullClass(Class<?> type) {
        OracleR2dbcExceptions.requireNonNull(type, "type is null");
        if (OracleR2dbcObject.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("A type name is required for NULL OBJECT binds. Use: bind(Parameters.in(OracleR2dbcTypes.objectType(typeName)))");
        }
        if (type.isArray() && !byte[].class.equals(type)) {
            throw new IllegalArgumentException("A type name is required for NULL ARRAY binds. Use: bind(Parameters.in(OracleR2dbcTypes.arrayType(typeName)))");
        }
    }

    private static IllegalStateException outParameterWithGeneratedValues() {
        return new IllegalStateException("Statement can not return both out-parameters and generated values");
    }

    private static IllegalStateException outParameterWithBatch() {
        return new IllegalStateException("Batch execution with out parameters is not supported");
    }

    private static IllegalStateException generatedValuesWithBatch() {
        return new IllegalStateException("Batch execution returning generated values is not supported");
    }

    private final class JdbcReturningGenerated
    extends JdbcStatement {
        private JdbcReturningGenerated(PreparedStatement preparedStatement, Object[] binds) {
            super(preparedStatement, binds);
        }

        @Override
        protected Publisher<OracleResultImpl> executeJdbc() {
            return Mono.from(OracleStatementImpl.this.adapter.publishSQLExecution(this.preparedStatement)).flatMapMany(isResultSet -> {
                if (isResultSet.booleanValue()) {
                    return super.getResults(true);
                }
                return OracleStatementImpl.this.adapter.getLock().flatMap(() -> {
                    ResultSet generatedKeys = this.preparedStatement.getGeneratedKeys();
                    if (generatedKeys.isBeforeFirst()) {
                        return Mono.just((Object)OracleResultImpl.createGeneratedValuesResult(this.preparedStatement.getLargeUpdateCount(), this.dependentCounter, generatedKeys, OracleStatementImpl.this.adapter)).concatWith(super.getResults(this.preparedStatement.getMoreResults(2)));
                    }
                    return super.getResults(false);
                });
            });
        }
    }

    private final class JdbcBatchInvalidBinds
    extends JdbcBatch {
        private final IllegalStateException missingBinds;

        private JdbcBatchInvalidBinds(PreparedStatement preparedStatement, Queue<Object[]> batch, IllegalStateException missingBinds) {
            super(preparedStatement, batch);
            this.missingBinds = missingBinds;
        }

        @Override
        protected Publisher<OracleResultImpl> executeJdbc() {
            return Flux.from(super.executeJdbc()).concatWithValues((Object[])new OracleResultImpl[]{OracleResultImpl.createErrorResult((R2dbcException)OracleR2dbcExceptions.newNonTransientException("One or more binds not set after calling add()", OracleStatementImpl.this.sql, this.missingBinds))});
        }
    }

    private class JdbcBatch
    extends JdbcStatement {
        private final Queue<Object[]> batch;
        private final int batchSize;

        private JdbcBatch(PreparedStatement preparedStatement, Queue<Object[]> batch) {
            super(preparedStatement, null);
            this.batch = batch;
            this.batchSize = batch.size();
        }

        @Override
        protected Publisher<Void> bind() {
            Publisher[] bindPublishers = new Publisher[this.batchSize];
            for (int i = 0; i < this.batchSize; ++i) {
                Publisher[] publisherArray = new Publisher[2];
                publisherArray[0] = this.bind(this.batch.remove());
                publisherArray[1] = OracleStatementImpl.this.adapter.getLock().run(this.preparedStatement::addBatch);
                bindPublishers[i] = Flux.concat((Publisher[])publisherArray);
            }
            return Flux.concat((Publisher[])bindPublishers).cast(Void.class);
        }

        @Override
        protected Publisher<OracleResultImpl> executeJdbc() {
            AtomicInteger index = new AtomicInteger(0);
            return Flux.from(OracleStatementImpl.this.adapter.publishBatchUpdate(this.preparedStatement)).collect(() -> new long[this.batchSize], (updateCounts, updateCount) -> {
                updateCounts[index.getAndIncrement()] = updateCount;
            }).map(OracleResultImpl::createBatchUpdateResult).onErrorResume(error -> error instanceof R2dbcException && error.getCause() instanceof BatchUpdateException, error -> Mono.just((Object)OracleResultImpl.createBatchUpdateErrorResult((BatchUpdateException)error.getCause())));
        }
    }

    private class JdbcCall
    extends JdbcStatement {
        private final int[] outBindIndexes;
        private final ReadablesMetadata.OutParametersMetadataImpl metadata;

        private JdbcCall(CallableStatement callableStatement, Object[] bindValues, List<String> parameterNames) {
            super(callableStatement, bindValues);
            this.outBindIndexes = IntStream.range(0, bindValues.length).filter(i -> bindValues[i] instanceof Parameter.Out).toArray();
            OutParameterMetadata[] metadataArray = new OutParameterMetadata[this.outBindIndexes.length];
            for (int i2 = 0; i2 < metadataArray.length; ++i2) {
                int bindIndex = this.outBindIndexes[i2];
                String name = Objects.requireNonNullElse(parameterNames.get(bindIndex), String.valueOf(i2));
                metadataArray[i2] = OracleReadableMetadataImpl.createParameterMetadata(name, ((Parameter)bindValues[bindIndex]).getType());
            }
            this.metadata = ReadablesMetadata.createOutParametersMetadata(metadataArray);
        }

        @Override
        protected Publisher<Void> bind() {
            return Flux.concat((Publisher[])new Publisher[]{super.bind(), this.registerOutParameters()});
        }

        private Publisher<Void> registerOutParameters() {
            return OracleStatementImpl.this.adapter.getLock().run(() -> {
                CallableStatement callableStatement = this.preparedStatement.unwrap(CallableStatement.class);
                for (int i : this.outBindIndexes) {
                    Type type = ((Parameter)this.binds[i]).getType();
                    SQLType jdbcType = SqlTypeMap.toJdbcType(type);
                    if (type instanceof OracleR2dbcTypes.ArrayType || type instanceof OracleR2dbcTypes.ObjectType) {
                        callableStatement.registerOutParameter(i + 1, jdbcType, type.getName());
                        continue;
                    }
                    callableStatement.registerOutParameter(i + 1, jdbcType);
                }
            });
        }

        @Override
        protected Publisher<OracleResultImpl> executeJdbc() {
            Publisher[] publisherArray = new Publisher[2];
            publisherArray[0] = super.executeJdbc();
            publisherArray[1] = Mono.just((Object)OracleResultImpl.createCallResult(this.dependentCounter, OracleReadableImpl.createOutParameters(OracleR2dbcExceptions.fromJdbc(this.preparedStatement::getConnection), this.dependentCounter, new JdbcOutParameters(), this.metadata, OracleStatementImpl.this.adapter), OracleStatementImpl.this.adapter));
            return Flux.concat((Publisher[])publisherArray);
        }

        private final class JdbcOutParameters
        implements ReactiveJdbcAdapter.JdbcReadable {
            private JdbcOutParameters() {
            }

            @Override
            public <T> T getObject(int index, Class<T> type) {
                return (T)OracleR2dbcExceptions.fromJdbc(() -> JdbcCall.this.preparedStatement.unwrap(CallableStatement.class).getObject(JdbcCall.this.outBindIndexes[index] + 1, type));
            }
        }
    }

    private class JdbcStatement {
        protected final PreparedStatement preparedStatement;
        protected final DependentCounter dependentCounter;
        protected final Object[] binds;
        private Publisher<Void> deallocators = Mono.empty();

        private JdbcStatement(PreparedStatement preparedStatement, Object[] binds) {
            this.preparedStatement = preparedStatement;
            this.binds = binds;
            this.dependentCounter = new DependentCounter(this.closeStatement());
            this.dependentCounter.increment();
        }

        final Publisher<OracleResultImpl> execute() {
            Mono deallocate = Mono.from(this.deallocate()).cast(OracleResultImpl.class);
            return Flux.concatDelayError((Publisher[])new Publisher[]{Mono.from(this.bind()).thenMany(this.executeJdbc()).map(this::getWarnings).onErrorResume(R2dbcException.class, r2dbcException -> Mono.just((Object)OracleResultImpl.createErrorResult(r2dbcException))).doOnNext(OracleResultImpl::addDependent), deallocate}).doOnCancel(() -> ((Mono)deallocate).subscribe());
        }

        protected Publisher<Void> bind() {
            return this.bind(this.binds);
        }

        protected final Publisher<Void> bind(Object[] binds) {
            return OracleStatementImpl.this.adapter.getLock().flatMap(() -> {
                LinkedList<Publisher<Void>> bindPublishers = null;
                for (int i = 0; i < binds.length; ++i) {
                    Publisher<Void> bindPublisher;
                    if (binds[i] instanceof Parameter.Out && !(binds[i] instanceof Parameter.In) || (bindPublisher = this.bind(i, binds[i])) == null) continue;
                    if (bindPublishers == null) {
                        bindPublishers = new LinkedList<Publisher<Void>>();
                    }
                    bindPublishers.add(bindPublisher);
                }
                return bindPublishers == null ? Mono.empty() : Flux.concat(bindPublishers);
            });
        }

        private Publisher<Void> bind(int index, Object value) {
            String typeName;
            SQLType jdbcType;
            Object jdbcValue = this.convertBind(value);
            if (value instanceof Parameter) {
                Type type = ((Parameter)value).getType();
                jdbcType = SqlTypeMap.toJdbcType(type);
                typeName = type.getName();
            } else {
                jdbcType = null;
                typeName = null;
            }
            if (jdbcValue instanceof Publisher) {
                return this.setPublishedBind(index, (Publisher)jdbcValue);
            }
            this.setBind(index, jdbcValue, jdbcType, typeName);
            return null;
        }

        private Publisher<Void> setPublishedBind(int index, Publisher<?> publisher) {
            return Mono.from(publisher).flatMap(value -> {
                Publisher<Void> bindPublisher = this.bind(index, value);
                return bindPublisher == null ? Mono.empty() : Mono.from(bindPublisher);
            });
        }

        protected Publisher<OracleResultImpl> executeJdbc() {
            return Mono.from(OracleStatementImpl.this.adapter.publishSQLExecution(this.preparedStatement)).flatMapMany(this::getResults);
        }

        protected final Publisher<OracleResultImpl> getResults(boolean isResultSet) {
            return OracleStatementImpl.this.adapter.getLock().flatMap(() -> {
                OracleResultImpl result = this.getCurrentResult(isResultSet);
                OracleResultImpl nextResult = this.getCurrentResult(this.preparedStatement.getMoreResults(2));
                if (nextResult == null) {
                    return Mono.justOrEmpty((Object)result);
                }
                ArrayList<OracleResultImpl> results = new ArrayList<OracleResultImpl>();
                if (result != null) {
                    results.add(result);
                }
                while (nextResult != null) {
                    results.add(nextResult);
                    nextResult = this.getCurrentResult(this.preparedStatement.getMoreResults(2));
                }
                return Flux.fromIterable(results);
            });
        }

        protected void addDeallocation(Publisher<Void> publisher) {
            this.deallocators = Flux.concatDelayError((Publisher[])new Publisher[]{this.deallocators, publisher});
        }

        private OracleResultImpl getCurrentResult(boolean isResultSet) {
            return OracleR2dbcExceptions.fromJdbc(() -> {
                if (isResultSet) {
                    return OracleResultImpl.createQueryResult(this.dependentCounter, this.preparedStatement.getResultSet(), OracleStatementImpl.this.adapter);
                }
                long updateCount = this.preparedStatement.getLargeUpdateCount();
                return updateCount >= 0L ? OracleResultImpl.createUpdateCountResult(updateCount) : null;
            });
        }

        private OracleResultImpl getWarnings(OracleResultImpl result) {
            return OracleR2dbcExceptions.fromJdbc(() -> {
                SQLWarning warning = this.preparedStatement.getWarnings();
                this.preparedStatement.clearWarnings();
                return warning == null ? result : OracleResultImpl.createWarningResult(OracleStatementImpl.this.sql, warning, result);
            });
        }

        private Publisher<Void> deallocate() {
            this.addDeallocation(this.dependentCounter.decrement());
            return this.deallocators;
        }

        private Publisher<Void> closeStatement() {
            return OracleStatementImpl.this.adapter.getLock().run(() -> {
                block2: {
                    try {
                        this.preparedStatement.getMoreResults(3);
                    }
                    catch (SQLException sqlException) {
                        if (OracleStatementImpl.this.jdbcConnection.isClosed()) break block2;
                        throw sqlException;
                    }
                }
                this.preparedStatement.close();
            });
        }

        private void setBind(int index, Object value, SQLType type, String typeName) {
            OracleR2dbcExceptions.runJdbc(() -> {
                int jdbcIndex = index + 1;
                if (type == null) {
                    this.preparedStatement.setObject(jdbcIndex, value);
                } else if (value == null) {
                    this.preparedStatement.setNull(jdbcIndex, type.getVendorTypeNumber(), typeName);
                } else {
                    this.preparedStatement.setObject(jdbcIndex, value, type);
                }
            });
        }

        private Object convertBind(Object value) {
            if (value == null || value == NULL_BIND) {
                return null;
            }
            if (value instanceof io.r2dbc.spi.Blob) {
                return this.convertBlobBind((io.r2dbc.spi.Blob)value);
            }
            if (value instanceof Clob) {
                return this.convertClobBind((Clob)value);
            }
            if (value instanceof ByteBuffer) {
                return this.convertByteBufferBind((ByteBuffer)value);
            }
            if (value instanceof Parameter) {
                return this.convertParameterBind((Parameter)value);
            }
            if (value instanceof OracleR2dbcObject) {
                return this.convertObjectBind((OracleR2dbcObject)value);
            }
            return value;
        }

        private Object convertParameterBind(Parameter parameter) {
            Object value = parameter.getValue();
            if (value == null) {
                return null;
            }
            Type type = parameter.getType();
            if (type instanceof OracleR2dbcTypes.ArrayType) {
                return this.convertArrayBind((OracleR2dbcTypes.ArrayType)type, value);
            }
            if (type instanceof OracleR2dbcTypes.ObjectType) {
                return this.convertObjectBind((OracleR2dbcTypes.ObjectType)type, value);
            }
            return this.convertBind(value);
        }

        private java.sql.Array convertArrayBind(OracleR2dbcTypes.ArrayType type, Object value) {
            return OracleR2dbcExceptions.fromJdbc(() -> OracleStatementImpl.this.jdbcConnection.unwrap(OracleConnection.class).createOracleArray(type.getName(), this.convertJavaArray(value)));
        }

        private Object convertJavaArray(Object array) {
            if (array == null) {
                return null;
            }
            if (array instanceof byte[]) {
                byte[] bytes = (byte[])array;
                short[] shorts = new short[bytes.length];
                for (int i = 0; i < bytes.length; ++i) {
                    shorts[i] = (short)(0xFF & bytes[i]);
                }
                return shorts;
            }
            if (array instanceof ByteBuffer[]) {
                ByteBuffer[] byteBuffers = (ByteBuffer[])array;
                byte[][] byteArrays = new byte[byteBuffers.length][];
                for (int i = 0; i < byteBuffers.length; ++i) {
                    ByteBuffer byteBuffer = byteBuffers[i];
                    byteArrays[i] = byteBuffer == null ? null : this.convertByteBufferBind(byteBuffers[i]);
                }
                return byteArrays;
            }
            if (array instanceof Period[]) {
                Period[] periods = (Period[])array;
                INTERVALYM[] intervalYearToMonths = new INTERVALYM[periods.length];
                for (int i = 0; i < periods.length; ++i) {
                    Period period = periods[i];
                    if (period == null) {
                        intervalYearToMonths[i] = null;
                        continue;
                    }
                    byte[] bytes = new byte[5];
                    ByteBuffer.wrap(bytes).putInt(period.getYears() + Integer.MIN_VALUE).put((byte)(period.getMonths() + 60));
                    intervalYearToMonths[i] = new INTERVALYM(bytes);
                }
                return intervalYearToMonths;
            }
            Class<?> componentType = array.getClass().getComponentType();
            if (componentType == null || !componentType.isArray()) {
                return array;
            }
            int length = Array.getLength(array);
            Object[] converted = new Object[length];
            for (int i = 0; i < length; ++i) {
                converted[i] = this.convertJavaArray(Array.get(array, i));
            }
            return converted;
        }

        private Object convertObjectBind(OracleR2dbcObject object) {
            return this.convertObjectBind(object.getMetadata().getObjectType(), object);
        }

        private Object convertObjectBind(OracleR2dbcTypes.ObjectType type, Object value) {
            Object[] attributes;
            if (value == null) {
                return null;
            }
            ReadablesMetadata.OracleR2dbcObjectMetadataImpl metadata = ReadablesMetadata.createAttributeMetadata(OracleR2dbcExceptions.fromJdbc(() -> (OracleStruct)OracleStatementImpl.this.jdbcConnection.createStruct(type.getName(), null)));
            if (value instanceof Object[]) {
                attributes = this.toAttributeArray((Object[])value, (OracleR2dbcObjectMetadata)metadata);
            } else if (value instanceof Map) {
                Map valueMap = (Map)value;
                attributes = this.toAttributeArray(valueMap, (OracleR2dbcObjectMetadata)metadata);
            } else if (value instanceof Readable) {
                attributes = this.toAttributeArray((Readable)value, (OracleR2dbcObjectMetadata)metadata);
            } else {
                return value;
            }
            Publisher<Void> conversionPublisher = this.convertUdtValues(attributes, metadata);
            OracleR2dbcExceptions.JdbcSupplier<Struct> structSupplier = () -> OracleStatementImpl.this.jdbcConnection.unwrap(OracleConnection.class).createStruct(type.getName(), attributes);
            if (conversionPublisher == null) {
                return structSupplier.get();
            }
            return Mono.from(conversionPublisher).then(Mono.fromSupplier(structSupplier));
        }

        private Object[] toAttributeArray(Object[] values, OracleR2dbcObjectMetadata metadata) {
            List<? extends ReadableMetadata> metadatas = metadata.getAttributeMetadatas();
            if (values.length != metadatas.size()) {
                throw new IllegalArgumentException(String.format("Length of Object[]: %d, does not match the number of attributes in OBJECT %s: %d", values.length, metadata.getObjectType().getName(), metadatas.size()));
            }
            return (Object[])values.clone();
        }

        private Object[] toAttributeArray(Map<String, Object> values, OracleR2dbcObjectMetadata metadata) {
            TreeMap<String, Object> treeMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
            treeMap.putAll(values);
            List<? extends ReadableMetadata> metadatas = metadata.getAttributeMetadatas();
            Set remainingNames = treeMap.keySet();
            Object[] attributes = new Object[metadatas.size()];
            for (int i = 0; i < attributes.length; ++i) {
                String attributeName = metadatas.get(i).getName();
                Object attribute = treeMap.get(attributeName);
                if (attribute == null && !treeMap.containsKey(attributeName)) {
                    throw new IllegalArgumentException(String.format("Map contains no key for attribute %s of OBJECT %s", attributeName, metadata.getObjectType().getName()));
                }
                remainingNames.remove(attributeName);
                attributes[i] = attribute;
            }
            if (!remainingNames.isEmpty()) {
                throw new IllegalArgumentException(String.format("Map contains keys: [%s], which do not match any attribute names of OBJECT %s: [%s]", String.join((CharSequence)",", remainingNames), metadata.getObjectType().getName(), metadatas.stream().map(ReadableMetadata::getName).collect(Collectors.joining(","))));
            }
            return attributes;
        }

        private Object[] toAttributeArray(Readable readable, OracleR2dbcObjectMetadata metadata) {
            Object[] attributes = new Object[metadata.getAttributeMetadatas().size()];
            for (int i = 0; i < attributes.length; ++i) {
                try {
                    attributes[i] = readable.get(i);
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw new IllegalArgumentException(String.format("Readable contains less values than the number of attributes, %d, in OBJECT %s", attributes.length, metadata.getObjectType().getName()));
                }
            }
            try {
                readable.get(attributes.length);
                throw new IllegalArgumentException(String.format("Readable contains more values than the number of attributes, %d, in OBJECT %s", attributes.length, metadata.getObjectType().getName()));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return attributes;
            }
        }

        private Publisher<Void> convertUdtValues(Object[] values, OracleR2dbcObjectMetadata metadata) {
            LinkedList<Mono> publishers = null;
            for (int i = 0; i < values.length; ++i) {
                values[i] = this.convertBind(values[i]);
                if (values[i] instanceof Period) {
                    values[i] = this.convertPeriodUdtValue((Period)values[i]);
                } else if (values[i] instanceof LocalDateTime) {
                    values[i] = this.convertLocalDateTimeUdtValue((LocalDateTime)values[i]);
                } else if (values[i] instanceof LocalDate) {
                    values[i] = this.convertLocalDateUdtValue((LocalDate)values[i]);
                } else if (values[i] instanceof LocalTime) {
                    values[i] = this.convertLocalTimeUdtValue((LocalTime)values[i]);
                } else if (values[i] instanceof Duration) {
                    values[i] = this.convertDurationUdtValue((Duration)values[i]);
                } else if (values[i] instanceof byte[] && R2dbcType.BLOB.equals((Object)metadata.getAttributeMetadata(i).getType())) {
                    values[i] = this.convertBlobUdtValue((byte[])values[i]);
                } else if (values[i] instanceof CharSequence && R2dbcType.CLOB.equals((Object)metadata.getAttributeMetadata(i).getType())) {
                    values[i] = this.convertClobUdtValue((CharSequence)values[i]);
                }
                if (!(values[i] instanceof Publisher)) continue;
                if (publishers == null) {
                    publishers = new LinkedList<Mono>();
                }
                int valueIndex = i;
                publishers.add(Mono.from((Publisher)((Publisher)values[i])).doOnSuccess(value -> {
                    values[valueIndex] = value;
                }).then());
            }
            return publishers == null ? null : Flux.concat(publishers);
        }

        private TIMESTAMP convertLocalDateTimeUdtValue(LocalDateTime localDateTime) {
            return OracleR2dbcExceptions.fromJdbc(() -> TIMESTAMP.of((LocalDateTime)localDateTime));
        }

        private DATE convertLocalDateUdtValue(LocalDate localDate) {
            return OracleR2dbcExceptions.fromJdbc(() -> DATE.of((LocalDate)localDate));
        }

        private TIMESTAMP convertLocalTimeUdtValue(LocalTime localTime) {
            return OracleR2dbcExceptions.fromJdbc(() -> TIMESTAMP.of((LocalDateTime)LocalDateTime.of(LocalDate.EPOCH, localTime)));
        }

        private INTERVALDS convertDurationUdtValue(Duration duration) {
            byte[] bytes = new byte[11];
            ByteBuffer.wrap(bytes).putInt((int)duration.toDaysPart() + Integer.MIN_VALUE).put((byte)(duration.toHoursPart() + 60)).put((byte)(duration.toMinutesPart() + 60)).put((byte)(duration.toSecondsPart() + 60)).putInt(duration.toNanosPart() + Integer.MIN_VALUE);
            return new INTERVALDS(bytes);
        }

        private INTERVALYM convertPeriodUdtValue(Period period) {
            byte[] bytes = new byte[5];
            ByteBuffer.wrap(bytes).putInt(period.getYears() + Integer.MIN_VALUE).put((byte)(period.getMonths() + 60));
            return new INTERVALYM(bytes);
        }

        private Publisher<Blob> convertBlobUdtValue(byte[] bytes) {
            return this.convertBlobBind(io.r2dbc.spi.Blob.from((Publisher)Mono.just((Object)ByteBuffer.wrap(bytes))));
        }

        private Publisher<java.sql.Clob> convertClobUdtValue(CharSequence charSequence) {
            return this.convertClobBind(Clob.from((Publisher)Mono.just((Object)charSequence)));
        }

        private Publisher<Blob> convertBlobBind(io.r2dbc.spi.Blob r2dbcBlob) {
            return Mono.usingWhen(OracleStatementImpl.this.adapter.getLock().get(OracleStatementImpl.this.jdbcConnection::createBlob), jdbcBlob -> Mono.from(OracleStatementImpl.this.adapter.publishBlobWrite((Publisher<ByteBuffer>)r2dbcBlob.stream(), (Blob)jdbcBlob)).thenReturn(jdbcBlob), jdbcBlob -> {
                this.addDeallocation(OracleStatementImpl.this.adapter.publishBlobFree((Blob)jdbcBlob));
                return r2dbcBlob.discard();
            });
        }

        private Publisher<java.sql.Clob> convertClobBind(Clob r2dbcClob) {
            return Mono.usingWhen(OracleStatementImpl.this.adapter.getLock().get(OracleStatementImpl.this.jdbcConnection::createNClob), jdbcClob -> Mono.from(OracleStatementImpl.this.adapter.publishClobWrite((Publisher<? extends CharSequence>)r2dbcClob.stream(), (java.sql.Clob)jdbcClob)).thenReturn(jdbcClob), jdbcClob -> {
                this.addDeallocation(OracleStatementImpl.this.adapter.publishClobFree((java.sql.Clob)jdbcClob));
                return r2dbcClob.discard();
            });
        }

        private byte[] convertByteBufferBind(ByteBuffer byteBuffer) {
            ByteBuffer slice = byteBuffer.slice();
            byte[] byteArray = new byte[slice.remaining()];
            slice.get(byteArray);
            return byteArray;
        }
    }
}

