/*
 * Decompiled with CFR 0.152.
 */
package oracle.r2dbc.impl;

import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.ConnectionFactoryMetadata;
import io.r2dbc.spi.ConnectionFactoryOptions;
import io.r2dbc.spi.Option;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import oracle.r2dbc.OracleR2dbcOptions;
import oracle.r2dbc.impl.OracleConnectionFactoryMetadataImpl;
import oracle.r2dbc.impl.OracleConnectionFactoryProviderImpl;
import oracle.r2dbc.impl.OracleR2dbcExceptions;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class SuppliedOptionConnectionFactory
implements ConnectionFactory {
    private static final Set<Option<?>> ALL_OPTIONS = Stream.concat(Stream.of(ConnectionFactoryOptions.CONNECT_TIMEOUT, ConnectionFactoryOptions.DATABASE, ConnectionFactoryOptions.DRIVER, ConnectionFactoryOptions.HOST, ConnectionFactoryOptions.LOCK_WAIT_TIMEOUT, ConnectionFactoryOptions.PASSWORD, ConnectionFactoryOptions.PORT, ConnectionFactoryOptions.PROTOCOL, ConnectionFactoryOptions.SSL, ConnectionFactoryOptions.STATEMENT_TIMEOUT, ConnectionFactoryOptions.USER), OracleR2dbcOptions.options().stream()).collect(Collectors.toUnmodifiableSet());
    private final Set<Publisher<OptionValue>> optionValuePublishers = ALL_OPTIONS.stream().map(option -> SuppliedOptionConnectionFactory.toOptionValuePublisher(option, options.getValue(option))).filter(Objects::nonNull).collect(Collectors.toUnmodifiableSet());

    SuppliedOptionConnectionFactory(ConnectionFactoryOptions options) {
    }

    public Publisher<? extends Connection> create() {
        return Flux.merge(this.optionValuePublishers).collectList().map(SuppliedOptionConnectionFactory::toConnectionFactoryOptions).flatMap(options -> Mono.from((Publisher)new OracleConnectionFactoryProviderImpl().create((ConnectionFactoryOptions)options).create()));
    }

    public ConnectionFactoryMetadata getMetadata() {
        return OracleConnectionFactoryMetadataImpl.INSTANCE;
    }

    private static Publisher<OptionValue> toOptionValuePublisher(Option<?> option, Object value) {
        Mono valuePublisher;
        if (value == null) {
            return null;
        }
        if (value instanceof Supplier) {
            valuePublisher = Mono.fromSupplier((Supplier)((Supplier)value));
        } else if (value instanceof Publisher) {
            valuePublisher = Mono.from((Publisher)((Publisher)value));
        } else {
            return Mono.just((Object)new OptionValue(option, value));
        }
        return Mono.from((Publisher)valuePublisher).map(publishedValue -> new OptionValue(option, publishedValue)).onErrorMap(error -> OracleR2dbcExceptions.newNonTransientException("Error when requesting a value of " + option + " from a Supplier or Publisher", null, error));
    }

    private static ConnectionFactoryOptions toConnectionFactoryOptions(Iterable<OptionValue> optionValues) {
        ConnectionFactoryOptions.Builder optionsBuilder = ConnectionFactoryOptions.builder();
        optionValues.forEach(optionValue -> optionValue.configure(optionsBuilder));
        return optionsBuilder.build();
    }

    static boolean containsSuppliedValue(ConnectionFactoryOptions options) {
        return ALL_OPTIONS.stream().map(arg_0 -> ((ConnectionFactoryOptions)options).getValue(arg_0)).anyMatch(value -> value instanceof Supplier || value instanceof Publisher);
    }

    private static final class OptionValue {
        final Option<?> option;
        final Object value;

        OptionValue(Option<?> option, Object value) {
            this.option = option;
            this.value = value;
        }

        void configure(ConnectionFactoryOptions.Builder builder) {
            Option<?> option = this.option;
            builder.option(option, this.value);
        }
    }
}

