/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.spring.aqjms;

import com.oracle.spring.aqjms.AqJmsConfigurationProperties;
import jakarta.jms.ConnectionFactory;
import javax.sql.DataSource;
import oracle.jakarta.jms.AQjmsFactory;
import oracle.ucp.jdbc.PoolDataSource;
import oracle.ucp.jdbc.PoolDataSourceFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={AqJmsConfigurationProperties.class})
public class AqJmsAutoConfiguration {
    @Autowired
    private AqJmsConfigurationProperties properties;

    @Bean
    @ConditionalOnMissingBean
    public PoolDataSource dataSource() {
        PoolDataSource ds = PoolDataSourceFactory.getPoolDataSource();
        try {
            ds.setConnectionFactoryClassName("oracle.jdbc.pool.OracleDataSource");
            ds.setURL(this.properties.getUrl());
            ds.setUser(this.properties.getUsername());
            ds.setPassword(this.properties.getPassword());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ds;
    }

    @Bean
    @ConditionalOnMissingBean
    public ConnectionFactory aqJmsConnectionFactory(PoolDataSource ds) {
        ConnectionFactory connectionFactory = null;
        try {
            connectionFactory = AQjmsFactory.getConnectionFactory((DataSource)ds);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return connectionFactory;
    }
}

