/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.spring.ucp;

import jakarta.annotation.PostConstruct;
import java.sql.SQLException;
import javax.sql.DataSource;
import oracle.jdbc.pool.OracleDataSource;
import oracle.ucp.jdbc.PoolDataSourceImpl;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;

@AutoConfiguration
@ConditionalOnClass(value={OracleDataSource.class})
@ConditionalOnBean(value={DataSource.class})
public class UCPAutoConfiguration {
    private final DataSource dataSource;

    public UCPAutoConfiguration(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @PostConstruct
    public void init() {
        DataSource dataSource = this.dataSource;
        if (dataSource instanceof PoolDataSourceImpl) {
            PoolDataSourceImpl ds = (PoolDataSourceImpl)dataSource;
            try {
                ds.setConnectionFactoryClassName("oracle.jdbc.pool.OracleDataSource");
                this.setIfNull(ds.getConnectionPoolName(), () -> ds.setConnectionPoolName("SpringConnectionPool"));
                this.setIfNull(ds.getInitialPoolSize(), () -> ds.setInitialPoolSize(15));
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private <T> void setIfNull(T value, Setter setter) throws SQLException {
        Integer intValue;
        if (value == null) {
            setter.set();
        } else if (value instanceof Integer && (intValue = (Integer)value) < 1) {
            setter.set();
        }
    }

    private static interface Setter {
        public void set() throws SQLException;
    }
}

