/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.net.HostAndPort;
import com.orbitz.consul.ConsulException;
import com.orbitz.consul.NotRegisteredException;
import com.orbitz.consul.model.State;
import com.orbitz.consul.model.agent.Agent;
import com.orbitz.consul.model.agent.Check;
import com.orbitz.consul.model.agent.ImmutableCheck;
import com.orbitz.consul.model.agent.ImmutableRegistration;
import com.orbitz.consul.model.agent.Member;
import com.orbitz.consul.model.agent.Registration;
import com.orbitz.consul.model.health.HealthCheck;
import com.orbitz.consul.model.health.Service;
import com.orbitz.consul.option.QueryOptions;
import com.orbitz.consul.util.Http;
import com.orbitz.retrofit.Call;
import com.orbitz.retrofit.Response;
import com.orbitz.retrofit.Retrofit;
import com.orbitz.retrofit.http.Body;
import com.orbitz.retrofit.http.GET;
import com.orbitz.retrofit.http.PUT;
import com.orbitz.retrofit.http.Path;
import com.orbitz.retrofit.http.QueryMap;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class AgentClient {
    private final Api api;

    AgentClient(Retrofit retrofit) {
        this.api = retrofit.create(Api.class);
    }

    public boolean isRegistered(String serviceId) {
        Map<String, Service> serviceIdToService = this.getServices();
        return serviceIdToService.containsKey(serviceId);
    }

    public void ping() {
        try {
            Response<Void> response = this.api.ping().execute();
            if (!response.isSuccessful()) {
                throw new ConsulException(String.format("Error pinging Consul: %s", response.message()));
            }
        }
        catch (Exception ex) {
            throw new ConsulException("Error connecting to Consul", ex);
        }
    }

    public void register(int port, long ttl, String name, String id, String ... tags) {
        Registration.RegCheck check = Registration.RegCheck.ttl(ttl);
        this.register(port, check, name, id, tags);
    }

    public void register(int port, String script, long interval, String name, String id, String ... tags) {
        Registration.RegCheck check = Registration.RegCheck.script(script, interval);
        this.register(port, check, name, id, tags);
    }

    public void register(int port, URL http, long interval, String name, String id, String ... tags) {
        Registration.RegCheck check = Registration.RegCheck.http(http.toExternalForm(), interval);
        this.register(port, check, name, id, tags);
    }

    public void register(int port, HostAndPort tcp, long interval, String name, String id, String ... tags) {
        Registration.RegCheck check = Registration.RegCheck.tcp(tcp.toString(), interval);
        this.register(port, check, name, id, tags);
    }

    public void register(int port, Registration.RegCheck check, String name, String id, String ... tags) {
        ImmutableRegistration registration = ImmutableRegistration.builder().port(port).check((Optional<Registration.RegCheck>)Optional.fromNullable((Object)check)).name(name).id(id).addTags(tags).build();
        this.register(registration);
    }

    public void register(int port, List<Registration.RegCheck> checks, String name, String id, String ... tags) {
        ImmutableRegistration registration = ImmutableRegistration.builder().port(port).checks(checks).name(name).id(id).addTags(tags).build();
        this.register(registration);
    }

    public void register(Registration registration, QueryOptions options) {
        Http.handle(this.api.register(registration, options.toQuery()));
    }

    public void register(Registration registration) {
        this.register(registration, QueryOptions.BLANK);
    }

    public void deregister(String serviceId) {
        Http.handle(this.api.deregister(serviceId));
    }

    public void registerCheck(String checkId, String name, String script, long interval) {
        this.registerCheck(checkId, name, script, interval, null);
    }

    public void registerCheck(String checkId, String name, URL http, long interval) {
        this.registerCheck(checkId, name, http, interval, null);
    }

    public void registerCheck(String checkId, String name, HostAndPort tcp, long interval) {
        this.registerCheck(checkId, name, tcp, interval, null);
    }

    public void registerCheck(String checkId, String name, String script, long interval, String notes) {
        ImmutableCheck check = ImmutableCheck.builder().id(checkId).name(name).script(script).interval(String.format("%ss", interval)).notes((Optional<String>)Optional.fromNullable((Object)notes)).build();
        this.registerCheck(check);
    }

    public void registerCheck(String checkId, String name, URL http, long interval, String notes) {
        ImmutableCheck check = ImmutableCheck.builder().id(checkId).name(name).http(http.toExternalForm()).interval(String.format("%ss", interval)).notes((Optional<String>)Optional.fromNullable((Object)notes)).build();
        this.registerCheck(check);
    }

    public void registerCheck(String checkId, String name, HostAndPort tcp, long interval, String notes) {
        ImmutableCheck check = ImmutableCheck.builder().id(checkId).name(name).tcp(tcp.toString()).interval(String.format("%ss", interval)).notes((Optional<String>)Optional.fromNullable((Object)notes)).build();
        this.registerCheck(check);
    }

    public void registerCheck(String checkId, String name, long ttl) {
        this.registerCheck(checkId, name, ttl, null);
    }

    public void registerCheck(String checkId, String name, long ttl, String notes) {
        ImmutableCheck check = ImmutableCheck.builder().id(checkId).name(name).ttl(String.format("%ss", ttl)).notes((Optional<String>)Optional.fromNullable((Object)notes)).build();
        this.registerCheck(check);
    }

    public void registerCheck(Check check) {
        Http.handle(this.api.registerCheck(check));
    }

    public void deregisterCheck(String checkId) {
        Http.handle(this.api.deregisterCheck(checkId));
    }

    public Agent getAgent() {
        return Http.extract(this.api.getAgent());
    }

    public Map<String, HealthCheck> getChecks() {
        return Http.extract(this.api.getChecks());
    }

    public Map<String, Service> getServices() {
        return Http.extract(this.api.getServices());
    }

    public List<Member> getMembers() {
        return Http.extract(this.api.getMembers());
    }

    public void forceLeave(String node) {
        Http.handle(this.api.forceLeave());
    }

    public void check(String checkId, State state, String note) throws NotRegisteredException {
        try {
            ImmutableMap query = Collections.emptyMap();
            if (note != null) {
                query = ImmutableMap.of((Object)"note", (Object)note);
            }
            Http.handle(this.api.check(state.getPath(), checkId, (Map<String, String>)query));
        }
        catch (Exception ex) {
            throw new NotRegisteredException();
        }
    }

    public void checkTtl(String serviceId, State state, String note) throws NotRegisteredException {
        this.check("service:" + serviceId, state, note);
    }

    public void pass(String serviceId) throws NotRegisteredException {
        this.checkTtl(serviceId, State.PASS, null);
    }

    public void pass(String serviceId, String note) throws NotRegisteredException {
        this.checkTtl(serviceId, State.PASS, note);
    }

    public void warn(String serviceId) throws NotRegisteredException {
        this.checkTtl(serviceId, State.WARN, null);
    }

    public void warn(String serviceId, String note) throws NotRegisteredException {
        this.checkTtl(serviceId, State.WARN, note);
    }

    public void fail(String serviceId) throws NotRegisteredException {
        this.checkTtl(serviceId, State.FAIL, null);
    }

    public void fail(String serviceId, String note) throws NotRegisteredException {
        this.checkTtl(serviceId, State.FAIL, note);
    }

    public void passCheck(String checkId) throws NotRegisteredException {
        this.check(checkId, State.PASS, null);
    }

    public void passCheck(String checkId, String note) throws NotRegisteredException {
        this.check(checkId, State.PASS, note);
    }

    public void warnCheck(String checkId) throws NotRegisteredException {
        this.check(checkId, State.WARN, null);
    }

    public void warnCheck(String checkId, String note) throws NotRegisteredException {
        this.check(checkId, State.WARN, note);
    }

    public void failCheck(String checkId) throws NotRegisteredException {
        this.check(checkId, State.FAIL, null);
    }

    public void failCheck(String checkId, String note) throws NotRegisteredException {
        this.check(checkId, State.FAIL, note);
    }

    public boolean join(String address) {
        return this.join(address, false);
    }

    public boolean join(String address, boolean wan) {
        ImmutableMap query = Collections.emptyMap();
        boolean result = true;
        if (wan) {
            query = ImmutableMap.of((Object)"wan", (Object)"1");
        }
        try {
            Http.handle(this.api.join(address, (Map<String, String>)query));
        }
        catch (Exception ex) {
            result = false;
        }
        return result;
    }

    static interface Api {
        @PUT(value="agent/service/register")
        public Call<Void> register(@Body Registration var1, @QueryMap Map<String, Object> var2);

        @GET(value="agent/service/deregister/{serviceId}")
        public Call<Void> deregister(@Path(value="serviceId") String var1);

        @PUT(value="agent/check/register")
        public Call<Void> registerCheck(@Body Check var1);

        @GET(value="agent/check/deregister/{checkId}")
        public Call<Void> deregisterCheck(@Path(value="checkId") String var1);

        @GET(value="agent/self")
        public Call<Void> ping();

        @GET(value="agent/self")
        public Call<Agent> getAgent();

        @GET(value="agent/checks")
        public Call<Map<String, HealthCheck>> getChecks();

        @GET(value="agent/services")
        public Call<Map<String, Service>> getServices();

        @GET(value="agent/members")
        public Call<List<Member>> getMembers();

        @GET(value="agent/force-leave")
        public Call<Void> forceLeave();

        @GET(value="agent/check/{state}/{checkId}")
        public Call<Void> check(@Path(value="state") String var1, @Path(value="checkId") String var2, @QueryMap Map<String, String> var3);

        @GET(value="agent/join/{address}")
        public Call<Void> join(String var1, Map<String, String> var2);
    }
}

