/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.query;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.orbitz.consul.model.query.Failover;
import com.orbitz.consul.model.query.ServiceQuery;
import com.orbitz.fasterxml.jackson.annotation.JsonCreator;
import com.orbitz.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.orbitz.fasterxml.jackson.annotation.JsonProperty;
import com.orbitz.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class ImmutableServiceQuery
extends ServiceQuery {
    private final String service;
    private final Optional<Boolean> onlyPassing;
    private final Optional<List<String>> tags;
    private final Optional<Failover> failover;

    private ImmutableServiceQuery(String service, Optional<Boolean> onlyPassing, Optional<List<String>> tags, Optional<Failover> failover) {
        this.service = service;
        this.onlyPassing = onlyPassing;
        this.tags = tags;
        this.failover = failover;
    }

    @Override
    @JsonProperty(value="Service")
    public String getService() {
        return this.service;
    }

    @Override
    @JsonProperty(value="OnlyPassing")
    public Optional<Boolean> getOnlyPassing() {
        return this.onlyPassing;
    }

    @Override
    @JsonProperty(value="Tags")
    public Optional<List<String>> getTags() {
        return this.tags;
    }

    @Override
    @JsonProperty(value="Failover")
    public Optional<Failover> getFailover() {
        return this.failover;
    }

    public final ImmutableServiceQuery withService(String value) {
        if (this.service.equals(value)) {
            return this;
        }
        return new ImmutableServiceQuery((String)Preconditions.checkNotNull((Object)value, (Object)"service"), this.onlyPassing, this.tags, this.failover);
    }

    public final ImmutableServiceQuery withOnlyPassing(boolean value) {
        Optional newValue = Optional.of((Object)value);
        if (this.onlyPassing.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableServiceQuery(this.service, (Optional<Boolean>)newValue, this.tags, this.failover);
    }

    public final ImmutableServiceQuery withOnlyPassing(Optional<Boolean> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"onlyPassing");
        if (this.onlyPassing.equals((Object)value)) {
            return this;
        }
        return new ImmutableServiceQuery(this.service, (Optional<Boolean>)value, this.tags, this.failover);
    }

    public final ImmutableServiceQuery withTags(List<String> value) {
        Optional newValue = Optional.of(value);
        if (this.tags.isPresent() && this.tags.get() == value) {
            return this;
        }
        return new ImmutableServiceQuery(this.service, this.onlyPassing, (Optional<List<String>>)newValue, this.failover);
    }

    public final ImmutableServiceQuery withTags(Optional<List<String>> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"tags");
        if (!this.tags.isPresent() && !value.isPresent()) {
            return this;
        }
        if (this.tags.isPresent() && value.isPresent() && this.tags.get() == value.get()) {
            return this;
        }
        return new ImmutableServiceQuery(this.service, this.onlyPassing, (Optional<List<String>>)value, this.failover);
    }

    public final ImmutableServiceQuery withFailover(Failover value) {
        Optional newValue = Optional.of((Object)value);
        if (this.failover.isPresent() && this.failover.get() == value) {
            return this;
        }
        return new ImmutableServiceQuery(this.service, this.onlyPassing, this.tags, (Optional<Failover>)newValue);
    }

    public final ImmutableServiceQuery withFailover(Optional<Failover> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"failover");
        if (!this.failover.isPresent() && !value.isPresent()) {
            return this;
        }
        if (this.failover.isPresent() && value.isPresent() && this.failover.get() == value.get()) {
            return this;
        }
        return new ImmutableServiceQuery(this.service, this.onlyPassing, this.tags, (Optional<Failover>)value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableServiceQuery && this.equalTo((ImmutableServiceQuery)another);
    }

    private boolean equalTo(ImmutableServiceQuery another) {
        return this.service.equals(another.service) && this.onlyPassing.equals(another.onlyPassing) && this.tags.equals(another.tags) && this.failover.equals(another.failover);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.service.hashCode();
        h = h * 17 + this.onlyPassing.hashCode();
        h = h * 17 + this.tags.hashCode();
        h = h * 17 + this.failover.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ServiceQuery").omitNullValues().add("service", (Object)this.service).add("onlyPassing", this.onlyPassing.orNull()).add("tags", this.tags.orNull()).add("failover", this.failover.orNull()).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableServiceQuery fromJson(Json json) {
        Builder builder = ImmutableServiceQuery.builder();
        if (json.service != null) {
            builder.service(json.service);
        }
        if (json.onlyPassing != null) {
            builder.onlyPassing(json.onlyPassing);
        }
        if (json.tags != null) {
            builder.tags(json.tags);
        }
        if (json.failover != null) {
            builder.failover(json.failover);
        }
        return builder.build();
    }

    public static ImmutableServiceQuery copyOf(ServiceQuery instance) {
        if (instance instanceof ImmutableServiceQuery) {
            return (ImmutableServiceQuery)instance;
        }
        return ImmutableServiceQuery.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_SERVICE = 1L;
        private long initBits = 1L;
        private String service;
        private Optional<Boolean> onlyPassing = Optional.absent();
        private Optional<List<String>> tags = Optional.absent();
        private Optional<Failover> failover = Optional.absent();

        private Builder() {
        }

        public final Builder from(ServiceQuery instance) {
            Optional<Failover> failoverOptional;
            Optional<List<String>> tagsOptional;
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.service(instance.getService());
            Optional<Boolean> onlyPassingOptional = instance.getOnlyPassing();
            if (onlyPassingOptional.isPresent()) {
                this.onlyPassing(onlyPassingOptional);
            }
            if ((tagsOptional = instance.getTags()).isPresent()) {
                this.tags(tagsOptional);
            }
            if ((failoverOptional = instance.getFailover()).isPresent()) {
                this.failover(failoverOptional);
            }
            return this;
        }

        public final Builder service(String service) {
            this.service = (String)Preconditions.checkNotNull((Object)service, (Object)"service");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder onlyPassing(boolean onlyPassing) {
            this.onlyPassing = Optional.of((Object)onlyPassing);
            return this;
        }

        public final Builder onlyPassing(Optional<Boolean> onlyPassing) {
            this.onlyPassing = (Optional)Preconditions.checkNotNull(onlyPassing, (Object)"onlyPassing");
            return this;
        }

        public final Builder tags(List<String> tags) {
            this.tags = Optional.of(tags);
            return this;
        }

        public final Builder tags(Optional<List<String>> tags) {
            this.tags = (Optional)Preconditions.checkNotNull(tags, (Object)"tags");
            return this;
        }

        public final Builder failover(Failover failover) {
            this.failover = Optional.of((Object)failover);
            return this;
        }

        public final Builder failover(Optional<Failover> failover) {
            this.failover = (Optional)Preconditions.checkNotNull(failover, (Object)"failover");
            return this;
        }

        public ImmutableServiceQuery build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableServiceQuery(this.service, this.onlyPassing, this.tags, this.failover);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("service");
            }
            return "Cannot build ServiceQuery, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends ServiceQuery {
        String service;
        Optional<Boolean> onlyPassing = Optional.absent();
        Optional<List<String>> tags = Optional.absent();
        Optional<Failover> failover = Optional.absent();

        Json() {
        }

        @JsonProperty(value="Service")
        public void setService(String service) {
            this.service = service;
        }

        @JsonProperty(value="OnlyPassing")
        public void setOnlyPassing(Optional<Boolean> onlyPassing) {
            this.onlyPassing = onlyPassing;
        }

        @JsonProperty(value="Tags")
        public void setTags(Optional<List<String>> tags) {
            this.tags = tags;
        }

        @JsonProperty(value="Failover")
        public void setFailover(Optional<Failover> failover) {
            this.failover = failover;
        }

        @Override
        public String getService() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> getOnlyPassing() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<List<String>> getTags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Failover> getFailover() {
            throw new UnsupportedOperationException();
        }
    }
}

