/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.option;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.orbitz.consul.option.ConsistencyMode;
import com.orbitz.consul.option.ImmutableQueryOptions;
import com.orbitz.consul.option.Options;
import com.orbitz.consul.option.ParamAdder;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.immutables.value.Value;

@Value.Immutable
public abstract class QueryOptions
implements ParamAdder {
    public static final QueryOptions BLANK = ImmutableQueryOptions.builder().build();

    public abstract Optional<String> getWait();

    public abstract Optional<String> getToken();

    public abstract Optional<BigInteger> getIndex();

    public abstract Optional<String> getNear();

    @Value.Default
    public ConsistencyMode getConsistencyMode() {
        return ConsistencyMode.DEFAULT;
    }

    @Value.Derived
    public boolean isBlocking() {
        return this.getWait().isPresent();
    }

    @Value.Derived
    public boolean hasToken() {
        return this.getToken().isPresent();
    }

    @Value.Check
    void validate() {
        if (this.isBlocking()) {
            Preconditions.checkArgument((boolean)this.getIndex().isPresent(), (Object)"If wait is specified, index must also be specified");
        }
    }

    public static ImmutableQueryOptions.Builder blockSeconds(int seconds, BigInteger index) {
        return QueryOptions.blockBuilder("s", seconds, index);
    }

    public static ImmutableQueryOptions.Builder blockMinutes(int minutes, BigInteger index) {
        return QueryOptions.blockBuilder("m", minutes, index);
    }

    private static ImmutableQueryOptions.Builder blockBuilder(String identifier, int qty, BigInteger index) {
        return ImmutableQueryOptions.builder().wait(String.format("%s%s", qty, identifier)).index(index);
    }

    @Override
    public Map<String, Object> toQuery() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        switch (this.getConsistencyMode()) {
            case CONSISTENT: {
                result.put("consistent", "");
                break;
            }
            case STALE: {
                result.put("stale", "");
            }
        }
        if (this.isBlocking()) {
            Options.optionallyAdd(result, "wait", this.getWait());
            Options.optionallyAdd(result, "index", this.getIndex());
        }
        Options.optionallyAdd(result, "token", this.getToken());
        Options.optionallyAdd(result, "near", this.getNear());
        return result;
    }
}

