/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.fasterxml.jackson.databind;

import com.orbitz.fasterxml.jackson.annotation.JsonCreator;
import com.orbitz.fasterxml.jackson.annotation.JsonFormat;
import com.orbitz.fasterxml.jackson.annotation.JsonInclude;
import com.orbitz.fasterxml.jackson.annotation.JsonProperty;
import com.orbitz.fasterxml.jackson.core.Version;
import com.orbitz.fasterxml.jackson.core.Versioned;
import com.orbitz.fasterxml.jackson.databind.JavaType;
import com.orbitz.fasterxml.jackson.databind.JsonMappingException;
import com.orbitz.fasterxml.jackson.databind.PropertyName;
import com.orbitz.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.orbitz.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.orbitz.fasterxml.jackson.databind.cfg.MapperConfig;
import com.orbitz.fasterxml.jackson.databind.introspect.Annotated;
import com.orbitz.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.orbitz.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.orbitz.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.orbitz.fasterxml.jackson.databind.introspect.AnnotationIntrospectorPair;
import com.orbitz.fasterxml.jackson.databind.introspect.NopAnnotationIntrospector;
import com.orbitz.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.orbitz.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.orbitz.fasterxml.jackson.databind.jsontype.NamedType;
import com.orbitz.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.orbitz.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.orbitz.fasterxml.jackson.databind.type.MapLikeType;
import com.orbitz.fasterxml.jackson.databind.type.TypeFactory;
import com.orbitz.fasterxml.jackson.databind.util.NameTransformer;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class AnnotationIntrospector
implements Versioned,
Serializable {
    public static AnnotationIntrospector nopInstance() {
        return NopAnnotationIntrospector.instance;
    }

    public static AnnotationIntrospector pair(AnnotationIntrospector a1, AnnotationIntrospector a2) {
        return new AnnotationIntrospectorPair(a1, a2);
    }

    public Collection<AnnotationIntrospector> allIntrospectors() {
        return Collections.singletonList(this);
    }

    public Collection<AnnotationIntrospector> allIntrospectors(Collection<AnnotationIntrospector> result) {
        result.add(this);
        return result;
    }

    @Override
    public abstract Version version();

    public boolean isAnnotationBundle(Annotation ann) {
        return false;
    }

    public ObjectIdInfo findObjectIdInfo(Annotated ann) {
        return null;
    }

    public ObjectIdInfo findObjectReferenceInfo(Annotated ann, ObjectIdInfo objectIdInfo) {
        return objectIdInfo;
    }

    public PropertyName findRootName(AnnotatedClass ac) {
        return null;
    }

    public String[] findPropertiesToIgnore(Annotated ac, boolean forSerialization) {
        return null;
    }

    @Deprecated
    public String[] findPropertiesToIgnore(Annotated ac) {
        return this.findPropertiesToIgnore(ac, true);
    }

    public Boolean findIgnoreUnknownProperties(AnnotatedClass ac) {
        return null;
    }

    public Boolean isIgnorableType(AnnotatedClass ac) {
        return null;
    }

    public Object findFilterId(Annotated ann) {
        return null;
    }

    public Object findNamingStrategy(AnnotatedClass ac) {
        return null;
    }

    public String findClassDescription(AnnotatedClass ac) {
        return null;
    }

    public VisibilityChecker<?> findAutoDetectVisibility(AnnotatedClass ac, VisibilityChecker<?> checker) {
        return checker;
    }

    public TypeResolverBuilder<?> findTypeResolver(MapperConfig<?> config, AnnotatedClass ac, JavaType baseType) {
        return null;
    }

    public TypeResolverBuilder<?> findPropertyTypeResolver(MapperConfig<?> config, AnnotatedMember am, JavaType baseType) {
        return null;
    }

    public TypeResolverBuilder<?> findPropertyContentTypeResolver(MapperConfig<?> config, AnnotatedMember am, JavaType containerType) {
        return null;
    }

    public List<NamedType> findSubtypes(Annotated a) {
        return null;
    }

    public String findTypeName(AnnotatedClass ac) {
        return null;
    }

    public Boolean isTypeId(AnnotatedMember member) {
        return null;
    }

    public ReferenceProperty findReferenceType(AnnotatedMember member) {
        return null;
    }

    public NameTransformer findUnwrappingNameTransformer(AnnotatedMember member) {
        return null;
    }

    public boolean hasIgnoreMarker(AnnotatedMember m) {
        return false;
    }

    public Object findInjectableValueId(AnnotatedMember m) {
        return null;
    }

    public Boolean hasRequiredMarker(AnnotatedMember m) {
        return null;
    }

    public Class<?>[] findViews(Annotated a) {
        return null;
    }

    public JsonFormat.Value findFormat(Annotated memberOrClass) {
        return null;
    }

    public PropertyName findWrapperName(Annotated ann) {
        return null;
    }

    public String findPropertyDefaultValue(Annotated ann) {
        return null;
    }

    public String findPropertyDescription(Annotated ann) {
        return null;
    }

    public Integer findPropertyIndex(Annotated ann) {
        return null;
    }

    public String findImplicitPropertyName(AnnotatedMember member) {
        return null;
    }

    public JsonProperty.Access findPropertyAccess(Annotated ann) {
        return null;
    }

    public AnnotatedMethod resolveSetterConflict(MapperConfig<?> config, AnnotatedMethod setter1, AnnotatedMethod setter2) {
        return null;
    }

    public Object findSerializer(Annotated am) {
        return null;
    }

    public Object findKeySerializer(Annotated am) {
        return null;
    }

    public Object findContentSerializer(Annotated am) {
        return null;
    }

    public Object findNullSerializer(Annotated am) {
        return null;
    }

    public JsonSerialize.Typing findSerializationTyping(Annotated a) {
        return null;
    }

    public Object findSerializationConverter(Annotated a) {
        return null;
    }

    public Object findSerializationContentConverter(AnnotatedMember a) {
        return null;
    }

    @Deprecated
    public JsonInclude.Include findSerializationInclusion(Annotated a, JsonInclude.Include defValue) {
        return defValue;
    }

    @Deprecated
    public JsonInclude.Include findSerializationInclusionForContent(Annotated a, JsonInclude.Include defValue) {
        return defValue;
    }

    public JsonInclude.Value findPropertyInclusion(Annotated a) {
        return JsonInclude.Value.empty();
    }

    @Deprecated
    public Class<?> findSerializationType(Annotated a) {
        return null;
    }

    @Deprecated
    public Class<?> findSerializationKeyType(Annotated am, JavaType baseType) {
        return null;
    }

    @Deprecated
    public Class<?> findSerializationContentType(Annotated am, JavaType baseType) {
        return null;
    }

    public JavaType refineSerializationType(MapperConfig<?> config, Annotated a, JavaType baseType) throws JsonMappingException {
        Class<?> contentClass;
        JavaType contentType;
        JavaType keyType;
        Class<?> keyClass;
        JavaType type = baseType;
        TypeFactory tf = config.getTypeFactory();
        Class<?> serClass = this.findSerializationType(a);
        if (serClass != null) {
            if (type.hasRawClass(serClass)) {
                type = type.withStaticTyping();
            } else {
                try {
                    type = tf.constructGeneralizedType(type, serClass);
                }
                catch (IllegalArgumentException iae) {
                    throw new JsonMappingException(null, String.format("Failed to widen type %s with annotation (value %s), from '%s': %s", type, serClass.getName(), a.getName(), iae.getMessage()), (Throwable)iae);
                }
            }
        }
        if (type.isMapLikeType() && (keyClass = this.findSerializationKeyType(a, keyType = type.getKeyType())) != null) {
            if (keyType.hasRawClass(keyClass)) {
                keyType = keyType.withStaticTyping();
            } else {
                try {
                    keyType = tf.constructGeneralizedType(keyType, keyClass);
                }
                catch (IllegalArgumentException iae) {
                    throw new JsonMappingException(null, String.format("Failed to widen key type of %s with concrete-type annotation (value %s), from '%s': %s", type, keyClass.getName(), a.getName(), iae.getMessage()), (Throwable)iae);
                }
            }
            type = ((MapLikeType)type).withKeyType(keyType);
        }
        if ((contentType = type.getContentType()) != null && (contentClass = this.findSerializationContentType(a, contentType)) != null) {
            block17: {
                if (contentType.hasRawClass(contentClass)) {
                    contentType = contentType.withStaticTyping();
                } else {
                    Class<?> currRaw = contentType.getRawClass();
                    try {
                        if (contentClass.isAssignableFrom(currRaw)) {
                            contentType = tf.constructGeneralizedType(contentType, contentClass);
                            break block17;
                        }
                        if (currRaw.isAssignableFrom(contentClass)) {
                            contentType = tf.constructSpecializedType(contentType, contentClass);
                            break block17;
                        }
                        throw new JsonMappingException(null, String.format("Can not refine serialization content type %s into %s; types not related", contentType, contentClass.getName()));
                    }
                    catch (IllegalArgumentException iae) {
                        throw new JsonMappingException(null, String.format("Internal error: failed to refine value type of %s with concrete-type annotation (value %s), from '%s': %s", type, contentClass.getName(), a.getName(), iae.getMessage()), (Throwable)iae);
                    }
                }
            }
            type = type.withContentType(contentType);
        }
        return type;
    }

    public String[] findSerializationPropertyOrder(AnnotatedClass ac) {
        return null;
    }

    public Boolean findSerializationSortAlphabetically(Annotated ann) {
        return null;
    }

    public void findAndAddVirtualProperties(MapperConfig<?> config, AnnotatedClass ac, List<BeanPropertyWriter> properties) {
    }

    public PropertyName findNameForSerialization(Annotated a) {
        return null;
    }

    public boolean hasAsValueAnnotation(AnnotatedMethod am) {
        return false;
    }

    public String findEnumValue(Enum<?> value) {
        return value.name();
    }

    public String[] findEnumValues(Class<?> enumType, Enum<?>[] enumValues, String[] names) {
        int len = enumValues.length;
        for (int i = 0; i < len; ++i) {
            if (names[i] != null) continue;
            names[i] = this.findEnumValue(enumValues[i]);
        }
        return names;
    }

    public Object findDeserializer(Annotated am) {
        return null;
    }

    public Object findKeyDeserializer(Annotated am) {
        return null;
    }

    public Object findContentDeserializer(Annotated am) {
        return null;
    }

    public Object findDeserializationConverter(Annotated a) {
        return null;
    }

    public Object findDeserializationContentConverter(AnnotatedMember a) {
        return null;
    }

    public JavaType refineDeserializationType(MapperConfig<?> config, Annotated a, JavaType baseType) throws JsonMappingException {
        Class<?> contentClass;
        JavaType contentType;
        JavaType keyType;
        Class<?> keyClass;
        JavaType type = baseType;
        TypeFactory tf = config.getTypeFactory();
        Class<?> valueClass = this.findDeserializationType(a, type);
        if (valueClass != null && !type.hasRawClass(valueClass)) {
            try {
                type = tf.constructSpecializedType(type, valueClass);
            }
            catch (IllegalArgumentException iae) {
                throw new JsonMappingException(null, String.format("Failed to narrow type %s with annotation (value %s), from '%s': %s", type, valueClass.getName(), a.getName(), iae.getMessage()), (Throwable)iae);
            }
        }
        if (type.isMapLikeType() && (keyClass = this.findDeserializationKeyType(a, keyType = type.getKeyType())) != null) {
            try {
                keyType = tf.constructSpecializedType(keyType, keyClass);
                type = ((MapLikeType)type).withKeyType(keyType);
            }
            catch (IllegalArgumentException iae) {
                throw new JsonMappingException(null, String.format("Failed to narrow key type of %s with concrete-type annotation (value %s), from '%s': %s", type, keyClass.getName(), a.getName(), iae.getMessage()), (Throwable)iae);
            }
        }
        if ((contentType = type.getContentType()) != null && (contentClass = this.findDeserializationContentType(a, contentType)) != null) {
            try {
                contentType = tf.constructSpecializedType(contentType, contentClass);
                type = type.withContentType(contentType);
            }
            catch (IllegalArgumentException iae) {
                throw new JsonMappingException(null, String.format("Failed to narrow value type of %s with concrete-type annotation (value %s), from '%s': %s", type, contentClass.getName(), a.getName(), iae.getMessage()), (Throwable)iae);
            }
        }
        return type;
    }

    @Deprecated
    public Class<?> findDeserializationType(Annotated am, JavaType baseType) {
        return null;
    }

    @Deprecated
    public Class<?> findDeserializationKeyType(Annotated am, JavaType baseKeyType) {
        return null;
    }

    @Deprecated
    public Class<?> findDeserializationContentType(Annotated am, JavaType baseContentType) {
        return null;
    }

    public Object findValueInstantiator(AnnotatedClass ac) {
        return null;
    }

    public Class<?> findPOJOBuilder(AnnotatedClass ac) {
        return null;
    }

    public JsonPOJOBuilder.Value findPOJOBuilderConfig(AnnotatedClass ac) {
        return null;
    }

    public PropertyName findNameForDeserialization(Annotated a) {
        return null;
    }

    public boolean hasAnySetterAnnotation(AnnotatedMethod am) {
        return false;
    }

    public boolean hasAnyGetterAnnotation(AnnotatedMethod am) {
        return false;
    }

    public boolean hasCreatorAnnotation(Annotated a) {
        return false;
    }

    public JsonCreator.Mode findCreatorBinding(Annotated a) {
        return null;
    }

    protected <A extends Annotation> A _findAnnotation(Annotated annotated, Class<A> annoClass) {
        return annotated.getAnnotation(annoClass);
    }

    protected boolean _hasAnnotation(Annotated annotated, Class<? extends Annotation> annoClass) {
        return annotated.hasAnnotation(annoClass);
    }

    protected boolean _hasOneOf(Annotated annotated, Class<? extends Annotation>[] annoClasses) {
        return annotated.hasOneOf(annoClasses);
    }

    public static class ReferenceProperty {
        private final Type _type;
        private final String _name;

        public ReferenceProperty(Type t, String n) {
            this._type = t;
            this._name = n;
        }

        public static ReferenceProperty managed(String name) {
            return new ReferenceProperty(Type.MANAGED_REFERENCE, name);
        }

        public static ReferenceProperty back(String name) {
            return new ReferenceProperty(Type.BACK_REFERENCE, name);
        }

        public Type getType() {
            return this._type;
        }

        public String getName() {
            return this._name;
        }

        public boolean isManagedReference() {
            return this._type == Type.MANAGED_REFERENCE;
        }

        public boolean isBackReference() {
            return this._type == Type.BACK_REFERENCE;
        }

        public static enum Type {
            MANAGED_REFERENCE,
            BACK_REFERENCE;

        }
    }
}

