/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.cache;

import com.google.common.base.Function;
import com.orbitz.consul.KeyValueClient;
import com.orbitz.consul.async.ConsulResponseCallback;
import com.orbitz.consul.cache.ConsulCache;
import com.orbitz.consul.model.kv.Value;
import com.orbitz.consul.option.QueryOptions;
import java.math.BigInteger;
import java.util.List;

public class KVCache
extends ConsulCache<String, Value> {
    private KVCache(Function<Value, String> keyConversion, ConsulCache.CallbackConsumer<Value> callbackConsumer) {
        super(keyConversion, callbackConsumer);
    }

    public static KVCache newCache(final KeyValueClient kvClient, final String rootPath, final int watchSeconds, final QueryOptions queryOptions) {
        final String rootPathWithTrailingSlash = rootPath.endsWith("/") ? rootPath : rootPath + "/";
        final int rootPathWithTrailingSlashLength = rootPathWithTrailingSlash.length();
        Function<Value, String> keyExtractor = new Function<Value, String>(){

            public String apply(Value input) {
                if (input == null) {
                    throw new RuntimeException("Input to key extractor is null");
                }
                if (input.getKey() == null) {
                    throw new RuntimeException("Input to key extractor has no key");
                }
                if (input.getKey().startsWith(rootPathWithTrailingSlash)) {
                    return input.getKey().substring(rootPathWithTrailingSlashLength);
                }
                throw new RuntimeException(String.format("Got value for key %s but root is %s", input.getKey(), rootPathWithTrailingSlash));
            }
        };
        ConsulCache.CallbackConsumer<Value> callbackConsumer = new ConsulCache.CallbackConsumer<Value>(){

            @Override
            public void consume(BigInteger index, ConsulResponseCallback<List<Value>> callback) {
                QueryOptions params = ConsulCache.watchParams(index, watchSeconds, queryOptions);
                kvClient.getValues(rootPath, params, callback);
            }
        };
        return new KVCache(keyExtractor, callbackConsumer);
    }

    public static KVCache newCache(KeyValueClient kvClient, String rootPath, int watchSeconds) {
        return KVCache.newCache(kvClient, rootPath, watchSeconds, QueryOptions.BLANK);
    }

    public static KVCache newCache(KeyValueClient kvClient, String rootPath) {
        return KVCache.newCache(kvClient, rootPath, 10);
    }
}

