/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tokens.auth;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.palantir.tokens.auth.BearerToken;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="BearerToken", generator="Immutables")
final class ImmutableBearerToken
extends BearerToken {
    private final String token;
    private final transient byte[] tokenAsBytes;

    private ImmutableBearerToken(String token) {
        this.token = Objects.requireNonNull(token, "token");
        this.tokenAsBytes = Objects.requireNonNull(super.getTokenAsBytes(), "tokenAsBytes");
    }

    private ImmutableBearerToken(ImmutableBearerToken original, String token) {
        this.token = token;
        this.tokenAsBytes = Objects.requireNonNull(super.getTokenAsBytes(), "tokenAsBytes");
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    byte[] getTokenAsBytes() {
        return this.tokenAsBytes;
    }

    public final ImmutableBearerToken withToken(String value) {
        String newValue = Objects.requireNonNull(value, "token");
        if (this.token.equals(newValue)) {
            return this;
        }
        return new ImmutableBearerToken(this, newValue);
    }

    public static ImmutableBearerToken of(String token) {
        return new ImmutableBearerToken(token);
    }

    public static ImmutableBearerToken copyOf(BearerToken instance) {
        if (instance instanceof ImmutableBearerToken) {
            return (ImmutableBearerToken)instance;
        }
        return ImmutableBearerToken.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="BearerToken", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_TOKEN = 1L;
        private long initBits = 1L;
        private String token;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(BearerToken instance) {
            Objects.requireNonNull(instance, "instance");
            this.token(instance.getToken());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder token(String token) {
            this.token = Objects.requireNonNull(token, "token");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableBearerToken build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBearerToken(null, this.token);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("token");
            }
            return "Cannot build BearerToken, some of required attributes are not set " + attributes;
        }
    }
}

