/*
 * Decompiled with CFR 0.152.
 */
package com.paritytrading.juncture.nasdaq.itch50;

import com.paritytrading.juncture.nasdaq.itch50.ITCH50;
import com.paritytrading.juncture.nasdaq.itch50.ITCH50Exception;
import com.paritytrading.juncture.nasdaq.itch50.ITCH50Listener;
import com.paritytrading.nassau.MessageListener;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ITCH50Parser
implements MessageListener {
    private ITCH50.SystemEvent systemEvent = new ITCH50.SystemEvent();
    private ITCH50.StockDirectory stockDirectory = new ITCH50.StockDirectory();
    private ITCH50.StockTradingAction stockTradingAction = new ITCH50.StockTradingAction();
    private ITCH50.RegSHORestriction regSHORestriction = new ITCH50.RegSHORestriction();
    private ITCH50.MarketParticipantPosition marketParticipantPosition = new ITCH50.MarketParticipantPosition();
    private ITCH50.MWCBDeclineLevel mwcbDeclineLevel = new ITCH50.MWCBDeclineLevel();
    private ITCH50.MWCBStatus mwcbStatus = new ITCH50.MWCBStatus();
    private ITCH50.IPOQuotingPeriodUpdate ipoQuotingPeriodUpdate = new ITCH50.IPOQuotingPeriodUpdate();
    private ITCH50.LULDAuctionCollar luldAuctionCollar = new ITCH50.LULDAuctionCollar();
    private ITCH50.OperationalHalt operationalHalt = new ITCH50.OperationalHalt();
    private ITCH50.AddOrder addOrder = new ITCH50.AddOrder();
    private ITCH50.AddOrderMPID addOrderMPID = new ITCH50.AddOrderMPID();
    private ITCH50.OrderExecuted orderExecuted = new ITCH50.OrderExecuted();
    private ITCH50.OrderExecutedWithPrice orderExecutedWithPrice = new ITCH50.OrderExecutedWithPrice();
    private ITCH50.OrderCancel orderCancel = new ITCH50.OrderCancel();
    private ITCH50.OrderDelete orderDelete = new ITCH50.OrderDelete();
    private ITCH50.OrderReplace orderReplace = new ITCH50.OrderReplace();
    private ITCH50.Trade trade = new ITCH50.Trade();
    private ITCH50.CrossTrade crossTrade = new ITCH50.CrossTrade();
    private ITCH50.BrokenTrade brokenTrade = new ITCH50.BrokenTrade();
    private ITCH50.NOII noii = new ITCH50.NOII();
    private ITCH50.RPII rpii = new ITCH50.RPII();
    private ITCH50Listener listener;

    public ITCH50Parser(ITCH50Listener listener) {
        this.listener = listener;
    }

    public void message(ByteBuffer buffer) throws IOException {
        byte messageType = buffer.get();
        switch (messageType) {
            case 83: {
                this.systemEvent.get(buffer);
                this.listener.systemEvent(this.systemEvent);
                break;
            }
            case 82: {
                this.stockDirectory.get(buffer);
                this.listener.stockDirectory(this.stockDirectory);
                break;
            }
            case 72: {
                this.stockTradingAction.get(buffer);
                this.listener.stockTradingAction(this.stockTradingAction);
                break;
            }
            case 89: {
                this.regSHORestriction.get(buffer);
                this.listener.regSHORestriction(this.regSHORestriction);
                break;
            }
            case 76: {
                this.marketParticipantPosition.get(buffer);
                this.listener.marketParticipantPosition(this.marketParticipantPosition);
                break;
            }
            case 86: {
                this.mwcbDeclineLevel.get(buffer);
                this.listener.mwcbDeclineLevel(this.mwcbDeclineLevel);
                break;
            }
            case 87: {
                this.mwcbStatus.get(buffer);
                this.listener.mwcbStatus(this.mwcbStatus);
                break;
            }
            case 75: {
                this.ipoQuotingPeriodUpdate.get(buffer);
                this.listener.ipoQuotingPeriodUpdate(this.ipoQuotingPeriodUpdate);
                break;
            }
            case 74: {
                this.luldAuctionCollar.get(buffer);
                this.listener.luldAuctionCollar(this.luldAuctionCollar);
                break;
            }
            case 104: {
                this.operationalHalt.get(buffer);
                this.listener.operationalHalt(this.operationalHalt);
                break;
            }
            case 65: {
                this.addOrder.get(buffer);
                this.listener.addOrder(this.addOrder);
                break;
            }
            case 70: {
                this.addOrderMPID.get(buffer);
                this.listener.addOrderMPID(this.addOrderMPID);
                break;
            }
            case 69: {
                this.orderExecuted.get(buffer);
                this.listener.orderExecuted(this.orderExecuted);
                break;
            }
            case 67: {
                this.orderExecutedWithPrice.get(buffer);
                this.listener.orderExecutedWithPrice(this.orderExecutedWithPrice);
                break;
            }
            case 88: {
                this.orderCancel.get(buffer);
                this.listener.orderCancel(this.orderCancel);
                break;
            }
            case 68: {
                this.orderDelete.get(buffer);
                this.listener.orderDelete(this.orderDelete);
                break;
            }
            case 85: {
                this.orderReplace.get(buffer);
                this.listener.orderReplace(this.orderReplace);
                break;
            }
            case 80: {
                this.trade.get(buffer);
                this.listener.trade(this.trade);
                break;
            }
            case 81: {
                this.crossTrade.get(buffer);
                this.listener.crossTrade(this.crossTrade);
                break;
            }
            case 66: {
                this.brokenTrade.get(buffer);
                this.listener.brokenTrade(this.brokenTrade);
                break;
            }
            case 73: {
                this.noii.get(buffer);
                this.listener.noii(this.noii);
                break;
            }
            case 78: {
                this.rpii.get(buffer);
                this.listener.rpii(this.rpii);
                break;
            }
            default: {
                throw new ITCH50Exception("Unknown message type: " + (char)messageType);
            }
        }
    }
}

