/*
 * Decompiled with CFR 0.152.
 */
package com.paritytrading.nassau.moldudp64;

import com.paritytrading.foundation.ByteBuffers;
import com.paritytrading.nassau.MessageListener;
import com.paritytrading.nassau.moldudp64.MoldUDP64DownstreamPacket;
import com.paritytrading.nassau.moldudp64.MoldUDP64MessageStore;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class MoldUDP64DefaultMessageStore
implements MoldUDP64MessageStore {
    private List<byte[]> messages = new ArrayList<byte[]>();
    private MessageListener listener = new MessageListener(){

        @Override
        public void message(ByteBuffer buffer) {
            MoldUDP64DefaultMessageStore.this.put(buffer);
        }
    };

    public void put(ByteBuffer buffer) {
        int length = buffer.remaining();
        byte[] message = new byte[length];
        buffer.get(message);
        this.messages.add(message);
    }

    public void put(MoldUDP64DownstreamPacket packet) {
        try {
            packet.apply(this.listener);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public int get(ByteBuffer buffer, long sequenceNumber, int requestedMessageCount) {
        if (sequenceNumber > Integer.MAX_VALUE) {
            return 0;
        }
        int messageCount = 0;
        for (int i = (int)sequenceNumber; (long)i < sequenceNumber + (long)requestedMessageCount && i <= this.messages.size(); ++i) {
            byte[] message = this.messages.get(i - 1);
            if (buffer.remaining() < 2 + message.length) break;
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)message.length);
            buffer.put(message);
            ++messageCount;
        }
        return messageCount;
    }
}

