/*
 * Decompiled with CFR 0.152.
 */
package com.paritytrading.nassau.moldudp64;

import com.paritytrading.foundation.ByteBuffers;
import com.paritytrading.nassau.MessageListener;
import com.paritytrading.nassau.moldudp64.MoldUDP64Exception;
import java.io.IOException;
import java.nio.ByteBuffer;

public class MoldUDP64DownstreamPacket {
    private int messageCount = 0;
    private ByteBuffer payload = ByteBuffer.allocate(1400);

    public void put(ByteBuffer buffer) throws MoldUDP64Exception {
        if (this.remaining() < buffer.remaining()) {
            throw new MoldUDP64Exception("Buffer overflow");
        }
        ByteBuffers.putUnsignedShort((ByteBuffer)this.payload, (int)buffer.remaining());
        this.payload.put(buffer);
        ++this.messageCount;
    }

    public void apply(MessageListener listener) throws IOException {
        while (this.payload.remaining() >= 2) {
            int messageLength = ByteBuffers.getUnsignedShort((ByteBuffer)this.payload);
            int limit = this.payload.limit();
            this.payload.limit(this.payload.position() + messageLength);
            listener.message(this.payload);
            this.payload.position(this.payload.limit());
            this.payload.limit(limit);
        }
    }

    public void clear() {
        this.messageCount = 0;
        this.payload.clear();
    }

    public int messageCount() {
        return this.messageCount;
    }

    public ByteBuffer payload() {
        return this.payload;
    }

    public int remaining() {
        return Math.max(0, this.payload.remaining() - 2);
    }
}

