/*
 * Decompiled with CFR 0.152.
 */
package com.paritytrading.nassau.moldudp64;

import com.paritytrading.foundation.ByteBuffers;
import com.paritytrading.nassau.moldudp64.MoldUDP64MessageStore;
import java.io.Closeable;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;

public class MoldUDP64RequestServer
implements Closeable {
    private static final int MESSAGE_COUNT_OFFSET = 18;
    private DatagramChannel channel;
    private ByteBuffer rxBuffer;
    private ByteBuffer txBuffer;
    private byte[] session;

    public MoldUDP64RequestServer(DatagramChannel channel) {
        this.channel = channel;
        this.rxBuffer = ByteBuffer.allocate(20);
        this.txBuffer = ByteBuffer.allocate(1420);
        this.session = new byte[10];
    }

    public DatagramChannel getChannel() {
        return this.channel;
    }

    public void serve(MoldUDP64MessageStore store) throws IOException {
        this.rxBuffer.clear();
        SocketAddress address = this.channel.receive(this.rxBuffer);
        if (address == null) {
            return;
        }
        this.rxBuffer.flip();
        if (this.rxBuffer.remaining() < 20) {
            return;
        }
        this.rxBuffer.get(this.session);
        long sequenceNumber = this.rxBuffer.getLong();
        if (sequenceNumber < 1L) {
            return;
        }
        int requestedMessageCount = ByteBuffers.getUnsignedShort((ByteBuffer)this.rxBuffer);
        this.txBuffer.clear();
        this.txBuffer.put(this.session);
        this.txBuffer.putLong(sequenceNumber);
        ByteBuffers.putUnsignedShort((ByteBuffer)this.txBuffer, (int)0);
        int messageCount = store.get(this.txBuffer, sequenceNumber, requestedMessageCount);
        if (messageCount == 0) {
            return;
        }
        ByteBuffers.putUnsignedShort((ByteBuffer)this.txBuffer, (int)18, (int)messageCount);
        this.txBuffer.flip();
        while (this.channel.send(this.txBuffer, address) == 0) {
        }
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }
}

