/*
 * Decompiled with CFR 0.152.
 */
package com.paritytrading.nassau.soupbintcp;

import com.paritytrading.foundation.ByteBuffers;
import com.paritytrading.nassau.soupbintcp.SoupBinTCPException;
import com.paritytrading.nassau.time.Clock;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SocketChannel;

public abstract class SoupBinTCPSession
implements Closeable {
    private static final long RX_HEARTBEAT_TIMEOUT_MILLIS = 15000L;
    private static final long TX_HEARTBEAT_INTERVAL_MILLIS = 1000L;
    private Clock clock;
    private SocketChannel channel;
    private volatile long lastRxMillis;
    private long lastTxMillis;
    private ByteBuffer rxBuffer;
    private ByteBuffer txHeader;
    private ByteBuffer[] txBuffers;
    private byte heartbeatPacketType;

    protected SoupBinTCPSession(Clock clock, SocketChannel channel, int maxPayloadLength, byte heartbeatPacketType) {
        this.clock = clock;
        this.channel = channel;
        this.lastRxMillis = clock.currentTimeMillis();
        this.lastTxMillis = clock.currentTimeMillis();
        this.rxBuffer = ByteBuffer.allocate(3 + Math.min(maxPayloadLength, 65534));
        this.txHeader = ByteBuffer.allocate(3);
        this.txBuffers = new ByteBuffer[2];
        this.txHeader.order(ByteOrder.BIG_ENDIAN);
        this.txBuffers[0] = this.txHeader;
        this.heartbeatPacketType = heartbeatPacketType;
    }

    public SocketChannel getChannel() {
        return this.channel;
    }

    public int receive() throws IOException {
        int bytes = this.channel.read(this.rxBuffer);
        if (bytes <= 0) {
            return bytes;
        }
        this.rxBuffer.flip();
        while (this.parse()) {
        }
        this.rxBuffer.compact();
        this.receivedData();
        return bytes;
    }

    private boolean parse() throws IOException {
        if (this.rxBuffer.remaining() < 2) {
            return false;
        }
        this.rxBuffer.mark();
        this.rxBuffer.order(ByteOrder.BIG_ENDIAN);
        int packetLength = ByteBuffers.getUnsignedShort((ByteBuffer)this.rxBuffer);
        if (packetLength > this.rxBuffer.capacity() - 2) {
            throw new SoupBinTCPException("Packet length exceeds buffer capacity");
        }
        if (this.rxBuffer.remaining() < packetLength) {
            this.rxBuffer.reset();
            return false;
        }
        byte packetType = this.rxBuffer.get();
        int limit = this.rxBuffer.limit();
        this.rxBuffer.limit(this.rxBuffer.position() + packetLength - 1);
        this.packet(packetType, this.rxBuffer);
        this.rxBuffer.position(this.rxBuffer.limit());
        this.rxBuffer.limit(limit);
        return true;
    }

    public void keepAlive() throws IOException {
        long currentTimeMillis = this.clock.currentTimeMillis();
        if (currentTimeMillis - this.lastTxMillis > 1000L) {
            this.send(this.heartbeatPacketType);
        }
        if (currentTimeMillis - this.lastRxMillis > 15000L) {
            this.handleHeartbeatTimeout();
        }
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    protected abstract void heartbeatTimeout() throws IOException;

    protected abstract void packet(byte var1, ByteBuffer var2) throws IOException;

    protected void send(byte packetType) throws IOException {
        this.txHeader.clear();
        ByteBuffers.putUnsignedShort((ByteBuffer)this.txHeader, (int)1);
        this.txHeader.put(packetType);
        this.txHeader.flip();
        do {
            this.channel.write(this.txHeader);
        } while (this.txHeader.hasRemaining());
        this.sentData();
    }

    protected void send(byte packetType, ByteBuffer payload) throws IOException {
        int packetLength = payload.remaining() + 1;
        if (packetLength > 65535) {
            throw new SoupBinTCPException("Packet length exceeds maximum packet length");
        }
        this.txHeader.clear();
        ByteBuffers.putUnsignedShort((ByteBuffer)this.txHeader, (int)packetLength);
        this.txHeader.put(packetType);
        this.txHeader.flip();
        this.txBuffers[1] = payload;
        int remaining = this.txHeader.remaining() + payload.remaining();
        while ((remaining = (int)((long)remaining - this.channel.write(this.txBuffers))) > 0) {
        }
        this.sentData();
    }

    protected void unexpectedPacketType(byte packetType) throws SoupBinTCPException {
        throw new SoupBinTCPException("Unexpected packet type: " + (char)packetType);
    }

    private void handleHeartbeatTimeout() throws IOException {
        this.heartbeatTimeout();
        this.receivedData();
    }

    private void receivedData() {
        this.lastRxMillis = this.clock.currentTimeMillis();
    }

    private void sentData() {
        this.lastTxMillis = this.clock.currentTimeMillis();
    }
}

