/*
 * Decompiled with CFR 0.152.
 */
package com.paritytrading.nassau.util;

import com.paritytrading.nassau.MessageListener;
import com.paritytrading.nassau.moldudp64.MoldUDP64Client;
import com.paritytrading.nassau.moldudp64.MoldUDP64ClientState;
import com.paritytrading.nassau.moldudp64.MoldUDP64ClientStatusListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardProtocolFamily;
import java.net.StandardSocketOptions;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Set;

public class MoldUDP64 {
    private MoldUDP64() {
    }

    public static void receive(NetworkInterface multicastInterface, InetSocketAddress multicastGroup, InetSocketAddress requestAddress, MessageListener listener) throws IOException {
        DatagramChannel channel = DatagramChannel.open(StandardProtocolFamily.INET);
        channel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
        channel.bind(new InetSocketAddress(multicastGroup.getPort()));
        channel.join(multicastGroup.getAddress(), multicastInterface);
        channel.configureBlocking(false);
        DatagramChannel requestChannel = DatagramChannel.open(StandardProtocolFamily.INET);
        requestChannel.configureBlocking(false);
        StatusListener statusListener = new StatusListener();
        try (Selector selector = Selector.open();
             MoldUDP64Client client = new MoldUDP64Client(channel, requestChannel, (SocketAddress)requestAddress, listener, (MoldUDP64ClientStatusListener)statusListener);){
            SelectionKey channelKey = channel.register(selector, 1);
            SelectionKey requestChannelKey = requestChannel.register(selector, 1);
            while (statusListener.receive) {
                while (selector.select() == 0) {
                }
                Set<SelectionKey> selectedKeys = selector.selectedKeys();
                if (selectedKeys.contains(channelKey)) {
                    client.receive();
                }
                if (selectedKeys.contains(requestChannelKey)) {
                    client.receiveResponse();
                }
                selectedKeys.clear();
            }
        }
    }

    private static class StatusListener
    implements MoldUDP64ClientStatusListener {
        boolean receive = true;

        private StatusListener() {
        }

        public void state(MoldUDP64Client session, MoldUDP64ClientState next) {
        }

        public void downstream(MoldUDP64Client session, long sequenceNumber, int messageCount) {
        }

        public void request(MoldUDP64Client session, long sequenceNumber, int requestedMessageCount) {
        }

        public void endOfSession(MoldUDP64Client session) {
            this.receive = false;
        }
    }
}

