/*
 * Decompiled with CFR 0.152.
 */
package com.mediasmiths.std.guice.apploader.impl;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.mediasmiths.std.guice.apploader.GuiceSetup;
import com.mediasmiths.std.guice.common.JAXBModule;
import com.mediasmiths.std.guice.common.Log4JModule;
import com.mediasmiths.std.guice.common.ServicePropertiesModule;
import com.mediasmiths.std.guice.common.converter.PropertiesTypeConversionModule;
import com.mediasmiths.std.guice.common.retry.module.RetryModule;
import com.mediasmiths.std.guice.common.shutdown.ShutdownModule;
import com.mediasmiths.std.guice.serviceregistry.ApplicationContextNameRegistry;
import com.mediasmiths.std.io.PropertyFile;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class GuiceInjectorBootstrap {
    private static final Logger log = Logger.getLogger(GuiceInjectorBootstrap.class);

    public static Injector createInjector() {
        PropertyFile properties = GuiceInjectorBootstrap.discoverProperties();
        return GuiceInjectorBootstrap.createInjector(properties);
    }

    private static PropertyFile discoverProperties() {
        String contextName = ApplicationContextNameRegistry.getContextName();
        ArrayList<String> fileNames = new ArrayList<String>();
        fileNames.add("service.properties");
        fileNames.add("environment.properties");
        if (!StringUtils.isEmpty((String)contextName)) {
            String propertyFileName = "services/" + contextName.replace("/", "") + ".properties";
            fileNames.add(propertyFileName);
        }
        return GuiceInjectorBootstrap.loadAllProperties(fileNames);
    }

    private static PropertyFile loadAllProperties(List<String> files) {
        PropertyFile file = new PropertyFile();
        for (String name : files) {
            log.debug((Object)("Loading property files with name: " + name));
            PropertyFile[] props = PropertyFile.findAll((String)name);
            if (props == null) continue;
            for (PropertyFile prop : props) {
                file.merge(prop);
            }
        }
        file.makeReadOnly();
        return file;
    }

    public static Injector createInjector(PropertyFile properties) {
        GuiceSetup setup = GuiceInjectorBootstrap.getSetup(properties);
        return GuiceInjectorBootstrap.createInjector(properties, setup);
    }

    public static Injector createInjector(GuiceSetup setup) {
        PropertyFile properties = GuiceInjectorBootstrap.discoverProperties();
        return GuiceInjectorBootstrap.createInjector(properties, setup);
    }

    public static Injector createInjector(PropertyFile properties, GuiceSetup setup) {
        ShutdownModule shutdown = new ShutdownModule();
        try {
            ArrayList<Module> modules = new ArrayList<Module>();
            modules.add((Module)shutdown);
            modules.add((Module)new RetryModule());
            modules.add((Module)new JAXBModule(properties));
            modules.add((Module)new PropertiesTypeConversionModule());
            modules.add((Module)new ServicePropertiesModule(properties));
            modules.add((Module)new Log4JModule(properties));
            setup.registerModules(modules, properties);
            Injector injector = Guice.createInjector(modules);
            setup.injectorCreated(injector);
            return injector;
        }
        catch (RuntimeException e) {
            GuiceInjectorBootstrap.cleanup(shutdown);
            throw e;
        }
        catch (Error e) {
            GuiceInjectorBootstrap.cleanup(shutdown);
            throw e;
        }
    }

    private static GuiceSetup getSetup(PropertyFile properties) {
        Class clazz = properties.getClass("guice.bootstrap.class", null);
        if (clazz == null) {
            throw new IllegalArgumentException("Missing guice.bootstrap.class in config: " + properties.getFile());
        }
        try {
            return (GuiceSetup)clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading guice.bootstrap.class " + clazz + ": " + e.getMessage(), e);
        }
    }

    private static void cleanup(ShutdownModule shutdown) {
        shutdown.shutdown();
    }
}

