/*
 * Decompiled with CFR 0.152.
 */
package com.mediasmiths.std.guice.apploader.impl;

import com.google.inject.Injector;
import com.mediasmiths.std.guice.apploader.GuiceApplication;
import com.mediasmiths.std.guice.apploader.impl.GuiceInjectorBootstrap;
import com.mediasmiths.std.guice.common.shutdown.iface.ShutdownManager;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class GuiceRegistry {
    private static final Logger log = Logger.getLogger(GuiceRegistry.class);
    private static final Object monitor = new Object();
    private static Set<GuiceApplication> services = new HashSet<GuiceApplication>();
    private static Injector injector;

    public static synchronized void register(GuiceApplication service, boolean durable) {
        Injector injector = GuiceRegistry.getInjector();
        injector.injectMembers((Object)service);
        if (durable) {
            services.add(service);
        }
        service.configured();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Injector getInjector() {
        if (injector == null) {
            Object object = monitor;
            synchronized (object) {
                if (injector == null) {
                    log.info((Object)"Trying to create Guice Injector...");
                    injector = GuiceInjectorBootstrap.createInjector();
                }
            }
        }
        return injector;
    }

    public static synchronized void stop() {
        if (injector != null) {
            for (GuiceApplication service : services) {
                try {
                    service.stopping();
                }
                catch (Throwable t) {
                    log.warn((Object)("Error shutting down service " + service + ": " + t.getMessage()), t);
                }
            }
            ShutdownManager manager = (ShutdownManager)injector.getInstance(ShutdownManager.class);
            manager.shutdown();
            injector = null;
        }
    }

    public static synchronized void restart() {
        GuiceRegistry.stop();
        try {
            for (GuiceApplication service : services) {
                GuiceRegistry.register(service, true);
            }
        }
        catch (RuntimeException e) {
            log.warn((Object)("Failed to restart: " + e.getMessage()), (Throwable)e);
            GuiceRegistry.stop();
            throw e;
        }
        catch (Error e) {
            log.warn((Object)("Failed to restart: " + e.getMessage()), (Throwable)e);
            GuiceRegistry.stop();
            throw e;
        }
    }
}

