/*
 * Decompiled with CFR 0.152.
 */
package com.mediasmiths.std.guice.common.shutdown;

import com.mediasmiths.std.guice.common.shutdown.iface.ShutdownManager;
import com.mediasmiths.std.guice.common.shutdown.iface.StoppableService;
import java.util.Stack;
import org.apache.log4j.Logger;

class ShutdownManagerImpl
implements ShutdownManager {
    private static final Logger log = Logger.getLogger(ShutdownManagerImpl.class);
    private Stack<StoppableService> services = new Stack();
    private boolean stopped = false;

    ShutdownManagerImpl() {
    }

    @Override
    public synchronized void register(StoppableService service) {
        if (service == null) {
            throw new IllegalArgumentException("Must provide service to register!");
        }
        if (this.stopped) {
            throw new IllegalArgumentException("Cannot register for shutdown: manager already stopped");
        }
        log.debug((Object)("Register for shutdown: " + service));
        this.services.push(service);
    }

    @Override
    public synchronized void shutdown() {
        if (this.stopped) {
            log.warn((Object)"Ignoring duplicate shutdown request");
        }
        if (!this.services.isEmpty()) {
            int failures = 0;
            log.info((Object)("Shutting down " + this.services.size() + " service(s)"));
            while (!this.services.empty()) {
                StoppableService service = this.services.pop();
                try {
                    log.debug((Object)("Requesting shutdown of " + service));
                    service.shutdown();
                }
                catch (Throwable t) {
                    ++failures;
                    log.warn((Object)("Shutdown failed for " + service + ": " + t.getMessage()), t);
                }
            }
            if (failures == 0) {
                log.info((Object)"Shutdown complete");
            } else {
                log.warn((Object)("Shutdown completed, " + failures + " service(s) threw an exception during shutdown"));
            }
            this.stopped = true;
            this.services.clear();
        }
    }
}

