/*
 * Decompiled with CFR 0.152.
 */
package com.mediasmiths.carbon.type.immutable;

import com.mediasmiths.carbon.exception.CarbonBuildException;
import com.mediasmiths.carbon.type.CarbonXMLWrapper;
import org.jdom2.Attribute;
import org.jdom2.DataConversionException;
import org.jdom2.Element;

public class CarbonJobInfo
extends CarbonXMLWrapper {
    public CarbonJobInfo(Element element) {
        super(element);
        if (this.getGUID() == null) {
            throw new IllegalArgumentException("Not a valid JobInfo element: " + element);
        }
    }

    public String getName() {
        return this.element.getAttributeValue("Name");
    }

    public String getGUID() {
        return this.element.getAttributeValue("GUID");
    }

    public String getState() {
        return this.element.getAttributeValue("State");
    }

    public String getStatus() {
        return this.element.getAttributeValue("Status");
    }

    public int getProgress() {
        Attribute attribute = this.element.getAttribute("Progress.DWD");
        if (attribute != null) {
            try {
                return attribute.getIntValue();
            }
            catch (DataConversionException e) {
                throw new CarbonBuildException("Job Progress.DWD not an int: " + attribute.getValue(), e);
            }
        }
        return 0;
    }

    public String getError() {
        return this.element.getAttributeValue("Error");
    }
}

