/*
 * Decompiled with CFR 0.152.
 */
package com.mediasmiths.carbon.type.mutable;

import com.mediasmiths.carbon.type.mutable.CarbonModule;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;

public class CarbonSource
extends CarbonModule {
    public CarbonSource() {
        super(new Element("Module_XXXX"));
    }

    public CarbonSource(Element element) {
        super(element);
    }

    public boolean isMultiSource() {
        String value = this.element.getAttributeValue("MultiSource.DWD");
        if (value == null) {
            return false;
        }
        return Integer.parseInt(value) == 1;
    }

    public boolean isComplexSource() {
        String value = this.element.getAttributeValue("ComplexSource.DWD");
        if (value == null) {
            return false;
        }
        return Integer.parseInt(value) == 1;
    }

    public void setFullUNCFilename(String path) {
        this.element.setAttribute("FullUNCFilename", path);
    }

    public String getFullUNCFilename() {
        return this.element.getAttributeValue("FullUNCFilename");
    }

    public void setInOutPoint(long in, long out) {
        this.removeInOutPoint();
        Element filter = CarbonSource.buildInOutElement(in, out);
        this.element.addContent((Content)filter);
    }

    public Long getInPoint() {
        Element element = this.element.getChild("InOutPoints");
        if (element == null) {
            return null;
        }
        String val = element.getAttributeValue("Inpoint_0.QWD");
        if (val != null) {
            return Long.parseLong(val);
        }
        return null;
    }

    public Long getOutPoint() {
        Element element = this.element.getChild("InOutPoints");
        if (element == null) {
            return null;
        }
        String val = element.getAttributeValue("Outpoint_0.QWD");
        if (val != null) {
            return Long.parseLong(val);
        }
        return null;
    }

    public void removeInOutPoint() {
        this.element.removeChild("InOutPoints");
    }

    public void setFilterGUIDs(List<String> filterGUIDs) {
        int i = 0;
        for (String filterGUID : filterGUIDs) {
            this.removeFilter("Filter_" + i);
            Element filter = CarbonSource.buildFilterElement("Filter_" + i, filterGUID);
            this.element.addContent((Content)filter);
            ++i;
        }
    }

    public void removeFilter(String filterName) {
        this.element.removeChild(filterName);
    }

    static Element buildInOutElement(long in, long out) {
        Element element = new Element("InOutPoints");
        element.setAttribute("Inpoint_0.QWD", Long.toString(in));
        element.setAttribute("Outpoint_0.QWD", Long.toString(out));
        return element;
    }

    static Element buildFilterElement(String filterName, String filterGUID) {
        Element filter = new Element(filterName);
        Element module = new Element("Module_0");
        filter.addContent((Content)module);
        module.setAttribute("PresetGUID", filterGUID);
        return filter;
    }
}

