/*
 * Decompiled with CFR 0.152.
 */
package com.mediasmiths.carbon.util.mediainfo;

import com.mediasmiths.carbon.util.mediainfo.MediaInfoTrack;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Element;

public class MediaInfo {
    private final Element root;

    public MediaInfo(Element root) {
        this.root = root;
    }

    public String getMediaInfoVersion() {
        return this.root.getAttributeValue("version");
    }

    private Element getFileElement() {
        return this.root.getChild("File");
    }

    public List<MediaInfoTrack> getTracks() {
        ArrayList<MediaInfoTrack> tracks = new ArrayList<MediaInfoTrack>();
        for (Element track : this.getFileElement().getChildren("track")) {
            tracks.add(new MediaInfoTrack(track));
        }
        return tracks;
    }

    public MediaInfoTrack getFirstVideoTrack() {
        for (MediaInfoTrack track : this.getTracks()) {
            if (!"video".equalsIgnoreCase(track.getTrackType())) continue;
            return track;
        }
        throw new RuntimeException("No track type=Video found in mediainfo output!");
    }
}

