/*
 * Decompiled with CFR 0.152.
 */
package com.mediasmiths.carbon.util.mediainfo;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.mediasmiths.carbon.util.mediainfo.MediaInfo;
import com.mediasmiths.std.system.exec.Exec;
import com.mediasmiths.std.system.exec.Execed;
import com.mediasmiths.std.threading.Deadline;
import com.mediasmiths.std.threading.Timeout;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

@Singleton
public class MediaInfoCommand {
    private static final transient Logger log = Logger.getLogger(MediaInfoCommand.class);
    private final File mediainfo;

    @Inject
    public MediaInfoCommand(@Named(value="mediainfo.executable") File mediainfo) {
        this.mediainfo = mediainfo;
    }

    public MediaInfo inspect(File mediafile) throws IOException {
        Deadline timeOut;
        log.debug((Object)("Retrieving mediainfo output for " + mediafile.getAbsolutePath()));
        if (!mediafile.exists()) {
            throw new IllegalArgumentException("Media file " + mediafile + " does not exist!");
        }
        Exec exec = new Exec(new String[]{this.mediainfo.getAbsolutePath(), "--output=XML", "--full", mediafile.getAbsolutePath()});
        Execed process = exec.start();
        int result = process.waitForExit(timeOut = new Deadline(Timeout.ONE_MINUTE));
        if (result == 0) {
            return MediaInfoCommand.parse(process.getStandardOut());
        }
        throw new IOException("MediaInfo failed with non-zero code: " + result);
    }

    protected static MediaInfo parse(String xml) throws IOException {
        try {
            Document doc = new SAXBuilder().build((Reader)new StringReader(xml));
            return new MediaInfo(doc.getRootElement());
        }
        catch (JDOMException e) {
            throw new IOException("Error parsing XML response: " + e.getMessage(), e);
        }
    }
}

