/*
 * Decompiled with CFR 0.152.
 */
package com.mediasmiths.carbon.util.mediainfo;

import com.mediasmiths.std.types.Framerate;
import com.mediasmiths.std.types.Timecode;
import java.util.List;
import org.jdom2.Element;

public class MediaInfoTrack {
    private Element track;

    public MediaInfoTrack(Element track) {
        this.track = track;
    }

    public Timecode getDelay() {
        Framerate framerate = this.getFramerate();
        long delayMicros = this.getDelayInMicroseconds();
        long frames = framerate.resample(delayMicros, Framerate.HZ_1000000);
        return Timecode.getInstance((long)frames, (boolean)false, (Framerate)framerate);
    }

    private Framerate getFramerate() {
        return Framerate.HZ_25;
    }

    private long getDelayInMicroseconds() {
        List delays = this.track.getChildren("Delay");
        if (delays.size() != 0) {
            String millistring = ((Element)delays.get(0)).getValue();
            double millis = Double.parseDouble(millistring);
            return Math.round(millis * 1000.0);
        }
        throw new RuntimeException("No Delay elements present on track!");
    }

    public String getTrackType() {
        return this.track.getAttributeValue("type");
    }

    public String getAspectRatio() {
        List ratios = this.track.getChildren("Display_aspect_ratio");
        if (ratios.size() > 1) {
            String ratio = ((Element)ratios.get(1)).getValue();
            if (!ratio.isEmpty()) {
                return ratio;
            }
            throw new RuntimeException("Display aspect ratio not found");
        }
        throw new RuntimeException("No Display_aspect_ratio elements present on track!");
    }

    public long getBitRate() {
        List bitRates = this.track.getChildren("Bit_rate");
        if (bitRates.size() != 0) {
            String bitString = ((Element)bitRates.get(0)).getValue();
            Long bitRate = Long.parseLong(bitString);
            return bitRate;
        }
        throw new RuntimeException("No Bit_rate elements present on track!");
    }

    public long getDuration() {
        List durations = this.track.getChildren("Duration");
        if (durations.size() != 0) {
            String durationString = ((Element)durations.get(0)).getValue();
            long duration = Long.parseLong(durationString);
            return duration;
        }
        throw new RuntimeException("No Duration elements present on track!");
    }

    public String getFrameHeight() {
        List heights = this.track.getChildren("Height");
        if (heights.size() > 0) {
            String height = ((Element)heights.get(0)).getValue();
            if (!height.isEmpty()) {
                return height;
            }
            throw new RuntimeException("Height not found");
        }
        throw new RuntimeException("No Height elements present on track!");
    }

    public String getFrameWidth() {
        List widths = this.track.getChildren("Width");
        if (widths.size() > 0) {
            String width = ((Element)widths.get(0)).getValue();
            if (!width.isEmpty()) {
                return width;
            }
            throw new RuntimeException("Width not found");
        }
        throw new RuntimeException("No Width elements present on track!");
    }
}

