/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.carbon;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.peterphi.carbon.CarbonClient;
import com.peterphi.carbon.exception.CarbonConnectException;
import com.peterphi.carbon.exception.CarbonException;
import com.peterphi.carbon.message.Builder;
import com.peterphi.carbon.message.CarbonSocketAPI;
import com.peterphi.carbon.type.immutable.CarbonJobInfo;
import com.peterphi.carbon.type.immutable.CarbonProfile;
import com.peterphi.carbon.type.immutable.CarbonReply;
import com.peterphi.carbon.type.mutable.CarbonProject;
import com.peterphi.std.threading.Timeout;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.Socket;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.XMLOutputter;

@Singleton
public class CarbonClientImpl
implements CarbonClient {
    private static final Logger log = Logger.getLogger(CarbonClientImpl.class);
    private static final int MAX_CONNECT_ATTEMPTS = 3;
    private Timeout reconnectSleep = new Timeout(1L, TimeUnit.SECONDS);
    private int reconnectSleepMultiplier = 2;
    private final String host;
    private final int port;
    @Inject(optional=true)
    @Named(value="carbon.user")
    private String clientId = "CarbonClientImpl_" + UUID.randomUUID().toString();
    @Inject
    private Builder builder = new Builder();

    public CarbonClientImpl(String host) {
        this(host, 1120);
    }

    @Inject
    public CarbonClientImpl(@Named(value="carbon.coder.host") String host, @Named(value="carbon.coder.port") Integer port) {
        this.host = host;
        this.port = port;
    }

    @Override
    public String getEndpoint() {
        return "carbon-socket://" + this.host + ":" + this.port;
    }

    @Override
    public boolean isHealthy() {
        try {
            List<CarbonProfile> profiles = this.getProfiles();
            if (profiles.size() > 0) {
                return true;
            }
            log.warn((Object)("Carbon " + this.getEndpoint() + " failed health check with no video profiles"));
            return false;
        }
        catch (CarbonException e) {
            log.warn((Object)("Carbon " + this.getEndpoint() + " failed health check with exception"), (Throwable)e);
            return false;
        }
    }

    @Override
    public CarbonReply send(Element element) throws CarbonException {
        try {
            String responseXml = this.send(CarbonClientImpl.serialise(element));
            return new CarbonReply(CarbonClientImpl.deserialise(responseXml));
        }
        catch (CarbonException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CarbonException(e);
        }
    }

    private String send(byte[] data) throws CarbonException {
        try {
            log.trace((Object)"Connecting to Carbon...");
            Socket socket = this.createSocket();
            CarbonSocketAPI api = new CarbonSocketAPI(socket);
            return api.send(data);
        }
        catch (CarbonException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CarbonException(e);
        }
    }

    private Socket createSocket() {
        int attempt = 0;
        Timeout sleep = this.reconnectSleep;
        while (attempt++ < 3) {
            try {
                return new Socket(this.host, this.port);
            }
            catch (Exception e) {
                if (attempt < 3) {
                    sleep.sleep();
                    sleep = sleep.multiply((long)this.reconnectSleepMultiplier);
                    continue;
                }
                throw new CarbonConnectException("Could not connect to Carbon API in 3 attempts", e);
            }
        }
        throw new CarbonConnectException("Could not conect to Carbon API socket!");
    }

    private static byte[] serialise(Element element) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
            new XMLOutputter().output(element, (OutputStream)bos);
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw new CarbonException(e.getMessage(), e);
        }
    }

    private static Document deserialise(String xml) {
        try {
            return new SAXBuilder().build((Reader)new StringReader(xml));
        }
        catch (IOException e) {
            throw new CarbonException(e.getMessage(), e);
        }
        catch (JDOMException e) {
            throw new CarbonException(e.getMessage(), e);
        }
    }

    @Override
    public CarbonJobInfo getJob(String guid) throws CarbonException {
        CarbonReply reply = this.send(new Builder().createJobInfoRequest(guid));
        if (!reply.isSuccess()) {
            throw new CarbonException("Failure acquiring info for job " + guid);
        }
        return reply.getJobInfo();
    }

    @Override
    public CarbonProject getJobDetails(String guid) throws CarbonException {
        CarbonReply reply = this.send(new Builder().createJobFullInfoRequest(guid));
        if (!reply.isSuccess()) {
            throw new CarbonException("Failure acquiring info for job " + guid);
        }
        return reply.getJob();
    }

    @Override
    public String createJob(CarbonProject project) throws CarbonException {
        CarbonReply reply;
        if (project.getUser() == null) {
            project.setUser(this.clientId);
        }
        if (!(reply = this.send(project.getElement())).isSuccess()) {
            throw new CarbonException("Carbon createJob call failed. Error returned was: " + reply.getError());
        }
        return reply.getGUID();
    }

    @Override
    public List<String> listJobs() throws CarbonException {
        CarbonReply reply = this.send(this.builder.createJobListRequest());
        if (!reply.isSuccess()) {
            throw new CarbonException("Carbon call failed. Error returned was: " + reply.getError());
        }
        return reply.getJobIdList();
    }

    @Override
    public List<CarbonProfile> getProfiles() throws CarbonException {
        CarbonReply reply = this.send(this.builder.createDestinationProfileListRequest());
        if (!reply.isSuccess()) {
            throw new CarbonException("Carbon call failed. Error returned was: " + reply.getError());
        }
        return reply.getProfileList();
    }

    @Override
    public CarbonProfile getProfile(String query) throws CarbonException {
        for (CarbonProfile profile : this.getProfiles()) {
            String name = profile.getName();
            String guid = profile.getGUID();
            if (!query.equalsIgnoreCase(name) && !query.equalsIgnoreCase(guid)) continue;
            return profile;
        }
        return null;
    }

    @Override
    public CarbonProfile getVideoFilter(String query) {
        for (CarbonProfile profile : this.getVideoFilters()) {
            String name = profile.getName();
            String guid = profile.getGUID();
            if (!query.equalsIgnoreCase(name) && !query.equalsIgnoreCase(guid)) continue;
            return profile;
        }
        return null;
    }

    @Override
    public List<CarbonProfile> getVideoFilters() throws CarbonException {
        CarbonReply reply = this.send(this.builder.createVideoFilterProfileListRequest());
        if (!reply.isSuccess()) {
            throw new CarbonException("Carbon call failed. Error returned was: " + reply.getError());
        }
        return reply.getProfileList();
    }

    @Override
    public void removeJob(String guid) throws CarbonException {
        CarbonReply reply = this.send(this.builder.createJobCommandRequest(guid, "Remove"));
        if (!reply.isSuccess()) {
            throw new CarbonException("Carbon call failed. Error returned was: " + reply.getError());
        }
    }
}

