/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.carbon.message;

import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;

public class Builder {
    private static final String ROOT_ELEMENT = "cnpsXML";
    private static final String API_VERSION = "1.2";

    private Element createNewRequest(String taskType) {
        Document doc = new Document();
        Element element = new Element(ROOT_ELEMENT);
        element.setAttribute("CarbonAPIVer", API_VERSION);
        element.setAttribute("TaskType", taskType);
        doc.setRootElement(element);
        return element;
    }

    public Element createJobListRequest() {
        return this.createNewRequest("JobList");
    }

    public Element createDestinationProfileListRequest() {
        return this.createProfileListRequest("Destination");
    }

    public Element createVideoFilterProfileListRequest() {
        return this.createProfileListRequest("Filter_Video");
    }

    public Element createProfileListRequest(String profileType) {
        Element root = this.createNewRequest("ProfileList");
        Element attribs = new Element("ProfileAttributes");
        attribs.setAttribute("ProfileType", profileType);
        root.addContent((Content)attribs);
        return root;
    }

    public Element createJobInfoRequest(String guid) {
        return this.createJobCommandRequest(guid, "QueryInfo");
    }

    public Element createJobFullInfoRequest(String guid) {
        return this.createJobCommandRequest(guid, "Query");
    }

    public Element createJobCommandRequest(String guid, String command) {
        Element root = this.createNewRequest("JobCommand");
        Element element = new Element("JobCommand");
        element.setAttribute("Command", command);
        element.setAttribute("GUID", guid);
        root.addContent((Content)element);
        return root;
    }
}

