/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.carbon.message;

import com.peterphi.carbon.exception.MalformedCarbonResponseException;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.Socket;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class CarbonSocketAPI {
    private static final Logger log = Logger.getLogger(CarbonSocketAPI.class);
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final byte[] MESSAGE_PREFIX = "CarbonAPIXML1".getBytes(UTF8);
    private static final byte[] MESSAGE_SEPARATOR = " ".getBytes(UTF8);
    private static final byte[] MESSAGE_TERMINATOR = "\n".getBytes(UTF8);
    private final Socket socket;

    public CarbonSocketAPI(Socket socket) {
        this.socket = socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String send(byte[] xml) throws IOException, MalformedCarbonResponseException {
        try {
            OutputStream os = this.socket.getOutputStream();
            InputStream is = this.socket.getInputStream();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Writing request: " + xml));
            }
            CarbonSocketAPI.writeMessageWithData(xml, os);
            os.flush();
            if (log.isTraceEnabled()) {
                log.trace((Object)"Reading response");
            }
            StringWriter writer = new StringWriter(1024);
            IOUtils.copy((InputStream)is, (Writer)writer, (Charset)UTF8);
            String response = writer.toString();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Response: " + response));
            }
            String string = CarbonSocketAPI.getMessageFromData(response);
            return string;
        }
        finally {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Closing socket");
            }
            this.socket.close();
        }
    }

    public static void writeMessageWithData(byte[] xmlBytes, OutputStream os) throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(os);
        bos.write(MESSAGE_PREFIX);
        bos.write(MESSAGE_SEPARATOR);
        bos.write(String.valueOf(xmlBytes.length).getBytes(UTF8));
        bos.write(MESSAGE_SEPARATOR);
        bos.write(xmlBytes);
        bos.write(MESSAGE_TERMINATOR);
        bos.flush();
    }

    public static String getMessageFromData(String reply) throws MalformedCarbonResponseException {
        if (reply.length() > MESSAGE_PREFIX.length) {
            String cutLength;
            String cutPrefix = reply.substring(MESSAGE_PREFIX.length + 1);
            long length = Long.parseLong(cutPrefix.substring(0, cutPrefix.indexOf(32)));
            if (length != (long)(cutLength = cutPrefix.substring(cutPrefix.indexOf(32) + 1)).length()) {
                throw new MalformedCarbonResponseException("Carbon response length mismatch: expected " + length + ", got " + cutLength.length());
            }
            return cutLength;
        }
        throw new MalformedCarbonResponseException("Carbon response malformed: reply too short: '" + reply + "'");
    }
}

