/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.carbon.type.immutable;

import com.peterphi.carbon.exception.CarbonBuildException;
import com.peterphi.carbon.type.XMLWrapper;
import com.peterphi.carbon.type.immutable.CarbonJobInfo;
import com.peterphi.carbon.type.immutable.CarbonProfile;
import com.peterphi.carbon.type.mutable.CarbonProject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;

public class CarbonReply
extends XMLWrapper {
    private static final Logger log = Logger.getLogger(CarbonReply.class);

    public CarbonReply(Document doc) {
        this(doc.getRootElement());
    }

    public CarbonReply(Element element) {
        super(element);
    }

    public boolean isSuccess() {
        Attribute attribute = this.element.getAttribute("Success");
        if (attribute == null) {
            return false;
        }
        if (attribute.getValue().equalsIgnoreCase("true")) {
            return true;
        }
        if (attribute.getValue().equalsIgnoreCase("false")) {
            return false;
        }
        throw new CarbonBuildException("Success attribute had invalid value: " + attribute.getValue());
    }

    public String getGUID() {
        return this.element.getAttributeValue("GUID");
    }

    public String getError() {
        return this.element.getAttributeValue("Error");
    }

    public CarbonJobInfo getJobInfo() {
        Element child = this.element.getChild("JobInfo");
        if (child != null) {
            return new CarbonJobInfo(child);
        }
        return null;
    }

    public List<String> getJobIdList() {
        Element list = this.element.getChild("JobList");
        if (list != null) {
            ArrayList<String> guids = new ArrayList<String>();
            for (Element job : list.getChildren()) {
                if (job.getAttribute("GUID") != null) {
                    guids.add(job.getAttribute("GUID").getValue());
                    continue;
                }
                log.warn((Object)("Job without GUID attribute: " + job));
            }
            return guids;
        }
        return Collections.emptyList();
    }

    public List<CarbonJobInfo> getJobList() {
        Element statusList = this.element.getChild("JobStatusList");
        if (statusList != null) {
            ArrayList<CarbonJobInfo> jobs = new ArrayList<CarbonJobInfo>();
            for (Element job : statusList.getChildren()) {
                jobs.add(new CarbonJobInfo(job));
            }
            return jobs;
        }
        if (this.getJobInfo() != null) {
            return Collections.singletonList(this.getJobInfo());
        }
        return Collections.emptyList();
    }

    public List<CarbonProfile> getProfileList() {
        ArrayList<CarbonProfile> profiles = new ArrayList<CarbonProfile>();
        Element profileList = this.element.getChild("ProfileList");
        if (profileList != null) {
            for (Element profileElement : profileList.getChildren()) {
                CarbonProfile profile = new CarbonProfile(profileElement);
                profiles.add(profile);
            }
        }
        return profiles;
    }

    public CarbonProject getJob() {
        Element child = this.element.getChild("Job");
        if (child != null) {
            return new CarbonProject(child);
        }
        return null;
    }
}

