/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.carbon.type.mutable;

import com.peterphi.carbon.exception.CarbonBuildException;
import com.peterphi.carbon.type.XMLWrapper;
import com.peterphi.carbon.type.mutable.CarbonDestination;
import com.peterphi.carbon.type.mutable.CarbonSource;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;

public class CarbonProject
extends XMLWrapper {
    public CarbonProject(Document doc) {
        this(doc.getRootElement());
    }

    public CarbonProject(Element element) {
        super(element);
        if (element == null) {
            throw new IllegalArgumentException("Must provide element!");
        }
        if (!element.getName().equals("cnpsXML")) {
            throw new CarbonBuildException("Root element of Carbon Project must be cnpsXML!");
        }
    }

    public void addSource(CarbonSource source) {
        int newModuleNumber = this.getSources().size();
        String elementName = "Module_" + newModuleNumber;
        Element sources = this.element.getChild("Sources");
        Element element = source.getElement();
        element.setName(elementName);
        element.detach();
        sources.addContent((Content)element);
    }

    public List<CarbonSource> getSources() {
        Element sources = this.element.getChild("Sources");
        if (sources == null) {
            throw new CarbonBuildException("Carbon XML does not have a Sources element!");
        }
        ArrayList<CarbonSource> list = new ArrayList<CarbonSource>();
        for (Element source : sources.getChildren()) {
            list.add(new CarbonSource(source));
        }
        return list;
    }

    public void addDestination(CarbonDestination destination) {
        int newModuleNumber = this.getDestinations().size();
        String elementName = "Module_" + newModuleNumber;
        Element destinations = this.element.getChild("Destinations");
        Element element = destination.getElement();
        element.setName(elementName);
        element.detach();
        destinations.addContent((Content)element);
    }

    public List<CarbonDestination> getDestinations() {
        Element destinations = this.element.getChild("Destinations");
        if (destinations == null) {
            throw new CarbonBuildException("Carbon XML does not have a Destinations element!");
        }
        ArrayList<CarbonDestination> list = new ArrayList<CarbonDestination>();
        for (Element destination : destinations.getChildren()) {
            list.add(new CarbonDestination(destination));
        }
        return list;
    }

    public String getTaskType() {
        return this.getAttribute("TaskType");
    }

    public void setTaskType(String value) {
        this.setAttribute("TaskType", value);
    }

    public String getUser() {
        return this.getAttribute("User");
    }

    public void setUser(String value) {
        this.setAttribute("User", value);
    }

    public String getDescription() {
        return this.getAttribute("Descrption");
    }

    public void setDescription(String value) {
        this.setAttribute("Description", value);
    }

    public String getJobName() {
        return this.getAttribute("JobName");
    }

    public void setJobName(String value) {
        this.element.setAttribute("JobName", value);
    }
}

