/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.carbon.util.mediainfo;

import com.peterphi.carbon.util.mediainfo.MediaInfoTrack;
import com.peterphi.std.types.SampleCount;
import com.peterphi.std.types.Timebase;
import com.peterphi.std.types.Timecode;
import java.util.List;
import org.jdom2.Element;

public abstract class AVTrack
extends MediaInfoTrack {
    public AVTrack(Element track) {
        super(track);
    }

    public Timecode getDelay() {
        Timebase timebase = this.getRate();
        long delayMicros = this.getDelayInMicroseconds();
        long frames = timebase.resample(delayMicros, Timebase.HZ_1000000);
        return Timecode.getInstance((long)frames, (boolean)false, (Timebase)timebase);
    }

    public String getSource() {
        Element element = this.getElement("Source", 0);
        if (element != null) {
            return element.getText();
        }
        return null;
    }

    public String getCodecID() {
        Element element = this.getElement("Codec_ID", 0);
        if (element != null) {
            return element.getText();
        }
        return null;
    }

    protected abstract long getSamples();

    public abstract Timebase getRate();

    public SampleCount getSampleCount() {
        return new SampleCount(this.getSamples(), this.getRate());
    }

    protected long getDelayInMicroseconds() {
        List delays = this.element.getChildren("Delay");
        if (delays.size() != 0) {
            String millistring = ((Element)delays.get(0)).getValue();
            double millis = Double.parseDouble(millistring);
            return Math.round(millis * 1000.0);
        }
        throw new RuntimeException("No Delay elements present on track!");
    }

    public long getBitRate() {
        List bitRates = this.element.getChildren("Bit_rate");
        if (bitRates.size() != 0) {
            String bitString = ((Element)bitRates.get(0)).getValue();
            Long bitRate = Long.parseLong(bitString);
            return bitRate;
        }
        throw new RuntimeException("No Bit_rate elements present on track!");
    }
}

