/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.carbon.util.mediainfo;

import com.peterphi.carbon.type.XMLWrapper;
import com.peterphi.carbon.util.mediainfo.AudioTrack;
import com.peterphi.carbon.util.mediainfo.MediaInfoTrack;
import com.peterphi.carbon.util.mediainfo.VideoTrack;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jdom2.Element;

public class MediaInfo
extends XMLWrapper {
    public MediaInfo(Element element) {
        super(element);
    }

    public String getMediaInfoVersion() {
        return this.element.getAttributeValue("version");
    }

    private Element getFileElement() {
        return this.element.getChild("File");
    }

    public List<MediaInfoTrack> getTracks() {
        ArrayList<MediaInfoTrack> tracks = new ArrayList<MediaInfoTrack>();
        for (Element track : this.getFileElement().getChildren("track")) {
            MediaInfoTrack generic = new MediaInfoTrack(track);
            if (StringUtils.equalsIgnoreCase((String)generic.getTrackType(), (String)"video")) {
                tracks.add(new VideoTrack(track));
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)generic.getTrackType(), (String)"audio")) {
                tracks.add(new AudioTrack(track));
                continue;
            }
            tracks.add(generic);
        }
        return tracks;
    }

    public List<VideoTrack> getVideoTracks() {
        ArrayList<VideoTrack> tracks = new ArrayList<VideoTrack>();
        for (MediaInfoTrack track : this.getTracks()) {
            if (!(track instanceof VideoTrack)) continue;
            tracks.add((VideoTrack)track);
        }
        return tracks;
    }

    public List<AudioTrack> getAudioTracks() {
        ArrayList<AudioTrack> tracks = new ArrayList<AudioTrack>();
        for (MediaInfoTrack track : this.getTracks()) {
            if (!(track instanceof AudioTrack)) continue;
            tracks.add((AudioTrack)track);
        }
        return tracks;
    }

    public List<MediaInfoTrack> getTimeCodeTracks() {
        ArrayList<MediaInfoTrack> tracks = new ArrayList<MediaInfoTrack>();
        for (MediaInfoTrack track : this.getTracks()) {
            if (!StringUtils.equalsIgnoreCase((String)track.getTrackType(), (String)"other") || !StringUtils.equalsIgnoreCase((String)track.getOtherTrackType(), (String)"time code")) continue;
            tracks.add(track);
        }
        return tracks;
    }

    public VideoTrack getFirstVideoTrack() {
        List<VideoTrack> tracks = this.getVideoTracks();
        if (tracks.isEmpty()) {
            throw new RuntimeException("Media has no video tracks!");
        }
        return tracks.get(0);
    }

    public MediaInfoTrack getFirstTimecodeTrack() {
        List<MediaInfoTrack> tracks = this.getTimeCodeTracks();
        if (tracks.isEmpty()) {
            throw new RuntimeException("Media has no timecode tracks!");
        }
        return tracks.get(0);
    }
}

