/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.carbon.util.mediainfo;

import com.peterphi.carbon.util.mediainfo.AVTrack;
import com.peterphi.std.types.Timebase;
import java.util.List;
import org.jdom2.Element;

public class VideoTrack
extends AVTrack {
    public VideoTrack(Element track) {
        super(track);
    }

    public int getFrameHeight() {
        List heights = this.element.getChildren("Height");
        if (heights.size() > 0) {
            String height = ((Element)heights.get(0)).getValue();
            if (!height.isEmpty()) {
                return Integer.parseInt(height);
            }
            throw new RuntimeException("Height not found");
        }
        throw new RuntimeException("No Height elements present on track!");
    }

    public int getFrameWidth() {
        List widths = this.element.getChildren("Width");
        if (widths.size() > 0) {
            String width = ((Element)widths.get(0)).getValue();
            if (!width.isEmpty()) {
                return Integer.parseInt(width);
            }
            throw new RuntimeException("Width not found");
        }
        throw new RuntimeException("No Width elements present on track!");
    }

    public String getAspectRatio() {
        List ratios = this.element.getChildren("Display_aspect_ratio");
        if (ratios.size() > 1) {
            String ratio = ((Element)ratios.get(1)).getValue();
            if (!ratio.isEmpty()) {
                return ratio;
            }
            throw new RuntimeException("Display aspect ratio not found");
        }
        throw new RuntimeException("No Display_aspect_ratio elements present on track!");
    }

    @Override
    public Timebase getRate() {
        Element e = this.getElement("Frame_rate", 0);
        double rate = Double.parseDouble(e.getText());
        if (rate == Math.floor(rate)) {
            return Timebase.getInstance((String)Long.toString((long)rate));
        }
        throw new IllegalArgumentException("Cannot parse Frame rate " + e.getText() + ": floating point not permitted");
    }

    @Override
    protected long getSamples() {
        return Long.parseLong(this.getElement("Frame_count", 0).getText());
    }
}

