/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlapisync.data;

import com.phoenixnap.oss.ramlapisync.data.ApiBodyMetadata;
import com.phoenixnap.oss.ramlapisync.data.ApiParameterMetadata;
import com.phoenixnap.oss.ramlapisync.data.ApiResourceMetadata;
import com.phoenixnap.oss.ramlapisync.data.RamlFormParameter;
import com.phoenixnap.oss.ramlapisync.naming.NamingHelper;
import com.phoenixnap.oss.ramlapisync.naming.RamlHelper;
import com.phoenixnap.oss.ramlapisync.naming.SchemaHelper;
import com.phoenixnap.oss.ramlapisync.parser.ResourceParser;
import com.phoenixnap.oss.ramlapisync.raml.RamlAbstractParam;
import com.phoenixnap.oss.ramlapisync.raml.RamlAction;
import com.phoenixnap.oss.ramlapisync.raml.RamlActionType;
import com.phoenixnap.oss.ramlapisync.raml.RamlMimeType;
import com.phoenixnap.oss.ramlapisync.raml.RamlResource;
import com.phoenixnap.oss.ramlapisync.raml.RamlResponse;
import com.phoenixnap.oss.ramlapisync.raml.RamlUriParameter;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.util.StringUtils;

public class ApiActionMetadata {
    ApiResourceMetadata parent;
    RamlResource resource;
    RamlActionType actionType;
    RamlAction action;
    String requestBodyMime = null;
    ApiBodyMetadata requestBody = null;
    Map<String, ApiBodyMetadata> responseBody = new LinkedHashMap<String, ApiBodyMetadata>();
    Set<ApiParameterMetadata> pathVariables = null;
    Set<ApiParameterMetadata> requestParameters = null;
    Set<ApiParameterMetadata> requestHeaders = null;
    boolean injectHttpHeadersParameter = false;
    private String responseContentTypeFilter;

    public ApiActionMetadata(ApiResourceMetadata parent, RamlResource resource, RamlActionType actionType, RamlAction action, String responseContentTypeFilter, boolean injectHttpHeadersParameter) {
        this.parent = parent;
        this.resource = resource;
        this.actionType = actionType;
        this.action = action;
        this.responseContentTypeFilter = responseContentTypeFilter;
        this.injectHttpHeadersParameter = injectHttpHeadersParameter;
        this.parseRequest();
        this.parseResponse(responseContentTypeFilter);
    }

    public ApiActionMetadata(ApiResourceMetadata parent, RamlResource resource, RamlActionType actionType, RamlAction action) {
        this(parent, resource, actionType, action, null, false);
    }

    public String toString() {
        return "Method " + this.getName() + "  Verb [" + (Object)((Object)this.actionType) + "] Url [" + this.getUrl() + "] \nConsumes [" + this.getConsumes() + "] Produces [" + this.getProduces() + "] with Schema [" + null + "] \nPath Vars [" + StringUtils.collectionToCommaDelimitedString(this.getPathVariables()) + "] \nRequest Params [" + StringUtils.collectionToCommaDelimitedString(this.getRequestParameters()) + "] \nRequest Headers [" + StringUtils.collectionToCommaDelimitedString(this.getRequestHeaders()) + "] \n";
    }

    public Set<ApiParameterMetadata> getPathVariables() {
        if (this.pathVariables != null) {
            return this.pathVariables;
        }
        this.pathVariables = new LinkedHashSet<ApiParameterMetadata>();
        RamlResource targetResource = this.action.getResource();
        do {
            for (Map.Entry<String, RamlUriParameter> param : targetResource.getUriParameters().entrySet()) {
                this.pathVariables.add(new ApiParameterMetadata(param.getKey(), param.getValue()));
            }
        } while ((targetResource = targetResource.getParentResource()) != null);
        return this.pathVariables;
    }

    public Set<ApiParameterMetadata> getRequestParameters() {
        if (this.requestParameters == null) {
            return Collections.emptySet();
        }
        return this.requestParameters;
    }

    public Set<ApiParameterMetadata> getRequestHeaders() {
        if (this.requestHeaders == null) {
            return Collections.emptySet();
        }
        return this.requestHeaders;
    }

    private void parseRequest() {
        this.requestParameters = this.action.getQueryParameters().entrySet().stream().map(param -> new ApiParameterMetadata((String)param.getKey(), (RamlAbstractParam)param.getValue())).collect(Collectors.toCollection(LinkedHashSet::new));
        this.requestHeaders = this.action.getHeaders().entrySet().stream().map(param -> new ApiParameterMetadata((String)param.getKey(), (RamlAbstractParam)param.getValue())).collect(Collectors.toCollection(LinkedHashSet::new));
        if (this.action.getBody() != null && !this.action.getBody().isEmpty()) {
            this.action.getBody().entrySet().forEach(this::collectBodyParams);
        }
    }

    private void collectBodyParams(Map.Entry<String, RamlMimeType> mime) {
        ApiBodyMetadata requestBody;
        String schema;
        if (mime.getKey().equals("multipart/form-data") && ResourceParser.doesActionTypeSupportMultipartMime(this.actionType)) {
            this.collectRequestParamsForMime(this.action.getBody().get("multipart/form-data"));
        } else if (mime.getKey().equals("application/x-www-form-urlencoded") && ResourceParser.doesActionTypeSupportMultipartMime(this.actionType)) {
            this.collectRequestParamsForMime(this.action.getBody().get("application/x-www-form-urlencoded"));
        }
        if (ResourceParser.doesActionTypeSupportRequestBody(this.actionType) && mime.getKey().toLowerCase().contains("json") && StringUtils.hasText((String)(schema = mime.getValue().getSchema())) && (requestBody = SchemaHelper.mapSchemaToPojo(this.parent.getDocument(), schema, this.parent.getBasePackage() + NamingHelper.getDefaultModelPackage(), StringUtils.capitalize((String)this.getName()) + "Request", null)) != null) {
            this.setRequestBody(requestBody, mime.getKey());
        }
    }

    private void collectRequestParamsForMime(RamlMimeType requestBody) {
        if (requestBody == null) {
            return;
        }
        for (Map.Entry<String, List<RamlFormParameter>> params : requestBody.getFormParameters().entrySet()) {
            for (RamlFormParameter param : params.getValue()) {
                this.requestParameters.add(new ApiParameterMetadata(params.getKey(), param));
            }
        }
    }

    private void parseResponse(String responseContentTypeFilter) {
        RamlResponse response = RamlHelper.getSuccessfulResponse(this.action);
        if (response != null && response.getBody() != null && !response.getBody().isEmpty()) {
            for (Map.Entry<String, RamlMimeType> body : response.getBody().entrySet()) {
                ApiBodyMetadata responseBody;
                String schema;
                if (responseContentTypeFilter != null && !body.getKey().equals(responseContentTypeFilter) || !body.getKey().toLowerCase().contains("json") || !StringUtils.hasText((String)(schema = body.getValue().getSchema())) || (responseBody = SchemaHelper.mapSchemaToPojo(this.parent.getDocument(), schema, this.parent.getBasePackage() + NamingHelper.getDefaultModelPackage(), StringUtils.capitalize((String)this.getName()) + "Response", null)) == null) continue;
                this.responseBody.put(body.getKey(), responseBody);
            }
        }
    }

    public String getUrl() {
        return this.resource.getUri().replace(this.parent.getResourceUri(), "");
    }

    public String getName() {
        String name = NamingHelper.getActionName(this.parent.getResource(), this.resource, this.action, this.actionType);
        if (this.responseContentTypeFilter != null) {
            name = name + NamingHelper.convertContentTypeToQualifier(this.responseContentTypeFilter);
        }
        return name;
    }

    public String getProduces() {
        if (this.responseBody != null && !this.responseBody.isEmpty()) {
            String out = "";
            boolean first = true;
            for (String key : this.responseBody.keySet()) {
                if (first) {
                    first = false;
                } else {
                    out = out + ",";
                }
                out = out + key;
            }
            return out;
        }
        return null;
    }

    public String getConsumes() {
        if (this.action.hasBody()) {
            String out = null;
            boolean first = true;
            for (String key : this.action.getBody().keySet()) {
                if ("application/x-www-form-urlencoded".equals(key)) continue;
                if (first) {
                    first = false;
                    out = "";
                } else {
                    out = out + ",";
                }
                out = out + key;
            }
            return out;
        }
        return null;
    }

    public String getDescription() {
        return this.action.getDescription();
    }

    public ApiResourceMetadata getParent() {
        return this.parent;
    }

    public void setParent(ApiResourceMetadata parent) {
        this.parent = parent;
    }

    public RamlResource getResource() {
        return this.resource;
    }

    public void setResource(RamlResource resource) {
        this.resource = resource;
    }

    public RamlActionType getActionType() {
        return this.actionType;
    }

    public void setActionType(RamlActionType actionType) {
        this.actionType = actionType;
    }

    public RamlAction getAction() {
        return this.action;
    }

    public void setAction(RamlAction action) {
        this.action = action;
    }

    public ApiBodyMetadata getRequestBody() {
        return this.requestBody;
    }

    private void setRequestBody(ApiBodyMetadata requestBody, String mimeType) {
        if (this.requestBody != null) {
            throw new IllegalStateException("Body Metadata is immutable");
        }
        this.requestBodyMime = mimeType;
        this.requestBody = requestBody;
    }

    public void setPathVariables(Set<ApiParameterMetadata> pathVariables) {
        this.pathVariables = pathVariables;
    }

    public void setRequestParameters(Set<ApiParameterMetadata> requestParameters) {
        this.requestParameters = requestParameters;
    }

    public Map<String, ApiBodyMetadata> getResponseBody() {
        return this.responseBody;
    }

    public String getRequestBodyMime() {
        return this.requestBodyMime;
    }

    public void setRequestBodyMime(String requestBodyMime) {
        this.requestBodyMime = requestBodyMime;
    }

    public boolean getInjectHttpHeadersParameter() {
        return this.injectHttpHeadersParameter;
    }
}

