/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlapisync.data;

import com.phoenixnap.oss.ramlapisync.naming.NamingHelper;
import com.phoenixnap.oss.ramlapisync.naming.SchemaHelper;
import com.phoenixnap.oss.ramlapisync.raml.RamlParamType;
import com.sun.codemodel.JCodeModel;
import org.jsonschema2pojo.Annotator;
import org.jsonschema2pojo.GenerationConfig;

public class ApiBodyMetadata {
    private String name;
    private String schema;
    private JCodeModel codeModel;
    private boolean array = false;

    public static void main(String[] args) {
        String schema = "{\"$schema\": \"http://json-schema.org/draft-04/schema\",\"type\" : \"object\",\"javaType\": \"com.pnap.pncp.rbac.rest.model.Role\",\"id\" : \"role\",\"properties\" : {\"id\" : {  \"type\" : \"integer\"}, \"name\" : {  \"type\" : \"string\"},\"description\" : {  \"type\" : \"string\"},\"addedOn\" : {  \"type\" : \"integer\",  \"format\" : \"UTC_MILLISEC\"}},\"additionalProperties\" : false}";
        ApiBodyMetadata abm = new ApiBodyMetadata("blargh", schema, new JCodeModel());
        System.out.println(abm.getName());
    }

    public ApiBodyMetadata(String name, String schema, JCodeModel codeModel) {
        int nextQuoteIdxIdx;
        int quoteIdx;
        this.schema = schema;
        this.name = name;
        this.codeModel = codeModel;
        int typeIdx = schema.indexOf("type");
        if (typeIdx != -1 && (quoteIdx = schema.indexOf("\"", typeIdx + 6)) != -1 && (nextQuoteIdxIdx = schema.indexOf("\"", quoteIdx + 1)) != -1) {
            String possibleType = schema.substring(quoteIdx + 1, nextQuoteIdxIdx);
            this.name = NamingHelper.getResourceName(this.name, true);
            if ("array".equals(possibleType.toLowerCase())) {
                this.array = true;
            }
            if (codeModel.countArtifacts() == 0 && !"object".equals(possibleType.toLowerCase())) {
                try {
                    this.name = SchemaHelper.mapSimpleType(RamlParamType.valueOf(possibleType.toUpperCase())).getSimpleName();
                }
                catch (Exception ex) {
                    this.name = String.class.getSimpleName();
                }
                this.codeModel = null;
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public String getSchema() {
        return this.schema;
    }

    public JCodeModel getCodeModel() {
        return this.codeModel;
    }

    public boolean isArray() {
        return this.array;
    }

    public JCodeModel getCodeModel(String basePackage, String schemaLocation, GenerationConfig config, Annotator annotator) {
        return SchemaHelper.buildBodyJCodeModel(schemaLocation, basePackage, this.name, this.schema, config, annotator);
    }
}

