/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlapisync.data;

import com.phoenixnap.oss.ramlapisync.data.ApiActionMetadata;
import com.phoenixnap.oss.ramlapisync.data.ApiBodyMetadata;
import com.phoenixnap.oss.ramlapisync.naming.NamingHelper;
import com.phoenixnap.oss.ramlapisync.raml.RamlAction;
import com.phoenixnap.oss.ramlapisync.raml.RamlActionType;
import com.phoenixnap.oss.ramlapisync.raml.RamlResource;
import com.phoenixnap.oss.ramlapisync.raml.RamlRoot;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class ApiResourceMetadata {
    public static final String CONTROLLER_SUFFIX = "Controller";
    private String controllerUrl;
    private transient RamlResource resource;
    private String basePackage;
    private RamlRoot document;
    private boolean singularizeName = true;
    Set<ApiActionMetadata> apiCalls = new LinkedHashSet<ApiActionMetadata>();

    public ApiResourceMetadata(String controllerUrl, RamlResource resource, String basePackage, RamlRoot document) {
        this.controllerUrl = controllerUrl;
        this.resource = resource;
        this.basePackage = basePackage;
        this.document = document;
    }

    public void addApiCall(RamlResource resource, RamlActionType actionType, RamlAction action) {
        this.apiCalls.add(new ApiActionMetadata(this, resource, actionType, action));
    }

    public void addApiCall(RamlResource resource, RamlActionType actionType, RamlAction action, String responseContentType, boolean injectHttpHeadersParameter) {
        this.apiCalls.add(new ApiActionMetadata(this, resource, actionType, action, responseContentType, injectHttpHeadersParameter));
    }

    public Set<ApiActionMetadata> getApiCalls() {
        return Collections.unmodifiableSet(this.apiCalls);
    }

    public String getName() {
        String name = NamingHelper.getResourceName(this.resource, this.singularizeName);
        if (name != null) {
            return name + CONTROLLER_SUFFIX;
        }
        return CONTROLLER_SUFFIX;
    }

    public RamlResource getResource() {
        return this.resource;
    }

    public String getResourceName() {
        return NamingHelper.getResourceName(this.resource, this.singularizeName);
    }

    public String getResourceUri() {
        return this.resource.getUri();
    }

    public String getControllerUrl() {
        return this.controllerUrl;
    }

    public String toString() {
        return "Controller " + this.getName() + "[" + this.getControllerUrl() + "]";
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    public Set<ApiBodyMetadata> getDependencies() {
        LinkedHashSet<ApiBodyMetadata> dependencies = new LinkedHashSet<ApiBodyMetadata>();
        for (ApiActionMetadata method : this.apiCalls) {
            if (method.getRequestBody() != null) {
                dependencies.add(method.getRequestBody());
            }
            dependencies.addAll(method.getResponseBody().values());
        }
        return dependencies;
    }

    public String getDescription() {
        return this.resource.getDescription();
    }

    public RamlRoot getDocument() {
        return this.document;
    }

    public void setSingularizeName(boolean singularizeName) {
        this.singularizeName = singularizeName;
    }
}

