/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlapisync.generation;

import com.phoenixnap.oss.ramlapisync.data.ApiResourceMetadata;
import com.phoenixnap.oss.ramlapisync.naming.RamlHelper;
import com.phoenixnap.oss.ramlapisync.raml.RamlAction;
import com.phoenixnap.oss.ramlapisync.raml.RamlActionType;
import com.phoenixnap.oss.ramlapisync.raml.RamlModelFactoryOfFactories;
import com.phoenixnap.oss.ramlapisync.raml.RamlResource;
import com.phoenixnap.oss.ramlapisync.raml.RamlResponse;
import com.phoenixnap.oss.ramlapisync.raml.RamlRoot;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RamlParser {
    protected static final Logger logger = LoggerFactory.getLogger(RamlParser.class);
    private String basePackage;
    private String startUrl = "";
    protected boolean seperateMethodsByContentType = false;
    protected boolean injectHttpHeadersParameter = false;

    public RamlParser(String basePackage) {
        this.basePackage = basePackage;
    }

    public RamlParser(String basePackage, String startUrl) {
        this(basePackage);
        this.startUrl = startUrl;
    }

    public RamlParser(String basePackage, String startUrl, boolean seperateMethodsByContentType, boolean injectHttpHeadersParameter) {
        this(basePackage, startUrl);
        this.seperateMethodsByContentType = seperateMethodsByContentType;
        this.injectHttpHeadersParameter = injectHttpHeadersParameter;
    }

    public Set<ApiResourceMetadata> extractControllers(RamlRoot raml) {
        LinkedHashSet<ApiResourceMetadata> controllers = new LinkedHashSet<ApiResourceMetadata>();
        if (raml == null) {
            return controllers;
        }
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        LinkedHashSet<String> namesToDisable = new LinkedHashSet<String>();
        for (Map.Entry<String, RamlResource> resource : raml.getResources().entrySet()) {
            Set<ApiResourceMetadata> resources = this.checkResource(this.startUrl, resource.getValue(), null, raml);
            for (ApiResourceMetadata resourceMetadata : resources) {
                if (names.contains(resourceMetadata.getResourceName())) {
                    namesToDisable.add(resourceMetadata.getResourceName());
                }
                names.add(resourceMetadata.getResourceName());
                controllers.add(resourceMetadata);
            }
        }
        for (ApiResourceMetadata resourceMetadata : controllers) {
            if (!namesToDisable.contains(resourceMetadata.getResourceName())) continue;
            resourceMetadata.setSingularizeName(false);
        }
        return controllers;
    }

    private boolean shouldCreateController(RamlResource resource) {
        if (resource.getActions() != null && !resource.getActions().isEmpty()) {
            return true;
        }
        if (resource.getResources() != null && !resource.getResources().isEmpty()) {
            for (RamlResource childResource : resource.getResources().values()) {
                if ((childResource.getUriParameters() == null || childResource.getUriParameters().isEmpty()) && (childResource.getResolvedUriParameters() == null || childResource.getResolvedUriParameters().isEmpty())) continue;
                return true;
            }
        }
        return false;
    }

    public Set<ApiResourceMetadata> checkResource(String baseUrl, RamlResource resource, ApiResourceMetadata controller, RamlRoot document) {
        LinkedHashSet<ApiResourceMetadata> controllers = new LinkedHashSet<ApiResourceMetadata>();
        String url = baseUrl + resource.getRelativeUri();
        if (controller == null && this.shouldCreateController(resource)) {
            controller = new ApiResourceMetadata(url, resource, this.basePackage, document);
            controllers.add(controller);
        }
        if (resource.getActions() != null && !resource.getActions().isEmpty()) {
            for (Map.Entry<Object, Object> entry : resource.getActions().entrySet()) {
                RamlResponse response = null;
                if (((RamlAction)entry.getValue()).getResponses() != null) {
                    response = RamlHelper.getSuccessfulResponse((RamlAction)entry.getValue());
                }
                if (this.seperateMethodsByContentType && response != null && response.hasBody() && response.getBody().size() > 1) {
                    for (String responseType : response.getBody().keySet()) {
                        controller.addApiCall(resource, (RamlActionType)((Object)entry.getKey()), (RamlAction)entry.getValue(), responseType, this.injectHttpHeadersParameter);
                    }
                    continue;
                }
                controller.addApiCall(resource, (RamlActionType)((Object)entry.getKey()), (RamlAction)entry.getValue(), null, this.injectHttpHeadersParameter);
            }
        }
        if (resource.getResources() != null && !resource.getResources().isEmpty()) {
            for (Map.Entry<Object, Object> entry : resource.getResources().entrySet()) {
                controllers.addAll(this.checkResource(url, (RamlResource)entry.getValue(), controller, document));
            }
        }
        return controllers;
    }

    public static RamlRoot loadRamlFromFile(String ramlFileUrl) {
        try {
            return RamlModelFactoryOfFactories.createRamlModelFactory().buildRamlRoot(ramlFileUrl);
        }
        catch (NullPointerException npe) {
            logger.error("File not found at " + ramlFileUrl);
            return null;
        }
    }
}

