/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlapisync.generation;

import com.phoenixnap.oss.ramlapisync.naming.Pair;
import com.phoenixnap.oss.ramlapisync.naming.RamlHelper;
import com.phoenixnap.oss.ramlapisync.raml.RamlModelFactory;
import com.phoenixnap.oss.ramlapisync.raml.RamlModelFactoryOfFactories;
import com.phoenixnap.oss.ramlapisync.raml.RamlRoot;
import com.phoenixnap.oss.ramlapisync.style.RamlStyleCheckVisitorCoordinator;
import com.phoenixnap.oss.ramlapisync.style.RamlStyleChecker;
import com.phoenixnap.oss.ramlapisync.verification.Issue;
import com.phoenixnap.oss.ramlapisync.verification.RamlActionVisitorCheck;
import com.phoenixnap.oss.ramlapisync.verification.RamlChecker;
import com.phoenixnap.oss.ramlapisync.verification.RamlResourceVisitorCheck;
import com.phoenixnap.oss.ramlapisync.verification.checkers.RamlCheckerResourceVisitorCoordinator;
import com.phoenixnap.oss.ramlapisync.verification.checkers.ResourceExistenceChecker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class RamlVerifier {
    protected static final Logger logger = LoggerFactory.getLogger(RamlVerifier.class);
    private static RamlModelFactory ramlModelFactory = RamlModelFactoryOfFactories.createRamlModelFactory();
    private RamlRoot published;
    private RamlRoot implemented;
    private Set<Issue> errors = new LinkedHashSet<Issue>();
    private Set<Issue> warnings = new LinkedHashSet<Issue>();
    private List<RamlChecker> checkers;

    public RamlVerifier(RamlRoot published, RamlRoot implemented, List<RamlChecker> checkers, List<RamlActionVisitorCheck> actionCheckers, List<RamlResourceVisitorCheck> resourceCheckers, List<RamlStyleChecker> styleChecks) {
        this(published, implemented, checkers, actionCheckers, resourceCheckers, styleChecks, null);
    }

    public RamlVerifier(RamlRoot published, RamlRoot implemented, List<RamlChecker> checkers, List<RamlActionVisitorCheck> actionCheckers, List<RamlResourceVisitorCheck> resourceCheckers, List<RamlStyleChecker> styleChecks, String implementedUrlPrefixToIgnore) {
        this.published = published;
        this.implemented = implemented;
        this.checkers = new ArrayList<RamlChecker>();
        if (implemented != null && StringUtils.hasText((String)implementedUrlPrefixToIgnore)) {
            RamlHelper.removeResourceTree(implemented, implementedUrlPrefixToIgnore);
        }
        this.checkers.add(new RamlCheckerResourceVisitorCoordinator(actionCheckers == null ? Collections.emptyList() : actionCheckers, resourceCheckers == null ? Collections.emptyList() : resourceCheckers));
        if (checkers == null) {
            this.checkers.add(new ResourceExistenceChecker());
        } else {
            this.checkers.addAll(checkers);
        }
        if (styleChecks != null) {
            this.checkers.add(new RamlStyleCheckVisitorCoordinator(styleChecks));
        }
        this.validate();
    }

    public RamlVerifier(RamlRoot published, RamlRoot implemented, List<RamlChecker> checkers, List<RamlActionVisitorCheck> actionCheckers, List<RamlResourceVisitorCheck> resourceCheckers) {
        this(published, implemented, checkers, actionCheckers, resourceCheckers, null);
    }

    public boolean hasErrors() {
        return this.errors.size() > 0;
    }

    public boolean hasWarnings() {
        return this.warnings.size() > 0;
    }

    private void validate() {
        if (this.checkers != null) {
            for (RamlChecker checker : this.checkers) {
                Pair<Set<Issue>, Set<Issue>> check = checker.check(this.published, this.implemented);
                this.warnings.addAll((Collection<Issue>)check.getFirst());
                this.errors.addAll((Collection<Issue>)check.getSecond());
            }
        }
    }

    public static RamlRoot loadRamlFromFile(String ramlFileUrl) {
        try {
            return ramlModelFactory.createRamlRoot(ramlFileUrl);
        }
        catch (NullPointerException npe) {
            logger.error("File not found at " + ramlFileUrl);
            return null;
        }
    }

    public Set<Issue> getErrors() {
        return this.errors;
    }

    public Set<Issue> getWarnings() {
        return this.warnings;
    }
}

